/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostColumnVectorCore;
import com.nvidia.spark.rapids.RapidsHostColumnVectorCore;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class RapidsNullSafeHostColumnVectorCore
extends ColumnVector {
    private final RapidsHostColumnVectorCore rapidsHcvc;
    private final RapidsNullSafeHostColumnVectorCore[] cachedChildren;

    public RapidsNullSafeHostColumnVectorCore(RapidsHostColumnVectorCore hcvc) {
        super(hcvc.dataType());
        this.rapidsHcvc = hcvc;
        this.cachedChildren = this.type instanceof MapType ? new RapidsNullSafeHostColumnVectorCore[2] : new RapidsNullSafeHostColumnVectorCore[hcvc.getBase().getNumChildren()];
    }

    public HostColumnVectorCore getBase() {
        return this.rapidsHcvc.getBase();
    }

    public void close() {
        for (int i = 0; i < this.cachedChildren.length; ++i) {
            RapidsNullSafeHostColumnVectorCore cv = this.cachedChildren[i];
            if (cv == null) continue;
            cv.close();
            this.cachedChildren[i] = null;
        }
        this.rapidsHcvc.close();
    }

    public boolean hasNull() {
        return this.rapidsHcvc.hasNull();
    }

    public int numNulls() {
        return this.rapidsHcvc.numNulls();
    }

    public boolean isNullAt(int rowId) {
        return this.rapidsHcvc.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        return this.isNullAt(rowId) ? false : this.rapidsHcvc.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        return this.isNullAt(rowId) ? (byte)0 : this.rapidsHcvc.getByte(rowId);
    }

    public short getShort(int rowId) {
        return this.isNullAt(rowId) ? (short)0 : this.rapidsHcvc.getShort(rowId);
    }

    public int getInt(int rowId) {
        return this.isNullAt(rowId) ? 0 : this.rapidsHcvc.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.isNullAt(rowId) ? 0L : this.rapidsHcvc.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.isNullAt(rowId) ? 0.0f : this.rapidsHcvc.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.isNullAt(rowId) ? 0.0 : this.rapidsHcvc.getDouble(rowId);
    }

    public UTF8String getUTF8String(int rowId) {
        return this.isNullAt(rowId) ? null : this.rapidsHcvc.getUTF8String(rowId);
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        return this.isNullAt(rowId) ? null : this.rapidsHcvc.getDecimal(rowId, precision, scale);
    }

    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (this.cachedChildren[0] == null) {
            ArrayType at = (ArrayType)this.type;
            HostColumnVectorCore data = this.getBase().getChildColumnView(0);
            this.cachedChildren[0] = new RapidsNullSafeHostColumnVectorCore(new RapidsHostColumnVectorCore(at.elementType(), data));
        }
        RapidsNullSafeHostColumnVectorCore data = this.cachedChildren[0];
        int startOffset = (int)this.getBase().getStartListOffset((long)rowId);
        int endOffset = (int)this.getBase().getEndListOffset((long)rowId);
        return new ColumnarArray((ColumnVector)data, startOffset, endOffset - startOffset);
    }

    public ColumnarMap getMap(int ordinal) {
        if (this.isNullAt(ordinal)) {
            return null;
        }
        if (this.cachedChildren[0] == null) {
            MapType mt = (MapType)this.type;
            HostColumnVectorCore structHcv = this.getBase().getChildColumnView(0);
            HostColumnVectorCore keyHcvCore = structHcv.getChildColumnView(0);
            HostColumnVectorCore valueHcvCore = structHcv.getChildColumnView(1);
            this.cachedChildren[0] = new RapidsNullSafeHostColumnVectorCore(new RapidsHostColumnVectorCore(mt.keyType(), keyHcvCore));
            this.cachedChildren[1] = new RapidsNullSafeHostColumnVectorCore(new RapidsHostColumnVectorCore(mt.valueType(), valueHcvCore));
        }
        RapidsNullSafeHostColumnVectorCore keys = this.cachedChildren[0];
        RapidsNullSafeHostColumnVectorCore values = this.cachedChildren[1];
        int startOffset = (int)this.getBase().getStartListOffset((long)ordinal);
        int endOffset = (int)this.getBase().getEndListOffset((long)ordinal);
        return new ColumnarMap((ColumnVector)keys, (ColumnVector)values, startOffset, endOffset - startOffset);
    }

    public ColumnVector getChild(int ordinal) {
        if (this.cachedChildren[ordinal] == null) {
            StructType st = (StructType)this.type;
            StructField[] fields = st.fields();
            for (int i = 0; i < fields.length; ++i) {
                HostColumnVectorCore tmp = this.getBase().getChildColumnView(i);
                this.cachedChildren[i] = new RapidsNullSafeHostColumnVectorCore(new RapidsHostColumnVectorCore(fields[i].dataType(), tmp));
            }
        }
        return this.cachedChildren[ordinal];
    }

    public byte[] getBinary(int rowId) {
        Object data;
        if (this.isNullAt(rowId)) {
            return null;
        }
        if (this.cachedChildren[0] == null) {
            data = this.getBase().getChildColumnView(0);
            this.cachedChildren[0] = new RapidsNullSafeHostColumnVectorCore(new RapidsHostColumnVectorCore(DataTypes.ByteType, (HostColumnVectorCore)data));
        }
        data = this.cachedChildren[0];
        int startOffset = (int)this.getBase().getStartListOffset((long)rowId);
        int endOffset = (int)this.getBase().getEndListOffset((long)rowId);
        return new ColumnarArray((ColumnVector)data, startOffset, endOffset - startOffset).toByteArray();
    }
}

