/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.ConfBuilder;
import com.nvidia.spark.rapids.ConfEntry;
import com.nvidia.spark.rapids.ConfEntryWithDefault;
import com.nvidia.spark.rapids.ConfHelper$;
import com.nvidia.spark.rapids.ExprRule;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.OptionalConfEntry;
import com.nvidia.spark.rapids.RapidsConf$ParquetFooterReaderType$;
import com.nvidia.spark.rapids.RapidsConf$RapidsShuffleManagerMode$;
import com.nvidia.spark.rapids.RapidsReaderType$;
import com.nvidia.spark.rapids.python.PythonConfEntries$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.network.util.ByteUnit;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class RapidsConf$ {
    public static RapidsConf$ MODULE$;
    private Seq<String> com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES;
    private final int MULTITHREAD_READ_NUM_THREADS_DEFAULT;
    private final ListBuffer<ConfEntry<?>> registeredConfs;
    private final ConfEntryWithDefault<Object> PINNED_POOL_SIZE;
    private final ConfEntryWithDefault<Object> PAGEABLE_POOL_SIZE;
    private final ConfEntryWithDefault<String> RMM_DEBUG;
    private final OptionalConfEntry<String> GPU_OOM_DUMP_DIR;
    private final String RMM_ALLOC_MAX_FRACTION_KEY;
    private final String RMM_ALLOC_MIN_FRACTION_KEY;
    private final String RMM_ALLOC_RESERVE_KEY;
    private final ConfEntryWithDefault<Object> RMM_ALLOC_FRACTION;
    private final OptionalConfEntry<Object> RMM_EXACT_ALLOC;
    private final ConfEntryWithDefault<Object> RMM_ALLOC_MAX_FRACTION;
    private final ConfEntryWithDefault<Object> RMM_ALLOC_MIN_FRACTION;
    private final ConfEntryWithDefault<Object> RMM_ALLOC_RESERVE;
    private final ConfEntryWithDefault<Object> HOST_SPILL_STORAGE_SIZE;
    private final ConfEntryWithDefault<Object> UNSPILL;
    private final ConfEntryWithDefault<Object> GDS_SPILL;
    private final ConfEntryWithDefault<Object> GDS_SPILL_BATCH_WRITE_BUFFER_SIZE;
    private final ConfEntryWithDefault<Object> POOLED_MEM;
    private final ConfEntryWithDefault<String> RMM_POOL;
    private final ConfEntryWithDefault<Integer> CONCURRENT_GPU_TASKS;
    private final ConfEntryWithDefault<Integer> SHUFFLE_SPILL_THREADS;
    private final ConfEntryWithDefault<Object> GPU_BATCH_SIZE_BYTES;
    private final ConfEntryWithDefault<Integer> MAX_READER_BATCH_SIZE_ROWS;
    private final ConfEntryWithDefault<Object> MAX_READER_BATCH_SIZE_BYTES;
    private final OptionalConfEntry<String> DRIVER_TIMEZONE;
    private final ConfEntryWithDefault<Object> UVM_ENABLED;
    private final ConfEntryWithDefault<Object> EXPORT_COLUMNAR_RDD;
    private final ConfEntryWithDefault<Object> SHUFFLED_HASH_JOIN_OPTIMIZE_SHUFFLE;
    private final ConfEntryWithDefault<Object> STABLE_SORT;
    private final ConfEntryWithDefault<String> METRICS_LEVEL;
    private final ConfEntryWithDefault<Object> IMPROVED_TIMESTAMP_OPS;
    private final ConfEntryWithDefault<Object> SQL_ENABLED;
    private final ConfEntryWithDefault<String> SQL_MODE;
    private final ConfEntryWithDefault<Object> UDF_COMPILER_ENABLED;
    private final ConfEntryWithDefault<Object> INCOMPATIBLE_OPS;
    private final ConfEntryWithDefault<Object> INCOMPATIBLE_DATE_FORMATS;
    private final ConfEntryWithDefault<Object> IMPROVED_FLOAT_OPS;
    private final ConfEntryWithDefault<Object> HAS_NANS;
    private final ConfEntryWithDefault<Object> NEED_DECIMAL_OVERFLOW_GUARANTEES;
    private final ConfEntryWithDefault<Object> ENABLE_FLOAT_AGG;
    private final ConfEntryWithDefault<Object> ENABLE_REPLACE_SORTMERGEJOIN;
    private final ConfEntryWithDefault<Object> ENABLE_HASH_OPTIMIZE_SORT;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_DECIMAL;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_STRING;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_INTEGRAL_TYPES;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_DECIMAL_TO_FLOAT;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_STRING_TO_FLOAT;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_STRING_TO_TIMESTAMP;
    private final ConfEntryWithDefault<Object> HAS_EXTENDED_YEAR_VALUES;
    private final ConfEntryWithDefault<Object> ENABLE_CAST_DECIMAL_TO_STRING;
    private final ConfEntryWithDefault<Object> ENABLE_INNER_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_CROSS_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_LEFT_OUTER_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_RIGHT_OUTER_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_FULL_OUTER_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_LEFT_SEMI_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_LEFT_ANTI_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_EXISTENCE_JOIN;
    private final ConfEntryWithDefault<Object> ENABLE_PROJECT_AST;
    private final ConfEntryWithDefault<Integer> MULTITHREAD_READ_NUM_THREADS;
    private final ConfEntryWithDefault<Object> ENABLE_PARQUET;
    private final ConfEntryWithDefault<Object> ENABLE_PARQUET_INT96_WRITE;
    private final ConfEntryWithDefault<String> PARQUET_READER_FOOTER_TYPE;
    private final ConfEntryWithDefault<Object> ENABLE_CPU_BASED_UDF;
    private final ConfEntryWithDefault<String> PARQUET_READER_TYPE;
    private final OptionalConfEntry<Seq<String>> CLOUD_SCHEMES;
    private final OptionalConfEntry<Integer> PARQUET_MULTITHREAD_READ_NUM_THREADS;
    private final ConfEntryWithDefault<Integer> PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    private final ConfEntryWithDefault<Object> ENABLE_PARQUET_READ;
    private final ConfEntryWithDefault<Object> ENABLE_PARQUET_WRITE;
    private final ConfEntryWithDefault<Object> ENABLE_ORC;
    private final ConfEntryWithDefault<Object> ENABLE_ORC_READ;
    private final ConfEntryWithDefault<Object> ENABLE_ORC_WRITE;
    private final ConfEntryWithDefault<String> ORC_READER_TYPE;
    private final OptionalConfEntry<Integer> ORC_MULTITHREAD_READ_NUM_THREADS;
    private final ConfEntryWithDefault<Integer> ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    private final ConfEntryWithDefault<Object> ENABLE_CSV;
    private final ConfEntryWithDefault<Object> ENABLE_CSV_READ;
    private final ConfEntryWithDefault<Object> ENABLE_READ_CSV_FLOATS;
    private final ConfEntryWithDefault<Object> ENABLE_READ_CSV_DOUBLES;
    private final ConfEntryWithDefault<Object> ENABLE_READ_CSV_DECIMALS;
    private final ConfEntryWithDefault<Object> ENABLE_JSON;
    private final ConfEntryWithDefault<Object> ENABLE_JSON_READ;
    private final ConfEntryWithDefault<Object> ENABLE_READ_JSON_FLOATS;
    private final ConfEntryWithDefault<Object> ENABLE_READ_JSON_DOUBLES;
    private final ConfEntryWithDefault<Object> ENABLE_READ_JSON_DECIMALS;
    private final ConfEntryWithDefault<Object> ENABLE_AVRO;
    private final ConfEntryWithDefault<Object> ENABLE_AVRO_READ;
    private final ConfEntryWithDefault<String> AVRO_READER_TYPE;
    private final OptionalConfEntry<Integer> AVRO_MULTITHREAD_READ_NUM_THREADS;
    private final ConfEntryWithDefault<Integer> AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    private final ConfEntryWithDefault<Object> ENABLE_ICEBERG;
    private final ConfEntryWithDefault<Object> ENABLE_ICEBERG_READ;
    private final ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_BYTES;
    private final ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_SHORT;
    private final ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_INT;
    private final ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_LONG;
    private final ConfEntryWithDefault<Object> ENABLE_REGEXP;
    private final ConfEntryWithDefault<Object> TEST_CONF;
    private final ConfEntryWithDefault<Seq<String>> TEST_ALLOWED_NONGPU;
    private final ConfEntryWithDefault<Seq<String>> TEST_VALIDATE_EXECS_ONGPU;
    private final ConfEntryWithDefault<String> PARQUET_DEBUG_DUMP_PREFIX;
    private final ConfEntryWithDefault<String> ORC_DEBUG_DUMP_PREFIX;
    private final ConfEntryWithDefault<String> AVRO_DEBUG_DUMP_PREFIX;
    private final ConfEntryWithDefault<String> HASH_AGG_REPLACE_MODE;
    private final ConfEntryWithDefault<Object> PARTIAL_MERGE_DISTINCT_ENABLED;
    private final ConfEntryWithDefault<Object> SHUFFLE_MANAGER_ENABLED;
    private final ConfEntryWithDefault<String> SHUFFLE_MANAGER_MODE;
    private final ConfEntryWithDefault<Object> SHUFFLE_TRANSPORT_EARLY_START;
    private final ConfEntryWithDefault<Integer> SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_INTERVAL;
    private final ConfEntryWithDefault<Integer> SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_TIMEOUT;
    private final ConfEntryWithDefault<String> SHUFFLE_TRANSPORT_CLASS_NAME;
    private final ConfEntryWithDefault<Object> SHUFFLE_TRANSPORT_MAX_RECEIVE_INFLIGHT_BYTES;
    private final ConfEntryWithDefault<Object> SHUFFLE_UCX_ACTIVE_MESSAGES_FORCE_RNDV;
    private final ConfEntryWithDefault<Object> SHUFFLE_UCX_USE_WAKEUP;
    private final ConfEntryWithDefault<Integer> SHUFFLE_UCX_LISTENER_START_PORT;
    private final ConfEntryWithDefault<String> SHUFFLE_UCX_MGMT_SERVER_HOST;
    private final ConfEntryWithDefault<Integer> SHUFFLE_UCX_MGMT_CONNECTION_TIMEOUT;
    private final ConfEntryWithDefault<Object> SHUFFLE_UCX_BOUNCE_BUFFERS_SIZE;
    private final ConfEntryWithDefault<Integer> SHUFFLE_UCX_BOUNCE_BUFFERS_DEVICE_COUNT;
    private final ConfEntryWithDefault<Integer> SHUFFLE_UCX_BOUNCE_BUFFERS_HOST_COUNT;
    private final ConfEntryWithDefault<Integer> SHUFFLE_MAX_CLIENT_THREADS;
    private final ConfEntryWithDefault<Integer> SHUFFLE_MAX_CLIENT_TASKS;
    private final ConfEntryWithDefault<Integer> SHUFFLE_CLIENT_THREAD_KEEPALIVE;
    private final ConfEntryWithDefault<Integer> SHUFFLE_MAX_SERVER_TASKS;
    private final ConfEntryWithDefault<Object> SHUFFLE_MAX_METADATA_SIZE;
    private final ConfEntryWithDefault<String> SHUFFLE_COMPRESSION_CODEC;
    private final ConfEntryWithDefault<Object> SHUFFLE_COMPRESSION_LZ4_CHUNK_SIZE;
    private final ConfEntryWithDefault<Integer> SHUFFLE_MULTITHREADED_WRITER_THREADS;
    private final OptionalConfEntry<Seq<String>> ALLUXIO_PATHS_REPLACE;
    private final ConfEntryWithDefault<Object> ALLUXIO_AUTOMOUNT_ENABLED;
    private final ConfEntryWithDefault<String> ALLUXIO_BUCKET_REGEX;
    private final ConfEntryWithDefault<Seq<String>> ALLUXIO_CMD;
    private final ConfEntryWithDefault<Object> SHUFFLE_COMPRESSION_MAX_BATCH_MEMORY;
    private final ConfEntryWithDefault<String> EXPLAIN;
    private final OptionalConfEntry<String> SHIMS_PROVIDER_OVERRIDE;
    private final ConfEntryWithDefault<Object> CUDF_VERSION_OVERRIDE;
    private final ConfEntryWithDefault<Object> ALLOW_DISABLE_ENTIRE_PLAN;
    private final ConfEntryWithDefault<Object> OPTIMIZER_ENABLED;
    private final ConfEntryWithDefault<String> OPTIMIZER_EXPLAIN;
    private final ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_ROW_COUNT;
    private final ConfEntryWithDefault<String> OPTIMIZER_CLASS_NAME;
    private final ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_CPU_OPERATOR_COST;
    private final ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_CPU_EXPRESSION_COST;
    private final ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_GPU_OPERATOR_COST;
    private final ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_GPU_EXPRESSION_COST;
    private final ConfEntryWithDefault<Object> OPTIMIZER_CPU_READ_SPEED;
    private final ConfEntryWithDefault<Object> OPTIMIZER_CPU_WRITE_SPEED;
    private final ConfEntryWithDefault<Object> OPTIMIZER_GPU_READ_SPEED;
    private final ConfEntryWithDefault<Object> OPTIMIZER_GPU_WRITE_SPEED;
    private final ConfEntryWithDefault<Object> USE_ARROW_OPT;
    private final ConfEntryWithDefault<Object> FORCE_SHIMCALLER_CLASSLOADER;
    private final ConfEntryWithDefault<String> SPARK_GPU_RESOURCE_NAME;
    private final ConfEntryWithDefault<Object> SUPPRESS_PLANNING_FAILURE;
    private final ConfEntryWithDefault<Object> ENABLE_FAST_SAMPLE;
    private final ConfEntryWithDefault<Object> DETECT_DELTA_LOG_QUERIES;
    private volatile boolean bitmap$0;

    static {
        new RapidsConf$();
    }

    public int MULTITHREAD_READ_NUM_THREADS_DEFAULT() {
        return this.MULTITHREAD_READ_NUM_THREADS_DEFAULT;
    }

    private ListBuffer<ConfEntry<?>> registeredConfs() {
        return this.registeredConfs;
    }

    private void register(ConfEntry<?> entry) {
        this.registeredConfs().$plus$eq(entry);
    }

    public ConfBuilder conf(String key) {
        return new ConfBuilder(key, (Function1 & Serializable & scala.Serializable)entry -> {
            RapidsConf$.MODULE$.register(entry);
            return BoxedUnit.UNIT;
        });
    }

    public ConfEntryWithDefault<Object> PINNED_POOL_SIZE() {
        return this.PINNED_POOL_SIZE;
    }

    public ConfEntryWithDefault<Object> PAGEABLE_POOL_SIZE() {
        return this.PAGEABLE_POOL_SIZE;
    }

    public ConfEntryWithDefault<String> RMM_DEBUG() {
        return this.RMM_DEBUG;
    }

    public OptionalConfEntry<String> GPU_OOM_DUMP_DIR() {
        return this.GPU_OOM_DUMP_DIR;
    }

    private String RMM_ALLOC_MAX_FRACTION_KEY() {
        return this.RMM_ALLOC_MAX_FRACTION_KEY;
    }

    private String RMM_ALLOC_MIN_FRACTION_KEY() {
        return this.RMM_ALLOC_MIN_FRACTION_KEY;
    }

    private String RMM_ALLOC_RESERVE_KEY() {
        return this.RMM_ALLOC_RESERVE_KEY;
    }

    public ConfEntryWithDefault<Object> RMM_ALLOC_FRACTION() {
        return this.RMM_ALLOC_FRACTION;
    }

    public OptionalConfEntry<Object> RMM_EXACT_ALLOC() {
        return this.RMM_EXACT_ALLOC;
    }

    public ConfEntryWithDefault<Object> RMM_ALLOC_MAX_FRACTION() {
        return this.RMM_ALLOC_MAX_FRACTION;
    }

    public ConfEntryWithDefault<Object> RMM_ALLOC_MIN_FRACTION() {
        return this.RMM_ALLOC_MIN_FRACTION;
    }

    public ConfEntryWithDefault<Object> RMM_ALLOC_RESERVE() {
        return this.RMM_ALLOC_RESERVE;
    }

    public ConfEntryWithDefault<Object> HOST_SPILL_STORAGE_SIZE() {
        return this.HOST_SPILL_STORAGE_SIZE;
    }

    public ConfEntryWithDefault<Object> UNSPILL() {
        return this.UNSPILL;
    }

    public ConfEntryWithDefault<Object> GDS_SPILL() {
        return this.GDS_SPILL;
    }

    public ConfEntryWithDefault<Object> GDS_SPILL_BATCH_WRITE_BUFFER_SIZE() {
        return this.GDS_SPILL_BATCH_WRITE_BUFFER_SIZE;
    }

    public ConfEntryWithDefault<Object> POOLED_MEM() {
        return this.POOLED_MEM;
    }

    public ConfEntryWithDefault<String> RMM_POOL() {
        return this.RMM_POOL;
    }

    public ConfEntryWithDefault<Integer> CONCURRENT_GPU_TASKS() {
        return this.CONCURRENT_GPU_TASKS;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_SPILL_THREADS() {
        return this.SHUFFLE_SPILL_THREADS;
    }

    public ConfEntryWithDefault<Object> GPU_BATCH_SIZE_BYTES() {
        return this.GPU_BATCH_SIZE_BYTES;
    }

    public ConfEntryWithDefault<Integer> MAX_READER_BATCH_SIZE_ROWS() {
        return this.MAX_READER_BATCH_SIZE_ROWS;
    }

    public ConfEntryWithDefault<Object> MAX_READER_BATCH_SIZE_BYTES() {
        return this.MAX_READER_BATCH_SIZE_BYTES;
    }

    public OptionalConfEntry<String> DRIVER_TIMEZONE() {
        return this.DRIVER_TIMEZONE;
    }

    public ConfEntryWithDefault<Object> UVM_ENABLED() {
        return this.UVM_ENABLED;
    }

    public ConfEntryWithDefault<Object> EXPORT_COLUMNAR_RDD() {
        return this.EXPORT_COLUMNAR_RDD;
    }

    public ConfEntryWithDefault<Object> SHUFFLED_HASH_JOIN_OPTIMIZE_SHUFFLE() {
        return this.SHUFFLED_HASH_JOIN_OPTIMIZE_SHUFFLE;
    }

    public ConfEntryWithDefault<Object> STABLE_SORT() {
        return this.STABLE_SORT;
    }

    public ConfEntryWithDefault<String> METRICS_LEVEL() {
        return this.METRICS_LEVEL;
    }

    public ConfEntryWithDefault<Object> IMPROVED_TIMESTAMP_OPS() {
        return this.IMPROVED_TIMESTAMP_OPS;
    }

    public ConfEntryWithDefault<Object> SQL_ENABLED() {
        return this.SQL_ENABLED;
    }

    public ConfEntryWithDefault<String> SQL_MODE() {
        return this.SQL_MODE;
    }

    public ConfEntryWithDefault<Object> UDF_COMPILER_ENABLED() {
        return this.UDF_COMPILER_ENABLED;
    }

    public ConfEntryWithDefault<Object> INCOMPATIBLE_OPS() {
        return this.INCOMPATIBLE_OPS;
    }

    public ConfEntryWithDefault<Object> INCOMPATIBLE_DATE_FORMATS() {
        return this.INCOMPATIBLE_DATE_FORMATS;
    }

    public ConfEntryWithDefault<Object> IMPROVED_FLOAT_OPS() {
        return this.IMPROVED_FLOAT_OPS;
    }

    public ConfEntryWithDefault<Object> HAS_NANS() {
        return this.HAS_NANS;
    }

    public ConfEntryWithDefault<Object> NEED_DECIMAL_OVERFLOW_GUARANTEES() {
        return this.NEED_DECIMAL_OVERFLOW_GUARANTEES;
    }

    public ConfEntryWithDefault<Object> ENABLE_FLOAT_AGG() {
        return this.ENABLE_FLOAT_AGG;
    }

    public ConfEntryWithDefault<Object> ENABLE_REPLACE_SORTMERGEJOIN() {
        return this.ENABLE_REPLACE_SORTMERGEJOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_HASH_OPTIMIZE_SORT() {
        return this.ENABLE_HASH_OPTIMIZE_SORT;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_DECIMAL() {
        return this.ENABLE_CAST_FLOAT_TO_DECIMAL;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_STRING() {
        return this.ENABLE_CAST_FLOAT_TO_STRING;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_FLOAT_TO_INTEGRAL_TYPES() {
        return this.ENABLE_CAST_FLOAT_TO_INTEGRAL_TYPES;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_DECIMAL_TO_FLOAT() {
        return this.ENABLE_CAST_DECIMAL_TO_FLOAT;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_STRING_TO_FLOAT() {
        return this.ENABLE_CAST_STRING_TO_FLOAT;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_STRING_TO_TIMESTAMP() {
        return this.ENABLE_CAST_STRING_TO_TIMESTAMP;
    }

    public ConfEntryWithDefault<Object> HAS_EXTENDED_YEAR_VALUES() {
        return this.HAS_EXTENDED_YEAR_VALUES;
    }

    public ConfEntryWithDefault<Object> ENABLE_CAST_DECIMAL_TO_STRING() {
        return this.ENABLE_CAST_DECIMAL_TO_STRING;
    }

    public ConfEntryWithDefault<Object> ENABLE_INNER_JOIN() {
        return this.ENABLE_INNER_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_CROSS_JOIN() {
        return this.ENABLE_CROSS_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_LEFT_OUTER_JOIN() {
        return this.ENABLE_LEFT_OUTER_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_RIGHT_OUTER_JOIN() {
        return this.ENABLE_RIGHT_OUTER_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_FULL_OUTER_JOIN() {
        return this.ENABLE_FULL_OUTER_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_LEFT_SEMI_JOIN() {
        return this.ENABLE_LEFT_SEMI_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_LEFT_ANTI_JOIN() {
        return this.ENABLE_LEFT_ANTI_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_EXISTENCE_JOIN() {
        return this.ENABLE_EXISTENCE_JOIN;
    }

    public ConfEntryWithDefault<Object> ENABLE_PROJECT_AST() {
        return this.ENABLE_PROJECT_AST;
    }

    public ConfEntryWithDefault<Integer> MULTITHREAD_READ_NUM_THREADS() {
        return this.MULTITHREAD_READ_NUM_THREADS;
    }

    public ConfEntryWithDefault<Object> ENABLE_PARQUET() {
        return this.ENABLE_PARQUET;
    }

    public ConfEntryWithDefault<Object> ENABLE_PARQUET_INT96_WRITE() {
        return this.ENABLE_PARQUET_INT96_WRITE;
    }

    public ConfEntryWithDefault<String> PARQUET_READER_FOOTER_TYPE() {
        return this.PARQUET_READER_FOOTER_TYPE;
    }

    public ConfEntryWithDefault<Object> ENABLE_CPU_BASED_UDF() {
        return this.ENABLE_CPU_BASED_UDF;
    }

    public ConfEntryWithDefault<String> PARQUET_READER_TYPE() {
        return this.PARQUET_READER_TYPE;
    }

    private Seq<String> DEFAULT_CLOUD_SCHEMES$lzycompute() {
        RapidsConf$ rapidsConf$ = this;
        synchronized (rapidsConf$) {
            if (!this.bitmap$0) {
                this.com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abfs", "abfss", "dbfs", "gs", "s3", "s3a", "s3n", "wasbs"}));
                this.bitmap$0 = true;
            }
        }
        return this.com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES;
    }

    public Seq<String> com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES() {
        return !this.bitmap$0 ? this.DEFAULT_CLOUD_SCHEMES$lzycompute() : this.com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES;
    }

    public OptionalConfEntry<Seq<String>> CLOUD_SCHEMES() {
        return this.CLOUD_SCHEMES;
    }

    public OptionalConfEntry<Integer> PARQUET_MULTITHREAD_READ_NUM_THREADS() {
        return this.PARQUET_MULTITHREAD_READ_NUM_THREADS;
    }

    public ConfEntryWithDefault<Integer> PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL() {
        return this.PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    }

    public ConfEntryWithDefault<Object> ENABLE_PARQUET_READ() {
        return this.ENABLE_PARQUET_READ;
    }

    public ConfEntryWithDefault<Object> ENABLE_PARQUET_WRITE() {
        return this.ENABLE_PARQUET_WRITE;
    }

    public ConfEntryWithDefault<Object> ENABLE_ORC() {
        return this.ENABLE_ORC;
    }

    public ConfEntryWithDefault<Object> ENABLE_ORC_READ() {
        return this.ENABLE_ORC_READ;
    }

    public ConfEntryWithDefault<Object> ENABLE_ORC_WRITE() {
        return this.ENABLE_ORC_WRITE;
    }

    public ConfEntryWithDefault<String> ORC_READER_TYPE() {
        return this.ORC_READER_TYPE;
    }

    public OptionalConfEntry<Integer> ORC_MULTITHREAD_READ_NUM_THREADS() {
        return this.ORC_MULTITHREAD_READ_NUM_THREADS;
    }

    public ConfEntryWithDefault<Integer> ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL() {
        return this.ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    }

    public ConfEntryWithDefault<Object> ENABLE_CSV() {
        return this.ENABLE_CSV;
    }

    public ConfEntryWithDefault<Object> ENABLE_CSV_READ() {
        return this.ENABLE_CSV_READ;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_CSV_FLOATS() {
        return this.ENABLE_READ_CSV_FLOATS;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_CSV_DOUBLES() {
        return this.ENABLE_READ_CSV_DOUBLES;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_CSV_DECIMALS() {
        return this.ENABLE_READ_CSV_DECIMALS;
    }

    public ConfEntryWithDefault<Object> ENABLE_JSON() {
        return this.ENABLE_JSON;
    }

    public ConfEntryWithDefault<Object> ENABLE_JSON_READ() {
        return this.ENABLE_JSON_READ;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_JSON_FLOATS() {
        return this.ENABLE_READ_JSON_FLOATS;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_JSON_DOUBLES() {
        return this.ENABLE_READ_JSON_DOUBLES;
    }

    public ConfEntryWithDefault<Object> ENABLE_READ_JSON_DECIMALS() {
        return this.ENABLE_READ_JSON_DECIMALS;
    }

    public ConfEntryWithDefault<Object> ENABLE_AVRO() {
        return this.ENABLE_AVRO;
    }

    public ConfEntryWithDefault<Object> ENABLE_AVRO_READ() {
        return this.ENABLE_AVRO_READ;
    }

    public ConfEntryWithDefault<String> AVRO_READER_TYPE() {
        return this.AVRO_READER_TYPE;
    }

    public OptionalConfEntry<Integer> AVRO_MULTITHREAD_READ_NUM_THREADS() {
        return this.AVRO_MULTITHREAD_READ_NUM_THREADS;
    }

    public ConfEntryWithDefault<Integer> AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL() {
        return this.AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL;
    }

    public ConfEntryWithDefault<Object> ENABLE_ICEBERG() {
        return this.ENABLE_ICEBERG;
    }

    public ConfEntryWithDefault<Object> ENABLE_ICEBERG_READ() {
        return this.ENABLE_ICEBERG_READ;
    }

    public ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_BYTES() {
        return this.ENABLE_RANGE_WINDOW_BYTES;
    }

    public ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_SHORT() {
        return this.ENABLE_RANGE_WINDOW_SHORT;
    }

    public ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_INT() {
        return this.ENABLE_RANGE_WINDOW_INT;
    }

    public ConfEntryWithDefault<Object> ENABLE_RANGE_WINDOW_LONG() {
        return this.ENABLE_RANGE_WINDOW_LONG;
    }

    public ConfEntryWithDefault<Object> ENABLE_REGEXP() {
        return this.ENABLE_REGEXP;
    }

    public ConfEntryWithDefault<Object> TEST_CONF() {
        return this.TEST_CONF;
    }

    public ConfEntryWithDefault<Seq<String>> TEST_ALLOWED_NONGPU() {
        return this.TEST_ALLOWED_NONGPU;
    }

    public ConfEntryWithDefault<Seq<String>> TEST_VALIDATE_EXECS_ONGPU() {
        return this.TEST_VALIDATE_EXECS_ONGPU;
    }

    public ConfEntryWithDefault<String> PARQUET_DEBUG_DUMP_PREFIX() {
        return this.PARQUET_DEBUG_DUMP_PREFIX;
    }

    public ConfEntryWithDefault<String> ORC_DEBUG_DUMP_PREFIX() {
        return this.ORC_DEBUG_DUMP_PREFIX;
    }

    public ConfEntryWithDefault<String> AVRO_DEBUG_DUMP_PREFIX() {
        return this.AVRO_DEBUG_DUMP_PREFIX;
    }

    public ConfEntryWithDefault<String> HASH_AGG_REPLACE_MODE() {
        return this.HASH_AGG_REPLACE_MODE;
    }

    public ConfEntryWithDefault<Object> PARTIAL_MERGE_DISTINCT_ENABLED() {
        return this.PARTIAL_MERGE_DISTINCT_ENABLED;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_MANAGER_ENABLED() {
        return this.SHUFFLE_MANAGER_ENABLED;
    }

    public ConfEntryWithDefault<String> SHUFFLE_MANAGER_MODE() {
        return this.SHUFFLE_MANAGER_MODE;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_TRANSPORT_EARLY_START() {
        return this.SHUFFLE_TRANSPORT_EARLY_START;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_INTERVAL() {
        return this.SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_INTERVAL;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_TIMEOUT() {
        return this.SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_TIMEOUT;
    }

    public ConfEntryWithDefault<String> SHUFFLE_TRANSPORT_CLASS_NAME() {
        return this.SHUFFLE_TRANSPORT_CLASS_NAME;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_TRANSPORT_MAX_RECEIVE_INFLIGHT_BYTES() {
        return this.SHUFFLE_TRANSPORT_MAX_RECEIVE_INFLIGHT_BYTES;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_UCX_ACTIVE_MESSAGES_FORCE_RNDV() {
        return this.SHUFFLE_UCX_ACTIVE_MESSAGES_FORCE_RNDV;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_UCX_USE_WAKEUP() {
        return this.SHUFFLE_UCX_USE_WAKEUP;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_UCX_LISTENER_START_PORT() {
        return this.SHUFFLE_UCX_LISTENER_START_PORT;
    }

    public ConfEntryWithDefault<String> SHUFFLE_UCX_MGMT_SERVER_HOST() {
        return this.SHUFFLE_UCX_MGMT_SERVER_HOST;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_UCX_MGMT_CONNECTION_TIMEOUT() {
        return this.SHUFFLE_UCX_MGMT_CONNECTION_TIMEOUT;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_UCX_BOUNCE_BUFFERS_SIZE() {
        return this.SHUFFLE_UCX_BOUNCE_BUFFERS_SIZE;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_UCX_BOUNCE_BUFFERS_DEVICE_COUNT() {
        return this.SHUFFLE_UCX_BOUNCE_BUFFERS_DEVICE_COUNT;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_UCX_BOUNCE_BUFFERS_HOST_COUNT() {
        return this.SHUFFLE_UCX_BOUNCE_BUFFERS_HOST_COUNT;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_MAX_CLIENT_THREADS() {
        return this.SHUFFLE_MAX_CLIENT_THREADS;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_MAX_CLIENT_TASKS() {
        return this.SHUFFLE_MAX_CLIENT_TASKS;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_CLIENT_THREAD_KEEPALIVE() {
        return this.SHUFFLE_CLIENT_THREAD_KEEPALIVE;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_MAX_SERVER_TASKS() {
        return this.SHUFFLE_MAX_SERVER_TASKS;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_MAX_METADATA_SIZE() {
        return this.SHUFFLE_MAX_METADATA_SIZE;
    }

    public ConfEntryWithDefault<String> SHUFFLE_COMPRESSION_CODEC() {
        return this.SHUFFLE_COMPRESSION_CODEC;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_COMPRESSION_LZ4_CHUNK_SIZE() {
        return this.SHUFFLE_COMPRESSION_LZ4_CHUNK_SIZE;
    }

    public ConfEntryWithDefault<Integer> SHUFFLE_MULTITHREADED_WRITER_THREADS() {
        return this.SHUFFLE_MULTITHREADED_WRITER_THREADS;
    }

    public OptionalConfEntry<Seq<String>> ALLUXIO_PATHS_REPLACE() {
        return this.ALLUXIO_PATHS_REPLACE;
    }

    public ConfEntryWithDefault<Object> ALLUXIO_AUTOMOUNT_ENABLED() {
        return this.ALLUXIO_AUTOMOUNT_ENABLED;
    }

    public ConfEntryWithDefault<String> ALLUXIO_BUCKET_REGEX() {
        return this.ALLUXIO_BUCKET_REGEX;
    }

    public ConfEntryWithDefault<Seq<String>> ALLUXIO_CMD() {
        return this.ALLUXIO_CMD;
    }

    public ConfEntryWithDefault<Object> SHUFFLE_COMPRESSION_MAX_BATCH_MEMORY() {
        return this.SHUFFLE_COMPRESSION_MAX_BATCH_MEMORY;
    }

    public ConfEntryWithDefault<String> EXPLAIN() {
        return this.EXPLAIN;
    }

    public OptionalConfEntry<String> SHIMS_PROVIDER_OVERRIDE() {
        return this.SHIMS_PROVIDER_OVERRIDE;
    }

    public ConfEntryWithDefault<Object> CUDF_VERSION_OVERRIDE() {
        return this.CUDF_VERSION_OVERRIDE;
    }

    public ConfEntryWithDefault<Object> ALLOW_DISABLE_ENTIRE_PLAN() {
        return this.ALLOW_DISABLE_ENTIRE_PLAN;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_ENABLED() {
        return this.OPTIMIZER_ENABLED;
    }

    public ConfEntryWithDefault<String> OPTIMIZER_EXPLAIN() {
        return this.OPTIMIZER_EXPLAIN;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_ROW_COUNT() {
        return this.OPTIMIZER_DEFAULT_ROW_COUNT;
    }

    public ConfEntryWithDefault<String> OPTIMIZER_CLASS_NAME() {
        return this.OPTIMIZER_CLASS_NAME;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_CPU_OPERATOR_COST() {
        return this.OPTIMIZER_DEFAULT_CPU_OPERATOR_COST;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_CPU_EXPRESSION_COST() {
        return this.OPTIMIZER_DEFAULT_CPU_EXPRESSION_COST;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_GPU_OPERATOR_COST() {
        return this.OPTIMIZER_DEFAULT_GPU_OPERATOR_COST;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_DEFAULT_GPU_EXPRESSION_COST() {
        return this.OPTIMIZER_DEFAULT_GPU_EXPRESSION_COST;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_CPU_READ_SPEED() {
        return this.OPTIMIZER_CPU_READ_SPEED;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_CPU_WRITE_SPEED() {
        return this.OPTIMIZER_CPU_WRITE_SPEED;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_GPU_READ_SPEED() {
        return this.OPTIMIZER_GPU_READ_SPEED;
    }

    public ConfEntryWithDefault<Object> OPTIMIZER_GPU_WRITE_SPEED() {
        return this.OPTIMIZER_GPU_WRITE_SPEED;
    }

    public ConfEntryWithDefault<Object> USE_ARROW_OPT() {
        return this.USE_ARROW_OPT;
    }

    public ConfEntryWithDefault<Object> FORCE_SHIMCALLER_CLASSLOADER() {
        return this.FORCE_SHIMCALLER_CLASSLOADER;
    }

    public ConfEntryWithDefault<String> SPARK_GPU_RESOURCE_NAME() {
        return this.SPARK_GPU_RESOURCE_NAME;
    }

    public ConfEntryWithDefault<Object> SUPPRESS_PLANNING_FAILURE() {
        return this.SUPPRESS_PLANNING_FAILURE;
    }

    public ConfEntryWithDefault<Object> ENABLE_FAST_SAMPLE() {
        return this.ENABLE_FAST_SAMPLE;
    }

    public ConfEntryWithDefault<Object> DETECT_DELTA_LOG_QUERIES() {
        return this.DETECT_DELTA_LOG_QUERIES;
    }

    private void printSectionHeader(String category) {
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("\n### ").append(category).toString());
    }

    private void printToggleHeader(String category) {
        this.printSectionHeader(category);
        Predef$.MODULE$.println((Object)"Name | Description | Default Value | Notes");
        Predef$.MODULE$.println((Object)"-----|-------------|---------------|------------------");
    }

    private void printToggleHeaderWithSqlFunction(String category) {
        this.printSectionHeader(category);
        Predef$.MODULE$.println((Object)"Name | SQL Function(s) | Description | Default Value | Notes");
        Predef$.MODULE$.println((Object)"-----|-----------------|-------------|---------------|------");
    }

    public void help(boolean asTable) {
        if (asTable) {
            Predef$.MODULE$.println((Object)"---");
            Predef$.MODULE$.println((Object)"layout: page");
            Predef$.MODULE$.println((Object)"title: Configuration");
            Predef$.MODULE$.println((Object)"nav_order: 4");
            Predef$.MODULE$.println((Object)"---");
            Predef$.MODULE$.println((Object)"<!-- Generated by RapidsConf.help. DO NOT EDIT! -->");
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("# RAPIDS Accelerator for Apache Spark Configuration\n        |The following is the list of options that `rapids-plugin-4-spark` supports.\n        |\n        |On startup use: `--conf [conf key]=[conf value]`. For example:\n        |\n        |```\n        |${SPARK_HOME}/bin/spark-shell --jars rapids-4-spark_2.12-22.08.0-SNAPSHOT-cuda11.jar \\\n        |--conf spark.plugins=com.nvidia.spark.SQLPlugin \\\n        |--conf spark.rapids.sql.concurrentGpuTasks=2\n        |```\n        |\n        |At runtime use: `spark.conf.set(\"[conf key]\", [conf value])`. For example:\n        |\n        |```\n        |scala> spark.conf.set(\"spark.rapids.sql.concurrentGpuTasks\", 2)\n        |```\n        |\n        | All configs can be set on startup, but some configs, especially for shuffle, will not\n        | work if they are set at runtime.\n        |")).stripMargin());
            Predef$.MODULE$.println((Object)"\n## General Configuration\n");
            Predef$.MODULE$.println((Object)"Name | Description | Default Value");
            Predef$.MODULE$.println((Object)"-----|-------------|--------------");
        } else {
            Predef$.MODULE$.println((Object)"Rapids Configs:");
        }
        ((TraversableForwarder)this.registeredConfs().sortBy((Function1 & Serializable & scala.Serializable)x$24 -> x$24.key(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$25 -> {
            x$25.help(asTable);
            return BoxedUnit.UNIT;
        });
        if (asTable) {
            Predef$.MODULE$.println((Object)"");
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("## Supported GPU Operators and Fine Tuning\n        |_The RAPIDS Accelerator for Apache Spark_ can be configured to enable or disable specific\n        |GPU accelerated expressions.  Enabled expressions are candidates for GPU execution. If the\n        |expression is configured as disabled, the accelerator plugin will not attempt replacement,\n        |and it will run on the CPU.\n        |\n        |Please leverage the [`spark.rapids.sql.explain`](#sql.explain) setting to get\n        |feedback from the plugin as to why parts of a query may not be executing on the GPU.\n        |\n        |**NOTE:** Setting\n        |[`spark.rapids.sql.incompatibleOps.enabled=true`](#sql.incompatibleOps.enabled)\n        |will enable all the settings in the table below which are not enabled by default due to\n        |incompatibilities.")).stripMargin());
            this.printToggleHeaderWithSqlFunction("Expressions\n");
        }
        ((IterableLike)GpuOverrides$.MODULE$.expressions().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$26 -> x$26.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)rule -> {
            RapidsConf$.$anonfun$help$4(asTable, rule);
            return BoxedUnit.UNIT;
        });
        if (asTable) {
            this.printToggleHeader("Execution\n");
        }
        ((IterableLike)GpuOverrides$.MODULE$.execs().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$28 -> x$28.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$29 -> {
            x$29.confHelp(asTable, x$29.confHelp$default$2());
            return BoxedUnit.UNIT;
        });
        if (asTable) {
            this.printToggleHeader("Scans\n");
        }
        ((IterableLike)GpuOverrides$.MODULE$.scans().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$30 -> x$30.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$31 -> {
            x$31.confHelp(asTable, x$31.confHelp$default$2());
            return BoxedUnit.UNIT;
        });
        if (asTable) {
            this.printToggleHeader("Partitioning\n");
        }
        ((IterableLike)GpuOverrides$.MODULE$.parts().values().toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$32 -> x$32.tag().toString(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$33 -> {
            x$33.confHelp(asTable, x$33.confHelp$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public boolean help$default$1() {
        return false;
    }

    public void main(String[] args) {
        PythonConfEntries$.MODULE$.init();
        FileOutputStream out = new FileOutputStream(new File(args[0]));
        Console$.MODULE$.withOut((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Console$.MODULE$.withErr((OutputStream)out, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.help(true)));
    }

    public static final /* synthetic */ boolean $anonfun$MULTITHREAD_READ_NUM_THREADS$1(Integer v) {
        return Predef$.MODULE$.Integer2int(v) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(Integer v) {
        return Predef$.MODULE$.Integer2int(v) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(Integer v) {
        return Predef$.MODULE$.Integer2int(v) > 0;
    }

    public static final /* synthetic */ boolean $anonfun$AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(Integer v) {
        return Predef$.MODULE$.Integer2int(v) > 0;
    }

    public static final /* synthetic */ void $anonfun$help$4(boolean asTable$1, ExprRule rule) {
        Option sqlFunctions = ConfHelper$.MODULE$.getSqlFunctionsForClass(rule.tag().runtimeClass()).map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.mkString(", "));
        rule.confHelp(asTable$1, (Option<String>)new Some(sqlFunctions.getOrElse((Function0 & Serializable & scala.Serializable)() -> " ")));
    }

    private RapidsConf$() {
        MODULE$ = this;
        this.MULTITHREAD_READ_NUM_THREADS_DEFAULT = 20;
        this.registeredConfs = new ListBuffer();
        this.PINNED_POOL_SIZE = this.conf("spark.rapids.memory.pinnedPool.size").doc("The size of the pinned memory pool in bytes unless otherwise specified. Use 0 to disable the pool.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)0L));
        this.PAGEABLE_POOL_SIZE = this.conf("spark.rapids.memory.host.pageablePool.size").doc("The size of the pageable memory pool in bytes unless otherwise specified. Use 0 to disable the pool.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)ByteUnit.GiB.toBytes(1L)));
        this.RMM_DEBUG = this.conf("spark.rapids.memory.gpu.debug").doc("Provides a log of GPU memory allocations and frees. If set to STDOUT or STDERR the logging will go there. Setting it to NONE disables logging. All other values are reserved for possible future expansion and in the mean time will disable logging.").stringConf().createWithDefault("NONE");
        this.GPU_OOM_DUMP_DIR = this.conf("spark.rapids.memory.gpu.oomDumpDir").doc("The path to a local directory where a heap dump will be created if the GPU encounters an unrecoverable out-of-memory (OOM) error. The filename will be of the form: \"gpu-oom-<pid>.hprof\" where <pid> is the process ID.").stringConf().createOptional();
        this.RMM_ALLOC_MAX_FRACTION_KEY = "spark.rapids.memory.gpu.maxAllocFraction";
        this.RMM_ALLOC_MIN_FRACTION_KEY = "spark.rapids.memory.gpu.minAllocFraction";
        this.RMM_ALLOC_RESERVE_KEY = "spark.rapids.memory.gpu.reserve";
        this.RMM_ALLOC_FRACTION = this.conf("spark.rapids.memory.gpu.allocFraction").doc(new StringBuilder(221).append("The fraction of available (free) GPU memory that should be allocated for pooled memory. This must be less than or equal to the maximum limit configured via ").append(this.RMM_ALLOC_MAX_FRACTION_KEY()).append(", and greater than or equal to the minimum limit configured ").append("via ").append(this.RMM_ALLOC_MIN_FRACTION_KEY()).append(".").toString()).doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> v >= 0.0 && v <= 1.0, "The fraction value must be in [0, 1].").createWithDefault(BoxesRunTime.boxToDouble((double)1.0));
        this.RMM_EXACT_ALLOC = this.conf("spark.rapids.memory.gpu.allocSize").doc("The exact size in byte that RMM should allocate. This is intended to only be used for testing.").internal().bytesConf(ByteUnit.BYTE).createOptional();
        this.RMM_ALLOC_MAX_FRACTION = this.conf(this.RMM_ALLOC_MAX_FRACTION_KEY()).doc(new StringBuilder(214).append("The fraction of total GPU memory that limits the maximum size of the RMM pool. ").append("The value must be greater than or equal to the setting for ").append(this.RMM_ALLOC_FRACTION()).append(". ").append("Note that this limit will be reduced by the reserve memory configured in ").append(this.RMM_ALLOC_RESERVE_KEY()).append(".").toString()).doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> v >= 0.0 && v <= 1.0, "The fraction value must be in [0, 1].").createWithDefault(BoxesRunTime.boxToDouble((double)1.0));
        this.RMM_ALLOC_MIN_FRACTION = this.conf(this.RMM_ALLOC_MIN_FRACTION_KEY()).doc(new StringBuilder(136).append("The fraction of total GPU memory that limits the minimum size of the RMM pool. ").append("The value must be less than or equal to the setting for ").append(this.RMM_ALLOC_FRACTION()).append(".").toString()).doubleConf().checkValue((Function1<Object, Object>)(JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> v >= 0.0 && v <= 1.0, "The fraction value must be in [0, 1].").createWithDefault(BoxesRunTime.boxToDouble((double)0.25));
        this.RMM_ALLOC_RESERVE = this.conf(this.RMM_ALLOC_RESERVE_KEY()).doc("The amount of GPU memory that should remain unallocated by RMM and left for system use such as memory needed for kernels and kernel launches.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)ByteUnit.MiB.toBytes(640L)));
        this.HOST_SPILL_STORAGE_SIZE = this.conf("spark.rapids.memory.host.spillStorageSize").doc("Amount of off-heap host memory to use for buffering spilled GPU data before spilling to local disk. Use -1 to set the amount to the combined size of pinned and pageable memory pools.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)-1L));
        this.UNSPILL = this.conf("spark.rapids.memory.gpu.unspill.enabled").doc("When a spilled GPU buffer is needed again, should it be unspilled, or only copied back into GPU memory temporarily. Unspilling may be useful for GPU buffers that are needed frequently, for example, broadcast variables; however, it may also increase GPU memory usage").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.GDS_SPILL = this.conf("spark.rapids.memory.gpu.direct.storage.spill.enabled").doc("Should GPUDirect Storage (GDS) be used to spill GPU memory buffers directly to disk. GDS must be enabled and the directory `spark.local.dir` must support GDS. This is an experimental feature. For more information on GDS, see https://docs.nvidia.com/gpudirect-storage/.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.GDS_SPILL_BATCH_WRITE_BUFFER_SIZE = this.conf("spark.rapids.memory.gpu.direct.storage.spill.batchWriteBuffer.size").doc("The size of the GPU memory buffer used to batch small buffers when spilling to GDS. Note that this buffer is mapped to the PCI Base Address Register (BAR) space, which may be very limited on some GPUs (e.g. the NVIDIA T4 only has 256 MiB), and it is also used by UCX bounce buffers.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)ByteUnit.MiB.toBytes(8L)));
        this.POOLED_MEM = this.conf("spark.rapids.memory.gpu.pooling.enabled").doc("Should RMM act as a pooling allocator for GPU memory, or should it just pass through to CUDA memory allocation directly. DEPRECATED: please use spark.rapids.memory.gpu.pool instead.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.RMM_POOL = this.conf("spark.rapids.memory.gpu.pool").doc("Select the RMM pooling allocator to use. Valid values are \"DEFAULT\", \"ARENA\", \"ASYNC\", and \"NONE\". With \"DEFAULT\", the RMM pool allocator is used; with \"ARENA\", the RMM arena allocator is used; with \"ASYNC\", the new CUDA stream-ordered memory allocator in CUDA 11.2+ is used. If set to \"NONE\", pooling is disabled and RMM just passes through to CUDA memory allocation directly.").stringConf().createWithDefault("ASYNC");
        this.CONCURRENT_GPU_TASKS = this.conf("spark.rapids.sql.concurrentGpuTasks").doc("Set the number of tasks that can execute concurrently per GPU. Tasks may temporarily block when the number of concurrent tasks in the executor exceeds this amount. Allowing too many concurrent tasks on the same GPU may lead to GPU out of memory errors.").integerConf().createWithDefault(Predef$.MODULE$.int2Integer(1));
        this.SHUFFLE_SPILL_THREADS = this.conf("spark.rapids.sql.shuffle.spillThreads").doc("Number of threads used to spill shuffle data to disk in the background.").integerConf().createWithDefault(Predef$.MODULE$.int2Integer(6));
        this.GPU_BATCH_SIZE_BYTES = this.conf("spark.rapids.sql.batchSizeBytes").doc("Set the target number of bytes for a GPU batch. Splits sizes for input data is covered by separate configs. The maximum setting is 2 GB to avoid exceeding the cudf row count limit of a column.").bytesConf(ByteUnit.BYTE).checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)v -> v >= 0L && v <= Integer.MAX_VALUE, new StringBuilder(50).append("Batch size must be positive and not exceed ").append(Integer.MAX_VALUE).append(" bytes.").toString()).createWithDefault(BoxesRunTime.boxToLong((long)Integer.MAX_VALUE));
        this.MAX_READER_BATCH_SIZE_ROWS = this.conf("spark.rapids.sql.reader.batchSizeRows").doc("Soft limit on the maximum number of rows the reader will read per batch. The orc and parquet readers will read row groups until this limit is met or exceeded. The limit is respected by the csv reader.").integerConf().createWithDefault(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        this.MAX_READER_BATCH_SIZE_BYTES = this.conf("spark.rapids.sql.reader.batchSizeBytes").doc("Soft limit on the maximum number of bytes the reader reads per batch. The readers will read chunks of data until this limit is met or exceeded. Note that the reader may estimate the number of bytes that will be used on the GPU in some cases based on the schema and number of rows in each batch.").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)Integer.MAX_VALUE));
        this.DRIVER_TIMEZONE = this.conf("spark.rapids.driver.user.timezone").doc("This config is used to inform the executor plugin about the driver's timezone and is not intended to be set by the user.").internal().stringConf().createOptional();
        this.UVM_ENABLED = this.conf("spark.rapids.memory.uvm.enabled").doc("UVM or universal memory can allow main host memory to act essentially as swap for device(GPU) memory. This allows the GPU to process more data than fits in memory, but can result in slower processing. This is an experimental feature.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.EXPORT_COLUMNAR_RDD = this.conf("spark.rapids.sql.exportColumnarRdd").doc("Spark has no simply way to export columnar RDD data.  This turns on special processing/tagging that allows the RDD to be picked back apart into a Columnar RDD.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SHUFFLED_HASH_JOIN_OPTIMIZE_SHUFFLE = this.conf("spark.rapids.sql.shuffledHashJoin.optimizeShuffle").doc("Enable or disable an optimization where shuffled build side batches are kept on the host while the first stream batch is loaded onto the GPU. The optimization increases off-heap host memory usage to avoid holding onto the GPU semaphore while waiting for stream side IO.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.STABLE_SORT = this.conf("spark.rapids.sql.stableSort.enabled").doc("Enable or disable stable sorting. Apache Spark's sorting is typically a stable sort, but sort stability cannot be guaranteed in distributed work loads because the order in which upstream data arrives to a task is not guaranteed. Sort stability then only matters when reading and sorting data from a file using a single task/partition. Because of limitations in the plugin when you enable stable sorting all of the data for a single task will be combined into a single batch before sorting. This currently disables spilling from GPU memory if the data size is too large.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.METRICS_LEVEL = this.conf("spark.rapids.sql.metrics.level").doc("GPU plans can produce a lot more metrics than CPU plans do. In very large queries this can sometimes result in going over the max result size limit for the driver. Supported values include DEBUG which will enable all metrics supported and typically only needs to be enabled when debugging the plugin. MODERATE which should output enough metrics to understand how long each part of the query is taking and how much data is going to each part of the query. ESSENTIAL which disables most metrics except those Apache Spark CPU plans will also report or their equivalents.").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$13 -> x$13.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DEBUG", "MODERATE", "ESSENTIAL"})))).createWithDefault("MODERATE");
        this.IMPROVED_TIMESTAMP_OPS = this.conf("spark.rapids.sql.improvedTimeOps.enabled").doc("When set to true, some operators will avoid overflowing by converting epoch days directly to seconds without first converting to microseconds").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SQL_ENABLED = this.conf("spark.rapids.sql.enabled").doc("Enable (true) or disable (false) sql operations on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SQL_MODE = this.conf("spark.rapids.sql.mode").doc("Set the mode for the Rapids Accelerator. The supported modes are explainOnly and executeOnGPU. This config can not be changed at runtime, you must restart the application for it to take affect. The default mode is executeOnGPU, which means the RAPIDS Accelerator plugin convert the Spark operations and execute them on the GPU when possible. The explainOnly mode allows running queries on the CPU and the RAPIDS Accelerator will evaluate the queries as if it was going to run on the GPU. The explanations of what would have run on the GPU and why are output in log messages. When using explainOnly mode, the default explain output is ALL, this can be changed by setting spark.rapids.sql.explain. See that config for more details.").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$14 -> x$14.toLowerCase(Locale.ROOT)).checkValues((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"explainonly", "executeongpu"})))).createWithDefault("executeongpu");
        this.UDF_COMPILER_ENABLED = this.conf("spark.rapids.sql.udfCompiler.enabled").doc("When set to true, Scala UDFs will be considered for compilation as Catalyst expressions").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.INCOMPATIBLE_OPS = this.conf("spark.rapids.sql.incompatibleOps.enabled").doc("For operations that work, but are not 100% compatible with the Spark equivalent set if they should be enabled by default or disabled by default.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.INCOMPATIBLE_DATE_FORMATS = this.conf("spark.rapids.sql.incompatibleDateFormats.enabled").doc("When parsing strings as dates and timestamps in functions like unix_timestamp, some formats are fully supported on the GPU and some are unsupported and will fall back to the CPU.  Some formats behave differently on the GPU than the CPU.  Spark on the CPU interprets date formats with unsupported trailing characters as nulls, while Spark on the GPU will parse the date with invalid trailing characters. More detail can be found at [parsing strings as dates or timestamps](compatibility.md#parsing-strings-as-dates-or-timestamps).").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.IMPROVED_FLOAT_OPS = this.conf("spark.rapids.sql.improvedFloatOps.enabled").doc("For some floating point operations spark uses one way to compute the value and the underlying cudf implementation can use an improved algorithm. In some cases this can result in cudf producing an answer when spark overflows.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.HAS_NANS = this.conf("spark.rapids.sql.hasNans").doc("Config to indicate if your data has NaN's. Cudf doesn't currently support NaN's properly so you can get corrupt data if you have NaN's in your data and it runs on the GPU.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.NEED_DECIMAL_OVERFLOW_GUARANTEES = this.conf("spark.rapids.sql.decimalOverflowGuarantees").doc("FOR TESTING ONLY. DO NOT USE IN PRODUCTION. Please see the decimal section of the compatibility documents for more information on this config.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_FLOAT_AGG = this.conf("spark.rapids.sql.variableFloatAgg.enabled").doc("Spark assumes that all operations produce the exact same result each time. This is not true for some floating point aggregations, which can produce slightly different results on the GPU as the aggregation is done in parallel.  This can enable those operations if you know the query is only computing it once.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_REPLACE_SORTMERGEJOIN = this.conf("spark.rapids.sql.replaceSortMergeJoin.enabled").doc("Allow replacing sortMergeJoin with HashJoin").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_HASH_OPTIMIZE_SORT = this.conf("spark.rapids.sql.hashOptimizeSort.enabled").doc("Whether sorts should be inserted after some hashed operations to improve output ordering. This can improve output file sizes when saving to columnar formats.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_CAST_FLOAT_TO_DECIMAL = this.conf("spark.rapids.sql.castFloatToDecimal.enabled").doc("Casting from floating point types to decimal on the GPU returns results that have tiny difference compared to results returned from CPU.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_FLOAT_TO_STRING = this.conf("spark.rapids.sql.castFloatToString.enabled").doc("Casting from floating point types to string on the GPU returns results that have a different precision than the default results of Spark.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_FLOAT_TO_INTEGRAL_TYPES = this.conf("spark.rapids.sql.castFloatToIntegralTypes.enabled").doc("Casting from floating point types to integral types on the GPU supports a slightly different range of values when using Spark 3.1.0 or later. Refer to the CAST documentation for more details.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_DECIMAL_TO_FLOAT = this.conf("spark.rapids.sql.castDecimalToFloat.enabled").doc("Casting from decimal to floating point types on the GPU returns results that have tiny difference compared to results returned from CPU.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_STRING_TO_FLOAT = this.conf("spark.rapids.sql.castStringToFloat.enabled").doc("When set to true, enables casting from strings to float types (float, double) on the GPU. Currently hex values aren't supported on the GPU. Also note that casting from string to float types on the GPU returns incorrect results when the string represents any number \"1.7976931348623158E308\" <= x < \"1.7976931348623159E308\" and \"-1.7976931348623158E308\" >= x > \"-1.7976931348623159E308\" in both these cases the GPU returns Double.MaxValue while CPU returns \"+Infinity\" and \"-Infinity\" respectively").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_STRING_TO_TIMESTAMP = this.conf("spark.rapids.sql.castStringToTimestamp.enabled").doc("When set to true, casting from string to timestamp is supported on the GPU. The GPU only supports a subset of formats when casting strings to timestamps. Refer to the CAST documentation for more details.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.HAS_EXTENDED_YEAR_VALUES = this.conf("spark.rapids.sql.hasExtendedYearValues").doc("Spark 3.2.0+ extended parsing of years in dates and timestamps to support the full range of possible values. Prior to this it was limited to a positive 4 digit year. The Accelerator does not support the extended range yet. This config indicates if your data includes this extended range or not, or if you don't care about getting the correct values on values with the extended range.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CAST_DECIMAL_TO_STRING = this.conf("spark.rapids.sql.castDecimalToString.enabled").doc("When set to true, casting from decimal to string is supported on the GPU. The GPU does NOT produce exact same string as spark produces, but producing strings which are semantically equal. For instance, given input BigDecimal(123, -2), the GPU produces \"12300\", which spark produces \"1.23E+4\".").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_INNER_JOIN = this.conf("spark.rapids.sql.join.inner.enabled").doc("When set to true inner joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CROSS_JOIN = this.conf("spark.rapids.sql.join.cross.enabled").doc("When set to true cross joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_LEFT_OUTER_JOIN = this.conf("spark.rapids.sql.join.leftOuter.enabled").doc("When set to true left outer joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_RIGHT_OUTER_JOIN = this.conf("spark.rapids.sql.join.rightOuter.enabled").doc("When set to true right outer joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_FULL_OUTER_JOIN = this.conf("spark.rapids.sql.join.fullOuter.enabled").doc("When set to true full outer joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_LEFT_SEMI_JOIN = this.conf("spark.rapids.sql.join.leftSemi.enabled").doc("When set to true left semi joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_LEFT_ANTI_JOIN = this.conf("spark.rapids.sql.join.leftAnti.enabled").doc("When set to true left anti joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_EXISTENCE_JOIN = this.conf("spark.rapids.sql.join.existence.enabled").doc("When set to true existence joins are enabled on the GPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_PROJECT_AST = this.conf("spark.rapids.sql.projectAstEnabled").doc("Enable project operations to use cudf AST expressions when possible.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.MULTITHREAD_READ_NUM_THREADS = this.conf("spark.rapids.sql.multiThreadedRead.numThreads").doc(new StringBuilder(584).append("The maximum number of threads on each executor to use for reading small files in parallel. This can not be changed at runtime after the executor has started. Used with COALESCING and MULTITHREADED readers, see spark.rapids.sql.format.parquet.reader.type, spark.rapids.sql.format.orc.reader.type, or spark.rapids.sql.format.avro.reader.type for a discussion of reader types. If it is not set explicitly and spark.executor.cores is set, it will be tried to assign value of `max(MULTITHREAD_READ_NUM_THREADS_DEFAULT, spark.executor.cores)`, ").append("where MULTITHREAD_READ_NUM_THREADS_DEFAULT = ").append(this.MULTITHREAD_READ_NUM_THREADS_DEFAULT()).append(".").toString()).integerConf().checkValue((Function1<Integer, Object>)(Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)RapidsConf$.$anonfun$MULTITHREAD_READ_NUM_THREADS$1(v)), "The thread count must be greater than zero.").createWithDefault(Predef$.MODULE$.int2Integer(this.MULTITHREAD_READ_NUM_THREADS_DEFAULT()));
        this.ENABLE_PARQUET = this.conf("spark.rapids.sql.format.parquet.enabled").doc("When set to false disables all parquet input and output acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_PARQUET_INT96_WRITE = this.conf("spark.rapids.sql.format.parquet.writer.int96.enabled").doc("When set to false, disables accelerated parquet write if the spark.sql.parquet.outputTimestampType is set to INT96").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.PARQUET_READER_FOOTER_TYPE = this.conf("spark.rapids.sql.format.parquet.reader.footer.type").doc("In some cases reading the footer of the file is very expensive. Typically this happens when there are a large number of columns and relatively few of them are being read on a large number of files. This provides the ability to use a different path to parse and filter the footer. AUTO is the default and decides which path to take using a heuristic. JAVA follows closely with what Apache Spark does. NATIVE will parse and filter the footer using C++.").stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$15 -> x$15.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)RapidsConf$ParquetFooterReaderType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RapidsConf$ParquetFooterReaderType$.MODULE$.AUTO().toString());
        this.ENABLE_CPU_BASED_UDF = this.conf("spark.rapids.sql.rowBasedUDF.enabled").doc("When set to true, optimizes a row-based UDF in a GPU operation by transferring only the data it needs between GPU and CPU inside a query operation, instead of falling this operation back to CPU. This is an experimental feature, and this config might be removed in the future.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.PARQUET_READER_TYPE = this.conf("spark.rapids.sql.format.parquet.reader.type").doc(new StringBuilder(1499).append("Sets the Parquet reader type. We support different types that are optimized for different environments. The original Spark style reader can be selected by setting this to PERFILE which individually reads and copies files to the GPU. Loading many small files individually has high overhead, and using either COALESCING or MULTITHREADED is recommended instead. The COALESCING reader is good when using a local file system where the executors are on the same nodes or close to the nodes the data is being read on. This reader coalesces all the files assigned to a task into a single host buffer before sending it down to the GPU. It copies blocks from a single file into a host buffer in ").append("separate threads in parallel, see ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(". ").append("MULTITHREADED is good for cloud environments where you are reading from a blobstore ").append("that is totally separate and likely has a higher I/O read cost. Many times the cloud ").append("environments also get better throughput when you have multiple readers in parallel. ").append("This reader uses multiple threads to read each file in parallel and each file is sent ").append("to the GPU separately. This allows the CPU to keep reading while GPU is also doing work. ").append("See ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(" and ").append("spark.rapids.sql.format.parquet.multiThreadedRead.maxNumFilesParallel to control ").append("the number of threads and amount of memory used. ").append("By default this is set to AUTO so we select the reader we think is best. This will ").append("either be the COALESCING or the MULTITHREADED based on whether we think the file is ").append("in the cloud. See spark.rapids.cloudSchemes.").toString()).stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$17 -> x$17.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)RapidsReaderType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RapidsReaderType$.MODULE$.AUTO().toString());
        this.CLOUD_SCHEMES = this.conf("spark.rapids.cloudSchemes").doc(new StringBuilder(403).append("Comma separated list of additional URI schemes that are to be considered cloud based ").append("filesystems. Schemes already included: ").append(this.com$nvidia$spark$rapids$RapidsConf$$DEFAULT_CLOUD_SCHEMES().mkString(", ")).append(". Cloud ").append("based stores generally would be total separate from the executors and likely have a ").append("higher I/O read cost. Many times the cloud filesystems also get better throughput when ").append("you have multiple readers in parallel. This is used with ").append("spark.rapids.sql.format.parquet.reader.type").toString()).stringConf().toSequence().createOptional();
        this.PARQUET_MULTITHREAD_READ_NUM_THREADS = this.conf("spark.rapids.sql.format.parquet.multiThreadedRead.numThreads").doc(new StringBuilder(236).append("The maximum number of threads, on the executor, to use for reading small Parquet files in parallel. This can not be changed at runtime after the executor has started. Used with COALESCING and MULTITHREADED reader, see ").append(this.PARQUET_READER_TYPE()).append(". DEPRECATED: use ").append(this.MULTITHREAD_READ_NUM_THREADS()).toString()).integerConf().createOptional();
        this.PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL = this.conf("spark.rapids.sql.format.parquet.multiThreadedRead.maxNumFilesParallel").doc(new StringBuilder(239).append("A limit on the maximum number of files per task processed in parallel on the CPU side before the file is sent to the GPU. This affects the amount of host memory used when reading the files in parallel. Used with MULTITHREADED reader, see ").append(this.PARQUET_READER_TYPE()).append(".").toString()).integerConf().checkValue((Function1<Integer, Object>)(Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)RapidsConf$.$anonfun$PARQUET_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(v)), "The maximum number of files must be greater than 0.").createWithDefault(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        this.ENABLE_PARQUET_READ = this.conf("spark.rapids.sql.format.parquet.read.enabled").doc("When set to false disables parquet input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_PARQUET_WRITE = this.conf("spark.rapids.sql.format.parquet.write.enabled").doc("When set to false disables parquet output acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_ORC = this.conf("spark.rapids.sql.format.orc.enabled").doc("When set to false disables all orc input and output acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_ORC_READ = this.conf("spark.rapids.sql.format.orc.read.enabled").doc("When set to false disables orc input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_ORC_WRITE = this.conf("spark.rapids.sql.format.orc.write.enabled").doc("When set to false disables orc output acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ORC_READER_TYPE = this.conf("spark.rapids.sql.format.orc.reader.type").doc(new StringBuilder(1491).append("Sets the ORC reader type. We support different types that are optimized for different environments. The original Spark style reader can be selected by setting this to PERFILE which individually reads and copies files to the GPU. Loading many small files individually has high overhead, and using either COALESCING or MULTITHREADED is recommended instead. The COALESCING reader is good when using a local file system where the executors are on the same nodes or close to the nodes the data is being read on. This reader coalesces all the files assigned to a task into a single host buffer before sending it down to the GPU. It copies blocks from a single file into a host buffer in ").append("separate threads in parallel, see ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(". ").append("MULTITHREADED is good for cloud environments where you are reading from a blobstore ").append("that is totally separate and likely has a higher I/O read cost. Many times the cloud ").append("environments also get better throughput when you have multiple readers in parallel. ").append("This reader uses multiple threads to read each file in parallel and each file is sent ").append("to the GPU separately. This allows the CPU to keep reading while GPU is also doing work. ").append("See ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(" and ").append("spark.rapids.sql.format.orc.multiThreadedRead.maxNumFilesParallel to control ").append("the number of threads and amount of memory used. ").append("By default this is set to AUTO so we select the reader we think is best. This will ").append("either be the COALESCING or the MULTITHREADED based on whether we think the file is ").append("in the cloud. See spark.rapids.cloudSchemes.").toString()).stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$19 -> x$19.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)RapidsReaderType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RapidsReaderType$.MODULE$.AUTO().toString());
        this.ORC_MULTITHREAD_READ_NUM_THREADS = this.conf("spark.rapids.sql.format.orc.multiThreadedRead.numThreads").doc(new StringBuilder(217).append("The maximum number of threads, on the executor, to use for reading small ORC files in parallel. This can not be changed at runtime after the executor has started. Used with MULTITHREADED reader, see ").append(this.ORC_READER_TYPE()).append(". DEPRECATED: use ").append(this.MULTITHREAD_READ_NUM_THREADS()).toString()).integerConf().createOptional();
        this.ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL = this.conf("spark.rapids.sql.format.orc.multiThreadedRead.maxNumFilesParallel").doc(new StringBuilder(239).append("A limit on the maximum number of files per task processed in parallel on the CPU side before the file is sent to the GPU. This affects the amount of host memory used when reading the files in parallel. Used with MULTITHREADED reader, see ").append(this.ORC_READER_TYPE()).append(".").toString()).integerConf().checkValue((Function1<Integer, Object>)(Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)RapidsConf$.$anonfun$ORC_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(v)), "The maximum number of files must be greater than 0.").createWithDefault(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        this.ENABLE_CSV = this.conf("spark.rapids.sql.format.csv.enabled").doc("When set to false disables all csv input and output acceleration. (only input is currently supported anyways)").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_CSV_READ = this.conf("spark.rapids.sql.format.csv.read.enabled").doc("When set to false disables csv input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_READ_CSV_FLOATS = this.conf("spark.rapids.sql.csv.read.float.enabled").doc("CSV reading is not 100% compatible when reading floats.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_READ_CSV_DOUBLES = this.conf("spark.rapids.sql.csv.read.double.enabled").doc("CSV reading is not 100% compatible when reading doubles.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_READ_CSV_DECIMALS = this.conf("spark.rapids.sql.csv.read.decimal.enabled").doc("CSV reading is not 100% compatible when reading decimals.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_JSON = this.conf("spark.rapids.sql.format.json.enabled").doc("When set to true enables all json input and output acceleration. (only input is currently supported anyways)").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_JSON_READ = this.conf("spark.rapids.sql.format.json.read.enabled").doc("When set to true enables json input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_READ_JSON_FLOATS = this.conf("spark.rapids.sql.json.read.float.enabled").doc("JSON reading is not 100% compatible when reading floats.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_READ_JSON_DOUBLES = this.conf("spark.rapids.sql.json.read.double.enabled").doc("JSON reading is not 100% compatible when reading doubles.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_READ_JSON_DECIMALS = this.conf("spark.rapids.sql.json.read.decimal.enabled").doc("JSON reading is not 100% compatible when reading decimals.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_AVRO = this.conf("spark.rapids.sql.format.avro.enabled").doc("When set to true enables all avro input and output acceleration. (only input is currently supported anyways)").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_AVRO_READ = this.conf("spark.rapids.sql.format.avro.read.enabled").doc("When set to true enables avro input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.AVRO_READER_TYPE = this.conf("spark.rapids.sql.format.avro.reader.type").doc(new StringBuilder(1493).append("Sets the Avro reader type. We support different types that are optimized for different environments. The original Spark style reader can be selected by setting this to PERFILE which individually reads and copies files to the GPU. Loading many small files individually has high overhead, and using either COALESCING or MULTITHREADED is recommended instead. The COALESCING reader is good when using a local file system where the executors are on the same nodes or close to the nodes the data is being read on. This reader coalesces all the files assigned to a task into a single host buffer before sending it down to the GPU. It copies blocks from a single file into a host buffer in ").append("separate threads in parallel, see ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(". ").append("MULTITHREADED is good for cloud environments where you are reading from a blobstore ").append("that is totally separate and likely has a higher I/O read cost. Many times the cloud ").append("environments also get better throughput when you have multiple readers in parallel. ").append("This reader uses multiple threads to read each file in parallel and each file is sent ").append("to the GPU separately. This allows the CPU to keep reading while GPU is also doing work. ").append("See ").append(this.MULTITHREAD_READ_NUM_THREADS()).append(" and ").append("spark.rapids.sql.format.avro.multiThreadedRead.maxNumFilesParallel to control ").append("the number of threads and amount of memory used. ").append("By default this is set to AUTO so we select the reader we think is best. This will ").append("either be the COALESCING or the MULTITHREADED based on whether we think the file is ").append("in the cloud. See spark.rapids.cloudSchemes.").toString()).stringConf().transform((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$21 -> x$21.toUpperCase(Locale.ROOT)).checkValues((Set<String>)((Set)RapidsReaderType$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RapidsReaderType$.MODULE$.AUTO().toString());
        this.AVRO_MULTITHREAD_READ_NUM_THREADS = this.conf("spark.rapids.sql.format.avro.multiThreadedRead.numThreads").doc(new StringBuilder(218).append("The maximum number of threads, on one executor, to use for reading small Avro files in parallel. This can not be changed at runtime after the executor has started. Used with MULTITHREADED reader, see ").append(this.AVRO_READER_TYPE()).append(". DEPRECATED: use ").append(this.MULTITHREAD_READ_NUM_THREADS()).toString()).integerConf().createOptional();
        this.AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL = this.conf("spark.rapids.sql.format.avro.multiThreadedRead.maxNumFilesParallel").doc(new StringBuilder(239).append("A limit on the maximum number of files per task processed in parallel on the CPU side before the file is sent to the GPU. This affects the amount of host memory used when reading the files in parallel. Used with MULTITHREADED reader, see ").append(this.AVRO_READER_TYPE()).append(".").toString()).integerConf().checkValue((Function1<Integer, Object>)(Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)RapidsConf$.$anonfun$AVRO_MULTITHREAD_READ_MAX_NUM_FILES_PARALLEL$1(v)), "The maximum number of files must be greater than 0.").createWithDefault(Predef$.MODULE$.int2Integer(Integer.MAX_VALUE));
        this.ENABLE_ICEBERG = this.conf("spark.rapids.sql.format.iceberg.enabled").doc("When set to false disables all Iceberg acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_ICEBERG_READ = this.conf("spark.rapids.sql.format.iceberg.read.enabled").doc("When set to false disables Iceberg input acceleration").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_RANGE_WINDOW_BYTES = this.conf("spark.rapids.sql.window.range.byte.enabled").doc("When the order-by column of a range based window is byte type and the range boundary calculated for a value has overflow, CPU and GPU will get the different results. When set to false disables the range window acceleration for the byte type order-by column").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_RANGE_WINDOW_SHORT = this.conf("spark.rapids.sql.window.range.short.enabled").doc("When the order-by column of a range based window is short type and the range boundary calculated for a value has overflow, CPU and GPU will get the different results. When set to false disables the range window acceleration for the short type order-by column").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_RANGE_WINDOW_INT = this.conf("spark.rapids.sql.window.range.int.enabled").doc("When the order-by column of a range based window is int type and the range boundary calculated for a value has overflow, CPU and GPU will get the different results. When set to false disables the range window acceleration for the int type order-by column").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_RANGE_WINDOW_LONG = this.conf("spark.rapids.sql.window.range.long.enabled").doc("When the order-by column of a range based window is long type and the range boundary calculated for a value has overflow, CPU and GPU will get the different results. When set to false disables the range window acceleration for the long type order-by column").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.ENABLE_REGEXP = this.conf("spark.rapids.sql.regexp.enabled").doc("Specifies whether supported regular expressions will be evaluated on the GPU. Unsupported expressions will fall back to CPU. However, there are some known edge cases that will still execute on GPU and produce incorrect results and these are documented in the compatibility guide. Setting this config to false will make all regular expressions run on the CPU instead.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.TEST_CONF = this.conf("spark.rapids.sql.test.enabled").doc("Intended to be used by unit tests, if enabled all operations must run on the GPU or an error happens.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.TEST_ALLOWED_NONGPU = this.conf("spark.rapids.sql.test.allowedNonGpu").doc("Comma separate string of exec or expression class names that are allowed to not be GPU accelerated for testing.").internal().stringConf().toSequence().createWithDefault((Seq<String>)Nil$.MODULE$);
        this.TEST_VALIDATE_EXECS_ONGPU = this.conf("spark.rapids.sql.test.validateExecsInGpuPlan").doc("Comma separate string of exec class names to validate they are GPU accelerated. Used for testing.").internal().stringConf().toSequence().createWithDefault((Seq<String>)Nil$.MODULE$);
        this.PARQUET_DEBUG_DUMP_PREFIX = this.conf("spark.rapids.sql.parquet.debug.dumpPrefix").doc("A path prefix where Parquet split file data is dumped for debugging.").internal().stringConf().createWithDefault(null);
        this.ORC_DEBUG_DUMP_PREFIX = this.conf("spark.rapids.sql.orc.debug.dumpPrefix").doc("A path prefix where ORC split file data is dumped for debugging.").internal().stringConf().createWithDefault(null);
        this.AVRO_DEBUG_DUMP_PREFIX = this.conf("spark.rapids.sql.avro.debug.dumpPrefix").doc("A path prefix where AVRO split file data is dumped for debugging.").internal().stringConf().createWithDefault(null);
        this.HASH_AGG_REPLACE_MODE = this.conf("spark.rapids.sql.hashAgg.replaceMode").doc("Only when hash aggregate exec has these modes (\"all\" by default): \"all\" (try to replace all aggregates, default), \"complete\" (exclusively replace complete aggregates), \"partial\" (exclusively replace partial aggregates), \"final\" (exclusively replace final aggregates). These modes can be connected with &(AND) or |(OR) to form sophisticated patterns.").internal().stringConf().createWithDefault("all");
        this.PARTIAL_MERGE_DISTINCT_ENABLED = this.conf("spark.rapids.sql.partialMerge.distinct.enabled").doc("Enables aggregates that are in PartialMerge mode to run on the GPU if true").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SHUFFLE_MANAGER_ENABLED = this.conf("spark.rapids.shuffle.enabled").doc("Enable or disable the RAPIDS Shuffle Manager at runtime. The [RAPIDS Shuffle Manager](additional-functionality/rapids-shuffle.md) must already be configured. When set to `false`, the built-in Spark shuffle will be used. ").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SHUFFLE_MANAGER_MODE = this.conf("spark.rapids.shuffle.mode").doc("RAPIDS Shuffle Manager mode. The default mode is \"UCX\", which has to be installed in the system. Consider setting to \"CACHE_ONLY\" if running with a single executor and UCX is not installed, for short-circuit cached shuffle (for testing purposes). Set to \"MULTITHREADED\" for an experimental mode that uses a thread pool to speed up shuffle writes without needing UCX. Note: Changing this mode dynamically is not supported.").stringConf().checkValues((Set<String>)((Set)RapidsConf$RapidsShuffleManagerMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$23 -> x$23.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RapidsConf$RapidsShuffleManagerMode$.MODULE$.UCX().toString());
        this.SHUFFLE_TRANSPORT_EARLY_START = this.conf("spark.rapids.shuffle.transport.earlyStart").doc("Enable early connection establishment for RAPIDS Shuffle").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_INTERVAL = this.conf("spark.rapids.shuffle.transport.earlyStart.heartbeatInterval").doc("Shuffle early start heartbeat interval (milliseconds). Executors will send a heartbeat RPC message to the driver at this interval").integerConf().createWithDefault(Predef$.MODULE$.int2Integer(5000));
        this.SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_TIMEOUT = this.conf("spark.rapids.shuffle.transport.earlyStart.heartbeatTimeout").doc(new StringBuilder(178).append("Shuffle early start heartbeat timeout (milliseconds). ").append("Executors that don't heartbeat within this timeout will be considered stale. ").append("This timeout must be higher than the value for ").append(this.SHUFFLE_TRANSPORT_EARLY_START_HEARTBEAT_INTERVAL().key()).toString()).integerConf().createWithDefault(Predef$.MODULE$.int2Integer(10000));
        this.SHUFFLE_TRANSPORT_CLASS_NAME = this.conf("spark.rapids.shuffle.transport.class").doc("The class of the specific RapidsShuffleTransport to use during the shuffle.").internal().stringConf().createWithDefault("com.nvidia.spark.rapids.shuffle.ucx.UCXShuffleTransport");
        this.SHUFFLE_TRANSPORT_MAX_RECEIVE_INFLIGHT_BYTES = this.conf("spark.rapids.shuffle.transport.maxReceiveInflightBytes").doc("Maximum aggregate amount of bytes that be fetched at any given time from peers during shuffle").bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)0x40000000L));
        this.SHUFFLE_UCX_ACTIVE_MESSAGES_FORCE_RNDV = this.conf("spark.rapids.shuffle.ucx.activeMessages.forceRndv").doc("Set to true to force 'rndv' mode for all UCX Active Messages. This should only be required with UCX 1.10.x. UCX 1.11.x deployments should set to false.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.SHUFFLE_UCX_USE_WAKEUP = this.conf("spark.rapids.shuffle.ucx.useWakeup").doc("When set to true, use UCX's event-based progress (epoll) in order to wake up the progress thread when needed, instead of a hot loop.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SHUFFLE_UCX_LISTENER_START_PORT = this.conf("spark.rapids.shuffle.ucx.listenerStartPort").doc("Starting port to try to bind the UCX listener.").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(0));
        this.SHUFFLE_UCX_MGMT_SERVER_HOST = this.conf("spark.rapids.shuffle.ucx.managementServerHost").doc("The host to be used to start the management server").stringConf().createWithDefault(null);
        this.SHUFFLE_UCX_MGMT_CONNECTION_TIMEOUT = this.conf("spark.rapids.shuffle.ucx.managementConnectionTimeout").doc("The timeout for client connections to a remote peer").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(0));
        this.SHUFFLE_UCX_BOUNCE_BUFFERS_SIZE = this.conf("spark.rapids.shuffle.ucx.bounceBuffers.size").doc("The size of bounce buffer to use in bytes. Note that this size will be the same for device and host memory").internal().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)0x400000L));
        this.SHUFFLE_UCX_BOUNCE_BUFFERS_DEVICE_COUNT = this.conf("spark.rapids.shuffle.ucx.bounceBuffers.device.count").doc("The number of bounce buffers to pre-allocate from device memory").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(32));
        this.SHUFFLE_UCX_BOUNCE_BUFFERS_HOST_COUNT = this.conf("spark.rapids.shuffle.ucx.bounceBuffers.host.count").doc("The number of bounce buffers to pre-allocate from host memory").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(32));
        this.SHUFFLE_MAX_CLIENT_THREADS = this.conf("spark.rapids.shuffle.maxClientThreads").doc("The maximum number of threads that the shuffle client should be allowed to start").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(50));
        this.SHUFFLE_MAX_CLIENT_TASKS = this.conf("spark.rapids.shuffle.maxClientTasks").doc(new StringBuilder(153).append("The maximum number of tasks shuffle clients will queue before adding threads ").append("(up to spark.rapids.shuffle.maxClientThreads), or slowing down the transport").toString()).internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(100));
        this.SHUFFLE_CLIENT_THREAD_KEEPALIVE = this.conf("spark.rapids.shuffle.clientThreadKeepAlive").doc("The number of seconds that the ThreadPoolExecutor will allow an idle client shuffle thread to stay alive, before reclaiming.").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(30));
        this.SHUFFLE_MAX_SERVER_TASKS = this.conf("spark.rapids.shuffle.maxServerTasks").doc("The maximum number of tasks the shuffle server will queue up for its thread").internal().integerConf().createWithDefault(Predef$.MODULE$.int2Integer(1000));
        this.SHUFFLE_MAX_METADATA_SIZE = this.conf("spark.rapids.shuffle.maxMetadataSize").doc("The maximum size of a metadata message that the shuffle plugin will keep in its direct message pool. ").internal().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)512000L));
        this.SHUFFLE_COMPRESSION_CODEC = this.conf("spark.rapids.shuffle.compression.codec").doc("The GPU codec used to compress shuffle data when using RAPIDS shuffle. Supported codecs: lz4, copy, none").internal().stringConf().createWithDefault("none");
        this.SHUFFLE_COMPRESSION_LZ4_CHUNK_SIZE = this.conf("spark.rapids.shuffle.compression.lz4.chunkSize").doc("A configurable chunk size to use when compressing with LZ4.").internal().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)65536L));
        this.SHUFFLE_MULTITHREADED_WRITER_THREADS = this.conf("spark.rapids.shuffle.multiThreaded.writer.threads").doc("The number of threads to use for writing shuffle blocks per executor.").integerConf().createWithDefault(Predef$.MODULE$.int2Integer(20));
        this.ALLUXIO_PATHS_REPLACE = this.conf("spark.rapids.alluxio.pathsToReplace").doc("List of paths to be replaced with corresponding Alluxio scheme. E.g. when configure is set to \"s3://foo->alluxio://0.1.2.3:19998/foo,gs://bar->alluxio://0.1.2.3:19998/bar\", it means: \"s3://foo/a.csv\" will be replaced to \"alluxio://0.1.2.3:19998/foo/a.csv\" and \"gs://bar/b.csv\" will be replaced to \"alluxio://0.1.2.3:19998/bar/b.csv\". To use this config, you have to mount the buckets to Alluxio by yourself. If you set this config, spark.rapids.alluxio.automount.enabled won't be valid.").stringConf().toSequence().createOptional();
        this.ALLUXIO_AUTOMOUNT_ENABLED = this.conf("spark.rapids.alluxio.automount.enabled").doc("Enable the feature of auto mounting the cloud storage to Alluxio. It requires the Alluxio master is the same node of Spark driver node. When it's true, it requires an environment variable ALLUXIO_HOME be set properly. The default value of ALLUXIO_HOME is \"/opt/alluxio-2.8.0\". You can set it as an environment variable when running a spark-submit or you can use spark.yarn.appMasterEnv.ALLUXIO_HOME to set it on Yarn. The Alluxio master's host and port will be read from alluxio.master.hostname and alluxio.master.rpc.port(default: 19998) from ALLUXIO_HOME/conf/alluxio-site.properties, then replace a cloud path which matches spark.rapids.alluxio.bucket.regex like \"s3://bar/b.csv\" to \"alluxio://0.1.2.3:19998/bar/b.csv\", and the bucket \"s3://bar\" will be mounted to \"/bar\" in Alluxio automatically.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ALLUXIO_BUCKET_REGEX = this.conf("spark.rapids.alluxio.bucket.regex").doc("A regex to decide which bucket should be auto-mounted to Alluxio. E.g. when setting as \"^s3://bucket.*\", the bucket which starts with \"s3://bucket\" will be mounted to Alluxio and the path \"s3://bucket-foo/a.csv\" will be replaced to \"alluxio://0.1.2.3:19998/bucket-foo/a.csv\". It's only valid when setting spark.rapids.alluxio.automount.enabled=true. The default value matches all the buckets in \"s3://\" or \"s3a://\" scheme.").stringConf().createWithDefault("^s3a{0,1}://.*");
        this.ALLUXIO_CMD = this.conf("spark.rapids.alluxio.cmd").doc("Provide the Alluxio command, which is used to mount or get information. The default value is \"su,ubuntu,-c,/opt/alluxio-2.8.0/bin/alluxio\", it means: run Process(Seq(\"su\", \"ubuntu\", \"-c\", \"/opt/alluxio-2.8.0/bin/alluxio fs mount --readonly /bucket-foo s3://bucket-foo\")), to mount s3://bucket-foo to /bucket-foo. the delimiter \",\" is used to convert to Seq[String] when you need to use a special user to run the mount command.").stringConf().toSequence().createWithDefault((Seq<String>)new .colon.colon((Object)"su", (List)new .colon.colon((Object)"ubuntu", (List)new .colon.colon((Object)"-c", (List)new .colon.colon((Object)"/opt/alluxio-2.8.0/bin/alluxio", (List)Nil$.MODULE$)))));
        this.SHUFFLE_COMPRESSION_MAX_BATCH_MEMORY = this.conf("spark.rapids.shuffle.compression.maxBatchMemory").internal().bytesConf(ByteUnit.BYTE).createWithDefault(BoxesRunTime.boxToLong((long)0x40000000L));
        this.EXPLAIN = this.conf("spark.rapids.sql.explain").doc("Explain why some parts of a query were not placed on a GPU or not. Possible values are ALL: print everything, NONE: print nothing, NOT_ON_GPU: print only parts of a query that did not go on the GPU").stringConf().createWithDefault("NOT_ON_GPU");
        this.SHIMS_PROVIDER_OVERRIDE = this.conf("spark.rapids.shims-provider-override").internal().doc("Overrides the automatic Spark shim detection logic and forces a specific shims provider class to be used. Set to the fully qualified shims provider class to use. If you are using a custom Spark version such as Spark 3.1.1.0 then this can be used to specify the shims provider that matches the base Spark version of Spark 3.1.1, i.e.: com.nvidia.spark.rapids.shims.spark311.SparkShimServiceProvider. If you modified Spark then there is no guarantee the RAPIDS Accelerator will function properly.When tested in a combined jar with other Shims, it's expected that the provided implementation follows the same convention as existing Spark shims. If its class name has the form com.nvidia.spark.rapids.shims.<shimId>.YourSparkShimServiceProvider. The last package name component, i.e., shimId, can be used in the combined jar as the root directory /shimId for any incompatible classes. When tested in isolation, no special jar root is required").stringConf().createOptional();
        this.CUDF_VERSION_OVERRIDE = this.conf("spark.rapids.cudfVersionOverride").internal().doc("Overrides the cudf version compatibility check between cudf jar and RAPIDS Accelerator jar. If you are sure that the cudf jar which is mentioned in the classpath is compatible with the RAPIDS Accelerator version, then set this to true.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ALLOW_DISABLE_ENTIRE_PLAN = this.conf("spark.rapids.allowDisableEntirePlan").internal().doc("The plugin has the ability to detect possibe incompatibility with some specific queries and cluster configurations. In those cases the plugin will disable GPU support for the entire query. Set this to false if you want to override that behavior, but use with caution.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.OPTIMIZER_ENABLED = this.conf("spark.rapids.sql.optimizer.enabled").internal().doc("Enable cost-based optimizer that will attempt to avoid transitions to GPU for operations that will not result in improved performance over CPU").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.OPTIMIZER_EXPLAIN = this.conf("spark.rapids.sql.optimizer.explain").internal().doc("Explain why some parts of a query were not placed on a GPU due to optimization rules. Possible values are ALL: print everything, NONE: print nothing").stringConf().createWithDefault("NONE");
        this.OPTIMIZER_DEFAULT_ROW_COUNT = this.conf("spark.rapids.sql.optimizer.defaultRowCount").internal().doc("The cost-based optimizer uses estimated row counts to calculate costs and sometimes there is no row count available so we need a default assumption to use in this case").longConf().createWithDefault(BoxesRunTime.boxToLong((long)1000000L));
        this.OPTIMIZER_CLASS_NAME = this.conf("spark.rapids.sql.optimizer.className").internal().doc("Optimizer implementation class name. The class must implement the com.nvidia.spark.rapids.Optimizer trait").stringConf().createWithDefault("com.nvidia.spark.rapids.CostBasedOptimizer");
        this.OPTIMIZER_DEFAULT_CPU_OPERATOR_COST = this.conf("spark.rapids.sql.optimizer.cpu.exec.default").internal().doc("Default per-row CPU cost of executing an operator, in seconds").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)2.0E-4));
        this.OPTIMIZER_DEFAULT_CPU_EXPRESSION_COST = this.conf("spark.rapids.sql.optimizer.cpu.expr.default").internal().doc("Default per-row CPU cost of evaluating an expression, in seconds").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)0.0));
        this.OPTIMIZER_DEFAULT_GPU_OPERATOR_COST = this.conf("spark.rapids.sql.optimizer.gpu.exec.default").internal().doc("Default per-row GPU cost of executing an operator, in seconds").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)1.0E-4));
        this.OPTIMIZER_DEFAULT_GPU_EXPRESSION_COST = this.conf("spark.rapids.sql.optimizer.gpu.expr.default").internal().doc("Default per-row GPU cost of evaluating an expression, in seconds").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)0.0));
        this.OPTIMIZER_CPU_READ_SPEED = this.conf("spark.rapids.sql.optimizer.cpuReadSpeed").internal().doc("Speed of reading data from CPU memory in GB/s").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)30.0));
        this.OPTIMIZER_CPU_WRITE_SPEED = this.conf("spark.rapids.sql.optimizer.cpuWriteSpeed").internal().doc("Speed of writing data to CPU memory in GB/s").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)30.0));
        this.OPTIMIZER_GPU_READ_SPEED = this.conf("spark.rapids.sql.optimizer.gpuReadSpeed").internal().doc("Speed of reading data from GPU memory in GB/s").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)320.0));
        this.OPTIMIZER_GPU_WRITE_SPEED = this.conf("spark.rapids.sql.optimizer.gpuWriteSpeed").internal().doc("Speed of writing data to GPU memory in GB/s").doubleConf().createWithDefault(BoxesRunTime.boxToDouble((double)320.0));
        this.USE_ARROW_OPT = this.conf("spark.rapids.arrowCopyOptimizationEnabled").doc("Option to turn off using the optimized Arrow copy code when reading from ArrowColumnVector in HostColumnarToGpu. Left as internal as user shouldn't have to turn it off, but its convenient for testing.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.FORCE_SHIMCALLER_CLASSLOADER = this.conf("spark.rapids.force.caller.classloader").doc("Option to statically add shim's parallel world classloader URLs to the classloader of the ShimLoader class, typically Bootstrap classloader. This option uses reflection with setAccessible true on a classloader that is not created by Spark.").internal().booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
        this.SPARK_GPU_RESOURCE_NAME = this.conf("spark.rapids.gpu.resourceName").doc("The name of the Spark resource that represents a GPU that you want the plugin to use if using custom resources with Spark.").stringConf().createWithDefault("gpu");
        this.SUPPRESS_PLANNING_FAILURE = this.conf("spark.rapids.sql.suppressPlanningFailure").doc("Option to fallback an individual query to CPU if an unexpected condition prevents the query plan from being converted to a GPU-enabled one. Note this is different from a normal CPU fallback for a yet-to-be-supported Spark SQL feature. If this happens the error should be reported and investigated as a GitHub issue.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.ENABLE_FAST_SAMPLE = this.conf("spark.rapids.sql.fast.sample").doc("Option to turn on fast sample. If enable it is inconsistent with CPU sample because of GPU sample algorithm is inconsistent with CPU.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
        this.DETECT_DELTA_LOG_QUERIES = this.conf("spark.rapids.sql.detectDeltaLogQueries").doc("Queries against Delta Lake _delta_log JSON files are not efficient on the GPU. When this option is enabled, the plugin will attempt to detect these queries and fall back to the CPU.").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)true));
    }
}

