/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.ParquetOutputFileFormat$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.MemoryManager;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4QAD\b\u0001\u001f]AQA\b\u0001\u0005\u0002\u0001BQa\t\u0001\u0005\u0002\u0011:QaU\b\t\nQ3QAD\b\t\nUCQA\b\u0003\u0005\u0002YC\u0011b\u0016\u0003A\u0002\u0003\u0007I\u0011\u0001-\t\u0013y#\u0001\u0019!a\u0001\n\u0003y\u0006\"C3\u0005\u0001\u0004\u0005\t\u0015)\u0003Z\u0011\u001d1GA1A\u0005\u0002\u001dDaa\u001b\u0003!\u0002\u0013A\u0007b\u00027\u0005\u0005\u0004%\t!\u001c\u0005\u0007c\u0012\u0001\u000b\u0011\u00028\t\u000bI$A\u0011A:\u0003/A\u000b'/];fi>+H\u000f];u\r&dWMR8s[\u0006$(B\u0001\t\u0012\u0003\u0019\u0011\u0018\r]5eg*\u0011!cE\u0001\u0006gB\f'o\u001b\u0006\u0003)U\taA\u001c<jI&\f'\"\u0001\f\u0002\u0007\r|Wn\u0005\u0002\u00011A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t1\u0011I\\=SK\u001a\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u001f\u0005yq-\u001a;SK\u000e|'\u000fZ,sSR,'\u000fF\u0002&\u00052\u0003BAJ\u00182s5\tqE\u0003\u0002)S\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003U-\na\u0001[1e_>\u0004(B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001eL!\u0001M\u0014\u0003\u0019I+7m\u001c:e/JLG/\u001a:\u0011\u0005I:T\"A\u001a\u000b\u0005Q*\u0014\u0001\u00027b]\u001eT\u0011AN\u0001\u0005U\u00064\u0018-\u0003\u00029g\t!ak\\5e!\tQ\u0004)D\u0001<\u0015\taT(\u0001\u0005dCR\fG._:u\u0015\tqt(A\u0002tc2T!AE\u0016\n\u0005\u0005[$aC%oi\u0016\u0014h.\u00197S_^DQa\u0011\u0002A\u0002\u0011\u000baa\\;uaV$\bCA#K\u001b\u00051%BA$I\u0003\tIwN\u0003\u0002JW\u00059\u0001/\u0019:rk\u0016$\u0018BA&G\u0005)yU\u000f\u001e9vi\u001aKG.\u001a\u0005\u0006\u001b\n\u0001\rAT\u0001\u0005G>tg\r\u0005\u0002P#6\t\u0001K\u0003\u0002NS%\u0011!\u000b\u0015\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002/A\u000b'/];fi>+H\u000f];u\r&dWMR8s[\u0006$\bC\u0001\u0012\u0005'\t!\u0001\u0004F\u0001U\u00035iW-\\8ss6\u000bg.Y4feV\t\u0011\f\u0005\u0002[96\t1L\u0003\u0002+\u0011&\u0011Ql\u0017\u0002\u000e\u001b\u0016lwN]=NC:\fw-\u001a:\u0002#5,Wn\u001c:z\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002aGB\u0011\u0011$Y\u0005\u0003Ej\u0011A!\u00168ji\"9AmBA\u0001\u0002\u0004I\u0016a\u0001=%c\u0005qQ.Z7pefl\u0015M\\1hKJ\u0004\u0013!\u0007#F\r\u0006+F\nV0N\u000b6{%+W0Q\u001f>cuLU!U\u0013>+\u0012\u0001\u001b\t\u00033%L!A\u001b\u000e\u0003\u000b\u0019cw.\u0019;\u00025\u0011+e)Q+M)~kU)T(S3~\u0003vj\u0014'`%\u0006#\u0016j\u0014\u0011\u0002;\u0011+e)Q+M)~k\u0015JT0N\u000b6{%+W0B\u00192{5)\u0011+J\u001f:+\u0012A\u001c\t\u00033=L!\u0001\u001d\u000e\u0003\t1{gnZ\u0001\u001f\t\u00163\u0015)\u0016'U?6KejX'F\u001b>\u0013\u0016lX!M\u0019>\u001b\u0015\tV%P\u001d\u0002\n\u0001cZ3u\u001b\u0016lwN]=NC:\fw-\u001a:\u0015\u0005e#\b\"B'\u000e\u0001\u0004q\u0005")
public class ParquetOutputFileFormat {
    public static MemoryManager getMemoryManager(Configuration configuration) {
        return ParquetOutputFileFormat$.MODULE$.getMemoryManager(configuration);
    }

    public static long DEFAULT_MIN_MEMORY_ALLOCATION() {
        return ParquetOutputFileFormat$.MODULE$.DEFAULT_MIN_MEMORY_ALLOCATION();
    }

    public static float DEFAULT_MEMORY_POOL_RATIO() {
        return ParquetOutputFileFormat$.MODULE$.DEFAULT_MEMORY_POOL_RATIO();
    }

    public static void memoryManager_$eq(MemoryManager memoryManager) {
        ParquetOutputFileFormat$.MODULE$.memoryManager_$eq(memoryManager);
    }

    public static MemoryManager memoryManager() {
        return ParquetOutputFileFormat$.MODULE$.memoryManager();
    }

    public RecordWriter<Void, InternalRow> getRecordWriter(OutputFile output2, Configuration conf) {
        long blockSize = ParquetOutputFormat.getLongBlockSize((Configuration)conf);
        int maxPaddingSize = conf.getInt("parquet.writer.max-padding", 0x800000);
        boolean validating = ParquetOutputFormat.getValidation((Configuration)conf);
        ParquetWriteSupport writeSupport = new ParquetWriteSupport();
        WriteSupport.WriteContext init = writeSupport.init(conf);
        ParquetFileWriter writer = new ParquetFileWriter(output2, init.getSchema(), ParquetFileWriter.Mode.CREATE, blockSize, maxPaddingSize);
        writer.start();
        ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.fromString((String)conf.get("parquet.writer.version", ParquetProperties.WriterVersion.PARQUET_1_0.toString()));
        CodecFactory codecFactory = new CodecFactory(conf, ParquetOutputFormat.getPageSize((Configuration)conf));
        return new ParquetRecordWriter(writer, (WriteSupport)writeSupport, init.getSchema(), init.getExtraMetaData(), blockSize, ParquetOutputFormat.getPageSize((Configuration)conf), codecFactory.getCompressor(CompressionCodecName.UNCOMPRESSED), ParquetOutputFormat.getDictionaryPageSize((Configuration)conf), ParquetOutputFormat.getEnableDictionary((Configuration)conf), validating, writerVersion, ParquetOutputFileFormat$.MODULE$.getMemoryManager(conf));
    }
}

