/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.Table;
import com.google.flatbuffers.FlatBufferBuilder;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVectorFromBuffer;
import com.nvidia.spark.rapids.GpuCompressedColumnVector;
import com.nvidia.spark.rapids.GpuPackedTableColumn;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.format.BufferMeta;
import com.nvidia.spark.rapids.format.CodecBufferDescriptor;
import com.nvidia.spark.rapids.format.TableMeta;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MetaUtils$
implements Arm {
    public static MetaUtils$ MODULE$;
    private final int TableIdDefaultValue;

    static {
        new MetaUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public int TableIdDefaultValue() {
        return this.TableIdDefaultValue;
    }

    public TableMeta buildTableMeta(int tableId, ContiguousTable ct) {
        return this.buildTableMeta(tableId, ct.getBuffer().getLength(), ct.getMetadataDirectBuffer(), ct.getRowCount());
    }

    public TableMeta buildTableMeta(int tableId, long bufferSize, ByteBuffer packedMeta, long rowCount) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024);
        BufferMeta.startBufferMeta(fbb);
        BufferMeta.addId(fbb, tableId);
        BufferMeta.addSize(fbb, bufferSize);
        BufferMeta.addUncompressedSize(fbb, bufferSize);
        Some bufferMetaOffset = new Some((Object)BoxesRunTime.boxToInteger((int)BufferMeta.endBufferMeta(fbb)));
        return this.buildTableMeta(fbb, (Option<Object>)bufferMetaOffset, packedMeta, rowCount);
    }

    public TableMeta buildTableMeta(Option<Object> tableId, ContiguousTable ct, byte codecId, long compressedSize) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024);
        DeviceMemoryBuffer uncompressedBuffer = ct.getBuffer();
        int codecDescrOffset = CodecBufferDescriptor.createCodecBufferDescriptor(fbb, codecId, 0L, compressedSize, 0L, uncompressedBuffer.getLength());
        int codecDescrArrayOffset = BufferMeta.createCodecBufferDescrsVector(fbb, new int[]{codecDescrOffset});
        BufferMeta.startBufferMeta(fbb);
        BufferMeta.addId(fbb, BoxesRunTime.unboxToInt((Object)tableId.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MODULE$.TableIdDefaultValue())));
        BufferMeta.addSize(fbb, compressedSize);
        BufferMeta.addUncompressedSize(fbb, uncompressedBuffer.getLength());
        BufferMeta.addCodecBufferDescrs(fbb, codecDescrArrayOffset);
        Some bufferMetaOffset = new Some((Object)BoxesRunTime.boxToInteger((int)BufferMeta.endBufferMeta(fbb)));
        return this.buildTableMeta(fbb, (Option<Object>)bufferMetaOffset, ct.getMetadataDirectBuffer(), ct.getRowCount());
    }

    public TableMeta buildTableMeta(FlatBufferBuilder fbb, Option<Object> bufferMetaOffset, ByteBuffer packedMeta, long numRows) {
        ByteBuffer vectorBuffer = fbb.createUnintializedVector(1, packedMeta.remaining(), 1);
        packedMeta.mark();
        vectorBuffer.put(packedMeta);
        packedMeta.reset();
        int packedMetaOffset = fbb.endVector();
        TableMeta.startTableMeta(fbb);
        bufferMetaOffset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bmo -> TableMeta.addBufferMeta(fbb, bmo));
        TableMeta.addPackedMeta(fbb, packedMetaOffset);
        TableMeta.addRowCount(fbb, numRows);
        fbb.finish(TableMeta.endTableMeta(fbb));
        return TableMeta.getRootAsTableMeta(ByteBuffer.wrap(fbb.sizedByteArray()));
    }

    public TableMeta buildDegenerateTableMeta(ColumnarBatch batch) {
        TableMeta tableMeta;
        Predef$.MODULE$.require(batch.numRows() == 0 || batch.numCols() == 0, (Function0 & Serializable & scala.Serializable)() -> "batch not degenerate");
        if (batch.numCols() == 0) {
            FlatBufferBuilder fbb = new FlatBufferBuilder(1024);
            TableMeta.startTableMeta(fbb);
            TableMeta.addRowCount(fbb, batch.numRows());
            fbb.finish(TableMeta.endTableMeta(fbb));
            tableMeta = TableMeta.getRootAsTableMeta(ByteBuffer.wrap(fbb.sizedByteArray()));
        } else {
            TableMeta tableMeta2;
            ColumnVector columnVector = batch.column(0);
            if (columnVector instanceof GpuCompressedColumnVector) {
                GpuCompressedColumnVector gpuCompressedColumnVector = (GpuCompressedColumnVector)columnVector;
                tableMeta2 = gpuCompressedColumnVector.getTableMeta();
            } else if (columnVector instanceof GpuPackedTableColumn) {
                GpuPackedTableColumn gpuPackedTableColumn = (GpuPackedTableColumn)columnVector;
                ContiguousTable contigTable = gpuPackedTableColumn.getContiguousTable();
                FlatBufferBuilder fbb = new FlatBufferBuilder(1024);
                tableMeta2 = this.buildTableMeta(fbb, (Option<Object>)None$.MODULE$, contigTable.getMetadataDirectBuffer(), contigTable.getRowCount());
            } else {
                throw new IllegalStateException("batch must be compressed or packed");
            }
            tableMeta = tableMeta2;
        }
        return tableMeta;
    }

    public TableMeta getTableMetaNoTable(DeviceMemoryBuffer buffer) {
        FlatBufferBuilder fbb = new FlatBufferBuilder(1024);
        long bufferSize = buffer.getLength();
        BufferMeta.startBufferMeta(fbb);
        BufferMeta.addId(fbb, 0);
        BufferMeta.addSize(fbb, bufferSize);
        BufferMeta.addUncompressedSize(fbb, bufferSize);
        int bufferMetaOffset = BufferMeta.endBufferMeta(fbb);
        TableMeta.startTableMeta(fbb);
        TableMeta.addRowCount(fbb, 0L);
        TableMeta.addBufferMeta(fbb, bufferMetaOffset);
        fbb.finish(TableMeta.endTableMeta(fbb));
        return TableMeta.getRootAsTableMeta(ByteBuffer.wrap(fbb.sizedByteArray()));
    }

    public Table getTableFromMeta(DeviceMemoryBuffer deviceBuffer, TableMeta meta) {
        ByteBuffer packedMeta = meta.packedMetaAsByteBuffer();
        Predef$.MODULE$.require(packedMeta != null, (Function0 & Serializable & scala.Serializable)() -> "Missing packed table metadata");
        return Table.fromPackedTable((ByteBuffer)packedMeta, (DeviceMemoryBuffer)deviceBuffer);
    }

    public ColumnarBatch getBatchFromMeta(DeviceMemoryBuffer deviceBuffer, TableMeta meta, DataType[] sparkTypes) {
        return (ColumnarBatch)this.withResource(this.getTableFromMeta(deviceBuffer, meta), (Function1 & Serializable & scala.Serializable)table -> GpuColumnVectorFromBuffer.from(table, deviceBuffer, meta, sparkTypes));
    }

    private MetaUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.TableIdDefaultValue = -1;
    }
}

