/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.WindowOptions;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuLiteral;
import com.nvidia.spark.rapids.GpuSpecialFrameBoundary;
import com.nvidia.spark.rapids.GpuSpecifiedWindowFrame;
import com.nvidia.spark.rapids.ParsedBoundary;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.shims.GpuWindowUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class GroupedAggregations$
implements Arm {
    public static GroupedAggregations$ MODULE$;

    static {
        new GroupedAggregations$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public WindowOptions com$nvidia$spark$rapids$GroupedAggregations$$getWindowOptions(Seq<SortOrder> orderSpec, Seq<Object> orderPositions, GpuSpecifiedWindowFrame frame) {
        WindowOptions windowOptions;
        FrameType frameType = frame.frameType();
        if (RowFrame$.MODULE$.equals(frameType)) {
            windowOptions = (WindowOptions)this.withResource(this.getRowBasedLower(frame), (Function1 & Serializable & scala.Serializable)lower -> (WindowOptions)MODULE$.withResource(MODULE$.getRowBasedUpper(frame), (Function1 & Serializable & scala.Serializable)upper -> WindowOptions.builder().minPeriods(1).window(lower, upper).build()));
        } else if (RangeFrame$.MODULE$.equals(frameType)) {
            Predef$.MODULE$.require(orderSpec.length() == 1);
            Predef$.MODULE$.require(orderPositions.length() == orderSpec.length());
            SortOrder orderExpr = (SortOrder)orderSpec.head();
            DType orderType = GpuColumnVector.getNonNestedRapidsType(orderExpr.dataType());
            int orderByIndex = BoxesRunTime.unboxToInt((Object)orderPositions.head());
            ParsedBoundary lower2 = this.getRangeBoundaryValue(frame.lower());
            ParsedBoundary upper = this.getRangeBoundaryValue(frame.upper());
            windowOptions = (WindowOptions)this.withResource(this.asScalarRangeBoundary(orderType, lower2), (Function1 & Serializable & scala.Serializable)preceding -> (WindowOptions)MODULE$.withResource(MODULE$.asScalarRangeBoundary(orderType, upper), (Function1 & Serializable & scala.Serializable)following -> {
                WindowOptions.Builder windowOptionBuilder = WindowOptions.builder().minPeriods(1).orderByColumnIndex(orderByIndex);
                WindowOptions.Builder builder = preceding.isEmpty() ? windowOptionBuilder.unboundedPreceding() : windowOptionBuilder.preceding((Scalar)preceding.get());
                WindowOptions.Builder builder2 = following.isEmpty() ? windowOptionBuilder.unboundedFollowing() : windowOptionBuilder.following((Scalar)following.get());
                WindowOptions.Builder builder3 = orderExpr.isAscending() ? windowOptionBuilder.orderByAscending() : windowOptionBuilder.orderByDescending();
                return windowOptionBuilder.build();
            }));
        } else {
            throw new MatchError((Object)frameType);
        }
        return windowOptions;
    }

    private Scalar getRowBasedLower(GpuSpecifiedWindowFrame windowFrameSpec) {
        int lower = this.getRowBoundaryValue(windowFrameSpec.lower());
        int ret = lower >= Integer.MAX_VALUE ? Integer.MIN_VALUE : (lower <= Integer.MIN_VALUE ? Integer.MAX_VALUE : -(lower - 1));
        return Scalar.fromInt((int)ret);
    }

    private Scalar getRowBasedUpper(GpuSpecifiedWindowFrame windowFrameSpec) {
        return Scalar.fromInt((int)this.getRowBoundaryValue(windowFrameSpec.upper()));
    }

    private int getRowBoundaryValue(Expression boundary) {
        int n;
        GpuLiteral gpuLiteral;
        Expression expression = boundary;
        if (expression instanceof GpuLiteral && (gpuLiteral = (GpuLiteral)expression).dataType().equals((Object)IntegerType$.MODULE$)) {
            n = BoxesRunTime.unboxToInt((Object)gpuLiteral.value());
        } else if (expression instanceof GpuSpecialFrameBoundary) {
            GpuSpecialFrameBoundary gpuSpecialFrameBoundary = (GpuSpecialFrameBoundary)expression;
            n = gpuSpecialFrameBoundary.value();
        } else {
            throw new UnsupportedOperationException(new StringBuilder(36).append("Unsupported window frame expression ").append(expression).toString());
        }
        return n;
    }

    private Option<Scalar> asScalarRangeBoundary(DType orderByType, ParsedBoundary bound) {
        None$ none$;
        if (bound.isUnbounded()) {
            none$ = None$.MODULE$;
        } else {
            Scalar scalar;
            long value = bound.valueAsLong();
            DType dType = orderByType;
            DType dType2 = DType.INT8;
            DType dType3 = dType;
            if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
                scalar = Scalar.fromByte((byte)((byte)value));
            } else {
                DType dType4 = DType.INT16;
                DType dType5 = dType;
                if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                    scalar = Scalar.fromShort((short)((short)value));
                } else {
                    DType dType6 = DType.INT32;
                    DType dType7 = dType;
                    if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                        scalar = Scalar.fromInt((int)((int)value));
                    } else {
                        DType dType8 = DType.INT64;
                        DType dType9 = dType;
                        if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                            scalar = Scalar.fromLong((long)value);
                        } else {
                            DType dType10 = DType.TIMESTAMP_DAYS;
                            DType dType11 = dType;
                            if (!(dType10 != null ? !dType10.equals(dType11) : dType11 != null)) {
                                scalar = Scalar.durationFromLong((DType)DType.DURATION_DAYS, (long)value);
                            } else {
                                DType dType12 = DType.TIMESTAMP_MICROSECONDS;
                                DType dType13 = dType;
                                if (!(dType12 != null ? !dType12.equals(dType13) : dType13 != null)) {
                                    scalar = Scalar.durationFromLong((DType)DType.DURATION_MICROSECONDS, (long)value);
                                } else {
                                    throw new RuntimeException(new StringBuilder(35).append("Not supported order by type, Found ").append(orderByType).toString());
                                }
                            }
                        }
                    }
                }
            }
            Scalar s = scalar;
            none$ = new Some((Object)s);
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParsedBoundary getRangeBoundaryValue(Expression boundary) {
        boolean bl = false;
        GpuLiteral gpuLiteral = null;
        Expression expression = boundary;
        if (expression instanceof GpuSpecialFrameBoundary) {
            GpuSpecialFrameBoundary gpuSpecialFrameBoundary = (GpuSpecialFrameBoundary)expression;
            boolean isUnBounded = gpuSpecialFrameBoundary.isUnbounded();
            return new ParsedBoundary(isUnBounded, gpuSpecialFrameBoundary.value());
        }
        if (expression instanceof GpuLiteral) {
            bl = true;
            gpuLiteral = (GpuLiteral)expression;
            Object ci = gpuLiteral.value();
            DataType dataType = gpuLiteral.dataType();
            if (ci instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)ci;
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    long x = TimeUnit.DAYS.toMicros(calendarInterval.days) + calendarInterval.microseconds;
                    if (x != Long.MIN_VALUE) return new ParsedBoundary(false, Math.abs(x));
                    x = Long.MAX_VALUE;
                    return new ParsedBoundary(false, Math.abs(x));
                }
            }
        }
        if (bl) {
            Object value = gpuLiteral.value();
            DataType dataType = gpuLiteral.dataType();
            if (ByteType$.MODULE$.equals(dataType)) {
                int x = BoxesRunTime.unboxToByte((Object)value);
                if (x != -128) return new ParsedBoundary(false, Math.abs(x));
                x = 127;
                return new ParsedBoundary(false, Math.abs(x));
            }
        }
        if (bl) {
            Object value = gpuLiteral.value();
            DataType dataType = gpuLiteral.dataType();
            if (ShortType$.MODULE$.equals(dataType)) {
                int x = BoxesRunTime.unboxToShort((Object)value);
                if (x != Short.MIN_VALUE) return new ParsedBoundary(false, Math.abs(x));
                x = Short.MAX_VALUE;
                return new ParsedBoundary(false, Math.abs(x));
            }
        }
        if (bl) {
            Object value = gpuLiteral.value();
            DataType dataType = gpuLiteral.dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                int x = BoxesRunTime.unboxToInt((Object)value);
                if (x != Integer.MIN_VALUE) return new ParsedBoundary(false, Math.abs(x));
                x = Integer.MAX_VALUE;
                return new ParsedBoundary(false, Math.abs(x));
            }
        }
        if (!bl) return GpuWindowUtil$.MODULE$.getRangeBoundaryValue(expression);
        Object value = gpuLiteral.value();
        DataType dataType = gpuLiteral.dataType();
        if (!LongType$.MODULE$.equals(dataType)) return GpuWindowUtil$.MODULE$.getRangeBoundaryValue(expression);
        long x = BoxesRunTime.unboxToLong((Object)value);
        if (x != Long.MIN_VALUE) return new ParsedBoundary(false, Math.abs(x));
        x = Long.MAX_VALUE;
        return new ParsedBoundary(false, Math.abs(x));
    }

    private GroupedAggregations$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

