/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.DataFromReplacementRule;
import com.nvidia.spark.rapids.ExprMeta;
import com.nvidia.spark.rapids.GpuExpression;
import com.nvidia.spark.rapids.GpuWindowExpression;
import com.nvidia.spark.rapids.GpuWindowSpecDefinition;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Lag;
import org.apache.spark.sql.catalyst.expressions.Lead;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4QAC\u0006\u0002\u0002QA\u0011\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!G\u0015\t\u00135\u0002!\u0011!Q\u0001\n9\n\u0004\"\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001aM\u0011!i\u0005A!A!\u0002\u0013q\u0005\"B)\u0001\t\u0003\u0011\u0006\"B1\u0001\t\u0013\u0011\u0007\"B6\u0001\t\u0003a\u0007\"\u0002:\u0001\t\u0003\u001a\b\"\u0002;\u0001\t\u0003*(aG$qk^Kg\u000eZ8x\u000bb\u0004(/Z:tS>tW*\u001a;b\u0005\u0006\u001cXM\u0003\u0002\r\u001b\u00051!/\u00199jINT!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012A\u00028wS\u0012L\u0017MC\u0001\u0013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0003E\u0002\u0017/ei\u0011aC\u0005\u00031-\u0011\u0001\"\u0012=qe6+G/\u0019\t\u00035\u0019j\u0011a\u0007\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\b#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dZ\"\u0001E,j]\u0012|w/\u0012=qe\u0016\u001c8/[8o\u0003A9\u0018N\u001c3po\u0016C\bO]3tg&|g.\u0003\u0002+W\u00059qO]1qa\u0016$\u0017B\u0001\u0017\f\u0005)\u0011\u0016\r]5eg6+G/Y\u0001\u0005G>tg\r\u0005\u0002\u0017_%\u0011\u0001g\u0003\u0002\u000b%\u0006\u0004\u0018\u000eZ:D_:4\u0017BA\u0017,\u0003\u0019\u0001\u0018M]3oiB\u0019AgN\u001d\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012aa\u00149uS>t\u0007\u0007\u0002\u001e>\u000f*\u0003RAF\u0016<\r&\u0003\"\u0001P\u001f\r\u0001\u0011IahAA\u0001\u0002\u0003\u0015\ta\u0010\u0002\u0004?\u0012\n\u0014C\u0001!D!\t!\u0014)\u0003\u0002Ck\t9aj\u001c;iS:<\u0007C\u0001\u001bE\u0013\t)UGA\u0002B]f\u0004\"\u0001P$\u0005\u0013!\u001b\u0011\u0011!A\u0001\u0006\u0003y$aA0%eA\u0011AH\u0013\u0003\n\u0017\u000e\t\t\u0011!A\u0003\u0002}\u00121a\u0018\u00134\u0013\t\u00114&\u0001\u0003sk2,\u0007C\u0001\fP\u0013\t\u00016BA\fECR\fgI]8n%\u0016\u0004H.Y2f[\u0016tGOU;mK\u00061A(\u001b8jiz\"Ra\u0015+V-\u0002\u0004\"A\u0006\u0001\t\u000b!*\u0001\u0019A\r\t\u000b5*\u0001\u0019\u0001\u0018\t\u000bI*\u0001\u0019A,\u0011\u0007Q:\u0004\f\r\u0003Z7v{\u0006#\u0002\f,5rs\u0006C\u0001\u001f\\\t%qd+!A\u0001\u0002\u000b\u0005q\b\u0005\u0002=;\u0012I\u0001JVA\u0001\u0002\u0003\u0015\ta\u0010\t\u0003y}#\u0011b\u0013,\u0002\u0002\u0003\u0005)\u0011A \t\u000b5+\u0001\u0019\u0001(\u00027\u001d,G/\u00118e\u0007\",7m\u001b*po\n{WO\u001c3bef4\u0016\r\\;f)\t\u0019g\r\u0005\u00025I&\u0011Q-\u000e\u0002\u0004\u0013:$\b\"B4\u0007\u0001\u0004A\u0017\u0001\u00032pk:$\u0017M]=\u0011\u0005iI\u0017B\u00016\u001c\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u001bi\u0006<w\n\u001e5feRK\b/Z:G_J\u0014\u0016M\\4f\rJ\fW.\u001a\u000b\u0003[B\u0004\"\u0001\u000e8\n\u0005=,$\u0001B+oSRDQ!]\u0004A\u0002!\faAY8v]\u0012\u001c\u0018!\u0004;bO\u0016C\bO\u001d$pe\u001e\u0003X\u000fF\u0001n\u00031\u0019wN\u001c<feR$vn\u00129v)\u00051\bC\u0001\fx\u0013\tA8BA\u0007HaV,\u0005\u0010\u001d:fgNLwN\u001c")
public abstract class GpuWindowExpressionMetaBase
extends ExprMeta<WindowExpression> {
    private int getAndCheckRowBoundaryValue(Expression boundary) {
        int n;
        Expression expression = boundary;
        if (expression instanceof Literal) {
            int n2;
            Literal literal = (Literal)expression;
            DataType dataType = literal.dataType();
            if (IntegerType$.MODULE$.equals(dataType)) {
                n2 = BoxesRunTime.unboxToInt((Object)literal.value());
            } else {
                this.willNotWorkOnGpu(new StringBuilder(33).append("unsupported window boundary type ").append(dataType).toString());
                n2 = -1;
            }
            n = n2;
        } else if (UnboundedPreceding$.MODULE$.equals(expression)) {
            n = Integer.MIN_VALUE;
        } else if (UnboundedFollowing$.MODULE$.equals(expression)) {
            n = Integer.MAX_VALUE;
        } else if (CurrentRow$.MODULE$.equals(expression)) {
            n = 0;
        } else {
            this.willNotWorkOnGpu("unsupported window boundary type");
            n = -1;
        }
        return n;
    }

    public void tagOtherTypesForRangeFrame(Expression bounds) {
        this.willNotWorkOnGpu(new StringBuilder(72).append("the type of boundary is not supported in a window range").append(" function, found ").append(bounds).toString());
    }

    @Override
    public void tagExprForGpu() {
        Expression windowFunction = ((WindowExpression)this.wrapped()).windowFunction();
        WindowFrame windowFrame = ((WindowExpression)this.wrapped()).windowSpec().frameSpecification();
        if (windowFrame instanceof SpecifiedWindowFrame) {
            SpecifiedWindowFrame specifiedWindowFrame = (SpecifiedWindowFrame)windowFrame;
            FrameType frameType = specifiedWindowFrame.frameType();
            if (RowFrame$.MODULE$.equals(frameType)) {
                int lower = this.getAndCheckRowBoundaryValue(specifiedWindowFrame.lower());
                int upper = this.getAndCheckRowBoundaryValue(specifiedWindowFrame.upper());
                Expression expression = windowFunction;
                boolean bl = expression instanceof Lead ? true : expression instanceof Lag;
                if (bl) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit;
                    if (lower > 0) {
                        this.willNotWorkOnGpu(new StringBuilder(58).append("lower-bounds ahead of current row is not supported. ").append("Found ").append(lower).toString());
                    }
                    if (upper < 0) {
                        this.willNotWorkOnGpu(new StringBuilder(60).append("upper-bounds behind the current row is not supported. ").append("Found ").append(upper).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (RangeFrame$.MODULE$.equals(frameType)) {
                BoxedUnit boxedUnit;
                if (specifiedWindowFrame.isUnbounded()) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean orderByTypeSupported;
                    Seq orderSpec = ((WindowExpression)this.wrapped()).windowSpec().orderSpec();
                    if (orderSpec.length() > 1) {
                        this.willNotWorkOnGpu("only a single date/time or integral (Boolean exclusive)based column in window range functions is supported");
                    }
                    if (!(orderByTypeSupported = orderSpec.forall((Function1 & Serializable & scala.Serializable)so -> BoxesRunTime.boxToBoolean((boolean)GpuWindowExpressionMetaBase.$anonfun$tagExprForGpu$1(so))))) {
                        this.willNotWorkOnGpu(new StringBuilder(78).append("the type of orderBy column is not supported in a window").append(" range function, found ").append(((SortOrder)orderSpec.head()).dataType()).toString());
                    }
                    ((IterableLike)new .colon.colon((Object)specifiedWindowFrame.lower(), (List)new .colon.colon((Object)specifiedWindowFrame.upper(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        GpuWindowExpressionMetaBase.$anonfun$tagExprForGpu$2(this, x0$1);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)frameType);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.willNotWorkOnGpu(new StringBuilder(75).append("only SpecifiedWindowFrame is a supported window-frame specification. ").append("Found ").append(((Expression)windowFrame).prettyName()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public GpuExpression convertToGpu() {
        Seq seq = (Seq)this.childExprs().map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1.convertToGpu(), Seq$.MODULE$.canBuildFrom());
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)seq);
        }
        Expression left = (Expression)((SeqLike)some.get()).apply(0);
        Expression right = (Expression)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
        Tuple2 tuple22 = tuple2;
        Expression left2 = (Expression)tuple22._1();
        Expression right2 = (Expression)tuple22._2();
        return new GpuWindowExpression(left2, (GpuWindowSpecDefinition)right2);
    }

    public static final /* synthetic */ boolean $anonfun$tagExprForGpu$1(SortOrder so) {
        DataType dataType = so.dataType();
        boolean bl = ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (LongType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType)))));
        boolean bl2 = bl;
        return bl2;
    }

    private final void checkRangeBoundaryConfig$1(DataType dt) {
        DataType dataType = dt;
        if (ByteType$.MODULE$.equals(dataType)) {
            BoxedUnit boxedUnit;
            if (!super.conf().isRangeWindowByteEnabled()) {
                this.willNotWorkOnGpu(new StringBuilder(151).append("Range window frame is not 100% compatible when the order by type is ").append("byte and the range value calculated has overflow. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_RANGE_WINDOW_BYTES()).append(" to true.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            BoxedUnit boxedUnit;
            if (!super.conf().isRangeWindowShortEnabled()) {
                this.willNotWorkOnGpu(new StringBuilder(152).append("Range window frame is not 100% compatible when the order by type is ").append("short and the range value calculated has overflow. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_RANGE_WINDOW_SHORT()).append(" to true.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            BoxedUnit boxedUnit;
            if (!super.conf().isRangeWindowIntEnabled()) {
                this.willNotWorkOnGpu(new StringBuilder(150).append("Range window frame is not 100% compatible when the order by type is ").append("int and the range value calculated has overflow. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_RANGE_WINDOW_INT()).append(" to true.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if (LongType$.MODULE$.equals(dataType)) {
            BoxedUnit boxedUnit;
            if (!super.conf().isRangeWindowLongEnabled()) {
                this.willNotWorkOnGpu(new StringBuilder(151).append("Range window frame is not 100% compatible when the order by type is ").append("long and the range value calculated has overflow. ").append("To enable it please set ").append(RapidsConf$.MODULE$.ENABLE_RANGE_WINDOW_LONG()).append(" to true.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$tagExprForGpu$2(GpuWindowExpressionMetaBase $this, Expression x0$1) {
        boolean bl;
        boolean bl2 = false;
        Literal literal = null;
        Expression expression = x0$1;
        if (expression instanceof Literal) {
            bl2 = true;
            literal = (Literal)expression;
            DataType dataType = literal.dataType();
            boolean bl3 = ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)));
            if (bl3) {
                $this.checkRangeBoundaryConfig$1(literal.dataType());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl2) {
            Object ci = literal.value();
            DataType dataType = literal.dataType();
            if (ci instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)ci;
                if (CalendarIntervalType$.MODULE$.equals(dataType)) {
                    BoxedUnit boxedUnit;
                    if (calendarInterval.months != 0) {
                        $this.willNotWorkOnGpu("interval months isn't supported");
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
            }
        }
        if (bl = UnboundedFollowing$.MODULE$.equals(expression) ? true : (UnboundedPreceding$.MODULE$.equals(expression) ? true : CurrentRow$.MODULE$.equals(expression))) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        $this.tagOtherTypesForRangeFrame(expression);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GpuWindowExpressionMetaBase(WindowExpression windowExpression, RapidsConf conf, Option<RapidsMeta<?, ?, ?>> parent, DataFromReplacementRule rule) {
        super(windowExpression, conf, parent, rule);
    }
}

