/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.Table;
import com.nvidia.spark.RebaseHelper$;
import com.nvidia.spark.rapids.DataTypeUtils$;
import com.nvidia.spark.rapids.FileFormatChecks$;
import com.nvidia.spark.rapids.GpuParquetScan;
import com.nvidia.spark.rapids.ParquetFormatType$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsConf$ParquetFooterReaderType$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.ReadFileOp$;
import com.nvidia.spark.rapids.ScanMeta;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.v2.parquet.ParquetScan;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple12;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class GpuParquetScan$
implements scala.Serializable {
    public static GpuParquetScan$ MODULE$;

    static {
        new GpuParquetScan$();
    }

    public boolean $lessinit$greater$default$12() {
        return false;
    }

    public void tagSupport(ScanMeta<ParquetScan> scanMeta) {
        ParquetScan scan = (ParquetScan)scanMeta.wrapped();
        StructType schema = StructType$.MODULE$.apply((Seq)scan.readDataSchema().$plus$plus((GenTraversableOnce)scan.readPartitionSchema(), Seq$.MODULE$.canBuildFrom()));
        this.tagSupport(scan.sparkSession(), schema, scanMeta);
    }

    public void throwIfNeeded(Table table, boolean isCorrectedInt96Rebase, boolean isCorrectedDateTimeRebase, boolean hasInt96Timestamps) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), table.getNumberOfColumns()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ColumnVector col = table.getColumn(i);
            if (!isCorrectedDateTimeRebase && RebaseHelper$.MODULE$.isDateRebaseNeededInRead(col)) {
                throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead("Parquet");
            }
            if ((hasInt96Timestamps && !isCorrectedInt96Rebase || !hasInt96Timestamps && !isCorrectedDateTimeRebase) && RebaseHelper$.MODULE$.isTimeRebaseNeededInRead(col)) {
                throw DataSourceUtils$.MODULE$.newRebaseExceptionInRead("Parquet");
            }
        });
    }

    public void tagSupport(SparkSession sparkSession, StructType readSchema, RapidsMeta<?, ?, ?> meta) {
        String string;
        RuntimeConfig sqlConf = sparkSession.conf();
        if (!meta.conf().isParquetEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(65).append("Parquet input and output has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_PARQUET()).append(" to true").toString());
        }
        if (!meta.conf().isParquetReadEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(54).append("Parquet input has been disabled. To enable set").append(RapidsConf$.MODULE$.ENABLE_PARQUET_READ()).append(" to true").toString());
        }
        FileFormatChecks$.MODULE$.tag(meta, readSchema, ParquetFormatType$.MODULE$, ReadFileOp$.MODULE$);
        boolean schemaHasTimestamps = readSchema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GpuParquetScan$.$anonfun$tagSupport$2(x$1)))));
        boolean schemaMightNeedNestedRebase = readSchema.exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)GpuParquetScan$.$anonfun$tagSupport$3(field)));
        if (schemaHasTimestamps && sparkSession.sessionState().conf().isParquetINT96TimestampConversion()) {
            meta.willNotWorkOnGpu("GpuParquetScan does not support int96 timestamp conversion");
        }
        if ("EXCEPTION".equals(string = sqlConf.get(SparkShimImpl$.MODULE$.int96ParquetRebaseReadKey()))) {
            BoxedUnit boxedUnit;
            if (schemaMightNeedNestedRebase) {
                meta.willNotWorkOnGpu(new StringBuilder(69).append("Nested timestamp and date values are not supported when ").append(SparkShimImpl$.MODULE$.int96ParquetRebaseReadKey()).append(" is EXCEPTION").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if ("CORRECTED".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("LEGACY".equals(string)) {
            BoxedUnit boxedUnit;
            if (schemaMightNeedNestedRebase) {
                meta.willNotWorkOnGpu(new StringBuilder(66).append("Nested timestamp and date values are not supported when ").append(SparkShimImpl$.MODULE$.int96ParquetRebaseReadKey()).append(" is LEGACY").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(36).append(string).append(" is not a supported read rebase mode").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        String string2 = sqlConf.get(SparkShimImpl$.MODULE$.parquetRebaseReadKey());
        if ("EXCEPTION".equals(string2)) {
            BoxedUnit boxedUnit;
            if (schemaMightNeedNestedRebase) {
                meta.willNotWorkOnGpu(new StringBuilder(69).append("Nested timestamp and date values are not supported when ").append(SparkShimImpl$.MODULE$.parquetRebaseReadKey()).append(" is EXCEPTION").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit;
        } else if ("CORRECTED".equals(string2)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("LEGACY".equals(string2)) {
            BoxedUnit boxedUnit;
            if (schemaMightNeedNestedRebase) {
                meta.willNotWorkOnGpu(new StringBuilder(66).append("Nested timestamp and date values are not supported when ").append(SparkShimImpl$.MODULE$.parquetRebaseReadKey()).append(" is LEGACY").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            meta.willNotWorkOnGpu(new StringBuilder(36).append(string2).append(" is not a supported read rebase mode").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private long numNodesEstimate(DataType dt) {
        long l;
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            l = 1L + BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)GpuParquetScan$.MODULE$.numNodesEstimate(f.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            l = 2L + this.numNodesEstimate(elementType);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            l = 2L + this.numNodesEstimate(keyType) + this.numNodesEstimate(valueType);
        } else {
            l = 1L;
        }
        return l;
    }

    public Enumeration.Value footerReaderHeuristic(Enumeration.Value inputValue, StructType data, StructType read) {
        Enumeration.Value value;
        Enumeration.Value value2 = inputValue;
        Enumeration.Value value3 = RapidsConf$ParquetFooterReaderType$.MODULE$.AUTO();
        Enumeration.Value value4 = value2;
        if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
            long dnc = this.numNodesEstimate((DataType)data);
            long rnc = this.numNodesEstimate((DataType)read);
            value = (double)rnc / (double)dnc <= 0.5 && dnc - rnc > 10L ? RapidsConf$ParquetFooterReaderType$.MODULE$.NATIVE() : RapidsConf$ParquetFooterReaderType$.MODULE$.JAVA();
        } else {
            value = value2;
        }
        return value;
    }

    public GpuParquetScan apply(SparkSession sparkSession, Configuration hadoopConf, PartitioningAwareFileIndex fileIndex, StructType dataSchema, StructType readDataSchema, StructType readPartitionSchema, Filter[] pushedFilters, CaseInsensitiveStringMap options, Seq<Expression> partitionFilters2, Seq<Expression> dataFilters, RapidsConf rapidsConf, boolean queryUsesInputFile) {
        return new GpuParquetScan(sparkSession, hadoopConf, fileIndex, dataSchema, readDataSchema, readPartitionSchema, pushedFilters, options, partitionFilters2, dataFilters, rapidsConf, queryUsesInputFile);
    }

    public boolean apply$default$12() {
        return false;
    }

    public Option<Tuple12<SparkSession, Configuration, PartitioningAwareFileIndex, StructType, StructType, StructType, Filter[], CaseInsensitiveStringMap, Seq<Expression>, Seq<Expression>, RapidsConf, Object>> unapply(GpuParquetScan x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple12((Object)x$0.sparkSession(), (Object)x$0.hadoopConf(), (Object)x$0.fileIndex(), (Object)x$0.dataSchema(), (Object)x$0.readDataSchema(), (Object)x$0.readPartitionSchema(), (Object)x$0.pushedFilters(), (Object)x$0.options(), x$0.partitionFilters(), x$0.dataFilters(), (Object)x$0.rapidsConf(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.queryUsesInputFile())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$tagSupport$2(DataType x$1) {
        return x$1 instanceof TimestampType;
    }

    private static final boolean isTsOrDate$1(DataType dt) {
        DataType dataType = dt;
        boolean bl = TimestampType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ boolean $anonfun$tagSupport$3(StructField field) {
        return DataTypeUtils$.MODULE$.isNestedType(field.dataType()) ? TrampolineUtil$.MODULE$.dataTypeExistsRecursively(field.dataType(), (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)GpuParquetScan$.isTsOrDate$1(dt))) : false;
    }

    private GpuParquetScan$() {
        MODULE$ = this;
    }
}

