/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DecimalUtils;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class DecimalUtil$
implements Arm {
    public static DecimalUtil$ MODULE$;
    private final DecimalType BooleanDecimal;

    static {
        new DecimalUtil$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public DType createCudfDecimal(DecimalType dt) {
        return DecimalUtils.createDecimalType((int)dt.precision(), (int)dt.scale());
    }

    public ColumnVector outOfBounds(ColumnView input, DecimalType to) {
        return DecimalUtils.outOfBounds((ColumnView)input, (int)to.precision(), (int)to.scale());
    }

    public int getDataTypeSize(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        int n = dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() <= Decimal$.MODULE$.MAX_INT_DIGITS() ? 4 : dataType.defaultSize();
        return n;
    }

    private DecimalType BooleanDecimal() {
        return this.BooleanDecimal;
    }

    public Option<DecimalType> optionallyAsDecimalType(DataType t) {
        Object object;
        DataType dataType = t;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)dataType;
            object = new Some((Object)decimalType);
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : LongType$.MODULE$.equals(dataType)));
            object = bl ? new Some((Object)new DecimalType(GpuColumnVector.getNonNestedRapidsType(t).getPrecisionForInt(), 0)) : (BooleanType$.MODULE$.equals(dataType) ? new Some((Object)this.BooleanDecimal()) : None$.MODULE$);
        }
        return object;
    }

    public DecimalType asDecimalType(DataType t) {
        DecimalType dt;
        Option<DecimalType> option = this.optionallyAsDecimalType(t);
        if (!(option instanceof Some)) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Internal Error: type ").append(t).append(" cannot automatically be cast to a supported DecimalType").toString());
        }
        Some some = (Some)option;
        DecimalType decimalType = dt = (DecimalType)some.value();
        return decimalType;
    }

    private DecimalUtil$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.BooleanDecimal = new DecimalType(1, 0);
    }
}

