/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.ContiguousTable;
import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.nvcomp.BatchedLZ4Compressor;
import com.nvidia.spark.rapids.BatchedTableCompressor;
import com.nvidia.spark.rapids.CompressedTable;
import com.nvidia.spark.rapids.MetaUtils$;
import com.nvidia.spark.rapids.TableCompressionCodecConfig;
import com.nvidia.spark.rapids.format.TableMeta;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r3AAB\u0004\u0001!!AQ\u0003\u0001B\u0001B\u0003%a\u0003\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"\u0002\u001b\u0001\t#*$A\u0007\"bi\u000eDW\r\u001a(wG>l\u0007\u000f\u0014.5\u0007>l\u0007O]3tg>\u0014(B\u0001\u0005\n\u0003\u0019\u0011\u0018\r]5eg*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\taA\u001c<jI&\f'\"\u0001\b\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u00059\u0011B\u0001\u000b\b\u0005Y\u0011\u0015\r^2iK\u0012$\u0016M\u00197f\u0007>l\u0007O]3tg>\u0014\u0018AE7bq\n\u000bGo\u00195NK6|'/_*ju\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011A\u0001T8oO\u0006a1m\u001c3fG\u000e{gNZ5hgB\u0011!CH\u0005\u0003?\u001d\u00111\u0004V1cY\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7mQ8oM&<\u0017AB:ue\u0016\fW\u000e\u0005\u0002#W9\u00111%K\u0007\u0002I)\u0011QEJ\u0001\u0005GV$gM\u0003\u0002\tO)\t\u0001&\u0001\u0002bS&\u0011!\u0006J\u0001\u0005\u0007V$\u0017-\u0003\u0002-[\t11\u000b\u001e:fC6T!A\u000b\u0013\u0002\rqJg.\u001b;?)\u0011\u0001\u0014GM\u001a\u0011\u0005I\u0001\u0001\"B\u000b\u0005\u0001\u00041\u0002\"\u0002\u000f\u0005\u0001\u0004i\u0002\"\u0002\u0011\u0005\u0001\u0004\t\u0013\u0001C2p[B\u0014Xm]:\u0015\u0007Yb$\tE\u0002\u0018oeJ!\u0001\u000f\r\u0003\u000b\u0005\u0013(/Y=\u0011\u0005IQ\u0014BA\u001e\b\u0005=\u0019u.\u001c9sKN\u001cX\r\u001a+bE2,\u0007\"B\u001f\u0006\u0001\u0004q\u0014A\u0002;bE2,7\u000fE\u0002\u0018o}\u0002\"a\t!\n\u0005\u0005##aD\"p]RLw-^8vgR\u000b'\r\\3\t\u000b\u0001*\u0001\u0019A\u0011")
public class BatchedNvcompLZ4Compressor
extends BatchedTableCompressor {
    private final long maxBatchMemorySize;
    private final TableCompressionCodecConfig codecConfigs;

    @Override
    public CompressedTable[] compress(ContiguousTable[] tables, Cuda.Stream stream) {
        BatchedLZ4Compressor batchCompressor = new BatchedLZ4Compressor(this.codecConfigs.lz4ChunkSize(), this.maxBatchMemorySize);
        BaseDeviceMemoryBuffer[] inputBuffers = (BaseDeviceMemoryBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tables)).map((Function1 & Serializable & scala.Serializable)table -> {
            void var1_1;
            DeviceMemoryBuffer buffer = table.getBuffer();
            buffer.incRefCount();
            return var1_1;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BaseDeviceMemoryBuffer.class)));
        return (CompressedTable[])this.closeOnExcept((AutoCloseable[])batchCompressor.compress(inputBuffers, stream), (Function1 & Serializable & scala.Serializable)compressedBuffers -> (CompressedTable[])this.withResource(new NvtxRange("lz4 post process", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$1 -> {
            Predef$.MODULE$.require(((DeviceMemoryBuffer[])compressedBuffers).length == tables.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("expected ").append(tables.length).append(" buffers, but compress() returned ").append(((DeviceMemoryBuffer[])compressedBuffers).length).toString());
            return (CompressedTable[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compressedBuffers)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tables), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DeviceMemoryBuffer buffer = (DeviceMemoryBuffer)tuple2._1();
                ContiguousTable table = (ContiguousTable)tuple2._2();
                long compressedSize = buffer.getLength();
                TableMeta meta = MetaUtils$.MODULE$.buildTableMeta((Option<Object>)None$.MODULE$, table, (byte)1, compressedSize);
                CompressedTable compressedTable = new CompressedTable(compressedSize, meta, buffer);
                return compressedTable;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CompressedTable.class))))).toArray(ClassTag$.MODULE$.apply(CompressedTable.class));
        }));
    }

    public BatchedNvcompLZ4Compressor(long maxBatchMemorySize, TableCompressionCodecConfig codecConfigs, Cuda.Stream stream) {
        this.maxBatchMemorySize = maxBatchMemorySize;
        this.codecConfigs = codecConfigs;
        super(maxBatchMemorySize, stream);
    }
}

