/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.AvroFileReader;
import com.nvidia.spark.rapids.MutableBlockInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.io.BinaryData;
import scala.Predef$;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\r\u001b\u0001\rB\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006k\u0001!\tA\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019!\u0005\u0001)A\u0005w!9Q\t\u0001b\u0001\n\u0013Q\u0004B\u0002$\u0001A\u0003%1\bC\u0004H\u0001\u0001\u0007I\u0011\u0002\u001e\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"1q\n\u0001Q!\nmBq\u0001\u0015\u0001A\u0002\u0013%\u0011\u000bC\u0004V\u0001\u0001\u0007I\u0011\u0002,\t\ra\u0003\u0001\u0015)\u0003S\u0011\u001dI\u0006\u00011A\u0005\nECqA\u0017\u0001A\u0002\u0013%1\f\u0003\u0004^\u0001\u0001\u0006KA\u0015\u0005\b=\u0002\u0001\r\u0011\"\u0003R\u0011\u001dy\u0006\u00011A\u0005\n\u0001DaA\u0019\u0001!B\u0013\u0011\u0006bB2\u0001\u0001\u0004%I\u0001\u001a\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0011\u0019Y\u0007\u0001)Q\u0005K\")A\u000e\u0001C\u0001[\")a\u000e\u0001C\u0001_\")Q\u000f\u0001C\u0001m\n\u0011\u0012I\u001e:p\t\u0006$\u0018MR5mKJ+\u0017\rZ3s\u0015\tYB$\u0001\u0004sCBLGm\u001d\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r94\u0018\u000eZ5b\u0015\u0005\t\u0013aA2p[\u000e\u00011C\u0001\u0001%!\t)c%D\u0001\u001b\u0013\t9#D\u0001\bBmJ|g)\u001b7f%\u0016\fG-\u001a:\u0002\u0005ML\u0007C\u0001\u00164\u001b\u0005Y#B\u0001\u0017.\u0003\u00111\u0017\u000e\\3\u000b\u00059z\u0013\u0001B1we>T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO&\u0011Ag\u000b\u0002\u000e'\u0016,7.\u00192mK&s\u0007/\u001e;\u0002\rqJg.\u001b;?)\t9\u0004\b\u0005\u0002&\u0001!)\u0001F\u0001a\u0001S\u0005YAn\u001c8hg\n+hMZ3s+\u0005Y\u0004c\u0001\u001f@\u00036\tQHC\u0001?\u0003\u0015\u00198-\u00197b\u0013\t\u0001UHA\u0003BeJ\f\u0017\u0010\u0005\u0002=\u0005&\u00111)\u0010\u0002\u0005\u0005f$X-\u0001\u0007m_:<7OQ;gM\u0016\u0014\b%\u0001\u0006ts:\u001c')\u001e4gKJ\f1b]=oG\n+hMZ3sA\u0005QA-\u0019;b\u0005V4g-\u001a:\u0002\u001d\u0011\fG/\u0019\"vM\u001a,'o\u0018\u0013fcR\u0011!*\u0014\t\u0003y-K!\u0001T\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u001d\"\t\t\u00111\u0001<\u0003\rAH%M\u0001\fI\u0006$\u0018MQ;gM\u0016\u0014\b%\u0001\u0005dkJ\u001cu.\u001e8u+\u0005\u0011\u0006C\u0001\u001fT\u0013\t!VH\u0001\u0003M_:<\u0017\u0001D2ve\u000e{WO\u001c;`I\u0015\fHC\u0001&X\u0011\u001dq5\"!AA\u0002I\u000b\u0011bY;s\u0007>,h\u000e\u001e\u0011\u0002\u0017\r,(\u000fR1uCNK'0Z\u0001\u0010GV\u0014H)\u0019;b'&TXm\u0018\u0013fcR\u0011!\n\u0018\u0005\b\u001d:\t\t\u00111\u0001S\u00031\u0019WO\u001d#bi\u0006\u001c\u0016N_3!\u00031\u0019WO\u001d\"m_\u000e\\7+\u001b>f\u0003A\u0019WO\u001d\"m_\u000e\\7+\u001b>f?\u0012*\u0017\u000f\u0006\u0002KC\"9a*EA\u0001\u0002\u0004\u0011\u0016!D2ve\ncwnY6TSj,\u0007%A\u0007dkJ\u0014En\\2l%\u0016\fG-_\u000b\u0002KB\u0011AHZ\u0005\u0003Ov\u0012qAQ8pY\u0016\fg.A\tdkJ\u0014En\\2l%\u0016\fG-_0%KF$\"A\u00136\t\u000f9#\u0012\u0011!a\u0001K\u0006q1-\u001e:CY>\u001c7NU3bIf\u0004\u0013\u0001\u00045bg:+\u0007\u0010\u001e\"m_\u000e\\G#A3\u0002\u0013A,Wm\u001b\"m_\u000e\\GC\u00019t!\t)\u0013/\u0003\u0002s5\t\u0001R*\u001e;bE2,'\t\\8dW&sgm\u001c\u0005\u0006i^\u0001\r\u0001]\u0001\u0006e\u0016,8/Z\u0001\u0011e\u0016\fGMT3yiJ\u000bwO\u00117pG.$\"AS<\t\u000baD\u0002\u0019A=\u0002\u0007=,H\u000f\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006\u0011\u0011n\u001c\u0006\u0002}\u0006!!.\u0019<b\u0013\r\t\ta\u001f\u0002\r\u001fV$\b/\u001e;TiJ,\u0017-\u001c")
public class AvroDataFileReader
extends AvroFileReader {
    private final byte[] longsBuffer = new byte[20];
    private final byte[] syncBuffer = new byte[16];
    private byte[] dataBuffer = null;
    private long curCount = 0L;
    private long curDataSize = 0L;
    private long curBlockSize = 0L;
    private boolean curBlockReady = false;

    private byte[] longsBuffer() {
        return this.longsBuffer;
    }

    private byte[] syncBuffer() {
        return this.syncBuffer;
    }

    private byte[] dataBuffer() {
        return this.dataBuffer;
    }

    private void dataBuffer_$eq(byte[] x$1) {
        this.dataBuffer = x$1;
    }

    private long curCount() {
        return this.curCount;
    }

    private void curCount_$eq(long x$1) {
        this.curCount = x$1;
    }

    private long curDataSize() {
        return this.curDataSize;
    }

    private void curDataSize_$eq(long x$1) {
        this.curDataSize = x$1;
    }

    private long curBlockSize() {
        return this.curBlockSize;
    }

    private void curBlockSize_$eq(long x$1) {
        this.curBlockSize = x$1;
    }

    private boolean curBlockReady() {
        return this.curBlockReady;
    }

    private void curBlockReady_$eq(boolean x$1) {
        this.curBlockReady = x$1;
    }

    public boolean hasNextBlock() {
        boolean bl;
        try {
            if (this.curBlockReady()) {
                return true;
            }
            if (this.vin().isEnd()) {
                return false;
            }
            this.curCount_$eq(this.vin().readLong());
            this.curDataSize_$eq(this.vin().readLong());
            if (this.curDataSize() > Integer.MAX_VALUE || this.curDataSize() < 0L) {
                throw new IOException(new StringBuilder(52).append("Invalid data size: ").append(this.curDataSize()).append(", should be in (0, Int.MaxValue).").toString());
            }
            int countLongLen = BinaryData.encodeLong((long)this.curCount(), (byte[])this.longsBuffer(), (int)0);
            int dataSizeLongLen = BinaryData.encodeLong((long)this.curDataSize(), (byte[])this.longsBuffer(), (int)countLongLen);
            this.curBlockSize_$eq((long)(countLongLen + dataSizeLongLen) + this.curDataSize() + 16L);
            this.curBlockReady_$eq(true);
            bl = true;
        }
        catch (EOFException eOFException) {
            bl = false;
        }
        return bl;
    }

    public MutableBlockInfo peekBlock(MutableBlockInfo reuse) {
        MutableBlockInfo mutableBlockInfo;
        if (!this.hasNextBlock()) {
            throw new NoSuchElementException();
        }
        if (reuse == null) {
            mutableBlockInfo = new MutableBlockInfo(this.curBlockSize(), this.curDataSize(), this.curCount());
        } else {
            reuse.blockSize_$eq(this.curBlockSize());
            reuse.dataSize_$eq(this.curDataSize());
            reuse.count_$eq(this.curCount());
            mutableBlockInfo = reuse;
        }
        return mutableBlockInfo;
    }

    public void readNextRawBlock(OutputStream out) {
        if (!this.hasNextBlock()) {
            throw new NoSuchElementException();
        }
        int dataSize = (int)this.curDataSize();
        if (this.dataBuffer() == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.dataBuffer())).size() < dataSize) {
            this.dataBuffer_$eq(new byte[dataSize]);
        }
        this.vin().readFixed(this.dataBuffer(), 0, dataSize);
        this.vin().readFixed(this.syncBuffer());
        this.curBlockStart_$eq(this.sin().tell() - (long)this.vin().inputStream().available());
        if (!new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.headerSync())).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(this.syncBuffer()))) {
            this.curBlockReady_$eq(false);
            throw new IOException("Invalid sync!");
        }
        out.write(this.longsBuffer(), 0, (int)(this.curBlockSize() - this.curDataSize() - 16L));
        out.write(this.dataBuffer(), 0, dataSize);
        out.write(this.syncBuffer());
        this.curBlockReady_$eq(false);
    }

    public AvroDataFileReader(SeekableInput si) {
        super(si);
    }
}

