/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.GpuDeviceManager$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.resource.ResourceInformation;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001\u0019!)Q\u0003\u0001C\u0001-\t)r\t];EKZL7-Z'b]\u0006<WM]*vSR,'B\u0001\u0003\u0006\u0003\u0019\u0011\u0018\r]5eg*\u0011aaB\u0001\u0006gB\f'o\u001b\u0006\u0003\u0011%\taA\u001c<jI&\f'\"\u0001\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001i\u0001C\u0001\b\u0014\u001b\u0005y!B\u0001\t\u0012\u0003%\u00198-\u00197bi\u0016\u001cHOC\u0001\u0013\u0003\ry'oZ\u0005\u0003)=\u0011\u0001BR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"\u0001\u0007\u0001\u000e\u0003\r\u0001")
public class GpuDeviceManagerSuite
extends FunSuite {
    public GpuDeviceManagerSuite() {
        this.test("Test Spark gpu resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option gpuAddr;
            SparkConf sparkConf = new SparkConf();
            RapidsConf conf = new RapidsConf(sparkConf);
            ResourceInformation gpu = new ResourceInformation("gpu", (String[])((Object[])new String[]{"3"}));
            Map resources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gpu"), (Object)gpu)}));
            Option $org_scalatest_assert_macro_left = gpuAddr = GpuDeviceManager$.MODULE$.getGPUAddrFromResources(resources, conf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
            int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)gpuAddr.get());
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
        }, new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 26));
        this.test("Test Spark custom resource missed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option gpuAddr;
            SparkConf sparkConf = new SparkConf();
            RapidsConf conf = new RapidsConf(sparkConf);
            ResourceInformation gpu = new ResourceInformation("nvidia/gpu", (String[])((Object[])new String[]{"2"}));
            Map resources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia/gpu"), (Object)gpu)}));
            Option $org_scalatest_assert_macro_left = gpuAddr = GpuDeviceManager$.MODULE$.getGPUAddrFromResources(resources, conf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
        }, new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Test Spark multiple GPUs throws", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkConf sparkConf = new SparkConf();
            RapidsConf conf = new RapidsConf(sparkConf);
            ResourceInformation gpu = new ResourceInformation("gpu", (String[])((Object[])new String[]{"2", "3"}));
            Map resources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"gpu"), (Object)gpu)}));
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> GpuDeviceManager$.MODULE$.getGPUAddrFromResources(resources, conf), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        }, new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Test Spark custom resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Option gpuAddr;
            SparkConf sparkConf = new SparkConf();
            sparkConf.set(RapidsConf$.MODULE$.SPARK_GPU_RESOURCE_NAME().toString(), "nvidia/gpu");
            RapidsConf conf = new RapidsConf(sparkConf);
            ResourceInformation gpu = new ResourceInformation("nvidia/gpu", (String[])((Object[])new String[]{"1"}));
            Map resources = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nvidia/gpu"), (Object)gpu)}));
            Option $org_scalatest_assert_macro_left = gpuAddr = GpuDeviceManager$.MODULE$.getGPUAddrFromResources(resources, conf);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            int $org_scalatest_assert_macro_left2 = BoxesRunTime.unboxToInt((Object)gpuAddr.get());
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        }, new Position("GpuDeviceManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }
}

