/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import com.nvidia.spark.rapids.BaseExprMeta;
import com.nvidia.spark.rapids.ExecChecks;
import com.nvidia.spark.rapids.ExecChecks$;
import com.nvidia.spark.rapids.InputCheck;
import com.nvidia.spark.rapids.InputCheck$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsMeta;
import com.nvidia.spark.rapids.TypeSig;
import com.nvidia.spark.rapids.TypeSig$;
import org.apache.spark.sql.catalyst.plans.Cross$;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class JoinTypeChecks$ {
    public static JoinTypeChecks$ MODULE$;
    private final String LEFT_KEYS;
    private final String RIGHT_KEYS;
    private final String CONDITION;
    private final TypeSig cudfSupportedKeyTypes;
    private final TypeSig sparkSupportedJoinKeyTypes;
    private final TypeSig joinRideAlongTypes;
    private final ExecChecks equiJoinExecChecks;
    private final ExecChecks nonEquiJoinChecks;

    static {
        new JoinTypeChecks$();
    }

    public void tagForGpu(JoinType joinType, RapidsMeta<?, ?, ?> meta) {
        RapidsConf conf = meta.conf();
        JoinType joinType2 = joinType;
        if (Inner$.MODULE$.equals(joinType2) && !conf.areInnerJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(54).append("inner joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_INNER_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (Cross$.MODULE$.equals(joinType2) && !conf.areCrossJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(54).append("cross joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_CROSS_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LeftOuter$.MODULE$.equals(joinType2) && !conf.areLeftOuterJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(59).append("left outer joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_LEFT_OUTER_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (RightOuter$.MODULE$.equals(joinType2) && !conf.areRightOuterJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(60).append("right outer joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_RIGHT_OUTER_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FullOuter$.MODULE$.equals(joinType2) && !conf.areFullOuterJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(59).append("full outer joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_FULL_OUTER_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LeftSemi$.MODULE$.equals(joinType2) && !conf.areLeftSemiJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(58).append("left semi joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_LEFT_SEMI_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LeftAnti$.MODULE$.equals(joinType2) && !conf.areLeftAntiJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(58).append("left anti joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_LEFT_ANTI_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (joinType2 instanceof ExistenceJoin && !conf.areExistenceJoinsEnabled()) {
            meta.willNotWorkOnGpu(new StringBuilder(58).append("existence joins have been disabled. To enable set ").append(RapidsConf$.MODULE$.ENABLE_EXISTENCE_JOIN().key()).append(" to true").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String LEFT_KEYS() {
        return this.LEFT_KEYS;
    }

    public String RIGHT_KEYS() {
        return this.RIGHT_KEYS;
    }

    public String CONDITION() {
        return this.CONDITION;
    }

    public ExecChecks equiJoinExecChecks() {
        return this.equiJoinExecChecks;
    }

    public Map<String, Seq<BaseExprMeta<?>>> equiJoinMeta(Seq<BaseExprMeta<?>> leftKeys, Seq<BaseExprMeta<?>> rightKeys, Option<BaseExprMeta<?>> condition) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LEFT_KEYS()), leftKeys), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RIGHT_KEYS()), rightKeys), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CONDITION()), (Object)Option$.MODULE$.option2Iterable(condition).toSeq())}));
    }

    public ExecChecks nonEquiJoinChecks() {
        return this.nonEquiJoinChecks;
    }

    public Map<String, Seq<BaseExprMeta<?>>> nonEquiJoinMeta(Option<BaseExprMeta<?>> condition) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CONDITION()), (Object)Option$.MODULE$.option2Iterable(condition).toSeq())}));
    }

    private JoinTypeChecks$() {
        MODULE$ = this;
        this.LEFT_KEYS = "leftKeys";
        this.RIGHT_KEYS = "rightKeys";
        this.CONDITION = "condition";
        this.cudfSupportedKeyTypes = TypeSig$.MODULE$.commonCudfTypes().$plus(TypeSig$.MODULE$.NULL()).$plus(TypeSig$.MODULE$.DECIMAL_128()).$plus(TypeSig$.MODULE$.STRUCT()).nested();
        this.sparkSupportedJoinKeyTypes = TypeSig$.MODULE$.all().$minus(TypeSig$.MODULE$.MAP().nested());
        this.joinRideAlongTypes = this.cudfSupportedKeyTypes.$plus(TypeSig$.MODULE$.DECIMAL_128()).$plus(TypeSig$.MODULE$.ARRAY()).$plus(TypeSig$.MODULE$.MAP()).nested();
        this.equiJoinExecChecks = ExecChecks$.MODULE$.apply(this.joinRideAlongTypes, TypeSig$.MODULE$.all(), (Map<String, InputCheck>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.LEFT_KEYS()), (Object)new InputCheck(this.cudfSupportedKeyTypes, this.sparkSupportedJoinKeyTypes, InputCheck$.MODULE$.apply$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RIGHT_KEYS()), (Object)new InputCheck(this.cudfSupportedKeyTypes, this.sparkSupportedJoinKeyTypes, InputCheck$.MODULE$.apply$default$3())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CONDITION()), (Object)new InputCheck(TypeSig$.MODULE$.BOOLEAN(), TypeSig$.MODULE$.BOOLEAN(), InputCheck$.MODULE$.apply$default$3()))}))));
        this.nonEquiJoinChecks = ExecChecks$.MODULE$.apply(this.joinRideAlongTypes, TypeSig$.MODULE$.all(), (Map<String, InputCheck>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.CONDITION()), (Object)new InputCheck(TypeSig$.MODULE$.BOOLEAN(), TypeSig$.MODULE$.BOOLEAN(), (List<String>)new .colon.colon((Object)"A non-inner join only is supported if the condition expression can be converted to a GPU AST expression", (List)Nil$.MODULE$)))}))));
    }
}

