/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import ai.rapids.cudf.ast.CompiledExpression;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuBuildSide;
import com.nvidia.spark.rapids.GpuExpression;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.LazySpillableColumnarBatch;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.SpillCallback;
import java.io.Serializable;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.ExistenceJoin;
import org.apache.spark.sql.catalyst.plans.InnerLike;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.rapids.execution.ConditionalNestedLoopExistenceJoinIterator;
import org.apache.spark.sql.rapids.execution.ConditionalNestedLoopJoinIterator;
import org.apache.spark.sql.rapids.execution.CrossJoinIterator;
import org.apache.spark.sql.rapids.execution.GpuBroadcastNestedLoopJoinExec;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public final class GpuBroadcastNestedLoopJoinExec$
implements Arm,
scala.Serializable {
    public static GpuBroadcastNestedLoopJoinExec$ MODULE$;

    static {
        new GpuBroadcastNestedLoopJoinExec$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Iterator<ColumnarBatch> nestedLoopJoin(JoinType joinType, GpuBuildSide buildSide, int numFirstTableColumns, LazySpillableColumnarBatch builtBatch, Iterator<LazySpillableColumnarBatch> stream, Seq<Attribute> streamAttributes, long targetSize, Option<GpuExpression> boundCondition, SpillCallback spillCallback, GpuMetric numOutputRows, GpuMetric joinOutputRows, GpuMetric numOutputBatches, GpuMetric opTime, GpuMetric joinTime) {
        Iterator<ColumnarBatch> iterator;
        if (boundCondition.isEmpty()) {
            Predef$.MODULE$.assert(joinType instanceof InnerLike, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Unexpected unconditional join type: ").append(joinType).toString());
            iterator = new CrossJoinIterator(builtBatch, stream, targetSize, buildSide, opTime, joinTime);
        } else {
            CompiledExpression compiledAst = ((GpuExpression)boundCondition.get()).convertToAst(numFirstTableColumns).compile();
            iterator = joinType instanceof ExistenceJoin ? new ConditionalNestedLoopExistenceJoinIterator(builtBatch, stream, compiledAst, opTime, joinTime) : new ConditionalNestedLoopJoinIterator(joinType, buildSide, builtBatch, stream, streamAttributes, targetSize, compiledAst, spillCallback, opTime, joinTime);
        }
        Iterator<ColumnarBatch> joinIterator = iterator;
        return joinIterator.map((Function1 & Serializable & scala.Serializable)cb -> {
            joinOutputRows.$plus$eq(cb.numRows());
            numOutputRows.$plus$eq(cb.numRows());
            numOutputBatches.$plus$eq(1L);
            return cb;
        });
    }

    public RDD<ColumnarBatch> divideIntoBatches(RDD<Object> rowCounts, long targetSizeBytes, GpuMetric numOutputRows, GpuMetric numOutputBatches, GpuMetric semWait) {
        long maxRowCount = targetSizeBytes / 8L;
        return rowCounts.flatMap((Function1 & Serializable & scala.Serializable)rows -> GpuBroadcastNestedLoopJoinExec$.divideIntoBatches$1(BoxesRunTime.unboxToLong((Object)rows), maxRowCount, numOutputRows, numOutputBatches, semWait), ClassTag$.MODULE$.apply(ColumnarBatch.class));
    }

    public GpuBroadcastNestedLoopJoinExec apply(SparkPlan left, SparkPlan right, JoinType joinType, GpuBuildSide gpuBuildSide, Option<Expression> condition, long targetSizeBytes) {
        return new GpuBroadcastNestedLoopJoinExec(left, right, joinType, gpuBuildSide, condition, targetSizeBytes);
    }

    public Option<Tuple6<SparkPlan, SparkPlan, JoinType, GpuBuildSide, Option<Expression>, Object>> unapply(GpuBroadcastNestedLoopJoinExec x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.left(), (Object)x$0.right(), (Object)x$0.joinType(), (Object)x$0.gpuBuildSide(), x$0.condition(), (Object)BoxesRunTime.boxToLong((long)x$0.targetSizeBytes())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ ColumnarBatch $anonfun$divideIntoBatches$1(long maxRowCount$1, long rows$1, GpuMetric numOutputRows$2, GpuMetric numOutputBatches$2, GpuMetric semWait$1, long i) {
        ColumnarBatch ret = new ColumnarBatch(new ColumnVector[0]);
        if ((i + 1L) * maxRowCount$1 > rows$1) {
            ret.setNumRows((int)(rows$1 - i * maxRowCount$1));
        } else {
            ret.setNumRows((int)maxRowCount$1);
        }
        numOutputRows$2.$plus$eq(ret.numRows());
        numOutputBatches$2.$plus$eq(1L);
        GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), semWait$1);
        return ret;
    }

    private static final Iterable divideIntoBatches$1(long rows, long maxRowCount$1, GpuMetric numOutputRows$2, GpuMetric numOutputBatches$2, GpuMetric semWait$1) {
        long numBatches = (rows + maxRowCount$1 - 1L) / maxRowCount$1;
        return (Iterable)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numBatches)).map((Function1 & Serializable & scala.Serializable)i -> GpuBroadcastNestedLoopJoinExec$.$anonfun$divideIntoBatches$1(maxRowCount$1, rows, numOutputRows$2, numOutputBatches$2, semWait$1, BoxesRunTime.unboxToLong((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private GpuBroadcastNestedLoopJoinExec$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

