/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import com.nvidia.spark.rapids.CoalesceSizeGoal;
import com.nvidia.spark.rapids.GpuBatchUtils$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.NoopMetric$;
import com.nvidia.spark.rapids.RequireSingleBatchLike;
import java.util.NoSuchElementException;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.rapids.execution.GpuExternalRowToColumnConverter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u000b\u0016\t\tB\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A\u0001\n\u0001B\u0001B\u0003%\u0011\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007bB3\u0001\u0001\u0004%IA\u001a\u0005\bU\u0002\u0001\r\u0011\"\u0003l\u0011\u0019\t\b\u0001)Q\u0005O\"9!\u000f\u0001a\u0001\n\u0013\u0001\u0007bB:\u0001\u0001\u0004%I\u0001\u001e\u0005\u0007m\u0002\u0001\u000b\u0015B1\t\u000f]\u0004\u0001\u0019!C\u0005A\"9\u0001\u0010\u0001a\u0001\n\u0013I\bBB>\u0001A\u0003&\u0011\rC\u0003}\u0001\u0011\u0005S\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005\u001d\u0001\u0001\"\u0003\u0002\u0006\tiR\t\u001f;fe:\fGNU8x)>\u001cu\u000e\\;n]\u0006\u0014\u0018\n^3sCR|'O\u0003\u0002\u0017/\u0005IQ\r_3dkRLwN\u001c\u0006\u00031e\taA]1qS\u0012\u001c(B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011c\u0001\u0001$SA\u0011AeJ\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t1\u0011I\\=SK\u001a\u00042A\u000b\u001a6\u001d\tY\u0003G\u0004\u0002-_5\tQF\u0003\u0002/C\u00051AH]8pizJ\u0011AJ\u0005\u0003c\u0015\nq\u0001]1dW\u0006<W-\u0003\u00024i\tA\u0011\n^3sCR|'O\u0003\u00022KA\u0011a'O\u0007\u0002o)\u0011\u0001(G\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017B\u0001\u001e8\u00055\u0019u\u000e\\;n]\u0006\u0014()\u0019;dQ\u00069!o\\<Ji\u0016\u0014\bc\u0001\u00163{A\u0011ahP\u0007\u00023%\u0011\u0001)\u0007\u0002\u0004%><\u0018a\u00037pG\u0006d7k\u00195f[\u0006\u0004\"a\u0011$\u000e\u0003\u0011S!!R\r\u0002\u000bQL\b/Z:\n\u0005\u001d#%AC*ueV\u001cG\u000fV=qK\u0006IAn\\2bY\u001e{\u0017\r\u001c\t\u0003\u0015Fk\u0011a\u0013\u0006\u000311S!\u0001H'\u000b\u00059{\u0015A\u00028wS\u0012L\u0017MC\u0001Q\u0003\r\u0019w.\\\u0005\u0003%.\u0013\u0001cQ8bY\u0016\u001c8-Z*ju\u0016<u.\u00197\u0002\u0015\r|gN^3si\u0016\u00148\u000f\u0005\u0002V-6\tQ#\u0003\u0002X+\tyr\t];FqR,'O\\1m%><Hk\\\"pYVlgnQ8om\u0016\u0014H/\u001a:\u0002\rqJg.\u001b;?)\u0015Q6\fX/_!\t)\u0006\u0001C\u0003<\u000b\u0001\u0007A\bC\u0003B\u000b\u0001\u0007!\tC\u0003I\u000b\u0001\u0007\u0011\nC\u0003T\u000b\u0001\u0007A+A\buCJ<W\r^*ju\u0016\u0014\u0015\u0010^3t+\u0005\t\u0007C\u0001\u0013c\u0013\t\u0019WE\u0001\u0003M_:<\u0017\u0001\u0005;be\u001e,GoU5{K\nKH/Z:!\u0003)!\u0018M]4fiJ{wo]\u000b\u0002OB\u0011A\u0005[\u0005\u0003S\u0016\u00121!\u00138u\u00039!\u0018M]4fiJ{wo]0%KF$\"\u0001\\8\u0011\u0005\u0011j\u0017B\u00018&\u0005\u0011)f.\u001b;\t\u000fAL\u0011\u0011!a\u0001O\u0006\u0019\u0001\u0010J\u0019\u0002\u0017Q\f'oZ3u%><8\u000fI\u0001\u0011i>$\u0018\r\\(viB,HOQ=uKN\fA\u0003^8uC2|U\u000f\u001e9vi\nKH/Z:`I\u0015\fHC\u00017v\u0011\u001d\u0001H\"!AA\u0002\u0005\f\u0011\u0003^8uC2|U\u000f\u001e9vi\nKH/Z:!\u0003=!x\u000e^1m\u001fV$\b/\u001e;S_^\u001c\u0018a\u0005;pi\u0006dw*\u001e;qkR\u0014vn^:`I\u0015\fHC\u00017{\u0011\u001d\u0001x\"!AA\u0002\u0005\f\u0001\u0003^8uC2|U\u000f\u001e9viJ{wo\u001d\u0011\u0002\u000f!\f7OT3yiV\ta\u0010\u0005\u0002%\u007f&\u0019\u0011\u0011A\u0013\u0003\u000f\t{w\u000e\\3b]\u0006!a.\u001a=u)\u0005)\u0014A\u00032vS2$')\u0019;dQ\u0002")
public class ExternalRowToColumnarIterator
implements Iterator<ColumnarBatch> {
    private final Iterator<Row> rowIter;
    private final StructType localSchema;
    private final CoalesceSizeGoal localGoal;
    private final GpuExternalRowToColumnConverter converters;
    private final long targetSizeBytes;
    private int targetRows;
    private long totalOutputBytes;
    private long totalOutputRows;

    public Iterator<ColumnarBatch> seq() {
        return Iterator.seq$((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.isEmpty$((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.isTraversableAgain$((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.hasDefiniteSize$((Iterator)this);
    }

    public Iterator<ColumnarBatch> take(int n) {
        return Iterator.take$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> drop(int n) {
        return Iterator.drop$((Iterator)this, (int)n);
    }

    public Iterator<ColumnarBatch> slice(int from, int until) {
        return Iterator.slice$((Iterator)this, (int)from, (int)until);
    }

    public Iterator<ColumnarBatch> sliceIterator(int from, int until) {
        return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<ColumnarBatch, B> f) {
        return Iterator.map$((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.$plus$plus$((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<ColumnarBatch, GenTraversableOnce<B>> f) {
        return Iterator.flatMap$((Iterator)this, f);
    }

    public Iterator<ColumnarBatch> filter(Function1<ColumnarBatch, Object> p) {
        return Iterator.filter$((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<ColumnarBatch, B, Object> p) {
        return Iterator.corresponds$((Iterator)this, that, p);
    }

    public Iterator<ColumnarBatch> withFilter(Function1<ColumnarBatch, Object> p) {
        return Iterator.withFilter$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> filterNot(Function1<ColumnarBatch, Object> p) {
        return Iterator.filterNot$((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<ColumnarBatch, B> pf) {
        return Iterator.collect$((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return Iterator.scanLeft$((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<ColumnarBatch, B, B> op) {
        return Iterator.scanRight$((Iterator)this, z, op);
    }

    public Iterator<ColumnarBatch> takeWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.takeWhile$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> partition(Function1<ColumnarBatch, Object> p) {
        return Iterator.partition$((Iterator)this, p);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> span(Function1<ColumnarBatch, Object> p) {
        return Iterator.span$((Iterator)this, p);
    }

    public Iterator<ColumnarBatch> dropWhile(Function1<ColumnarBatch, Object> p) {
        return Iterator.dropWhile$((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<ColumnarBatch, B>> zip(Iterator<B> that) {
        return Iterator.zip$((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.padTo$((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<ColumnarBatch, Object>> zipWithIndex() {
        return Iterator.zipWithIndex$((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<ColumnarBatch, U> f) {
        Iterator.foreach$((Iterator)this, f);
    }

    public boolean forall(Function1<ColumnarBatch, Object> p) {
        return Iterator.forall$((Iterator)this, p);
    }

    public boolean exists(Function1<ColumnarBatch, Object> p) {
        return Iterator.exists$((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.contains$((Iterator)this, (Object)elem);
    }

    public Option<ColumnarBatch> find(Function1<ColumnarBatch, Object> p) {
        return Iterator.find$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p) {
        return Iterator.indexWhere$((Iterator)this, p);
    }

    public int indexWhere(Function1<ColumnarBatch, Object> p, int from) {
        return Iterator.indexWhere$((Iterator)this, p, (int)from);
    }

    public <B> int indexOf(B elem) {
        return Iterator.indexOf$((Iterator)this, elem);
    }

    public <B> int indexOf(B elem, int from) {
        return Iterator.indexOf$((Iterator)this, elem, (int)from);
    }

    public BufferedIterator<ColumnarBatch> buffered() {
        return Iterator.buffered$((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.grouped$((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.sliding$((Iterator)this, (int)size, (int)step);
    }

    public <B> int sliding$default$2() {
        return Iterator.sliding$default$2$((Iterator)this);
    }

    public int length() {
        return Iterator.length$((Iterator)this);
    }

    public Tuple2<Iterator<ColumnarBatch>, Iterator<ColumnarBatch>> duplicate() {
        return Iterator.duplicate$((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start, int len) {
        Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.sameElements$((Iterator)this, that);
    }

    public Traversable<ColumnarBatch> toTraversable() {
        return Iterator.toTraversable$((Iterator)this);
    }

    public Iterator<ColumnarBatch> toIterator() {
        return Iterator.toIterator$((Iterator)this);
    }

    public Stream<ColumnarBatch> toStream() {
        return Iterator.toStream$((Iterator)this);
    }

    public String toString() {
        return Iterator.toString$((Iterator)this);
    }

    public List<ColumnarBatch> reversed() {
        return TraversableOnce.reversed$((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.size$((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.nonEmpty$((TraversableOnce)this);
    }

    public int count(Function1<ColumnarBatch, Object> p) {
        return TraversableOnce.count$((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<ColumnarBatch, B> pf) {
        return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, ColumnarBatch, B> op) {
        return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<ColumnarBatch, B, B> op) {
        return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, ColumnarBatch, B> op) {
        return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<ColumnarBatch, B, B> op) {
        return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.reduceOption$((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, ColumnarBatch, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.sum$((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.product$((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
    }

    public List<ColumnarBatch> toList() {
        return TraversableOnce.toList$((TraversableOnce)this);
    }

    public Iterable<ColumnarBatch> toIterable() {
        return TraversableOnce.toIterable$((TraversableOnce)this);
    }

    public Seq<ColumnarBatch> toSeq() {
        return TraversableOnce.toSeq$((TraversableOnce)this);
    }

    public IndexedSeq<ColumnarBatch> toIndexedSeq() {
        return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.toBuffer$((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.toSet$((TraversableOnce)this);
    }

    public Vector<ColumnarBatch> toVector() {
        return TraversableOnce.toVector$((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, ColumnarBatch, Col> cbf) {
        return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<ColumnarBatch, Tuple2<T, U>> ev) {
        return TraversableOnce.toMap$((TraversableOnce)this, ev);
    }

    public String mkString(String start, String sep, String end) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.mkString$((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
    }

    public int sizeHintIfCheap() {
        return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
    }

    private long targetSizeBytes() {
        return this.targetSizeBytes;
    }

    private int targetRows() {
        return this.targetRows;
    }

    private void targetRows_$eq(int x$1) {
        this.targetRows = x$1;
    }

    private long totalOutputBytes() {
        return this.totalOutputBytes;
    }

    private void totalOutputBytes_$eq(long x$1) {
        this.totalOutputBytes = x$1;
    }

    private long totalOutputRows() {
        return this.totalOutputRows;
    }

    private void totalOutputRows_$eq(long x$1) {
        this.totalOutputRows = x$1;
    }

    public boolean hasNext() {
        return this.rowIter.hasNext();
    }

    public ColumnarBatch next() {
        if (!this.rowIter.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.buildBatch();
    }

    private ColumnarBatch buildBatch() {
        ColumnarBatch columnarBatch;
        if (this.targetRows() == 0) {
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localSchema.fields())).isEmpty()) {
                this.targetRows_$eq(Integer.MAX_VALUE);
            } else {
                int sampleRows = GpuBatchUtils$.MODULE$.VALIDITY_BUFFER_BOUNDARY_ROWS();
                long sampleBytes = GpuBatchUtils$.MODULE$.estimateGpuMemory(this.localSchema, sampleRows);
                this.targetRows_$eq(GpuBatchUtils$.MODULE$.estimateRowCount(this.targetSizeBytes(), sampleBytes, sampleRows));
            }
        }
        try (GpuColumnVector.GpuColumnarBatchBuilder builders = new GpuColumnVector.GpuColumnarBatchBuilder(this.localSchema, this.targetRows());){
            Row row;
            int rowCount = 0;
            for (double byteCount = 0.0; rowCount < this.targetRows() && byteCount < (double)this.targetSizeBytes() && this.rowIter.hasNext(); byteCount += this.converters.convert(row, builders), ++rowCount) {
                row = (Row)this.rowIter.next();
            }
            if (this.rowIter.hasNext() && this.localGoal instanceof RequireSingleBatchLike) {
                throw new IllegalStateException("A single batch is required for this operation. Please try increasing your partition count.");
            }
            GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), NoopMetric$.MODULE$);
            ColumnarBatch ret = builders.build(rowCount);
            this.totalOutputBytes_$eq(this.totalOutputBytes() + GpuColumnVector.getTotalDeviceMemoryUsed(ret));
            this.totalOutputRows_$eq(this.totalOutputRows() + (long)rowCount);
            if (this.totalOutputRows() > 0L && this.totalOutputBytes() > 0L) {
                this.targetRows_$eq(GpuBatchUtils$.MODULE$.estimateRowCount(this.targetSizeBytes(), this.totalOutputBytes(), this.totalOutputRows()));
            }
            columnarBatch = ret;
        }
        return columnarBatch;
    }

    public ExternalRowToColumnarIterator(Iterator<Row> rowIter, StructType localSchema, CoalesceSizeGoal localGoal, GpuExternalRowToColumnConverter converters) {
        this.rowIter = rowIter;
        this.localSchema = localSchema;
        this.localGoal = localGoal;
        this.converters = converters;
        GenTraversableOnce.$init$((GenTraversableOnce)this);
        TraversableOnce.$init$((TraversableOnce)this);
        Iterator.$init$((Iterator)this);
        this.targetSizeBytes = localGoal.targetSizeBytes();
        this.targetRows = 0;
        this.totalOutputBytes = 0L;
        this.totalOutputRows = 0L;
    }
}

