/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle;

import com.nvidia.spark.rapids.shuffle.DirectByteBufferPool;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer$;
import java.nio.ByteBuffer;
import org.apache.spark.sql.rapids.storage.RapidsStorageUtils$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)a\b\u0001C\u0001\u007f!91\t\u0001a\u0001\n\u0003!\u0005b\u0002%\u0001\u0001\u0004%\t!\u0013\u0005\u0007\u001f\u0002\u0001\u000b\u0015B#\t\u000fA\u0003\u0001\u0019!C\u0001#\"9Q\u000b\u0001a\u0001\n\u00031\u0006B\u0002-\u0001A\u0003&!\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003\\\u0001\u0011\u0005!\fC\u0003]\u0001\u0011\u0005\u0011\u000bC\u0003^\u0001\u0011\u0005c\fC\u0003`\u0001\u0011\u0005a\fC\u0003a\u0001\u0011\u0005\u0013mB\u0004n+\u0005\u0005\t\u0012\u00018\u0007\u000fQ)\u0012\u0011!E\u0001_\")a(\u0005C\u0001g\"9A/EI\u0001\n\u0003)(A\u0007*fM\u000e{WO\u001c;fI\u0012K'/Z2u\u0005f$XMQ;gM\u0016\u0014(B\u0001\f\u0018\u0003\u001d\u0019\b.\u001e4gY\u0016T!\u0001G\r\u0002\rI\f\u0007/\u001b3t\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051aN^5eS\u0006T\u0011AH\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0005J\u0003C\u0001\u0012(\u001b\u0005\u0019#B\u0001\u0013&\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\tR\u0013BA\u0016$\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u0006\u0011!M\u0019\t\u0003]Ej\u0011a\f\u0006\u0003a\u0015\n1A\\5p\u0013\t\u0011tF\u0001\u0006CsR,')\u001e4gKJ\fA\u0001]8pYB\u0019Q\u0007\u000f\u001e\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012aa\u00149uS>t\u0007CA\u001e=\u001b\u0005)\u0012BA\u001f\u0016\u0005Q!\u0015N]3di\nKH/\u001a\"vM\u001a,'\u000fU8pY\u00061A(\u001b8jiz\"2\u0001Q!C!\tY\u0004\u0001C\u0003-\u0007\u0001\u0007Q\u0006C\u00044\u0007A\u0005\t\u0019\u0001\u001b\u0002\u0011I,gmQ8v]R,\u0012!\u0012\t\u0003k\u0019K!a\u0012\u001c\u0003\u0007%sG/\u0001\u0007sK\u001a\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002K\u001bB\u0011QgS\u0005\u0003\u0019Z\u0012A!\u00168ji\"9a*BA\u0001\u0002\u0004)\u0015a\u0001=%c\u0005I!/\u001a4D_VtG\u000fI\u0001\u0007G2|7/\u001a3\u0016\u0003I\u0003\"!N*\n\u0005Q3$a\u0002\"p_2,\u0017M\\\u0001\u000bG2|7/\u001a3`I\u0015\fHC\u0001&X\u0011\u001dq\u0005\"!AA\u0002I\u000bqa\u00197pg\u0016$\u0007%A\u0004bGF,\u0018N]3\u0015\u00035\n\u0011bZ3u\u0005V4g-\u001a:\u0002\u0011%\u001c8\t\\8tK\u0012\fQa\u00197pg\u0016$\u0012AS\u0001\u000ek:\u001c\u0018MZ3EKN$(o\\=\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0019\t\u0003G*t!\u0001\u001a5\u0011\u0005\u00154T\"\u00014\u000b\u0005\u001d|\u0012A\u0002\u001fs_>$h(\u0003\u0002jm\u00051\u0001K]3eK\u001aL!a\u001b7\u0003\rM#(/\u001b8h\u0015\tIg'\u0001\u000eSK\u001a\u001cu.\u001e8uK\u0012$\u0015N]3di\nKH/\u001a\"vM\u001a,'\u000f\u0005\u0002<#M\u0011\u0011\u0003\u001d\t\u0003kEL!A\u001d\u001c\u0003\r\u0005s\u0017PU3g)\u0005q\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001wU\t!toK\u0001y!\tIh0D\u0001{\u0015\tYH0A\u0005v]\u000eDWmY6fI*\u0011QPN\u0001\u000bC:tw\u000e^1uS>t\u0017BA@{\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RefCountedDirectByteBuffer
implements AutoCloseable {
    private final ByteBuffer bb;
    private final Option<DirectByteBufferPool> pool;
    private int refCount;
    private boolean closed;

    public static Option<DirectByteBufferPool> $lessinit$greater$default$2() {
        return RefCountedDirectByteBuffer$.MODULE$.$lessinit$greater$default$2();
    }

    public int refCount() {
        return this.refCount;
    }

    public void refCount_$eq(int x$1) {
        this.refCount = x$1;
    }

    public boolean closed() {
        return this.closed;
    }

    public void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public synchronized ByteBuffer acquire() {
        this.refCount_$eq(this.refCount() + 1);
        return this.bb;
    }

    public ByteBuffer getBuffer() {
        return this.bb;
    }

    public synchronized boolean isClosed() {
        return this.closed();
    }

    @Override
    public synchronized void close() {
        Object object;
        if (this.closed()) {
            throw new IllegalStateException("Close called too many times!");
        }
        this.refCount_$eq(this.refCount() - 1);
        if (this.refCount() <= 0) {
            if (this.pool.isDefined()) {
                object = BoxesRunTime.boxToBoolean((boolean)((DirectByteBufferPool)this.pool.get()).releaseBuffer(this));
            } else {
                this.unsafeDestroy();
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        this.closed_$eq(true);
    }

    public synchronized void unsafeDestroy() {
        RapidsStorageUtils$.MODULE$.dispose(this.bb);
    }

    public String toString() {
        return new StringBuilder(43).append("RefCountedDirectByteBuffer[bb=").append(this.bb).append(", ref_count=").append(this.refCount()).append("]").toString();
    }

    public RefCountedDirectByteBuffer(ByteBuffer bb, Option<DirectByteBufferPool> pool) {
        this.bb = bb;
        this.pool = pool;
        Predef$.MODULE$.assert(bb.isDirect(), (Function0 & java.io.Serializable & Serializable)() -> "Only direct buffers are supported");
        this.refCount = 0;
        this.closed = false;
    }
}

