/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle;

import ai.rapids.cudf.Cuda;
import ai.rapids.cudf.MemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.ShuffleMetadata$;
import com.nvidia.spark.rapids.format.BlockIdMeta;
import com.nvidia.spark.rapids.format.MetadataRequest;
import com.nvidia.spark.rapids.format.MetadataResponse;
import com.nvidia.spark.rapids.format.TableMeta;
import com.nvidia.spark.rapids.shuffle.BufferSendState;
import com.nvidia.spark.rapids.shuffle.MessageType$;
import com.nvidia.spark.rapids.shuffle.MetadataTransportBuffer;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleRequestHandler;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleServer;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleServer$PendingTransferResponse$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleServer$ShuffleServerOps$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport$;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer$;
import com.nvidia.spark.rapids.shuffle.SendBounceBuffers;
import com.nvidia.spark.rapids.shuffle.ServerConnection;
import com.nvidia.spark.rapids.shuffle.Transaction;
import com.nvidia.spark.rapids.shuffle.TransactionStats;
import com.nvidia.spark.rapids.shuffle.TransactionStatus$;
import com.nvidia.spark.rapids.shuffle.TransportUtils$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.rapids.RapidsShuffleSendPrepareException;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r]c\u0001\u00020`\u0001)D!\"a\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011)\t)\u0002\u0001B\u0001B\u0003%\u0011q\u0003\u0005\u000b\u0003;\u0001!Q1A\u0005\u0002\u0005}\u0001BCA\u0017\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011q\u0006\u0001\u0003\u0002\u0003\u0006I!!\r\t\u0015\u0005]\u0002A!A!\u0002\u0013\tI\u0004\u0003\u0006\u0002J\u0001\u0011\t\u0011)A\u0005\u0003sA!\"a\u0013\u0001\u0005\u0003\u0005\u000b\u0011BA'\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u001a\u0001\t\u0003\ty\u0002\u0003\u0005\u0002j\u0001\u0001\u000b\u0015BA6\u000f\u001d\t9\b\u0001E\u0005\u0003s2q!! \u0001\u0011\u0013\ty\bC\u0004\u0002T5!\t!a\"\u0007\r\u0005%U\u0002QAF\u0011)\tIj\u0004BK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003G{!\u0011#Q\u0001\n\u0005u\u0005bBA*\u001f\u0011\u0005\u0011Q\u0015\u0005\n\u0003[{\u0011\u0011!C\u0001\u0003_C\u0011\"a-\u0010#\u0003%\t!!.\t\u0013\u0005-w\"!A\u0005B\u00055\u0007\"CAk\u001f\u0005\u0005I\u0011AAl\u0011%\tynDA\u0001\n\u0003\t\t\u000fC\u0005\u0002n>\t\t\u0011\"\u0011\u0002p\"I\u0011Q`\b\u0002\u0002\u0013\u0005\u0011q \u0005\n\u0005\u0007y\u0011\u0011!C!\u0005\u000bA\u0011Ba\u0002\u0010\u0003\u0003%\tE!\u0003\t\u0013\t-q\"!A\u0005B\t5q!\u0003B\t\u001b\u0005\u0005\t\u0012\u0001B\n\r%\tI)DA\u0001\u0012\u0003\u0011)\u0002C\u0004\u0002Ty!\tAa\t\t\u0013\t\u001da$!A\u0005F\t%\u0001\"\u0003B\u0013=\u0005\u0005I\u0011\u0011B\u0014\u0011%\u0011YCHA\u0001\n\u0003\u0013iC\u0002\u0004\u0003:5\u0001%1\b\u0005\u000b\u0005{\u0019#Q3A\u0005\u0002\t}\u0002B\u0003B0G\tE\t\u0015!\u0003\u0003B!9\u00111K\u0012\u0005\u0002\t\u0005\u0004\"CAWG\u0005\u0005I\u0011\u0001B4\u0011%\t\u0019lII\u0001\n\u0003\u0011Y\u0007C\u0005\u0002L\u000e\n\t\u0011\"\u0011\u0002N\"I\u0011Q[\u0012\u0002\u0002\u0013\u0005\u0011q\u001b\u0005\n\u0003?\u001c\u0013\u0011!C\u0001\u0005_B\u0011\"!<$\u0003\u0003%\t%a<\t\u0013\u0005u8%!A\u0005\u0002\tM\u0004\"\u0003B\u0002G\u0005\u0005I\u0011\tB\u0003\u0011%\u00119aIA\u0001\n\u0003\u0012I\u0001C\u0005\u0003\f\r\n\t\u0011\"\u0011\u0003x\u001dI!1P\u0007\u0002\u0002#\u0005!Q\u0010\u0004\n\u0005si\u0011\u0011!E\u0001\u0005\u007fBq!a\u00153\t\u0003\u0011\u0019\tC\u0005\u0003\bI\n\t\u0011\"\u0012\u0003\n!I!Q\u0005\u001a\u0002\u0002\u0013\u0005%Q\u0011\u0005\n\u0005W\u0011\u0014\u0011!CA\u0005\u0013C\u0011Ba$\u0001\u0001\u0004%I!a6\t\u0013\tE\u0005\u00011A\u0005\n\tM\u0005\u0002\u0003BO\u0001\u0001\u0006K!!7\t\u000f\t}\u0005\u0001\"\u0001\u0002X\"9!\u0011\u0015\u0001\u0005\u0002\t\r\u0006b\u0002BS\u0001\u0011\u0005!q\u0015\u0005\b\u0005[\u0003A\u0011\u0001BX\u0011!\u0011)\f\u0001Q\u0001\n\t]\u0006\u0002\u0003Bs\u0001\u0001\u0006IAa:\t\u0013\t%\bA1A\u0005\u0002\t-\b\u0002CB\u0004\u0001\u0001\u0006IA!<\t\u000f\r%\u0001\u0001\"\u0003\u0004\f\u00191!q\u0018\u0001A\u0005\u0003D!\"!'D\u0005+\u0007I\u0011AAN\u0011)\t\u0019k\u0011B\tB\u0003%\u0011Q\u0014\u0005\u000b\u0003_\u0019%Q3A\u0005\u0002\t\r\u0007B\u0003Bc\u0007\nE\t\u0015!\u0003\u00022!9\u00111K\"\u0005\u0002\t\u001d\u0007\"CAW\u0007\u0006\u0005I\u0011\u0001Bg\u0011%\t\u0019lQI\u0001\n\u0003\t)\fC\u0005\u0003T\u000e\u000b\n\u0011\"\u0001\u0003V\"I\u00111Z\"\u0002\u0002\u0013\u0005\u0013Q\u001a\u0005\n\u0003+\u001c\u0015\u0011!C\u0001\u0003/D\u0011\"a8D\u0003\u0003%\tA!7\t\u0013\u000558)!A\u0005B\u0005=\b\"CA\u007f\u0007\u0006\u0005I\u0011\u0001Bo\u0011%\u0011\u0019aQA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\b\r\u000b\t\u0011\"\u0011\u0003\n!I!1B\"\u0002\u0002\u0013\u0005#\u0011]\u0004\n\u0007C\u0001\u0011\u0011!E\u0001\u0007G1\u0011Ba0\u0001\u0003\u0003E\ta!\n\t\u000f\u0005MS\u000b\"\u0001\u0004.!I!qA+\u0002\u0002\u0013\u0015#\u0011\u0002\u0005\n\u0005K)\u0016\u0011!CA\u0007_A\u0011Ba\u000bV\u0003\u0003%\ti!\u000e\t\u000f\r\u0005\u0003\u0001\"\u0001\u0004D!A1q\t\u0001\u0005\u0002}\u001bI\u0005C\u0004\u0004P\u0001!\ta!\u0015\t\u000f\rU\u0003\u0001\"\u0011\u0003$\n\u0019\"+\u00199jIN\u001c\u0006.\u001e4gY\u0016\u001cVM\u001d<fe*\u0011\u0001-Y\u0001\bg\",hM\u001a7f\u0015\t\u00117-\u0001\u0004sCBLGm\u001d\u0006\u0003I\u0016\fQa\u001d9be.T!AZ4\u0002\r94\u0018\u000eZ5b\u0015\u0005A\u0017aA2p[\u000e\u00011C\u0002\u0001lgZ\f\u0019\u0001\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!A.\u00198h\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\r=\u0013'.Z2u!\taG/\u0003\u0002v[\ni\u0011)\u001e;p\u00072|7/Z1cY\u0016\u0004\"a^@\u000e\u0003aT!!\u001f>\u0002\u0011%tG/\u001a:oC2T!\u0001Z>\u000b\u0005ql\u0018AB1qC\u000eDWMC\u0001\u007f\u0003\ry'oZ\u0005\u0004\u0003\u0003A(a\u0002'pO\u001eLgn\u001a\t\u0005\u0003\u000b\t9!D\u0001b\u0013\r\tI!\u0019\u0002\u0004\u0003Jl\u0017!\u0003;sC:\u001c\bo\u001c:u!\u0011\ty!!\u0005\u000e\u0003}K1!a\u0005`\u0005Y\u0011\u0016\r]5egNCWO\u001a4mKR\u0013\u0018M\\:q_J$\u0018\u0001E:feZ,'oQ8o]\u0016\u001cG/[8o!\u0011\ty!!\u0007\n\u0007\u0005mqL\u0001\tTKJ4XM]\"p]:,7\r^5p]\u00069rN]5hS:\fGn\u00155vM\u001adWmU3sm\u0016\u0014\u0018\nZ\u000b\u0003\u0003C\u0001B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003OQ\u0018aB:u_J\fw-Z\u0005\u0005\u0003W\t)C\u0001\bCY>\u001c7.T1oC\u001e,'/\u00133\u00021=\u0014\u0018nZ5oC2\u001c\u0006.\u001e4gY\u0016\u001cVM\u001d<fe&#\u0007%\u0001\bsKF,Xm\u001d;IC:$G.\u001a:\u0011\t\u0005=\u00111G\u0005\u0004\u0003ky&a\u0007*ba&$7o\u00155vM\u001adWMU3rk\u0016\u001cH\u000fS1oI2,'/\u0001\u0003fq\u0016\u001c\u0007\u0003BA\u001e\u0003\u000bj!!!\u0010\u000b\t\u0005}\u0012\u0011I\u0001\u000bG>t7-\u001e:sK:$(bAA\"_\u0006!Q\u000f^5m\u0013\u0011\t9%!\u0010\u0003\u0011\u0015CXmY;u_J\fqAY:t\u000bb,7-\u0001\u0006sCBLGm]\"p]\u001a\u0004B!!\u0002\u0002P%\u0019\u0011\u0011K1\u0003\u0015I\u000b\u0007/\u001b3t\u0007>tg-\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003/\nI&a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\u00022!a\u0004\u0001\u0011\u001d\tY!\u0003a\u0001\u0003\u001bAq!!\u0006\n\u0001\u0004\t9\u0002C\u0004\u0002\u001e%\u0001\r!!\t\t\u000f\u0005=\u0012\u00021\u0001\u00022!9\u0011qG\u0005A\u0002\u0005e\u0002bBA%\u0013\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u0017J\u0001\u0019AA'\u0003\u00159W\r^%e\u0003\u001d\u0019H/\u0019:uK\u0012\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0003\u0003c\nQa]2bY\u0006LA!!\u001e\u0002p\t9!i\\8mK\u0006t\u0017\u0001E*ik\u001a4G.Z*feZ,'o\u00149t!\r\tY(D\u0007\u0002\u0001\t\u00012\u000b[;gM2,7+\u001a:wKJ|\u0005o]\n\u0004\u001b\u0005\u0005\u0005\u0003BA7\u0003\u0007KA!!\"\u0002p\t1\u0011I\\=SK\u001a$\"!!\u001f\u0003\u0015!\u000bg\u000e\u001a7f\u001b\u0016$\u0018mE\u0004\u0010\u0003\u0003\u000bi)a%\u0011\t\u00055\u0014qR\u0005\u0005\u0003#\u000byGA\u0004Qe>$Wo\u0019;\u0011\t\u00055\u0014QS\u0005\u0005\u0003/\u000byG\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0002uqV\u0011\u0011Q\u0014\t\u0005\u0003\u001f\ty*C\u0002\u0002\"~\u00131\u0002\u0016:b]N\f7\r^5p]\u0006\u0019A\u000f\u001f\u0011\u0015\t\u0005\u001d\u00161\u0016\t\u0004\u0003S{Q\"A\u0007\t\u000f\u0005e%\u00031\u0001\u0002\u001e\u0006!1m\u001c9z)\u0011\t9+!-\t\u0013\u0005e5\u0003%AA\u0002\u0005u\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003oSC!!(\u0002:.\u0012\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003%)hn\u00195fG.,GM\u0003\u0003\u0002F\u0006=\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011ZA`\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0007c\u00017\u0002R&\u0019\u00111[7\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u000e\u0005\u0003\u0002n\u0005m\u0017\u0002BAo\u0003_\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a9\u0002jB!\u0011QNAs\u0013\u0011\t9/a\u001c\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002l^\t\t\u00111\u0001\u0002Z\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!=\u0011\r\u0005M\u0018\u0011`Ar\u001b\t\t)P\u0003\u0003\u0002x\u0006=\u0014AC2pY2,7\r^5p]&!\u00111`A{\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005-$\u0011\u0001\u0005\n\u0003WL\u0012\u0011!a\u0001\u0003G\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u00033\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\fa!Z9vC2\u001cH\u0003BA6\u0005\u001fA\u0011\"a;\u001d\u0003\u0003\u0005\r!a9\u0002\u0015!\u000bg\u000e\u001a7f\u001b\u0016$\u0018\rE\u0002\u0002*z\u0019RA\bB\f\u0003'\u0003\u0002B!\u0007\u0003 \u0005u\u0015qU\u0007\u0003\u00057QAA!\b\u0002p\u00059!/\u001e8uS6,\u0017\u0002\u0002B\u0011\u00057\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011\u0019\"A\u0003baBd\u0017\u0010\u0006\u0003\u0002(\n%\u0002bBAMC\u0001\u0007\u0011QT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yC!\u000e\u0011\r\u00055$\u0011GAO\u0013\u0011\u0011\u0019$a\u001c\u0003\r=\u0003H/[8o\u0011%\u00119DIA\u0001\u0002\u0004\t9+A\u0002yIA\u0012Q\u0003S1oI2,GK]1og\u001a,'OU3rk\u0016\u001cHoE\u0004$\u0003\u0003\u000bi)a%\u0002\u0013M,g\u000eZ*uCR,WC\u0001B!!\u0019\u0011\u0019Ea\u0015\u0003Z9!!Q\tB(\u001d\u0011\u00119E!\u0014\u000e\u0005\t%#b\u0001B&S\u00061AH]8pizJ!!!\u001d\n\t\tE\u0013qN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Fa\u0016\u0003\u0007M+\u0017O\u0003\u0003\u0003R\u0005=\u0004\u0003BA\b\u00057J1A!\u0018`\u0005=\u0011UO\u001a4feN+g\u000eZ*uCR,\u0017AC:f]\u0012\u001cF/\u0019;fAQ!!1\rB3!\r\tIk\t\u0005\b\u0005{1\u0003\u0019\u0001B!)\u0011\u0011\u0019G!\u001b\t\u0013\tur\u0005%AA\u0002\t\u0005SC\u0001B7U\u0011\u0011\t%!/\u0015\t\u0005\r(\u0011\u000f\u0005\n\u0003W\\\u0013\u0011!a\u0001\u00033$B!a\u001b\u0003v!I\u00111^\u0017\u0002\u0002\u0003\u0007\u00111\u001d\u000b\u0005\u0003W\u0012I\bC\u0005\u0002lB\n\t\u00111\u0001\u0002d\u0006)\u0002*\u00198eY\u0016$&/\u00198tM\u0016\u0014(+Z9vKN$\bcAAUeM)!G!!\u0002\u0014BA!\u0011\u0004B\u0010\u0005\u0003\u0012\u0019\u0007\u0006\u0002\u0003~Q!!1\rBD\u0011\u001d\u0011i$\u000ea\u0001\u0005\u0003\"BAa#\u0003\u000eB1\u0011Q\u000eB\u0019\u0005\u0003B\u0011Ba\u000e7\u0003\u0003\u0005\rAa\u0019\u0002\tA|'\u000f^\u0001\ta>\u0014Ho\u0018\u0013fcR!!Q\u0013BN!\u0011\tiGa&\n\t\te\u0015q\u000e\u0002\u0005+:LG\u000fC\u0005\u0002lb\n\t\u00111\u0001\u0002Z\u0006)\u0001o\u001c:uA\u00059q-\u001a;Q_J$\u0018!B:uCJ$HC\u0001BK\u0003!A\u0017M\u001c3mK>\u0003H\u0003\u0002BK\u0005SCqAa+=\u0001\u0004\t\u0019/\u0001\u0006tKJ4XM\u001d+bg.\fA\"Y:z]\u000e|%O\u00117pG.$BA!&\u00032\"9!1W\u001fA\u0002\u0005\r\u0018AA8q\u0003U\u0001XM\u001c3j]\u001e$&/\u00198tM\u0016\u00148/U;fk\u0016\u0004b!a\u000f\u0003:\nu\u0016\u0002\u0002B^\u0003{\u0011QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3Rk\u0016,X\rE\u0002\u0002|\r\u0013q\u0003U3oI&tw\r\u0016:b]N4WM\u001d*fgB|gn]3\u0014\u000f\r\u000b\t)!$\u0002\u0014V\u0011\u0011\u0011G\u0001\u0010e\u0016\fX/Z:u\u0011\u0006tG\r\\3sAQ1!Q\u0018Be\u0005\u0017Dq!!'I\u0001\u0004\ti\nC\u0004\u00020!\u0003\r!!\r\u0015\r\tu&q\u001aBi\u0011%\tI*\u0013I\u0001\u0002\u0004\ti\nC\u0005\u00020%\u0003\n\u00111\u0001\u00022\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BlU\u0011\t\t$!/\u0015\t\u0005\r(1\u001c\u0005\n\u0003Wt\u0015\u0011!a\u0001\u00033$B!a\u001b\u0003`\"I\u00111\u001e)\u0002\u0002\u0003\u0007\u00111\u001d\u000b\u0005\u0003W\u0012\u0019\u000fC\u0005\u0002lN\u000b\t\u00111\u0001\u0002d\u0006\u0001\"m]:D_:$\u0018N\\;f#V,W/\u001a\t\u0007\u0003w\u0011IL!\u0017\u0002\u0019M,'O^3s'R\u0014X-Y7\u0016\u0005\t5\b\u0003\u0002Bx\u0007\u0003qAA!=\u0003~6\u0011!1\u001f\u0006\u0005\u0005k\u001490\u0001\u0003dk\u00124'b\u00012\u0003z*\u0011!1`\u0001\u0003C&LAAa@\u0003t\u0006!1)\u001e3b\u0013\u0011\u0019\u0019a!\u0002\u0003\rM#(/Z1n\u0015\u0011\u0011yPa=\u0002\u001bM,'O^3s'R\u0014X-Y7!\u0003Y\u0011XmZ5ti\u0016\u0014(+Z9vKN$\b*\u00198eY\u0016\u0014H\u0003\u0002BK\u0007\u001bAqaa\u0004C\u0001\u0004\u0019\t\"A\u0006nKN\u001c\u0018mZ3UsB,\u0007\u0003BB\n\u00073qA!a\u0004\u0004\u0016%\u00191qC0\u0002\u00175+7o]1hKRK\b/Z\u0005\u0005\u00077\u0019iBA\u0003WC2,X-\u0003\u0003\u0004 \u0005=$aC#ok6,'/\u0019;j_:\fq\u0003U3oI&tw\r\u0016:b]N4WM\u001d*fgB|gn]3\u0011\u0007\u0005mTkE\u0003V\u0007O\t\u0019\n\u0005\u0006\u0003\u001a\r%\u0012QTA\u0019\u0005{KAaa\u000b\u0003\u001c\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\r\rBC\u0002B_\u0007c\u0019\u0019\u0004C\u0004\u0002\u001ab\u0003\r!!(\t\u000f\u0005=\u0002\f1\u0001\u00022Q!1qGB !\u0019\tiG!\r\u0004:AA\u0011QNB\u001e\u0003;\u000b\t$\u0003\u0003\u0004>\u0005=$A\u0002+va2,'\u0007C\u0005\u00038e\u000b\t\u00111\u0001\u0003>\u00069Bm\u001c%b]\u0012dW-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e\u000b\u0005\u0005+\u001b)\u0005C\u0004\u0002\u001aj\u0003\r!!(\u0002%\u0005$G\rV8D_:$\u0018N\\;f#V,W/\u001a\u000b\u0005\u0005+\u001bY\u0005C\u0004\u0004Nm\u0003\rA!\u0011\u0002!\t,hMZ3s'\u0016tGm\u0015;bi\u0016\u001c\u0018a\u00063p\u0011\u0006tG\r\\3Ue\u0006t7OZ3s%\u0016\fX/Z:u)\u0011\u0011)ja\u0015\t\u000f\r5C\f1\u0001\u0003B\u0005)1\r\\8tK\u0002")
public class RapidsShuffleServer
implements AutoCloseable,
Logging,
Arm {
    private volatile RapidsShuffleServer$ShuffleServerOps$ ShuffleServerOps$module;
    private volatile RapidsShuffleServer$PendingTransferResponse$ PendingTransferResponse$module;
    private final RapidsShuffleTransport transport;
    private final ServerConnection serverConnection;
    private final BlockManagerId originalShuffleServerId;
    private final RapidsShuffleRequestHandler requestHandler;
    private final Executor exec;
    private final Executor bssExec;
    private boolean started;
    private int port;
    private final ConcurrentLinkedQueue<PendingTransferResponse> pendingTransfersQueue;
    private final ConcurrentLinkedQueue<BufferSendState> bssContinueQueue;
    private final Cuda.Stream serverStream;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private RapidsShuffleServer$ShuffleServerOps$ ShuffleServerOps() {
        if (this.ShuffleServerOps$module == null) {
            this.ShuffleServerOps$lzycompute$1();
        }
        return this.ShuffleServerOps$module;
    }

    public RapidsShuffleServer$PendingTransferResponse$ PendingTransferResponse() {
        if (this.PendingTransferResponse$module == null) {
            this.PendingTransferResponse$lzycompute$1();
        }
        return this.PendingTransferResponse$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManagerId originalShuffleServerId() {
        return this.originalShuffleServerId;
    }

    public BlockManagerId getId() {
        return TrampolineUtil$.MODULE$.newBlockManagerId(this.originalShuffleServerId().executorId(), this.originalShuffleServerId().host(), this.originalShuffleServerId().port(), (Option<String>)new Some((Object)new StringBuilder(1).append(RapidsShuffleTransport$.MODULE$.BLOCK_MANAGER_ID_TOPO_PREFIX()).append("=").append(this.getPort()).toString()));
    }

    private int port() {
        return this.port;
    }

    private void port_$eq(int x$1) {
        this.port = x$1;
    }

    public int getPort() {
        if (this.port() == -1) {
            throw new IllegalStateException("RapidsShuffleServer port is not initialized");
        }
        return this.port();
    }

    public void start() {
        this.port_$eq(this.serverConnection.startManagementPort(this.originalShuffleServerId().host()));
        this.registerRequestHandler(MessageType$.MODULE$.MetadataRequest());
        this.registerRequestHandler(MessageType$.MODULE$.TransferRequest());
    }

    public void handleOp(Object serverTask) {
        block4: {
            try {
                ShuffleServerOps.HandleTransferRequest handleTransferRequest;
                Seq<BufferSendState> wt;
                Object object = serverTask;
                if (object instanceof ShuffleServerOps.HandleMeta && ((ShuffleServerOps.HandleMeta)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$ShuffleServerOps$HandleMeta$$$outer() == this.ShuffleServerOps()) {
                    ShuffleServerOps.HandleMeta handleMeta = (ShuffleServerOps.HandleMeta)object;
                    Transaction tx = handleMeta.tx();
                    this.doHandleMetadataRequest(tx);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (object instanceof ShuffleServerOps.HandleTransferRequest && ((ShuffleServerOps.HandleTransferRequest)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$ShuffleServerOps$HandleTransferRequest$$$outer() == this.ShuffleServerOps() && (wt = (handleTransferRequest = (ShuffleServerOps.HandleTransferRequest)object).sendState()) != null) {
                    Seq<BufferSendState> seq = wt;
                    this.doHandleTransferRequest(seq);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                throw new MatchError(object);
            }
            catch (Throwable t) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception occurred while handling shuffle server task.", t);
            }
        }
    }

    public void asyncOrBlock(Object op) {
        this.exec.execute(() -> this.handleOp(op));
    }

    public Cuda.Stream serverStream() {
        return this.serverStream;
    }

    private void registerRequestHandler(Enumeration.Value messageType) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Registering ").append(messageType).append(" request callback").toString());
        this.serverConnection.registerRequestHandler(messageType, tx -> this.withResource(new NvtxRange("Handle Meta Request", NvtxColor.PURPLE), (Function1 & Serializable & scala.Serializable)x$1 -> {
            RapidsShuffleServer.$anonfun$registerRequestHandler$3(this, messageType, tx, x$1);
            return BoxedUnit.UNIT;
        }));
    }

    public void doHandleMetadataRequest(Transaction tx) {
        this.withResource(tx, (Function1 & Serializable & scala.Serializable)x$2 -> {
            this.withResource(new NvtxRange("doHandleMeta", NvtxColor.PURPLE), (Function1 & Serializable & scala.Serializable)x$3 -> {
                $this.withResource(tx$2.releaseMessage(), (Function1 & Serializable & scala.Serializable)mtb -> {
                    RapidsShuffleServer.$anonfun$doHandleMetadataRequest$3($this, tx$2, mtb);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public void addToContinueQueue(Seq<BufferSendState> bufferSendStates) {
        Executor executor = this.bssExec;
        synchronized (executor) {
            bufferSendStates.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.bssContinueQueue.add(x$1)));
            this.bssExec.notifyAll();
        }
    }

    public void doHandleTransferRequest(Seq<BufferSendState> bufferSendStates) {
        this.closeOnExcept(bufferSendStates, (Function1 & Serializable & scala.Serializable)x$6 -> {
            RapidsShuffleServer.$anonfun$doHandleTransferRequest$1(this, bufferSendStates, x$6);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void close() {
        this.started = false;
        Executor executor = this.bssExec;
        synchronized (executor) {
            this.bssExec.notifyAll();
        }
    }

    private final void ShuffleServerOps$lzycompute$1() {
        RapidsShuffleServer rapidsShuffleServer = this;
        synchronized (rapidsShuffleServer) {
            if (this.ShuffleServerOps$module == null) {
                this.ShuffleServerOps$module = new RapidsShuffleServer$ShuffleServerOps$(this);
            }
        }
    }

    private final void PendingTransferResponse$lzycompute$1() {
        RapidsShuffleServer rapidsShuffleServer = this;
        synchronized (rapidsShuffleServer) {
            if (this.PendingTransferResponse$module == null) {
                this.PendingTransferResponse$module = new RapidsShuffleServer$PendingTransferResponse$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(RapidsShuffleServer $this, ArrayBuffer bssToIssue) {
        block3: {
            BufferSendState bssContinue = $this.bssContinueQueue.poll();
            while (bssContinue != null) {
                bssToIssue.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BufferSendState[]{bssContinue}));
                bssContinue = $this.bssContinueQueue.poll();
            }
            boolean bl = true;
            while (!$this.pendingTransfersQueue.isEmpty() && bl) {
                Seq<SendBounceBuffers> sendBounceBuffers = $this.transport.tryGetSendBounceBuffers(1L, 1);
                if (sendBounceBuffers.nonEmpty()) {
                    PendingTransferResponse pendingTransfer = $this.pendingTransfersQueue.poll();
                    bssToIssue.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BufferSendState[]{new BufferSendState(pendingTransfer.tx(), (SendBounceBuffers)sendBounceBuffers.head(), pendingTransfer.requestHandler(), $this.serverStream())}));
                    continue;
                }
                $this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can't acquire send bounce buffers");
                bl = false;
            }
            if (!bssToIssue.nonEmpty()) break block3;
            $this.doHandleTransferRequest((Seq<BufferSendState>)bssToIssue);
        }
    }

    public static final /* synthetic */ void $anonfun$registerRequestHandler$3(RapidsShuffleServer $this, Enumeration.Value messageType$1, Transaction tx$1, NvtxRange x$1) {
        Enumeration.Value value = messageType$1;
        Enumeration.Value value2 = MessageType$.MODULE$.MetadataRequest();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            $this.asyncOrBlock(new ShuffleServerOps.HandleMeta($this.ShuffleServerOps(), tx$1));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = MessageType$.MODULE$.TransferRequest();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                PendingTransferResponse pendingTransfer = new PendingTransferResponse($this, tx$1, $this.requestHandler);
                Executor executor = $this.bssExec;
                synchronized (executor) {
                    $this.pendingTransfersQueue.add(pendingTransfer);
                    $this.bssExec.notifyAll();
                }
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Got a transfer request ").append(pendingTransfer).append(" from ").append(tx$1).append(". ").append("Pending requests [new=").append($this.pendingTransfersQueue.size()).append(", ").append("continuing=").append($this.bssContinueQueue.size()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)value);
            }
        }
    }

    public static final /* synthetic */ Seq $anonfun$doHandleMetadataRequest$7(RapidsShuffleServer $this, MetadataRequest req$1, int i) {
        BlockIdMeta blockId = req$1.blockIds(i);
        return $this.requestHandler.getShuffleBufferMetas(new ShuffleBlockBatchId(blockId.shuffleId(), blockId.mapId(), blockId.startReduceId(), blockId.endReduceId()));
    }

    public static final /* synthetic */ void $anonfun$doHandleMetadataRequest$11(RapidsShuffleServer $this, Transaction responseTx$1, RefCountedDirectByteBuffer x$5) {
        TransactionStats stats = responseTx$1.getStats();
        $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Sent metadata ").append(stats.sendSize()).append(" in ").append(stats.txTimeMs()).append(" ms").toString());
    }

    public static final /* synthetic */ void $anonfun$doHandleMetadataRequest$10(RapidsShuffleServer $this, RefCountedDirectByteBuffer respBuffer$1, Transaction tx$2, Transaction responseTx) {
        Enumeration.Value value = responseTx.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Success();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit = (BoxedUnit)$this.withResource(respBuffer$1, (Function1 & Serializable & scala.Serializable)x$5 -> {
                RapidsShuffleServer.$anonfun$doHandleMetadataRequest$11($this, responseTx, x$5);
                return BoxedUnit.UNIT;
            });
        } else {
            Enumeration.Value value4 = TransactionStatus$.MODULE$.Error();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error sending metadata response in tx ").append(tx$2).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)value);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleMetadataRequest$3(RapidsShuffleServer $this, Transaction tx$2, MetadataTransportBuffer mtb) {
        Enumeration.Value value = tx$2.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Error();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("error getting metadata request: ").append(tx$2).toString());
        } else {
            MetadataRequest req = ShuffleMetadata$.MODULE$.getMetadataRequest(mtb.getBuffer());
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Received request req:\n: ").append(ShuffleMetadata$.MODULE$.printRequest(req)).toString());
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("HandleMetadataRequest for peerExecutorId ").append(tx$2.peerExecutorId()).append(" and ").append("tx ").append(tx$2).toString());
            IndexedSeq responseTables = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), req.blockIdsLength()).flatMap((Function1 & Serializable & scala.Serializable)i -> RapidsShuffleServer.$anonfun$doHandleMetadataRequest$7($this, req, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            ByteBuffer metadataResponse = ShuffleMetadata$.MODULE$.buildMetaResponse((Seq<TableMeta>)responseTables);
            RefCountedDirectByteBuffer respBuffer = new RefCountedDirectByteBuffer(metadataResponse, RefCountedDirectByteBuffer$.MODULE$.$lessinit$greater$default$2());
            MetadataResponse materializedResponse = ShuffleMetadata$.MODULE$.getMetadataResponse(metadataResponse);
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Response will be at header ").append(TransportUtils$.MODULE$.toHex(tx$2.getHeader())).append(":\n").append(ShuffleMetadata$.MODULE$.printResponse("responding", materializedResponse)).toString());
            Transaction responseTx = tx$2.respond(respBuffer.getBuffer(), x$4 -> $this.withResource(x$4, (Function1 & Serializable & scala.Serializable)responseTx -> {
                RapidsShuffleServer.$anonfun$doHandleMetadataRequest$10($this, respBuffer, tx$2, responseTx);
                return BoxedUnit.UNIT;
            }));
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Waiting for send metadata to complete: ").append(responseTx).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleTransferRequest$3(BufferSendState bufferSendState$1, ArrayBuffer bssBuffers$1, ObjectRef toTryAgain$1, ObjectRef supressedErrors$1, NvtxRange x$7) {
        Predef$.MODULE$.require(bufferSendState$1.hasMoreSends(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to handle a complete transfer request.");
        try {
            MemoryBuffer buffersToSend = bufferSendState$1.getBufferToSend();
            bssBuffers$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)bufferSendState$1, (Object)buffersToSend)}));
        }
        catch (RapidsShuffleSendPrepareException ex) {
            if ((ArrayBuffer)toTryAgain$1.elem == null) {
                toTryAgain$1.elem = new ArrayBuffer();
                supressedErrors$1.elem = new ArrayBuffer();
            }
            ((ArrayBuffer)toTryAgain$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BufferSendState[]{bufferSendState$1}));
            ((ArrayBuffer)supressedErrors$1.elem).append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Throwable[]{ex}));
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleTransferRequest$17(RapidsShuffleServer $this, Transaction responseTx$3, RefCountedDirectByteBuffer x$12) {
        boolean bl;
        Enumeration.Value value = responseTx$3.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Cancelled();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            bl = true;
        } else {
            Enumeration.Value value4 = TransactionStatus$.MODULE$.Error();
            Enumeration.Value value5 = value;
            bl = !(value4 != null ? !value4.equals(value5) : value5 != null);
        }
        if (bl) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Error while handling TransferResponse: ").append(responseTx$3.getErrorMessage()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleTransferRequest$11(RapidsShuffleServer $this, BufferSendState bufferSendState$2, MemoryBuffer buffersToSend$1, long peerExecutorId$1, Transaction bufferTx) {
        Enumeration.Value value = bufferTx.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Success();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit;
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Done with the send for ").append(bufferSendState$2).append(" with ").append(buffersToSend$1).toString());
            if (bufferSendState$2.hasMoreSends()) {
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Buffer send state ").append(bufferSendState$2).append(" is NOT done. ").append("Still pending: ").append($this.pendingTransfersQueue.size()).append(".").toString());
                $this.addToContinueQueue((Seq<BufferSendState>)((Seq)new .colon.colon((Object)bufferSendState$2, (List)Nil$.MODULE$)));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                RefCountedDirectByteBuffer transferResponse = bufferSendState$2.getTransferResponse();
                Transaction requestTx = bufferSendState$2.getRequestTransaction();
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Handling transfer request ").append(requestTx).append(" for executor ").append(peerExecutorId$1).append(" with ").append(buffersToSend$1).toString());
                requestTx.respond(transferResponse.acquire(), x$11 -> $this.withResource(x$11, (Function1 & Serializable & scala.Serializable)responseTx -> {
                    $this.withResource(transferResponse, (Function1 & Serializable & scala.Serializable)x$12 -> {
                        RapidsShuffleServer.$anonfun$doHandleTransferRequest$17($this, responseTx, x$12);
                        return BoxedUnit.UNIT;
                    });
                    return BoxedUnit.UNIT;
                }));
                $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Buffer send state ").append(TransportUtils$.MODULE$.toHex(bufferSendState$2.getPeerBufferReceiveHeader())).append(" ").append("is done, closing. Still pending: ").append($this.pendingTransfersQueue.size()).append(".").toString());
                Executor executor = $this.bssExec;
                synchronized (executor) {
                    bufferSendState$2.close();
                    $this.bssExec.notifyAll();
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Error while sending buffers ").append(bufferTx).append(".").toString());
            Executor executor = $this.bssExec;
            synchronized (executor) {
                bufferSendState$2.close();
                $this.bssExec.notifyAll();
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleTransferRequest$1(RapidsShuffleServer $this, Seq bufferSendStates$1, Seq x$6) {
        ArrayBuffer bssBuffers = new ArrayBuffer(bufferSendStates$1.size());
        ObjectRef toTryAgain = ObjectRef.create(null);
        ObjectRef supressedErrors = ObjectRef.create(null);
        bufferSendStates$1.foreach((Function1 & Serializable & scala.Serializable)bufferSendState -> {
            $this.withResource(new NvtxRange("doHandleTransferRequest", NvtxColor.CYAN), (Function1 & Serializable & scala.Serializable)x$7 -> {
                RapidsShuffleServer.$anonfun$doHandleTransferRequest$3(bufferSendState, bssBuffers$1, toTryAgain$1, supressedErrors$1, x$7);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        if ((ArrayBuffer)toTryAgain.elem != null) {
            if (bssBuffers.isEmpty()) {
                IllegalStateException ise = new IllegalStateException("Unable to prepare any sends. This issue can occur when requesting too many shuffle blocks. The sends will not be retried.");
                ((ArrayBuffer)supressedErrors.elem).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    ise.addSuppressed(x$1);
                    return BoxedUnit.UNIT;
                });
                throw ise;
            }
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Unable to prepare ").append(((ArrayBuffer)toTryAgain$1.elem).size()).append(" sends. ").append("This issue can occur when requesting many shuffle blocks. ").append("The sends will be retried.").toString());
            $this.addToContinueQueue((Seq<BufferSendState>)((ArrayBuffer)toTryAgain.elem));
        }
        $this.serverStream().sync();
        bufferSendStates$1.foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.releaseAcquiredToCatalog();
            return BoxedUnit.UNIT;
        });
        bssBuffers.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BufferSendState bufferSendState = (BufferSendState)tuple2._1();
            MemoryBuffer buffersToSend = (MemoryBuffer)tuple2._2();
            long peerExecutorId = bufferSendState.peerExecutorId();
            long sendHeader = bufferSendState.getPeerBufferReceiveHeader();
            Transaction transaction = (Transaction)$this.withResource(buffersToSend, (Function1 & Serializable & scala.Serializable)x$9 -> $this.serverConnection.send(peerExecutorId, MessageType$.MODULE$.Buffer(), sendHeader, buffersToSend, x$10 -> $this.withResource(x$10, (Function1 & Serializable & scala.Serializable)bufferTx -> {
                RapidsShuffleServer.$anonfun$doHandleTransferRequest$11($this, bufferSendState, buffersToSend, peerExecutorId, bufferTx);
                return BoxedUnit.UNIT;
            })));
            return transaction;
        });
    }

    public RapidsShuffleServer(RapidsShuffleTransport transport, ServerConnection serverConnection, BlockManagerId originalShuffleServerId, RapidsShuffleRequestHandler requestHandler, Executor exec, Executor bssExec, RapidsConf rapidsConf) {
        this.transport = transport;
        this.serverConnection = serverConnection;
        this.originalShuffleServerId = originalShuffleServerId;
        this.requestHandler = requestHandler;
        this.exec = exec;
        this.bssExec = bssExec;
        Logging.$init$((Logging)this);
        Arm.$init$(this);
        this.started = true;
        this.port = -1;
        this.pendingTransfersQueue = new ConcurrentLinkedQueue();
        this.bssContinueQueue = new ConcurrentLinkedQueue();
        bssExec.execute(() -> {
            while ($this.started) {
                this.closeOnExcept(new ArrayBuffer(), (Function1 & Serializable & scala.Serializable)bssToIssue -> {
                    RapidsShuffleServer.$anonfun$new$2(this, bssToIssue);
                    return BoxedUnit.UNIT;
                });
                Executor executor = $this.bssExec;
                synchronized (executor) {
                    if ($this.bssContinueQueue.isEmpty() && $this.pendingTransfersQueue.isEmpty()) {
                        $this.bssExec.wait(100L);
                    }
                }
            }
        });
        this.serverStream = Cuda.DEFAULT_STREAM;
    }

    public class PendingTransferResponse
    implements Product,
    scala.Serializable {
        private final Transaction tx;
        private final RapidsShuffleRequestHandler requestHandler;
        public final /* synthetic */ RapidsShuffleServer $outer;

        public Transaction tx() {
            return this.tx;
        }

        public RapidsShuffleRequestHandler requestHandler() {
            return this.requestHandler;
        }

        public PendingTransferResponse copy(Transaction tx, RapidsShuffleRequestHandler requestHandler) {
            return new PendingTransferResponse(this.com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$PendingTransferResponse$$$outer(), tx, requestHandler);
        }

        public Transaction copy$default$1() {
            return this.tx();
        }

        public RapidsShuffleRequestHandler copy$default$2() {
            return this.requestHandler();
        }

        public String productPrefix() {
            return "PendingTransferResponse";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.tx();
                    break;
                }
                case 1: {
                    object = this.requestHandler();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PendingTransferResponse;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PendingTransferResponse)) return false;
            if (((PendingTransferResponse)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$PendingTransferResponse$$$outer() != this.com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$PendingTransferResponse$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            PendingTransferResponse pendingTransferResponse = (PendingTransferResponse)x$1;
            Transaction transaction = this.tx();
            Transaction transaction2 = pendingTransferResponse.tx();
            if (transaction == null) {
                if (transaction2 != null) {
                    return false;
                }
            } else if (!transaction.equals(transaction2)) return false;
            RapidsShuffleRequestHandler rapidsShuffleRequestHandler = this.requestHandler();
            RapidsShuffleRequestHandler rapidsShuffleRequestHandler2 = pendingTransferResponse.requestHandler();
            if (rapidsShuffleRequestHandler == null) {
                if (rapidsShuffleRequestHandler2 != null) {
                    return false;
                }
            } else if (!rapidsShuffleRequestHandler.equals(rapidsShuffleRequestHandler2)) return false;
            if (!pendingTransferResponse.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ RapidsShuffleServer com$nvidia$spark$rapids$shuffle$RapidsShuffleServer$PendingTransferResponse$$$outer() {
            return this.$outer;
        }

        public PendingTransferResponse(RapidsShuffleServer $outer, Transaction tx, RapidsShuffleRequestHandler requestHandler) {
            this.tx = tx;
            this.requestHandler = requestHandler;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

