/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuParquetUtils;
import com.nvidia.spark.rapids.ParquetPartitionReader;
import com.nvidia.spark.rapids.PartitionReaderWithBytesRead;
import com.nvidia.spark.rapids.iceberg.data.GpuDeleteFilter;
import com.nvidia.spark.rapids.iceberg.parquet.ParquetDictionaryRowGroupFilter;
import com.nvidia.spark.rapids.iceberg.parquet.ParquetIO;
import com.nvidia.spark.rapids.iceberg.parquet.ParquetMetricsRowGroupFilter;
import com.nvidia.spark.rapids.iceberg.parquet.ParquetSchemaUtil;
import com.nvidia.spark.rapids.iceberg.parquet.TypeWithSchemaVisitor;
import com.nvidia.spark.rapids.iceberg.spark.SparkSchemaUtil;
import com.nvidia.spark.rapids.iceberg.spark.source.GpuIcebergReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.collection.Iterable;
import scala.collection.Seq;

public class GpuParquetReader
extends CloseableGroup
implements CloseableIterable<ColumnarBatch> {
    private final InputFile input;
    private final Schema expectedSchema;
    private final ParquetReadOptions options;
    private final Expression filter;
    private final boolean caseSensitive;
    private final NameMapping nameMapping;
    private final Map<Integer, ?> idToConstant;
    private final GpuDeleteFilter deleteFilter;
    private final PartitionedFile partFile;
    private final Configuration conf;
    private final int maxBatchSizeRows;
    private final long maxBatchSizeBytes;
    private final String debugDumpPrefix;
    private final scala.collection.immutable.Map<String, GpuMetric> metrics;

    public GpuParquetReader(InputFile input, Schema expectedSchema, ParquetReadOptions options, NameMapping nameMapping, Expression filter, boolean caseSensitive, Map<Integer, ?> idToConstant, GpuDeleteFilter deleteFilter, PartitionedFile partFile, Configuration conf, int maxBatchSizeRows, long maxBatchSizeBytes, String debugDumpPrefix, scala.collection.immutable.Map<String, GpuMetric> metrics) {
        this.input = input;
        this.expectedSchema = expectedSchema;
        this.options = options;
        this.nameMapping = nameMapping;
        this.filter = filter;
        this.caseSensitive = caseSensitive;
        this.idToConstant = idToConstant;
        this.deleteFilter = deleteFilter;
        this.partFile = partFile;
        this.conf = conf;
        this.maxBatchSizeRows = maxBatchSizeRows;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.debugDumpPrefix = debugDumpPrefix;
        this.metrics = metrics;
    }

    public CloseableIterator<ColumnarBatch> iterator() {
        GpuIcebergReader gpuIcebergReader;
        block11: {
            ParquetFileReader reader = GpuParquetReader.newReader(this.input, this.options);
            try {
                MessageType fileSchema = reader.getFileMetaData().getSchema();
                MessageType typeWithIds = ParquetSchemaUtil.hasIds(fileSchema) ? fileSchema : (this.nameMapping != null ? ParquetSchemaUtil.applyNameMapping(fileSchema, this.nameMapping) : ParquetSchemaUtil.addFallbackIds(fileSchema));
                List rowGroups = reader.getRowGroups();
                ArrayList filteredRowGroups = Lists.newArrayListWithCapacity((int)rowGroups.size());
                if (this.expectedSchema.findField(MetadataColumns.ROW_POSITION.fieldId()) != null) {
                    throw new UnsupportedOperationException("row position meta column not implemented");
                }
                ParquetMetricsRowGroupFilter statsFilter = null;
                ParquetDictionaryRowGroupFilter dictFilter = null;
                if (this.filter != null) {
                    statsFilter = new ParquetMetricsRowGroupFilter(this.expectedSchema, this.filter, this.caseSensitive);
                    dictFilter = new ParquetDictionaryRowGroupFilter(this.expectedSchema, this.filter, this.caseSensitive);
                }
                for (BlockMetaData rowGroup : rowGroups) {
                    boolean shouldRead = this.filter == null || statsFilter.shouldRead(typeWithIds, rowGroup) && dictFilter.shouldRead(typeWithIds, rowGroup, (DictionaryPageReadStore)reader.getDictionaryReader(rowGroup));
                    if (!shouldRead) continue;
                    filteredRowGroups.add(rowGroup);
                }
                ReorderColumns reorder = ParquetSchemaUtil.hasIds(fileSchema) ? new ReorderColumns(this.idToConstant) : new ReorderColumnsFallback(this.idToConstant);
                MessageType fileReadSchema = (MessageType)TypeWithSchemaVisitor.visit((Type)this.expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileSchema, reorder);
                Seq<BlockMetaData> clippedBlocks = GpuParquetUtils.clipBlocksToSchema(fileReadSchema, filteredRowGroups, this.caseSensitive);
                StructType partReaderSparkSchema = (StructType)TypeWithSchemaVisitor.visit((Type)this.expectedSchema.asStruct(), (org.apache.parquet.schema.Type)fileReadSchema, new SparkSchemaConverter());
                ParquetPartitionReader parquetPartReader = new ParquetPartitionReader(this.conf, this.partFile, new Path(this.input.location()), (Iterable<BlockMetaData>)clippedBlocks, fileReadSchema, this.caseSensitive, partReaderSparkSchema, this.debugDumpPrefix, this.maxBatchSizeRows, this.maxBatchSizeBytes, this.metrics, true, true, true, false);
                PartitionReaderWithBytesRead partReader = new PartitionReaderWithBytesRead(parquetPartReader);
                Map<Integer, ?> updatedConstants = GpuParquetReader.addNullsForMissingFields(this.idToConstant, reorder.getMissingFields());
                gpuIcebergReader = new GpuIcebergReader(this.expectedSchema, partReader, this.deleteFilter, updatedConstants);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to create/close reader for file: " + this.input, e);
                }
            }
            reader.close();
        }
        return gpuIcebergReader;
    }

    private static ParquetFileReader newReader(InputFile file, ParquetReadOptions options) {
        try {
            return ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file(file), (ParquetReadOptions)options);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open Parquet file: " + file.location(), e);
        }
    }

    private static Map<Integer, ?> addNullsForMissingFields(Map<Integer, ?> idToConstant, Set<Integer> missingFields) {
        if (missingFields.isEmpty()) {
            return idToConstant;
        }
        HashMap updated = Maps.newHashMap(idToConstant);
        for (Integer field : missingFields) {
            updated.put(field, null);
        }
        return updated;
    }

    private static class ReorderColumnsFallback
    extends ReorderColumns {
        public ReorderColumnsFallback(Map<Integer, ?> idToConstant) {
            super(idToConstant);
        }

        @Override
        public org.apache.parquet.schema.Type message(Types.StructType expected, MessageType message, List<org.apache.parquet.schema.Type> fields) {
            return super.struct(expected, (GroupType)message, fields);
        }

        @Override
        public org.apache.parquet.schema.Type struct(Types.StructType ignored, GroupType struct, List<org.apache.parquet.schema.Type> fields) {
            return struct;
        }
    }

    private static class ReorderColumns
    extends TypeWithSchemaVisitor<org.apache.parquet.schema.Type> {
        private final Map<Integer, ?> idToConstant;
        private final Set<Integer> missingFields = Sets.newHashSet();

        public ReorderColumns(Map<Integer, ?> idToConstant) {
            this.idToConstant = idToConstant;
        }

        public Set<Integer> getMissingFields() {
            return this.missingFields;
        }

        @Override
        public org.apache.parquet.schema.Type message(Types.StructType expected, MessageType message, List<org.apache.parquet.schema.Type> fields) {
            Types.MessageTypeBuilder builder = Types.buildMessage();
            List<org.apache.parquet.schema.Type> newFields = this.filterAndReorder(expected, fields);
            for (org.apache.parquet.schema.Type type : newFields) {
                builder.addField(type);
            }
            return builder.named(message.getName());
        }

        @Override
        public org.apache.parquet.schema.Type struct(Types.StructType expected, GroupType struct, List<org.apache.parquet.schema.Type> fields) {
            List<org.apache.parquet.schema.Type> newFields = this.filterAndReorder(expected, fields);
            return struct.withNewFields(newFields);
        }

        @Override
        public org.apache.parquet.schema.Type list(Types.ListType expectedList, GroupType list, org.apache.parquet.schema.Type element) {
            boolean hasConstant = expectedList.fields().stream().anyMatch(f -> this.idToConstant.containsKey(f.fieldId()));
            if (hasConstant) {
                throw new UnsupportedOperationException("constant column in list");
            }
            GroupType repeated = list.getType(0).asGroupType();
            org.apache.parquet.schema.Type originalElement = repeated.getType(0);
            if (Objects.equals(element, originalElement)) {
                return list;
            }
            return list.withNewFields(new org.apache.parquet.schema.Type[]{repeated.withNewFields(new org.apache.parquet.schema.Type[]{element})});
        }

        @Override
        public org.apache.parquet.schema.Type map(Types.MapType expectedMap, GroupType map, org.apache.parquet.schema.Type key, org.apache.parquet.schema.Type value) {
            boolean hasConstant = expectedMap.fields().stream().anyMatch(f -> this.idToConstant.containsKey(f.fieldId()));
            if (hasConstant) {
                throw new UnsupportedOperationException("constant column in map");
            }
            GroupType repeated = ((org.apache.parquet.schema.Type)map.getFields().get(0)).asGroupType();
            org.apache.parquet.schema.Type originalKey = repeated.getType(0);
            org.apache.parquet.schema.Type originalValue = repeated.getType(0);
            if (Objects.equals(key, originalKey) && Objects.equals(value, originalValue)) {
                return map;
            }
            return map.withNewFields(new org.apache.parquet.schema.Type[]{repeated.withNewFields(new org.apache.parquet.schema.Type[]{key, value})});
        }

        @Override
        public org.apache.parquet.schema.Type primitive(Type.PrimitiveType expected, PrimitiveType primitive) {
            return primitive;
        }

        private boolean shouldIgnoreFileColumn(int id) {
            return this.idToConstant.containsKey(id) || id == MetadataColumns.ROW_POSITION.fieldId() && id == MetadataColumns.IS_DELETED.fieldId();
        }

        private List<org.apache.parquet.schema.Type> filterAndReorder(Types.StructType expected, List<org.apache.parquet.schema.Type> fields) {
            HashMap typesById = Maps.newHashMap();
            for (org.apache.parquet.schema.Type fieldType : fields) {
                if (fieldType.getId() == null) continue;
                int id = fieldType.getId().intValue();
                typesById.put(id, fieldType);
            }
            List expectedFields = expected != null ? expected.fields() : ImmutableList.of();
            ArrayList reorderedFields = Lists.newArrayListWithCapacity((int)expectedFields.size());
            Iterator iterator = expectedFields.iterator();
            while (iterator.hasNext()) {
                Types.NestedField field = (Types.NestedField)iterator.next();
                int id = field.fieldId();
                if (this.shouldIgnoreFileColumn(id)) continue;
                org.apache.parquet.schema.Type newField = (org.apache.parquet.schema.Type)typesById.get(id);
                if (newField != null) {
                    reorderedFields.add(newField);
                    continue;
                }
                this.missingFields.add(id);
            }
            return reorderedFields;
        }
    }

    private static class SparkSchemaConverter
    extends TypeWithSchemaVisitor<DataType> {
        private SparkSchemaConverter() {
        }

        @Override
        public DataType message(Types.StructType iStruct, MessageType message, List<DataType> fields) {
            return this.struct(iStruct, (GroupType)message, fields);
        }

        @Override
        public DataType struct(Types.StructType iStruct, GroupType struct, List<DataType> fieldTypes) {
            List parquetFields = struct.getFields();
            ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldTypes.size());
            for (int i = 0; i < parquetFields.size(); ++i) {
                org.apache.parquet.schema.Type parquetField = (org.apache.parquet.schema.Type)parquetFields.get(i);
                Preconditions.checkArgument((!parquetField.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Fields cannot have repetition REPEATED: %s", (Object)parquetField);
                boolean isNullable = parquetField.isRepetition(Type.Repetition.OPTIONAL);
                StructField field = new StructField(parquetField.getName(), fieldTypes.get(i), isNullable, Metadata.empty());
                fields.add(field);
            }
            return new StructType(fields.toArray(new StructField[0]));
        }

        @Override
        public DataType list(Types.ListType iList, GroupType array, DataType elementType) {
            GroupType repeated = array.getType(0).asGroupType();
            org.apache.parquet.schema.Type element = repeated.getType(0);
            Preconditions.checkArgument((!element.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Elements cannot have repetition REPEATED: %s", (Object)element);
            boolean isNullable = element.isRepetition(Type.Repetition.OPTIONAL);
            return new ArrayType(elementType, isNullable);
        }

        @Override
        public DataType map(Types.MapType iMap, GroupType map, DataType keyType, DataType valueType) {
            GroupType keyValue = map.getType(0).asGroupType();
            org.apache.parquet.schema.Type value = keyValue.getType(1);
            Preconditions.checkArgument((!value.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Values cannot have repetition REPEATED: %s", (Object)value);
            boolean isValueNullable = value.isRepetition(Type.Repetition.OPTIONAL);
            return new MapType(keyType, valueType, isValueNullable);
        }

        @Override
        public DataType primitive(Type.PrimitiveType iPrimitive, PrimitiveType primitiveType) {
            switch (iPrimitive.typeId()) {
                case LONG: {
                    if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) {
                        return IntegerType$.MODULE$;
                    }
                    return LongType$.MODULE$;
                }
                case DOUBLE: {
                    if (primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.FLOAT)) {
                        return FloatType$.MODULE$;
                    }
                    return DoubleType$.MODULE$;
                }
                case DECIMAL: {
                    DecimalMetadata metadata = primitiveType.getDecimalMetadata();
                    return DecimalType$.MODULE$.apply(metadata.getPrecision(), metadata.getScale());
                }
            }
            return SparkSchemaUtil.convert((Type)iPrimitive);
        }
    }
}

