/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.PartitionedFileUtils;
import com.nvidia.spark.rapids.iceberg.data.GpuDeleteFilter;
import com.nvidia.spark.rapids.iceberg.parquet.GpuParquetReader;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.collection.immutable.Map;

public class GpuParquet {
    private static final Collection<String> READ_PROPERTIES_TO_REMOVE = Sets.newHashSet((Object[])new String[]{"parquet.read.filter", "parquet.private.read.filter.predicate", "parquet.read.support.class"});

    private GpuParquet() {
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    public static class ReadBuilder {
        private final InputFile file;
        private Long start = null;
        private Long length = null;
        private Schema projectSchema = null;
        private java.util.Map<Integer, ?> idToConstant = null;
        private GpuDeleteFilter deleteFilter = null;
        private Expression filter = null;
        private boolean caseSensitive = true;
        private NameMapping nameMapping = null;
        private Configuration conf = null;
        private int maxBatchSizeRows = Integer.MAX_VALUE;
        private long maxBatchSizeBytes = Integer.MAX_VALUE;
        private String debugDumpPrefix = null;
        private Map<String, GpuMetric> metrics = null;

        private ReadBuilder(InputFile file) {
            this.file = file;
        }

        public ReadBuilder split(long newStart, long newLength) {
            this.start = newStart;
            this.length = newLength;
            return this;
        }

        public ReadBuilder project(Schema newSchema) {
            this.projectSchema = newSchema;
            return this;
        }

        public ReadBuilder caseSensitive(boolean newCaseSensitive) {
            this.caseSensitive = newCaseSensitive;
            return this;
        }

        public ReadBuilder constants(java.util.Map<Integer, ?> constantsMap) {
            this.idToConstant = constantsMap;
            return this;
        }

        public ReadBuilder deleteFilter(GpuDeleteFilter deleteFilter) {
            this.deleteFilter = deleteFilter;
            return this;
        }

        public ReadBuilder filter(Expression newFilter) {
            this.filter = newFilter;
            return this;
        }

        public ReadBuilder withNameMapping(NameMapping newNameMapping) {
            this.nameMapping = newNameMapping;
            return this;
        }

        public ReadBuilder withConfiguration(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public ReadBuilder withMaxBatchSizeRows(int maxBatchSizeRows) {
            this.maxBatchSizeRows = maxBatchSizeRows;
            return this;
        }

        public ReadBuilder withMaxBatchSizeBytes(long maxBatchSizeBytes) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            return this;
        }

        public ReadBuilder withDebugDumpPrefix(String dumpPrefix) {
            this.debugDumpPrefix = dumpPrefix;
            return this;
        }

        public ReadBuilder withMetrics(Map<String, GpuMetric> metrics) {
            this.metrics = metrics;
            return this;
        }

        public CloseableIterable<ColumnarBatch> build() {
            Configuration conf;
            if (this.file instanceof HadoopInputFile) {
                conf = new Configuration(((HadoopInputFile)this.file).getConf());
                for (String property : READ_PROPERTIES_TO_REMOVE) {
                    conf.unset(property);
                }
            } else {
                throw new UnsupportedOperationException("Only Hadoop files are supported for now");
            }
            HadoopReadOptions.Builder optionsBuilder = HadoopReadOptions.builder((Configuration)conf);
            if (this.start != null) {
                optionsBuilder.withRange(this.start.longValue(), this.start + this.length);
            }
            ParquetReadOptions options = optionsBuilder.build();
            PartitionedFile partFile = PartitionedFileUtils.newPartitionedFile(InternalRow.empty(), this.file.location(), this.start, this.length);
            return new GpuParquetReader(this.file, this.projectSchema, options, this.nameMapping, this.filter, this.caseSensitive, this.idToConstant, this.deleteFilter, partFile, this.conf, this.maxBatchSizeRows, this.maxBatchSizeBytes, this.debugDumpPrefix, this.metrics);
        }
    }
}

