/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.DeviceMemoryBuffer;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsBufferCatalog$;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.SpillableBuffer$;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.rapids.TempSpillBufferId;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001E\t\u00015!A!\u0006\u0001B\u0001B\u0003%1\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u001d\u0001\u0005\u00011A\u0005\n\u0005Cq\u0001\u0013\u0001A\u0002\u0013%\u0011\n\u0003\u0004P\u0001\u0001\u0006KA\u0011\u0005\u0006!\u0002!\t!\u0015\u0005\t%\u0002A)\u0019!C\u0001'\")q\u000b\u0001C\u00011\")1\f\u0001C\u00019\")a\r\u0001C!O\u001e)\u0001.\u0005E\u0001S\u001a)\u0001#\u0005E\u0001U\")1(\u0004C\u0001]\")q.\u0004C\u0001a\ny1\u000b]5mY\u0006\u0014G.\u001a\"vM\u001a,'O\u0003\u0002\u0013'\u00051!/\u00199jINT!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012A\u00028wS\u0012L\u0017MC\u0001\u0019\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011d\t\u0014\u0011\u0005q\tS\"A\u000f\u000b\u0005yy\u0012\u0001\u00027b]\u001eT\u0011\u0001I\u0001\u0005U\u00064\u0018-\u0003\u0002#;\t1qJ\u00196fGR\u0004\"\u0001\b\u0013\n\u0005\u0015j\"!D!vi>\u001cEn\\:fC\ndW\r\u0005\u0002(Q5\t\u0011#\u0003\u0002*#\t\u0019\u0011I]7\u0002\u0005%$\u0007C\u0001\u00176\u001b\u0005i#B\u0001\n/\u0015\ty\u0003'A\u0002tc2T!\u0001F\u0019\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0005\u0003m5\u0012\u0011\u0003V3naN\u0003\u0018\u000e\u001c7Ck\u001a4WM]%e\u0003\u001d\u0019X-\\,bSR\u0004\"aJ\u001d\n\u0005i\n\"!C$qk6+GO]5d\u0003\u0019a\u0014N\\5u}Q\u0019QHP \u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\u0004\u0001\u0004Y\u0003\"B\u001c\u0004\u0001\u0004A\u0014AB2m_N,G-F\u0001C!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u001d\u0011un\u001c7fC:\f!b\u00197pg\u0016$w\fJ3r)\tQU\n\u0005\u0002D\u0017&\u0011A\n\u0012\u0002\u0005+:LG\u000fC\u0004O\u000b\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013'A\u0004dY>\u001cX\r\u001a\u0011\u0002\u000fM\u0004\u0018\u000e\u001c7JIV\t1&A\u0006tSj,\u0017J\u001c\"zi\u0016\u001cX#\u0001+\u0011\u0005\r+\u0016B\u0001,E\u0005\u0011auN\\4\u0002!M,Go\u00159jY2\u0004&/[8sSRLHC\u0001&Z\u0011\u0015Q\u0016\u00021\u0001U\u0003!\u0001(/[8sSRL\u0018aD4fi\u0012+g/[2f\u0005V4g-\u001a:\u0015\u0003u\u0003\"A\u00183\u000e\u0003}S!\u0001Y1\u0002\t\r,HM\u001a\u0006\u0003%\tT\u0011aY\u0001\u0003C&L!!Z0\u0003%\u0011+g/[2f\u001b\u0016lwN]=Ck\u001a4WM]\u0001\u0006G2|7/\u001a\u000b\u0002\u0015\u0006y1\u000b]5mY\u0006\u0014G.\u001a\"vM\u001a,'\u000f\u0005\u0002(\u001bM\u0019Qb\u001b\u0014\u0011\u0005\rc\u0017BA7E\u0005\u0019\te.\u001f*fMR\t\u0011.A\u0003baBd\u0017\u0010\u0006\u0003>cN$\b\"\u0002:\u0010\u0001\u0004i\u0016A\u00022vM\u001a,'\u000fC\u0003[\u001f\u0001\u0007A\u000bC\u0003v\u001f\u0001\u0007a/A\u0007ta&dGnQ1mY\n\f7m\u001b\t\u0003O]L!\u0001_\t\u0003\u001bM\u0003\u0018\u000e\u001c7DC2d'-Y2l\u0001")
public class SpillableBuffer
implements AutoCloseable,
Arm {
    private long sizeInBytes;
    private final TempSpillBufferId id;
    private final GpuMetric semWait;
    private boolean closed;
    private volatile boolean bitmap$0;

    public static SpillableBuffer apply(DeviceMemoryBuffer deviceMemoryBuffer, long l, SpillCallback spillCallback) {
        return SpillableBuffer$.MODULE$.apply(deviceMemoryBuffer, l, spillCallback);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public TempSpillBufferId spillId() {
        return this.id;
    }

    private long sizeInBytes$lzycompute() {
        SpillableBuffer spillableBuffer = this;
        synchronized (spillableBuffer) {
            if (!this.bitmap$0) {
                this.sizeInBytes = BoxesRunTime.unboxToLong(this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)buff -> BoxesRunTime.boxToLong((long)buff.size())));
                this.bitmap$0 = true;
            }
        }
        return this.sizeInBytes;
    }

    public long sizeInBytes() {
        return !this.bitmap$0 ? this.sizeInBytes$lzycompute() : this.sizeInBytes;
    }

    public void setSpillPriority(long priority) {
        this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)rapidsBuffer -> {
            rapidsBuffer.setSpillPriority(priority);
            return BoxedUnit.UNIT;
        });
    }

    public DeviceMemoryBuffer getDeviceBuffer() {
        return (DeviceMemoryBuffer)this.withResource(RapidsBufferCatalog$.MODULE$.acquireBuffer(this.id), (Function1 & java.io.Serializable & Serializable)rapidsBuffer -> {
            GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), $this.semWait);
            return rapidsBuffer.getDeviceMemoryBuffer();
        });
    }

    @Override
    public void close() {
        block0: {
            if (this.closed()) break block0;
            RapidsBufferCatalog$.MODULE$.removeBuffer(this.id);
            this.closed_$eq(true);
        }
    }

    public SpillableBuffer(TempSpillBufferId id, GpuMetric semWait) {
        this.id = id;
        this.semWait = semWait;
        Arm.$init$(this);
        this.closed = false;
    }
}

