/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostColumnVector;
import com.nvidia.spark.rapids.RapidsHostColumnVector;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class SlicedGpuColumnVector
extends ColumnVector {
    private final RapidsHostColumnVector wrap;
    private final int start;
    private final int end;

    protected SlicedGpuColumnVector(RapidsHostColumnVector w, int start, int end) {
        super(w.dataType());
        this.wrap = w;
        this.start = start;
        this.end = end;
        assert (start >= 0);
        assert (end > start);
        assert ((long)end <= w.getBase().getRowCount());
        w.incRefCount();
    }

    public void close() {
        this.wrap.close();
    }

    public static ColumnarBatch incRefCount(ColumnarBatch batch) {
        for (int i = 0; i < batch.numCols(); ++i) {
            ((SlicedGpuColumnVector)batch.column(i)).getBase().incRefCount();
        }
        return batch;
    }

    public boolean hasNull() {
        return this.wrap.hasNull();
    }

    public int numNulls() {
        return this.wrap.numNulls();
    }

    public boolean isNullAt(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.isNullAt(rowId + this.start);
    }

    public boolean getBoolean(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getBoolean(rowId + this.start);
    }

    public byte getByte(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getByte(rowId + this.start);
    }

    public short getShort(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getShort(rowId + this.start);
    }

    public int getInt(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getInt(rowId + this.start);
    }

    public long getLong(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getLong(rowId + this.start);
    }

    public float getFloat(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getFloat(rowId + this.start);
    }

    public double getDouble(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getDouble(rowId + this.start);
    }

    public ColumnarArray getArray(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getArray(rowId + this.start);
    }

    public ColumnarMap getMap(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getMap(rowId + this.start);
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        assert (rowId + this.start < this.end);
        return this.wrap.getDecimal(rowId + this.start, precision, scale);
    }

    public UTF8String getUTF8String(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getUTF8String(rowId + this.start);
    }

    public byte[] getBinary(int rowId) {
        assert (rowId + this.start < this.end);
        return this.wrap.getBinary(rowId + this.start);
    }

    public ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("Children for a slice are not currently supported...");
    }

    public HostColumnVector getBase() {
        return this.wrap.getBase();
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }
}

