/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BaseDeviceMemoryBuffer;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.DecimalUtil$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.SchemaUtils$;
import com.nvidia.spark.rapids.shims.ParquetSchemaClipShims$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.Optional;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.apache.spark.sql.rapids.shims.RapidsErrorUtils$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class ParquetSchemaUtils$
implements Arm {
    public static ParquetSchemaUtils$ MODULE$;
    private final String SPARK_PARQUET_SCHEMA_NAME;
    private final MessageType EMPTY_MESSAGE;

    static {
        new ParquetSchemaUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private String SPARK_PARQUET_SCHEMA_NAME() {
        return this.SPARK_PARQUET_SCHEMA_NAME;
    }

    public MessageType EMPTY_MESSAGE() {
        return this.EMPTY_MESSAGE;
    }

    public MessageType clipParquetSchema(MessageType parquetSchema, StructType catalystSchema, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetSchema.asGroupType(), catalystSchema, caseSensitive, useFieldId);
        return clippedParquetFields.isEmpty() ? this.EMPTY_MESSAGE() : (MessageType)Types.buildMessage().addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(this.SPARK_PARQUET_SCHEMA_NAME());
    }

    private Type clipParquetType(Type parquetType, DataType catalystType, boolean caseSensitive, boolean useFieldId) {
        MapType mapType;
        Type type;
        ArrayType arrayType;
        DataType dataType = catalystType;
        if (dataType instanceof ArrayType && !this.isPrimitiveCatalystType((arrayType = (ArrayType)dataType).elementType())) {
            type = this.clipParquetListType(parquetType.asGroupType(), arrayType.elementType(), caseSensitive, useFieldId);
        } else if (!(!(dataType instanceof MapType) || this.isPrimitiveCatalystType((mapType = (MapType)dataType).keyType()) && this.isPrimitiveCatalystType(mapType.valueType()))) {
            type = this.clipParquetMapType(parquetType.asGroupType(), mapType.keyType(), mapType.valueType(), caseSensitive, useFieldId);
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            type = this.clipParquetGroup(parquetType.asGroupType(), structType, caseSensitive, useFieldId);
        } else {
            type = parquetType;
        }
        Type newParquetType = type;
        return useFieldId && parquetType.getId() != null ? newParquetType.withId(parquetType.getId().intValue()) : newParquetType;
    }

    private boolean isPrimitiveCatalystType(DataType dataType) {
        DataType dataType2 = dataType;
        boolean bl = dataType2 instanceof ArrayType ? true : (dataType2 instanceof MapType ? true : dataType2 instanceof StructType);
        boolean bl2 = !bl;
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Type clipParquetListType(GroupType parquetList, DataType elementType, boolean caseSensitive, boolean useFieldId) {
        GroupType repeatedGroup;
        Type type;
        block5: {
            block4: {
                Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(elementType));
                if (parquetList.getOriginalType() == null && parquetList.isRepetition(Type.Repetition.REPEATED)) {
                    type = this.clipParquetType((Type)parquetList, elementType, caseSensitive, useFieldId);
                    return type;
                }
                OriginalType originalType = parquetList.getOriginalType();
                OriginalType originalType2 = OriginalType.LIST;
                Predef$.MODULE$.assert(!(originalType != null ? !originalType.equals(originalType2) : originalType2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Invalid Parquet schema. Logical type annotation of annotated Parquet lists must be ListLogicalTypeAnnotation: ").append(parquetList.toString()).toString());
                Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(90).append("Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append(parquetList).toString());
                Predef$.MODULE$.assert(!parquetList.getType(0).isPrimitive());
                repeatedGroup = parquetList.getType(0).asGroupType();
                if (repeatedGroup.getFieldCount() > 1) break block4;
                String string = repeatedGroup.getName();
                String string2 = "array";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block4;
                String string3 = repeatedGroup.getName();
                String string4 = new StringBuilder(6).append(parquetList.getName()).append("_tuple").toString();
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block5;
            }
            type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField(this.clipParquetType((Type)repeatedGroup, elementType, caseSensitive, useFieldId)).named(parquetList.getName());
            return type;
        }
        GroupType newRepeatedGroup = (GroupType)Types.repeatedGroup().addField(this.clipParquetType(repeatedGroup.getType(0), elementType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType newElementType = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        type = (Type)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetList.getRepetition()).as(OriginalType.LIST)).addField((Type)newElementType).named(parquetList.getName());
        return type;
    }

    private GroupType clipParquetMapType(GroupType parquetMap, DataType keyType, DataType valueType, boolean caseSensitive, boolean useFieldId) {
        Predef$.MODULE$.assert(!this.isPrimitiveCatalystType(keyType) || !this.isPrimitiveCatalystType(valueType));
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        GroupType newRepeatedGroup = (GroupType)((Types.BaseGroupBuilder)Types.repeatedGroup().as(repeatedGroup.getOriginalType())).addField(this.clipParquetType(parquetKeyType, keyType, caseSensitive, useFieldId)).addField(this.clipParquetType(parquetValueType, valueType, caseSensitive, useFieldId)).named(repeatedGroup.getName());
        GroupType clippedRepeatedGroup = useFieldId && repeatedGroup.getId() != null ? newRepeatedGroup.withId(repeatedGroup.getId().intValue()) : newRepeatedGroup;
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetMap.getRepetition()).as(parquetMap.getOriginalType())).addField((Type)clippedRepeatedGroup).named(parquetMap.getName());
    }

    private GroupType clipParquetGroup(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        Seq<Type> clippedParquetFields = this.clipParquetGroupFields(parquetRecord, structType, caseSensitive, useFieldId);
        return (GroupType)((Types.BaseGroupBuilder)Types.buildGroup((Type.Repetition)parquetRecord.getRepetition()).as(parquetRecord.getOriginalType())).addFields((Type[])clippedParquetFields.toArray(ClassTag$.MODULE$.apply(Type.class))).named(parquetRecord.getName());
    }

    private Seq<Type> clipParquetGroupFields(GroupType parquetRecord, StructType structType, boolean caseSensitive, boolean useFieldId) {
        LazyRef caseSensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef caseInsensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef idToParquetFieldMap$lzy = new LazyRef();
        boolean shouldMatchById = useFieldId && ParquetSchemaClipShims$.MODULE$.hasFieldIds(structType);
        return (Seq)structType.flatMap((Function1 & Serializable & scala.Serializable)f -> shouldMatchById && ParquetSchemaClipShims$.MODULE$.hasFieldId((StructField)f) ? Option$.MODULE$.option2Iterable(ParquetSchemaUtils$.matchIdField$1(f, caseSensitive, useFieldId, idToParquetFieldMap$lzy, parquetRecord)) : (caseSensitive ? Option$.MODULE$.option2Iterable(ParquetSchemaUtils$.matchCaseSensitiveField$1(f, caseSensitive, useFieldId, caseSensitiveParquetFieldMap$lzy, parquetRecord)) : Option$.MODULE$.option2Iterable(ParquetSchemaUtils$.matchCaseInsensitiveField$1(f, caseSensitive, useFieldId, caseInsensitiveParquetFieldMap$lzy, parquetRecord))), Seq$.MODULE$.canBuildFrom());
    }

    public StructType clipSparkSchema(StructType sparkSchema, MessageType parquetSchema, boolean caseSensitive, boolean useFieldId) {
        return this.clipSparkStructType(sparkSchema, parquetSchema.asGroupType(), caseSensitive, useFieldId);
    }

    private DataType clipSparkType(DataType sparkType, Type parquetType, boolean caseSensitive, boolean useFieldId) {
        DataType dataType;
        DataType dataType2 = sparkType;
        if (dataType2 instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            dataType = this.clipSparkArrayType(arrayType, parquetType.asGroupType(), caseSensitive, useFieldId);
        } else if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            dataType = this.clipSparkMapType(mapType, parquetType.asGroupType(), caseSensitive, useFieldId);
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            dataType = this.clipSparkStructType(structType, parquetType.asGroupType(), caseSensitive, useFieldId);
        } else {
            dataType = ParquetSchemaClipShims$.MODULE$.convertPrimitiveField(parquetType.asPrimitiveType());
        }
        return dataType;
    }

    /*
     * Unable to fully structure code
     */
    private DataType clipSparkArrayType(ArrayType sparkType, GroupType parquetList, boolean caseSensitive, boolean useFieldId) {
        block3: {
            block5: {
                block4: {
                    block2: {
                        elementType = sparkType.elementType();
                        if (parquetList.getOriginalType() != null || !parquetList.isRepetition(Type.Repetition.REPEATED)) break block2;
                        v0 = this.clipSparkType(elementType, (Type)parquetList, caseSensitive, useFieldId);
                        break block3;
                    }
                    v1 = parquetList.getOriginalType();
                    var6_6 = OriginalType.LIST;
                    Predef$.MODULE$.assert(!(v1 != null ? v1.equals(var6_6) == false : var6_6 != null), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$clipSparkArrayType$1(org.apache.parquet.schema.GroupType ), ()Ljava/lang/String;)((GroupType)parquetList));
                    Predef$.MODULE$.assert(parquetList.getFieldCount() == 1 && parquetList.getType(0).isRepetition(Type.Repetition.REPEATED) != false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$clipSparkArrayType$2(org.apache.parquet.schema.GroupType ), ()Ljava/lang/String;)((GroupType)parquetList));
                    repeated = parquetList.getType(0);
                    if (!repeated.isPrimitive()) break block4;
                    v2 = this.clipSparkType(elementType, parquetList.getType(0), caseSensitive, useFieldId);
                    break block5;
                }
                repeatedGroup = repeated.asGroupType();
                if (repeatedGroup.getFieldCount() > 1) ** GOTO lbl-1000
                v3 = repeatedGroup.getName();
                var11_9 = "array";
                if (!(v3 == null ? var11_9 != null : v3.equals(var11_9) == false)) ** GOTO lbl-1000
                v4 = repeatedGroup.getName();
                var12_10 = new StringBuilder(6).append(parquetList.getName()).append("_tuple").toString();
                if (!(v4 != null ? v4.equals(var12_10) == false : var12_10 != null)) lbl-1000:
                // 3 sources

                {
                    v5 = repeatedGroup;
                } else {
                    v5 = repeatedGroup.getType(0);
                }
                parquetElementType = v5;
                v2 = this.clipSparkType(elementType, (Type)parquetElementType, caseSensitive, useFieldId);
            }
            newSparkType = v2;
            v0 = sparkType.copy(newSparkType, sparkType.copy$default$2());
        }
        return v0;
    }

    private MapType clipSparkMapType(MapType sparkType, GroupType parquetMap, boolean caseSensitive, boolean useFieldId) {
        DataType keyType = sparkType.keyType();
        DataType valueType = sparkType.valueType();
        GroupType repeatedGroup = parquetMap.getType(0).asGroupType();
        Type parquetKeyType = repeatedGroup.getType(0);
        Type parquetValueType = repeatedGroup.getType(1);
        DataType newKeyType = this.clipSparkType(keyType, parquetKeyType, caseSensitive, useFieldId);
        DataType newValueType = this.clipSparkType(valueType, parquetValueType, caseSensitive, useFieldId);
        return sparkType.copy(newKeyType, newValueType, sparkType.copy$default$3());
    }

    private StructType clipSparkStructType(StructType sparkType, GroupType parquetType, boolean caseSensitive, boolean useFieldId) {
        LazyRef caseSensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef caseInsensitiveParquetFieldMap$lzy = new LazyRef();
        LazyRef idToParquetFieldMap$lzy = new LazyRef();
        boolean shouldMatchById = useFieldId && ParquetSchemaClipShims$.MODULE$.hasFieldIds(sparkType);
        Seq updatedFields = (Seq)sparkType.flatMap((Function1 & Serializable & scala.Serializable)f -> shouldMatchById && ParquetSchemaClipShims$.MODULE$.hasFieldId((StructField)f) ? Option$.MODULE$.option2Iterable(this.matchIdField$2((StructField)f, idToParquetFieldMap$lzy, parquetType, caseSensitive, useFieldId)) : (caseSensitive ? Option$.MODULE$.option2Iterable(this.matchCaseSensitiveField$2((StructField)f, caseSensitiveParquetFieldMap$lzy, parquetType, caseSensitive, useFieldId)) : Option$.MODULE$.option2Iterable(this.matchCaseInsensitiveField$2((StructField)f, caseInsensitiveParquetFieldMap$lzy, parquetType, caseSensitive, useFieldId))), Seq$.MODULE$.canBuildFrom());
        return StructType$.MODULE$.apply(updatedFields);
    }

    public Table evolveSchemaIfNeededAndClose(Table table, MessageType fileSchema, StructType sparkSchema, boolean caseSensitive, boolean useFieldId) {
        StructType fileSparkSchema = (StructType)this.closeOnExcept(table, (Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.clipSparkSchema(sparkSchema, fileSchema, caseSensitive, useFieldId));
        return SchemaUtils$.MODULE$.evolveSchemaIfNeededAndClose(table, fileSparkSchema, sparkSchema, caseSensitive, (Option<Function2<ColumnView, DataType, ColumnView>>)new Some((Function2 & Serializable & scala.Serializable)(cv, dt) -> MODULE$.evolveSchemaCasts((ColumnView)cv, (DataType)dt)), this.existsUnsignedType(fileSchema.asGroupType()) || TrampolineUtil$.MODULE$.dataTypeExistsRecursively((DataType)sparkSchema, (Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaUtils$.$anonfun$evolveSchemaIfNeededAndClose$3(x$12))));
    }

    private boolean existsUnsignedType(GroupType group) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(group.getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaUtils$.$anonfun$existsUnsignedType$1(field)));
    }

    private boolean needDecimalCast(ColumnView cv, DataType dt) {
        return cv.getType().isDecimalType() && !GpuColumnVector.getNonNestedRapidsType(dt).equals((Object)cv.getType()) || cv.getType().equals((Object)DType.UINT64);
    }

    private boolean needUnsignedToSignedCast(ColumnView cv, DataType dt) {
        return cv.getType().equals((Object)DType.UINT8) && dt instanceof ShortType || cv.getType().equals((Object)DType.UINT16) && dt instanceof IntegerType || cv.getType().equals((Object)DType.UINT32) && dt instanceof LongType;
    }

    private boolean needInt32Downcast(ColumnView cv, DataType dt) {
        return cv.getType().equals((Object)DType.INT32) && ((SeqLike)new .colon.colon((Object)ByteType$.MODULE$, (List)new .colon.colon((Object)ShortType$.MODULE$, (List)new .colon.colon((Object)DateType$.MODULE$, (List)Nil$.MODULE$)))).contains((Object)dt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ColumnView evolveSchemaCasts(ColumnView cv, DataType dt) {
        ColumnVector columnVector;
        if (this.needDecimalCast(cv, dt)) {
            columnVector = cv.castTo(DecimalUtil$.MODULE$.createCudfDecimal((DecimalType)dt));
            return columnVector;
        } else if (this.needUnsignedToSignedCast(cv, dt)) {
            columnVector = cv.castTo(DType.create((DType.DTypeEnum)GpuColumnVector.getNonNestedRapidsType(dt).getTypeId()));
            return columnVector;
        } else if (this.needInt32Downcast(cv, dt)) {
            columnVector = cv.castTo(DType.create((DType.DTypeEnum)GpuColumnVector.getNonNestedRapidsType(dt).getTypeId()));
            return columnVector;
        } else {
            if (!DType.STRING.equals((Object)cv.getType())) throw new IllegalStateException(new StringBuilder(44).append("Logical error: no valid casts are found ").append(cv.getType()).append(" to ").append(dt).toString());
            DataType dataType = dt;
            BinaryType$ binaryType$ = BinaryType$.MODULE$;
            if (dataType != null ? !dataType.equals(binaryType$) : binaryType$ != null) throw new IllegalStateException(new StringBuilder(44).append("Logical error: no valid casts are found ").append(cv.getType()).append(" to ").append(dt).toString());
            BaseDeviceMemoryBuffer dataBuf = cv.getData();
            columnVector = (ColumnView)this.withResource(new ColumnView(DType.INT8, dataBuf.getLength(), Optional.of(Predef$.MODULE$.long2Long(0L)), dataBuf, null), (Function1 & Serializable & scala.Serializable)data -> (ColumnVector)MODULE$.withResource(new ColumnView(DType.LIST, cv.getRowCount(), Optional.of(Predef$.MODULE$.long2Long(cv.getNullCount())), cv.getValid(), cv.getOffsets(), (ColumnView[])((Object[])new ColumnView[]{data})), (Function1 & Serializable & scala.Serializable)everything -> everything.copyToColumnVector()));
        }
        return columnVector;
    }

    private static final /* synthetic */ Map caseSensitiveParquetFieldMap$lzycompute$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseSensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : (Map)caseSensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return map;
    }

    private static final Map caseSensitiveParquetFieldMap$1(LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseSensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$1.value() : ParquetSchemaUtils$.caseSensitiveParquetFieldMap$lzycompute$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final /* synthetic */ Map caseInsensitiveParquetFieldMap$lzycompute$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = caseInsensitiveParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : (Map)caseInsensitiveParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName().toLowerCase(Locale.ROOT)));
        }
        return map;
    }

    private static final Map caseInsensitiveParquetFieldMap$1(LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return caseInsensitiveParquetFieldMap$lzy$1.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$1.value() : ParquetSchemaUtils$.caseInsensitiveParquetFieldMap$lzycompute$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1);
    }

    public static final /* synthetic */ boolean $anonfun$clipParquetGroupFields$3(Type x$2) {
        return x$2.getId() != null;
    }

    public static final /* synthetic */ int $anonfun$clipParquetGroupFields$4(Type f) {
        return f.getId().intValue();
    }

    private static final /* synthetic */ Map idToParquetFieldMap$lzycompute$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        Map map;
        LazyRef lazyRef = idToParquetFieldMap$lzy$1;
        synchronized (lazyRef) {
            map = idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : (Map)idToParquetFieldMap$lzy$1.initialize((Object)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetRecord$1.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaUtils$.$anonfun$clipParquetGroupFields$3(x$2)))).groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)ParquetSchemaUtils$.$anonfun$clipParquetGroupFields$4(f))));
        }
        return map;
    }

    private static final Map idToParquetFieldMap$1(LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return idToParquetFieldMap$lzy$1.initialized() ? (Map)idToParquetFieldMap$lzy$1.value() : ParquetSchemaUtils$.idToParquetFieldMap$lzycompute$1(idToParquetFieldMap$lzy$1, parquetRecord$1);
    }

    private static final Option matchCaseSensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, LazyRef caseSensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return ParquetSchemaUtils$.caseSensitiveParquetFieldMap$1(caseSensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name()).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.clipParquetType((Type)x$3, f.dataType(), caseSensitive$1, useFieldId$1));
    }

    private static final Option matchCaseInsensitiveField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, LazyRef caseInsensitiveParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        return ParquetSchemaUtils$.caseInsensitiveParquetFieldMap$1(caseInsensitiveParquetFieldMap$lzy$1, parquetRecord$1).get((Object)f.name().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw RapidsErrorUtils$.MODULE$.foundDuplicateFieldInCaseInsensitiveModeError(f.name(), parquetTypesString);
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        });
    }

    private static final Option matchIdField$1(StructField f, boolean caseSensitive$1, boolean useFieldId$1, LazyRef idToParquetFieldMap$lzy$1, GroupType parquetRecord$1) {
        int fieldId = ParquetSchemaClipShims$.MODULE$.getFieldId(f);
        return ParquetSchemaUtils$.idToParquetFieldMap$1(idToParquetFieldMap$lzy$1, parquetRecord$1).get((Object)BoxesRunTime.boxToInteger((int)fieldId)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("\n                   |Found duplicate field(s) \"").append(fieldId).append("\": ").append(parquetTypesString).append("\n                   |in case-insensitive mode\n                 ").toString())).stripMargin().replaceAll("\n", " "));
            }
            return MODULE$.clipParquetType((Type)parquetTypes.head(), f.dataType(), caseSensitive$1, useFieldId$1);
        });
    }

    public static final /* synthetic */ String $anonfun$clipSparkArrayType$1(GroupType parquetList$2) {
        return new StringBuilder(110).append("Invalid Parquet schema. Logical type annotation of annotated Parquet lists must be ListLogicalTypeAnnotation: ").append(parquetList$2.toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$clipSparkArrayType$2(GroupType parquetList$2) {
        return new StringBuilder(90).append("Invalid Parquet schema. LIST-annotated group should only have exactly one repeated field: ").append(parquetList$2).toString();
    }

    private static final /* synthetic */ Map caseSensitiveParquetFieldMap$lzycompute$2(LazyRef caseSensitiveParquetFieldMap$lzy$2, GroupType parquetType$1) {
        Map map;
        LazyRef lazyRef = caseSensitiveParquetFieldMap$lzy$2;
        synchronized (lazyRef) {
            map = caseSensitiveParquetFieldMap$lzy$2.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$2.value() : (Map)caseSensitiveParquetFieldMap$lzy$2.initialize((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetType$1.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getName()), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        }
        return map;
    }

    private static final Map caseSensitiveParquetFieldMap$2(LazyRef caseSensitiveParquetFieldMap$lzy$2, GroupType parquetType$1) {
        return caseSensitiveParquetFieldMap$lzy$2.initialized() ? (Map)caseSensitiveParquetFieldMap$lzy$2.value() : ParquetSchemaUtils$.caseSensitiveParquetFieldMap$lzycompute$2(caseSensitiveParquetFieldMap$lzy$2, parquetType$1);
    }

    private static final /* synthetic */ Map caseInsensitiveParquetFieldMap$lzycompute$2(LazyRef caseInsensitiveParquetFieldMap$lzy$2, GroupType parquetType$1) {
        Map map;
        LazyRef lazyRef = caseInsensitiveParquetFieldMap$lzy$2;
        synchronized (lazyRef) {
            map = caseInsensitiveParquetFieldMap$lzy$2.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$2.value() : (Map)caseInsensitiveParquetFieldMap$lzy$2.initialize((Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetType$1.getFields()).asScala()).groupBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName().toLowerCase(Locale.ROOT)));
        }
        return map;
    }

    private static final Map caseInsensitiveParquetFieldMap$2(LazyRef caseInsensitiveParquetFieldMap$lzy$2, GroupType parquetType$1) {
        return caseInsensitiveParquetFieldMap$lzy$2.initialized() ? (Map)caseInsensitiveParquetFieldMap$lzy$2.value() : ParquetSchemaUtils$.caseInsensitiveParquetFieldMap$lzycompute$2(caseInsensitiveParquetFieldMap$lzy$2, parquetType$1);
    }

    public static final /* synthetic */ boolean $anonfun$clipSparkStructType$3(Type x$7) {
        return x$7.getId() != null;
    }

    public static final /* synthetic */ int $anonfun$clipSparkStructType$4(Type f) {
        return f.getId().intValue();
    }

    private static final /* synthetic */ Map idToParquetFieldMap$lzycompute$2(LazyRef idToParquetFieldMap$lzy$2, GroupType parquetType$1) {
        Map map;
        LazyRef lazyRef = idToParquetFieldMap$lzy$2;
        synchronized (lazyRef) {
            map = idToParquetFieldMap$lzy$2.initialized() ? (Map)idToParquetFieldMap$lzy$2.value() : (Map)idToParquetFieldMap$lzy$2.initialize((Object)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parquetType$1.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ParquetSchemaUtils$.$anonfun$clipSparkStructType$3(x$7)))).groupBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)ParquetSchemaUtils$.$anonfun$clipSparkStructType$4(f))));
        }
        return map;
    }

    private static final Map idToParquetFieldMap$2(LazyRef idToParquetFieldMap$lzy$2, GroupType parquetType$1) {
        return idToParquetFieldMap$lzy$2.initialized() ? (Map)idToParquetFieldMap$lzy$2.value() : ParquetSchemaUtils$.idToParquetFieldMap$lzycompute$2(idToParquetFieldMap$lzy$2, parquetType$1);
    }

    private final StructField updateField$1(StructField oldField, Type p, boolean caseSensitive$2, boolean useFieldId$2) {
        DataType newSparkType;
        DataType x$1 = newSparkType = this.clipSparkType(oldField.dataType(), p, caseSensitive$2, useFieldId$2);
        String x$2 = oldField.copy$default$1();
        boolean x$3 = oldField.copy$default$3();
        Metadata x$4 = oldField.copy$default$4();
        return oldField.copy(x$2, x$1, x$3, x$4);
    }

    private final Option matchCaseSensitiveField$2(StructField f, LazyRef caseSensitiveParquetFieldMap$lzy$2, GroupType parquetType$1, boolean caseSensitive$2, boolean useFieldId$2) {
        return ParquetSchemaUtils$.caseSensitiveParquetFieldMap$2(caseSensitiveParquetFieldMap$lzy$2, parquetType$1).get((Object)f.name()).map((Function1 & Serializable & scala.Serializable)x$8 -> this.updateField$1(f, (Type)x$8, caseSensitive$2, useFieldId$2));
    }

    private final Option matchCaseInsensitiveField$2(StructField f, LazyRef caseInsensitiveParquetFieldMap$lzy$2, GroupType parquetType$1, boolean caseSensitive$2, boolean useFieldId$2) {
        return ParquetSchemaUtils$.caseInsensitiveParquetFieldMap$2(caseInsensitiveParquetFieldMap$lzy$2, parquetType$1).get((Object)f.name().toLowerCase(Locale.ROOT)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw RapidsErrorUtils$.MODULE$.foundDuplicateFieldInCaseInsensitiveModeError(f.name(), parquetTypesString);
            }
            return this.updateField$1(f, (Type)parquetTypes.head(), caseSensitive$2, useFieldId$2);
        });
    }

    private final Option matchIdField$2(StructField f, LazyRef idToParquetFieldMap$lzy$2, GroupType parquetType$1, boolean caseSensitive$2, boolean useFieldId$2) {
        int fieldId = ParquetSchemaClipShims$.MODULE$.getFieldId(f);
        return ParquetSchemaUtils$.idToParquetFieldMap$2(idToParquetFieldMap$lzy$2, parquetType$1).get((Object)BoxesRunTime.boxToInteger((int)fieldId)).map((Function1 & Serializable & scala.Serializable)parquetTypes -> {
            if (parquetTypes.size() > 1) {
                String parquetTypesString = ((TraversableOnce)parquetTypes.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("\n                   |Found duplicate field(s) \"").append(fieldId).append("\": ").append(parquetTypesString).append("\n                   |in case-insensitive mode\n                 ").toString())).stripMargin().replaceAll("\n", " "));
            }
            return this.updateField$1(f, (Type)parquetTypes.head(), caseSensitive$2, useFieldId$2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$evolveSchemaIfNeededAndClose$3(DataType x$12) {
        return x$12 instanceof BinaryType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$existsUnsignedType$1(Type field) {
        if (field.isPrimitive()) {
            OriginalType t;
            OriginalType originalType = t = field.getOriginalType();
            OriginalType originalType2 = OriginalType.UINT_8;
            if (originalType == null) {
                if (originalType2 == null) return true;
            } else if (originalType.equals(originalType2)) return true;
            OriginalType originalType3 = t;
            OriginalType originalType4 = OriginalType.UINT_16;
            if (originalType3 == null) {
                if (originalType4 == null) return true;
            } else if (originalType3.equals(originalType4)) return true;
            OriginalType originalType5 = t;
            OriginalType originalType6 = OriginalType.UINT_32;
            if (originalType5 == null) {
                if (originalType6 == null) return true;
            } else if (originalType5.equals(originalType6)) return true;
            OriginalType originalType7 = t;
            OriginalType originalType8 = OriginalType.UINT_64;
            if (originalType7 != null) {
                if (!originalType7.equals(originalType8)) return false;
                return true;
            }
            if (originalType8 == null) return true;
            return false;
        }
        boolean bl = MODULE$.existsUnsignedType(field.asGroupType());
        return bl;
    }

    private ParquetSchemaUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
        this.SPARK_PARQUET_SCHEMA_NAME = "spark_schema";
        this.EMPTY_MESSAGE = Types.buildMessage().named(this.SPARK_PARQUET_SCHEMA_NAME());
    }
}

