/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuParquetFileFilterHandler$;
import com.nvidia.spark.rapids.GpuParquetPartitionReaderFactoryBase$;
import com.nvidia.spark.rapids.GpuParquetUtils$;
import com.nvidia.spark.rapids.HMBInputFile;
import com.nvidia.spark.rapids.HostMemoryOutputStream;
import com.nvidia.spark.rapids.ParquetFileInfoWithBlockMeta;
import com.nvidia.spark.rapids.ParquetSchemaUtils$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.RapidsConf$ParquetFooterReaderType$;
import com.nvidia.spark.rapids.jni.ParquetFooter;
import com.nvidia.spark.rapids.shims.GpuParquetCrypto$;
import com.nvidia.spark.rapids.shims.GpuTypeShims$;
import com.nvidia.spark.rapids.shims.ParquetSchemaClipShims$;
import com.nvidia.spark.rapids.shims.ParquetStringPredShims$;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.SchemaColumnConvertNotSupportedException;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\"E\t6C\u0001B\u0018\u0001\u0003\u0016\u0004%\ta\u0018\u0005\t[\u0002\u0011\t\u0012)A\u0005A\")!\u000f\u0001C\u0001g\"9a\u000f\u0001b\u0001\n\u00139\bBB>\u0001A\u0003%\u0001\u0010C\u0004}\u0001\t\u0007I\u0011B<\t\ru\u0004\u0001\u0015!\u0003y\u0011\u001dq\bA1A\u0005\n]Daa \u0001!\u0002\u0013A\b\u0002CA\u0001\u0001\t\u0007I\u0011B<\t\u000f\u0005\r\u0001\u0001)A\u0005q\"A\u0011Q\u0001\u0001C\u0002\u0013%q\u000fC\u0004\u0002\b\u0001\u0001\u000b\u0011\u0002=\t\u0011\u0005%\u0001A1A\u0005\n]Dq!a\u0003\u0001A\u0003%\u0001\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011q\u0003\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u00111\u0007\u0001!\u0002\u0013\ti\u0002\u0003\u0005\u00026\u0001\u0011\r\u0011\"\u0003x\u0011\u001d\t9\u0004\u0001Q\u0001\naD\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u0007\t\u0011\u0005m\u0002\u0001)A\u0005\u0003;A\u0001\"!\u0010\u0001\u0005\u0004%Ia\u001e\u0005\b\u0003\u007f\u0001\u0001\u0015!\u0003y\u0011!\t\t\u0005\u0001b\u0001\n\u00139\bbBA\"\u0001\u0001\u0006I\u0001\u001f\u0005\t\u0003\u000b\u0002!\u0019!C\u0005o\"9\u0011q\t\u0001!\u0002\u0013A\b\"CA%\u0001\t\u0007I\u0011BA&\u0011!\t9\u0007\u0001Q\u0001\n\u00055\u0003\"CA5\u0001\t\u0007I\u0011BA6\u0011!\tI\b\u0001Q\u0001\n\u00055\u0004bBA>\u0001\u0011\u0005\u0011Q\u0010\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a3\u0001\t\u0003\ti\rC\u0004\u0003\u0010\u0001!\tA!\u0005\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!9!Q\u000f\u0001\u0005\n\t]\u0004\"\u0003BT\u0001E\u0005I\u0011\u0002BU\u0011%\u0011y\fAI\u0001\n\u0013\u0011\t\rC\u0004\u0003F\u0002!IAa2\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"9!1\u001e\u0001\u0005\n\t5\bb\u0002By\u0001\u0011%!1\u001f\u0005\b\u0005s\u0004A\u0011\u0002B~\u0011\u001d\u0019\t\u0001\u0001C\u0005\u0007\u0007Aqa!\u0003\u0001\t\u0013\u0019Y\u0001C\u0005\u0004\u0018\u0001\t\t\u0011\"\u0001\u0004\u001a!I1Q\u0004\u0001\u0012\u0002\u0013\u00051q\u0004\u0005\n\u0007G\u0001\u0011\u0011!C!\u0007KA\u0011ba\n\u0001\u0003\u0003%\t!a\u0004\t\u0013\r%\u0002!!A\u0005\u0002\r-\u0002\"CB\u001c\u0001\u0005\u0005I\u0011IB\u001d\u0011%\u0019\t\u0005AA\u0001\n\u0003\u0019\u0019\u0005C\u0005\u0004H\u0001\t\t\u0011\"\u0011\u0004J!I11\n\u0001\u0002\u0002\u0013\u00053Q\n\u0005\n\u0007\u001f\u0002\u0011\u0011!C!\u0007#:\u0011b!\u0016E\u0003\u0003EIaa\u0016\u0007\u0011\r#\u0015\u0011!E\u0005\u00073BaA]\u001f\u0005\u0002\r\u001d\u0004\"CB&{\u0005\u0005IQIB'\u0011%\u0019I'PA\u0001\n\u0003\u001bY\u0007C\u0005\u0004pu\n\t\u0011\"!\u0004r!I1\u0011P\u001f\u0002\u0002\u0013%11\u0010\u0002\u001c\u000fB,\b+\u0019:rk\u0016$h)\u001b7f\r&dG/\u001a:IC:$G.\u001a:\u000b\u0005\u00153\u0015A\u0002:ba&$7O\u0003\u0002H\u0011\u0006)1\u000f]1sW*\u0011\u0011JS\u0001\u0007]ZLG-[1\u000b\u0003-\u000b1aY8n\u0007\u0001\u0019R\u0001\u0001(U1n\u0003\"a\u0014*\u000e\u0003AS\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u0013a!\u00118z%\u00164\u0007CA+W\u001b\u0005!\u0015BA,E\u0005\r\t%/\u001c\t\u0003\u001ffK!A\u0017)\u0003\u000fA\u0013x\u000eZ;diB\u0011q\nX\u0005\u0003;B\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fqa]9m\u0007>tg-F\u0001a!\t\t7.D\u0001c\u0015\t\u0019G-\u0001\u0005j]R,'O\\1m\u0015\t)g-A\u0002tc2T!aR4\u000b\u0005!L\u0017AB1qC\u000eDWMC\u0001k\u0003\ry'oZ\u0005\u0003Y\n\u0014qaU)M\u0007>tg-\u0001\u0005tc2\u001cuN\u001c4!Q\t\u0011q\u000e\u0005\u0002Pa&\u0011\u0011\u000f\u0015\u0002\niJ\fgn]5f]R\fa\u0001P5oSRtDC\u0001;v!\t)\u0006\u0001C\u0003_\u0007\u0001\u0007\u0001-A\bjg\u000e\u000b7/Z*f]NLG/\u001b<f+\u0005A\bCA(z\u0013\tQ\bKA\u0004C_>dW-\u00198\u0002!%\u001c8)Y:f'\u0016t7/\u001b;jm\u0016\u0004\u0013aG3oC\ndW\rU1scV,GOR5mi\u0016\u0014\b+^:i\t><h.\u0001\u000ff]\u0006\u0014G.\u001a)beF,X\r\u001e$jYR,'\u000fU;tQ\u0012{wO\u001c\u0011\u0002\u0019A,8\u000f\u001b#po:$\u0015\r^3\u0002\u001bA,8\u000f\u001b#po:$\u0015\r^3!\u0003E\u0001Xo\u001d5E_^tG+[7fgR\fW\u000e]\u0001\u0013aV\u001c\b\u000eR8x]RKW.Z:uC6\u0004\b%A\bqkNDGi\\<o\t\u0016\u001c\u0017.\\1m\u0003A\u0001Xo\u001d5E_^tG)Z2j[\u0006d\u0007%A\fqkNDGi\\<o'R\u0014\u0018N\\4Qe\u0016$\u0017nY1uK\u0006A\u0002/^:i\t><hn\u0015;sS:<\u0007K]3eS\u000e\fG/\u001a\u0011\u00023A,8\u000f\u001b#po:LeNR5mi\u0016\u0014H\u000b\u001b:fg\"|G\u000eZ\u000b\u0003\u0003#\u00012aTA\n\u0013\r\t)\u0002\u0015\u0002\u0004\u0013:$\u0018A\u00079vg\"$un\u001e8J]\u001aKG\u000e^3s)\"\u0014Xm\u001d5pY\u0012\u0004\u0013A\u0003:fE\u0006\u001cX-T8eKV\u0011\u0011Q\u0004\t\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005%\u0002cAA\u0012!6\u0011\u0011Q\u0005\u0006\u0004\u0003Oa\u0015A\u0002\u001fs_>$h(C\u0002\u0002,A\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u0016!\u0006Y!/\u001a2bg\u0016lu\u000eZ3!\u0003EI7oQ8se\u0016\u001cG/\u001a3SK\n\f7/Z\u0001\u0013SN\u001cuN\u001d:fGR,GMU3cCN,\u0007%A\bj]RLdGU3cCN,Wj\u001c3f\u0003AIg\u000e^\u001d7%\u0016\u0014\u0017m]3N_\u0012,\u0007%\u0001\fjg&sG/\u000f\u001cD_J\u0014Xm\u0019;fIJ+'-Y:f\u0003]I7/\u00138usY\u001auN\u001d:fGR,GMU3cCN,\u0007%\u0001\bsK\u0006$Wk]3GS\u0016dG-\u00133\u0002\u001fI,\u0017\rZ+tK\u001aKW\r\u001c3JI\u0002\n1$[4o_J,W*[:tS:<\u0007+\u0019:rk\u0016$h)[3mI&#\u0017\u0001H5h]>\u0014X-T5tg&tw\rU1scV,GOR5fY\u0012LE\rI\u0001\u0019!\u0006\u0013\u0016+V#U?\u0016s5IU-Q)&{ejX\"P\u001d\u001a\u001bVCAA'!\u0019\ty%!\u0016\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0002\u0016AC2pY2,7\r^5p]&!\u0011qKA)\u0005\r\u0019V-\u001d\t\u0005\u00037\n)'\u0004\u0002\u0002^)!\u0011qLA1\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\r\u0014\u0001\u00026bm\u0006LA!a\f\u0002^\u0005I\u0002+\u0011*R+\u0016#v,\u0012(D%f\u0003F+S(O?\u000e{eJR*!\u0003]\u0001\u0016IU)V\u000bR{V*Q$J\u0007~+ej\u0011*Z!R+E)\u0006\u0002\u0002nA)q*a\u001c\u0002t%\u0019\u0011\u0011\u000f)\u0003\u000b\u0005\u0013(/Y=\u0011\u0007=\u000b)(C\u0002\u0002xA\u0013AAQ=uK\u0006A\u0002+\u0011*R+\u0016#v,T!H\u0013\u000e{VIT\"S3B#V\t\u0012\u0011\u0002)%\u001c\b+\u0019:rk\u0016$H+[7f\u0013:Le\u000e^\u001d7)\rA\u0018q\u0010\u0005\b\u0003\u0003\u0013\u0003\u0019AAB\u0003-\u0001\u0018M]9vKR$\u0016\u0010]3\u0011\t\u0005\u0015\u0015qR\u0007\u0003\u0003\u000fSA!!#\u0002\f\u000611o\u00195f[\u0006T1!!$h\u0003\u001d\u0001\u0018M]9vKRLA!!%\u0002\b\n!A+\u001f9f\u0003Y\u0019wN\u001c<feR$v\u000eU1scV,GOT1uSZ,G\u0003BAL\u0003W\u0003B!!'\u0002&:!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u0012\u000b1A\u001b8j\u0013\u0011\t\u0019+!(\u0002\u001bA\u000b'/];fi\u001a{w\u000e^3s\u0013\u0011\t9+!+\u0003\u001bM\u001b\u0007.Z7b\u000b2,W.\u001a8u\u0015\u0011\t\u0019+!(\t\u000f\u0005%5\u00051\u0001\u0002.B!\u0011qVA[\u001b\t\t\tLC\u0002\u00024\u0012\fQ\u0001^=qKNLA!a.\u00022\nAA)\u0019;b)f\u0004X-A\u000bd_:4XM\u001d;U_\u001a{w\u000e^3s'\u000eDW-\\1\u0015\t\u0005u\u00161\u0019\t\u0005\u00033\u000by,\u0003\u0003\u0002B\u0006%&!D*ueV\u001cG/\u00127f[\u0016tG\u000fC\u0004\u0002\n\u0012\u0002\r!!2\u0011\t\u0005=\u0016qY\u0005\u0005\u0003\u0013\f\tL\u0001\u0006TiJ,8\r\u001e+za\u0016\f1C]3bI\u0006sGMR5mi\u0016\u0014hi\\8uKJ$\"\"a4\u0002V\u0006%\u00181`A\u0000!\u0011\tY*!5\n\t\u0005M\u0017Q\u0014\u0002\u000e!\u0006\u0014\u0018/^3u\r>|G/\u001a:\t\u000f\u0005]W\u00051\u0001\u0002Z\u0006!a-\u001b7f!\u0011\tY.!:\u000e\u0005\u0005u'\u0002BAp\u0003C\f1\u0002Z1uCN|WO]2fg*\u0019\u00111\u001d3\u0002\u0013\u0015DXmY;uS>t\u0017\u0002BAt\u0003;\u0014q\u0002U1si&$\u0018n\u001c8fI\u001aKG.\u001a\u0005\b\u0003W,\u0003\u0019AAw\u0003\u0011\u0019wN\u001c4\u0011\t\u0005=\u0018q_\u0007\u0003\u0003cTA!a;\u0002t*\u0019\u0011Q_4\u0002\r!\fGm\\8q\u0013\u0011\tI0!=\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\ti0\na\u0001\u0003\u000b\faB]3bI\u0012\u000bG/Y*dQ\u0016l\u0017\rC\u0004\u0003\u0002\u0015\u0002\rAa\u0001\u0002\u0011\u0019LG.\u001a)bi\"\u0004BA!\u0002\u0003\f5\u0011!q\u0001\u0006\u0005\u0005\u0013\t\u00190\u0001\u0002gg&!!Q\u0002B\u0004\u0005\u0011\u0001\u0016\r\u001e5\u00023I,\u0017\rZ!oINKW\u000e\u001d7f\r&dG/\u001a:G_>$XM\u001d\u000b\t\u0005'\u0011\tCa\t\u0003&A!!Q\u0003B\u000f\u001b\t\u00119B\u0003\u0003\u0003\u001a\tm\u0011\u0001C7fi\u0006$\u0017\r^1\u000b\t\u0005U\u00181R\u0005\u0005\u0005?\u00119BA\bQCJ\fX/\u001a;NKR\fG-\u0019;b\u0011\u001d\t9N\na\u0001\u00033Dq!a;'\u0001\u0004\ti\u000fC\u0004\u0003\u0002\u0019\u0002\rAa\u0001\u0002\u0019\u0019LG\u000e^3s\u00052|7m[:\u0015\u0019\t-\"\u0011\u0007B/\u0005?\u0012\tGa\u001d\u0011\u0007U\u0013i#C\u0002\u00030\u0011\u0013A\u0004U1scV,GOR5mK&sgm\\,ji\"\u0014En\\2l\u001b\u0016$\u0018\rC\u0004\u00034\u001d\u0002\rA!\u000e\u0002\u0019\u0019|w\u000e^3s%\u0016\fG-\u001a:\u0011\t\t]\"Q\u000b\b\u0005\u0005s\u0011yE\u0004\u0003\u0003<\t-c\u0002\u0002B\u001f\u0005\u0013rAAa\u0010\u0003H9!!\u0011\tB#\u001d\u0011\t\u0019Ca\u0011\n\u0003-K!!\u0013&\n\u0005\u001dC\u0015BA#G\u0013\r\u0011i\u0005R\u0001\u000b%\u0006\u0004\u0018\u000eZ:D_:4\u0017\u0002\u0002B)\u0005'\nq\u0003U1scV,GOR8pi\u0016\u0014(+Z1eKJ$\u0016\u0010]3\u000b\u0007\t5C)\u0003\u0003\u0003X\te#!\u0002,bYV,\u0017b\u0001B.!\nYQI\\;nKJ\fG/[8o\u0011\u001d\t9n\na\u0001\u00033Dq!a;(\u0001\u0004\ti\u000fC\u0004\u0003d\u001d\u0002\rA!\u001a\u0002\u000f\u0019LG\u000e^3sgB)q*a\u001c\u0003hA!!\u0011\u000eB8\u001b\t\u0011YGC\u0002\u0003n\u0011\fqa]8ve\u000e,7/\u0003\u0003\u0003r\t-$A\u0002$jYR,'\u000fC\u0004\u0002~\u001e\u0002\r!!2\u0002#\rDWmY6TG\",W.Y\"p[B\fG\u000f\u0006\t\u0003z\t}$1\u0011BD\u0005#\u0013\u0019Ja&\u0003\"B\u0019qJa\u001f\n\u0007\tu\u0004K\u0001\u0003V]&$\bb\u0002BAQ\u0001\u0007\u00111Q\u0001\tM&dW\rV=qK\"9!Q\u0011\u0015A\u0002\u00055\u0016\u0001\u0003:fC\u0012$\u0016\u0010]3\t\u000f\t%\u0005\u00061\u0001\u0003\f\u0006iQM\u001d:pe\u000e\u000bG\u000e\u001c2bG.\u0004\u0012b\u0014BG\u0003\u0007\u000biK!\u001f\n\u0007\t=\u0005KA\u0005Gk:\u001cG/[8oe!)a\u000f\u000ba\u0001q\"1!Q\u0013\u0015A\u0002a\f!\"^:f\r&,G\u000eZ%e\u0011%\u0011I\n\u000bI\u0001\u0002\u0004\u0011Y*\u0001\u0007s_>$h)\u001b7f)f\u0004X\rE\u0003P\u0005;\u000b\u0019)C\u0002\u0003 B\u0013aa\u00149uS>t\u0007\"\u0003BRQA\u0005\t\u0019\u0001BS\u00031\u0011xn\u001c;SK\u0006$G+\u001f9f!\u0015y%QTAW\u0003m\u0019\u0007.Z2l'\u000eDW-\\1D_6\u0004\u0018\r\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\u0016\u0016\u0005\u00057\u0013ik\u000b\u0002\u00030B!!\u0011\u0017B^\u001b\t\u0011\u0019L\u0003\u0003\u00036\n]\u0016!C;oG\",7m[3e\u0015\r\u0011I\fU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B_\u0005g\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m\u0019\u0007.Z2l'\u000eDW-\\1D_6\u0004\u0018\r\u001e\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\u0019\u0016\u0005\u0005K\u0013i+\u0001\u000bdQ\u0016\u001c7\u000e\u0015:j[&$\u0018N^3D_6\u0004\u0018\r\u001e\u000b\t\u0005s\u0012IMa5\u0003X\"9!1Z\u0016A\u0002\t5\u0017A\u00019u!\u0011\t)Ia4\n\t\tE\u0017q\u0011\u0002\u000e!JLW.\u001b;jm\u0016$\u0016\u0010]3\t\u000f\tU7\u00061\u0001\u0002.\u0006\u0011A\r\u001e\u0005\b\u0005\u0013[\u0003\u0019\u0001Bm!\u0015y%1\u001cB=\u0013\r\u0011i\u000e\u0015\u0002\n\rVt7\r^5p]B\n!\u0004\u001e5s_^$\u0016\u0010]3J]\u000e|W\u000e]1uS\ndW-\u0012:s_J$\u0002B!\u001f\u0003d\n\u0015(\u0011\u001e\u0005\b\u0003\u0003c\u0003\u0019AAB\u0011\u001d\u00119\u000f\fa\u0001\u0003[\u000b\u0011b\u001d9be.$\u0016\u0010]3\t\u000f\t\u0005A\u00061\u0001\u0002\u001e\u0005i\u0011n\u001d'p]\u001e$UmY5nC2$2\u0001\u001fBx\u0011\u001d\u0011).\fa\u0001\u0003[\u000b1cY1o%\u0016\fG-Q:J]R$UmY5nC2$R\u0001\u001fB{\u0005oDqAa3/\u0001\u0004\u0011i\rC\u0004\u0003V:\u0002\r!!,\u0002)\r\fgNU3bI\u0006\u001bHj\u001c8h\t\u0016\u001c\u0017.\\1m)\u0015A(Q B\u0000\u0011\u001d\u0011Ym\fa\u0001\u0005\u001bDqA!60\u0001\u0004\ti+\u0001\fdC:\u0014V-\u00193Bg\nKg.\u0019:z\t\u0016\u001c\u0017.\\1m)\u0015A8QAB\u0004\u0011\u001d\u0011Y\r\ra\u0001\u0005\u001bDqA!61\u0001\u0004\ti+\u0001\u000bjg\u0012+7-[7bYRK\b/Z'bi\u000eDW\r\u001a\u000b\u0006q\u000e51Q\u0003\u0005\b\u00053\t\u0004\u0019AB\b!\u0011\t)i!\u0005\n\t\rM\u0011q\u0011\u0002\u0010\t\u0016\u001c\u0017.\\1m\u001b\u0016$\u0018\rZ1uC\"9!q]\u0019A\u0002\u00055\u0016\u0001B2paf$2\u0001^B\u000e\u0011\u001dq&\u0007%AA\u0002\u0001\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004\")\u001a\u0001M!,\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\r521\u0007\t\u0004\u001f\u000e=\u0012bAB\u0019!\n\u0019\u0011I\\=\t\u0013\rUb'!AA\u0002\u0005E\u0011a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004<A1\u0011qJB\u001f\u0007[IAaa\u0010\u0002R\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rA8Q\t\u0005\n\u0007kA\u0014\u0011!a\u0001\u0007[\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003#\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00033\na!Z9vC2\u001cHc\u0001=\u0004T!I1QG\u001e\u0002\u0002\u0003\u00071QF\u0001\u001c\u000fB,\b+\u0019:rk\u0016$h)\u001b7f\r&dG/\u001a:IC:$G.\u001a:\u0011\u0005Uk4\u0003B\u001f\u0004\\m\u0003ba!\u0018\u0004d\u0001$XBAB0\u0015\r\u0019\t\u0007U\u0001\beVtG/[7f\u0013\u0011\u0019)ga\u0018\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0004X\u0005)\u0011\r\u001d9msR\u0019Ao!\u001c\t\u000by\u0003\u0005\u0019\u00011\u0002\u000fUt\u0017\r\u001d9msR!11OB;!\u0011y%Q\u00141\t\u0011\r]\u0014)!AA\u0002Q\f1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\ru\u0004\u0003BA.\u0007\u007fJAa!!\u0002^\t1qJ\u00196fGR\u0004")
public class GpuParquetFileFilterHandler
implements Arm,
Product,
scala.Serializable {
    private final transient SQLConf sqlConf;
    private final boolean isCaseSensitive;
    private final boolean enableParquetFilterPushDown;
    private final boolean pushDownDate;
    private final boolean pushDownTimestamp;
    private final boolean pushDownDecimal;
    private final boolean pushDownStringPredicate;
    private final int pushDownInFilterThreshold;
    private final String rebaseMode;
    private final boolean isCorrectedRebase;
    private final String int96RebaseMode;
    private final boolean isInt96CorrectedRebase;
    private final boolean readUseFieldId;
    private final boolean ignoreMissingParquetFieldId;
    private final Seq<String> PARQUET_ENCRYPTION_CONFS;
    private final byte[] PARQUET_MAGIC_ENCRYPTED;

    public static Option<SQLConf> unapply(GpuParquetFileFilterHandler gpuParquetFileFilterHandler) {
        return GpuParquetFileFilterHandler$.MODULE$.unapply(gpuParquetFileFilterHandler);
    }

    public static GpuParquetFileFilterHandler apply(SQLConf sQLConf) {
        return GpuParquetFileFilterHandler$.MODULE$.apply(sQLConf);
    }

    public static <A> Function1<SQLConf, A> andThen(Function1<GpuParquetFileFilterHandler, A> function1) {
        return GpuParquetFileFilterHandler$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, GpuParquetFileFilterHandler> compose(Function1<A, SQLConf> function1) {
        return GpuParquetFileFilterHandler$.MODULE$.compose(function1);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public SQLConf sqlConf() {
        return this.sqlConf;
    }

    private boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    private boolean enableParquetFilterPushDown() {
        return this.enableParquetFilterPushDown;
    }

    private boolean pushDownDate() {
        return this.pushDownDate;
    }

    private boolean pushDownTimestamp() {
        return this.pushDownTimestamp;
    }

    private boolean pushDownDecimal() {
        return this.pushDownDecimal;
    }

    private boolean pushDownStringPredicate() {
        return this.pushDownStringPredicate;
    }

    private int pushDownInFilterThreshold() {
        return this.pushDownInFilterThreshold;
    }

    private String rebaseMode() {
        return this.rebaseMode;
    }

    private boolean isCorrectedRebase() {
        return this.isCorrectedRebase;
    }

    public String int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private boolean isInt96CorrectedRebase() {
        return this.isInt96CorrectedRebase;
    }

    private boolean readUseFieldId() {
        return this.readUseFieldId;
    }

    private boolean ignoreMissingParquetFieldId() {
        return this.ignoreMissingParquetFieldId;
    }

    private Seq<String> PARQUET_ENCRYPTION_CONFS() {
        return this.PARQUET_ENCRYPTION_CONFS;
    }

    private byte[] PARQUET_MAGIC_ENCRYPTED() {
        return this.PARQUET_MAGIC_ENCRYPTED;
    }

    public boolean isParquetTimeInInt96(Type parquetType) {
        boolean bl;
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
            PrimitiveType.PrimitiveTypeName primitiveTypeName2 = PrimitiveType.PrimitiveTypeName.INT96;
            bl = !(primitiveTypeName != null ? !primitiveTypeName.equals(primitiveTypeName2) : primitiveTypeName2 != null);
        } else if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            bl = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(groupType.getFields()).asScala()).exists((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isParquetTimeInInt96(t)));
        } else {
            bl = false;
        }
        return bl;
    }

    private ParquetFooter.SchemaElement convertToParquetNative(DataType schema) {
        ParquetFooter.ValueElement valueElement;
        DataType dataType = schema;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            ParquetFooter.StructBuilder schemaBuilder = ParquetFooter.StructElement.builder();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)field -> schemaBuilder.addChild(field.name(), this.convertToParquetNative(field.dataType())));
            valueElement = schemaBuilder.build();
        } else {
            boolean bl = dataType instanceof NumericType ? true : (BinaryType$.MODULE$.equals(dataType) ? true : (BooleanType$.MODULE$.equals(dataType) ? true : (DateType$.MODULE$.equals(dataType) ? true : (TimestampType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType)))));
            if (bl) {
                valueElement = new ParquetFooter.ValueElement();
            } else if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                valueElement = new ParquetFooter.ListElement(this.convertToParquetNative(arrayType.elementType()));
            } else if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                valueElement = new ParquetFooter.MapElement(this.convertToParquetNative(mapType.keyType()), this.convertToParquetNative(mapType.valueType()));
            } else {
                throw new UnsupportedOperationException(new StringBuilder(23).append("Need some help here ").append(dataType).append("...").toString());
            }
        }
        return valueElement;
    }

    public ParquetFooter.StructElement convertToFooterSchema(StructType schema) {
        return (ParquetFooter.StructElement)this.convertToParquetNative((DataType)schema);
    }

    public ParquetFooter readAndFilterFooter(PartitionedFile file, Configuration conf, StructType readDataSchema, Path filePath) {
        int FOOTER_LENGTH_SIZE;
        ParquetFooter.StructElement footerSchema = this.convertToFooterSchema(readDataSchema);
        FileSystem fs = filePath.getFileSystem(conf);
        FileStatus stat = fs.getFileStatus(filePath);
        long fileLen = stat.getLen();
        if (fileLen < (long)(ParquetFileWriter.MAGIC.length + (FOOTER_LENGTH_SIZE = 4) + ParquetFileWriter.MAGIC.length)) {
            throw new RuntimeException(new StringBuilder(44).append(filePath).append(" is not a Parquet file (too small length: ").append(fileLen).append(" )").toString());
        }
        long footerLengthIndex = fileLen - (long)FOOTER_LENGTH_SIZE - (long)ParquetFileWriter.MAGIC.length;
        HostMemoryBuffer footerBuffer2 = (HostMemoryBuffer)this.withResource(fs.open(filePath), (Function1 & Serializable & scala.Serializable)inputStream -> (HostMemoryBuffer)this.withResource(new NvtxRange("ReadFooterBytes", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$2 -> {
            inputStream.seek(footerLengthIndex);
            int footerLength = BytesUtils.readIntLittleEndian((InputStream)inputStream);
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            inputStream.readFully(magic);
            if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
                if (Arrays.equals(this.PARQUET_MAGIC_ENCRYPTED(), magic)) {
                    throw new RuntimeException(new StringBuilder(141).append("The GPU does not support reading encrypted Parquet files. To read encrypted or columnar encrypted files, disable the GPU Parquet ").append("reader via ").append(RapidsConf$.MODULE$.ENABLE_PARQUET_READ().key()).append(".").toString());
                }
                throw new RuntimeException(new StringBuilder(65).append(filePath).append(" is not a Parquet file. ").append("Expected magic number at tail ").append(Arrays.toString(ParquetFileWriter.MAGIC)).append(" ").append("but found ").append(Arrays.toString(magic)).toString());
            }
            long footerIndex = footerLengthIndex - (long)footerLength;
            if (footerIndex < (long)ParquetFileWriter.MAGIC.length || footerIndex >= footerLengthIndex) {
                throw new RuntimeException(new StringBuilder(57).append("corrupted file: the footer index is not within ").append("the file: ").append(footerIndex).toString());
            }
            inputStream.seek(footerIndex);
            return (HostMemoryBuffer)this.closeOnExcept(HostMemoryBuffer.allocate((long)footerLength, (boolean)false), (Function1 & Serializable & scala.Serializable)outBuffer -> {
                int readLength;
                HostMemoryOutputStream out = new HostMemoryOutputStream((HostMemoryBuffer)outBuffer);
                byte[] tmpBuffer = new byte[4096];
                for (int bytesLeft = footerLength; bytesLeft > 0; bytesLeft -= readLength) {
                    readLength = Math.min(bytesLeft, tmpBuffer.length);
                    inputStream.readFully(tmpBuffer, 0, readLength);
                    out.write(tmpBuffer, 0, readLength);
                }
                return outBuffer;
            });
        }));
        return (ParquetFooter)this.withResource(footerBuffer2, (Function1 & Serializable & scala.Serializable)footerBuffer -> (ParquetFooter)this.withResource(new NvtxRange("Parse and filter footer by range", NvtxColor.RED), (Function1 & Serializable & scala.Serializable)x$3 -> {
            long len = fileLen <= file.length() ? -1L : file.length();
            return ParquetFooter.readAndFilter((HostMemoryBuffer)footerBuffer, (long)file.start(), (long)len, (ParquetFooter.StructElement)footerSchema, (!this.isCaseSensitive() ? 1 : 0) != 0);
        }));
    }

    public ParquetMetadata readAndSimpleFilterFooter(PartitionedFile file, Configuration conf, Path filePath) {
        return (ParquetMetadata)this.withResource(new NvtxRange("readFooter", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$4 -> ParquetFileReader.readFooter((Configuration)conf, (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.range((long)file.start(), (long)(file.start() + file.length()))));
    }

    public ParquetFileInfoWithBlockMeta filterBlocks(Enumeration.Value footerReader, PartitionedFile file, Configuration conf, Filter[] filters, StructType readDataSchema) {
        ParquetFileInfoWithBlockMeta parquetFileInfoWithBlockMeta;
        Object object = new Object();
        try {
            parquetFileInfoWithBlockMeta = (ParquetFileInfoWithBlockMeta)this.withResource(new NvtxRange("filterBlocks", NvtxColor.PURPLE), (Function1 & Serializable & scala.Serializable)x$5 -> {
                None$ none$;
                ParquetMetadata parquetMetadata;
                Path filePath = new Path(new URI(file.filePath()));
                this.PARQUET_ENCRYPTION_CONFS().foreach((Function1 & Serializable & scala.Serializable)encryptConf -> {
                    GpuParquetFileFilterHandler.$anonfun$filterBlocks$2(conf, encryptConf);
                    return BoxedUnit.UNIT;
                });
                try {
                    ParquetMetadata parquetMetadata2;
                    Enumeration.Value value = footerReader;
                    Enumeration.Value value2 = RapidsConf$ParquetFooterReaderType$.MODULE$.NATIVE();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        HostMemoryBuffer serialized2 = (HostMemoryBuffer)this.withResource(this.readAndFilterFooter(file, conf, readDataSchema, filePath), (Function1 & Serializable & scala.Serializable)tableFooter -> {
                            if (tableFooter.getNumColumns() <= 0) {
                                long numRows = tableFooter.getNumRows();
                                BlockMetaData block = new BlockMetaData();
                                block.setRowCount(numRows);
                                MessageType schema = new MessageType("root", new Type[0]);
                                throw new NonLocalReturnControl(object, (Object)new ParquetFileInfoWithBlockMeta(filePath, (Seq<BlockMetaData>)((Seq)new .colon.colon((Object)block, (List)Nil$.MODULE$)), file.partitionValues(), schema, false, false, false));
                            }
                            return tableFooter.serializeThriftFile();
                        });
                        parquetMetadata2 = (ParquetMetadata)this.withResource(serialized2, (Function1 & Serializable & scala.Serializable)serialized -> (ParquetMetadata)this.withResource(new NvtxRange("readFilteredFooter", NvtxColor.YELLOW), (Function1 & Serializable & scala.Serializable)x$6 -> {
                            HMBInputFile inputFile = new HMBInputFile((HostMemoryBuffer)serialized);
                            return ParquetFileReader.readFooter((InputFile)inputFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                        }));
                    } else {
                        parquetMetadata2 = this.readAndSimpleFilterFooter(file, conf, filePath);
                    }
                    parquetMetadata = parquetMetadata2;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (GpuParquetCrypto$.MODULE$.isColumnarCryptoException(throwable2)) {
                        throw new RuntimeException(new StringBuilder(141).append("The GPU does not support reading encrypted Parquet files. To read encrypted or columnar encrypted files, disable the GPU Parquet ").append("reader via ").append(RapidsConf$.MODULE$.ENABLE_PARQUET_READ().key()).append(".").toString(), throwable2);
                    }
                    throw throwable;
                }
                ParquetMetadata footer = parquetMetadata;
                MessageType fileSchema = footer.getFileMetaData().getSchema();
                ParquetSchemaClipShims$.MODULE$.checkIgnoreMissingIds(this.ignoreMissingParquetFieldId(), fileSchema, readDataSchema);
                if (this.enableParquetFilterPushDown()) {
                    Map map = footer.getFileMetaData().getKeyValueMetaData();
                    ParquetFilters parquetFilters = SparkShimImpl$.MODULE$.getParquetFilters(fileSchema, this.pushDownDate(), this.pushDownTimestamp(), this.pushDownDecimal(), this.pushDownStringPredicate(), this.pushDownInFilterThreshold(), this.isCaseSensitive(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), this.rebaseMode());
                    none$ = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filters)).flatMap((Function1 & Serializable & scala.Serializable)predicate -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(predicate)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FilterPredicate.class))))).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ pushedFilters = none$;
                boolean hasInt96Timestamps = this.isParquetTimeInInt96((Type)fileSchema);
                Map map = footer.getFileMetaData().getKeyValueMetaData();
                boolean isCorrectedRebaseForThisFile = GpuParquetPartitionReaderFactoryBase$.MODULE$.isCorrectedRebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), this.isCorrectedRebase());
                Map map2 = footer.getFileMetaData().getKeyValueMetaData();
                boolean isCorrectedInt96RebaseForThisFile = GpuParquetPartitionReaderFactoryBase$.MODULE$.isCorrectedInt96RebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), this.isInt96CorrectedRebase());
                java.util.List blocks = pushedFilters.isDefined() ? (java.util.List)this.withResource(new NvtxRange("getBlocksWithFilter", NvtxColor.CYAN), arg_0 -> GpuParquetFileFilterHandler.$anonfun$filterBlocks$11(this, conf, (Option)pushedFilters, footer, filePath, arg_0)) : footer.getBlocks();
                Tuple2 tuple2 = (Tuple2)this.withResource(new NvtxRange("clipSchema", NvtxColor.DARK_GREEN), (Function1 & Serializable & scala.Serializable)x$8 -> {
                    MessageType clippedSchema = ParquetSchemaUtils$.MODULE$.clipParquetSchema(fileSchema, readDataSchema, this.isCaseSensitive(), this.readUseFieldId());
                    this.checkSchemaCompat((Type)clippedSchema, (DataType)readDataSchema, (Function2<Type, DataType, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(t, d) -> {
                        this.throwTypeIncompatibleError(t, d, file.filePath());
                        return BoxedUnit.UNIT;
                    }, this.isCaseSensitive(), this.readUseFieldId(), this.checkSchemaCompat$default$6(), this.checkSchemaCompat$default$7());
                    Seq<BlockMetaData> clipped = GpuParquetUtils$.MODULE$.clipBlocksToSchema(clippedSchema, blocks, this.isCaseSensitive());
                    return new Tuple2(clipped, (Object)clippedSchema);
                });
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Seq clipped = (Seq)tuple2._1();
                MessageType clippedSchema = (MessageType)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)clipped, (Object)clippedSchema);
                Tuple2 tuple23 = tuple22;
                Seq clipped2 = (Seq)tuple23._1();
                MessageType clippedSchema2 = (MessageType)tuple23._2();
                return new ParquetFileInfoWithBlockMeta(filePath, (Seq<BlockMetaData>)clipped2, file.partitionValues(), clippedSchema2, isCorrectedInt96RebaseForThisFile, isCorrectedRebaseForThisFile, hasInt96Timestamps);
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                parquetFileInfoWithBlockMeta = (ParquetFileInfoWithBlockMeta)ex.value();
            }
            throw ex;
        }
        return parquetFileInfoWithBlockMeta;
    }

    private void checkSchemaCompat(Type fileType, DataType readType, Function2<Type, DataType, BoxedUnit> errorCallback, boolean isCaseSensitive, boolean useFieldId, Option<Type> rootFileType, Option<DataType> rootReadType) {
        block3: {
            DataType dataType;
            while (true) {
                if ((dataType = readType) instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    scala.collection.immutable.Map fileFieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fileType.asGroupType().getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)(isCaseSensitive ? f.getName() : f.getName().toLowerCase(Locale.ROOT))), f), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    scala.collection.immutable.Map<Object, Type> fieldIdToFieldMap = ParquetSchemaClipShims$.MODULE$.fieldIdToFieldMap(useFieldId, fileType);
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).foreach((Function1 & Serializable & scala.Serializable)f -> {
                        GpuParquetFileFilterHandler.$anonfun$checkSchemaCompat$2(this, errorCallback, isCaseSensitive, useFieldId, rootFileType, rootReadType, fieldIdToFieldMap, fileFieldMap, f);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    Type fileChild = fileType.asGroupType().getType(0).asGroupType().getType(0);
                    readType = arrayType.elementType();
                    fileType = fileChild;
                    continue;
                }
                if (!(dataType instanceof MapType)) break;
                MapType mapType = (MapType)dataType;
                GroupType parquetMap = fileType.asGroupType().getType(0).asGroupType();
                Type parquetMapKey = parquetMap.getType(0);
                Type parquetMapValue = parquetMap.getType(1);
                this.checkSchemaCompat(parquetMapKey, mapType.keyType(), errorCallback, isCaseSensitive, useFieldId, rootFileType, rootReadType);
                readType = mapType.valueType();
                fileType = parquetMapValue;
            }
            this.checkPrimitiveCompat(fileType.asPrimitiveType(), dataType, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> errorCallback.apply(rootFileType.get(), rootReadType.get()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Option<Type> checkSchemaCompat$default$6() {
        return None$.MODULE$;
    }

    private Option<DataType> checkSchemaCompat$default$7() {
        return None$.MODULE$;
    }

    private void checkPrimitiveCompat(PrimitiveType pt, DataType dt, Function0<BoxedUnit> errorCallback) {
        block27: {
            PrimitiveType.PrimitiveTypeName primitiveTypeName;
            block31: {
                block32: {
                    block28: {
                        block30: {
                            block29: {
                                block24: {
                                    block26: {
                                        block25: {
                                            primitiveTypeName = pt.getPrimitiveTypeName();
                                            if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
                                                DataType dataType = dt;
                                                DataType dataType2 = DataTypes.BooleanType;
                                                if (!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null)) {
                                                    return;
                                                }
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) break block24;
                                            DataType dataType = dt;
                                            DataType dataType3 = DataTypes.IntegerType;
                                            if (!(dataType == null ? dataType3 != null : !dataType.equals(dataType3)) || GpuTypeShims$.MODULE$.isSupportedYearMonthType(dt) || this.canReadAsIntDecimal(pt, dt)) {
                                                return;
                                            }
                                            DataType dataType4 = dt;
                                            DataType dataType5 = DataTypes.LongType;
                                            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                                                OriginalType originalType = pt.getOriginalType();
                                                OriginalType originalType2 = OriginalType.UINT_32;
                                                if (!(originalType != null ? !originalType.equals(originalType2) : originalType2 != null)) {
                                                    return;
                                                }
                                            }
                                            DataType dataType6 = dt;
                                            DataType dataType7 = DataTypes.ByteType;
                                            if (!(dataType6 == null ? dataType7 != null : !dataType6.equals(dataType7))) break block25;
                                            DataType dataType8 = dt;
                                            DataType dataType9 = DataTypes.ShortType;
                                            if (!(dataType8 == null ? dataType9 != null : !dataType8.equals(dataType9))) break block25;
                                            DataType dataType10 = dt;
                                            DataType dataType11 = DataTypes.DateType;
                                            if (dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null) break block26;
                                        }
                                        return;
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block27;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) break block28;
                                DataType dataType = dt;
                                DataType dataType12 = DataTypes.LongType;
                                if (!(dataType == null ? dataType12 != null : !dataType.equals(dataType12)) || GpuTypeShims$.MODULE$.isSupportedDayTimeType(dt) || this.canReadAsLongDecimal(pt, dt)) {
                                    return;
                                }
                                if (this.isLongDecimal(dt)) {
                                    OriginalType originalType = pt.getOriginalType();
                                    OriginalType originalType3 = OriginalType.UINT_64;
                                    if (!(originalType != null ? !originalType.equals(originalType3) : originalType3 != null)) {
                                        return;
                                    }
                                }
                                OriginalType originalType = pt.getOriginalType();
                                OriginalType originalType4 = OriginalType.TIMESTAMP_MICROS;
                                if (!(originalType == null ? originalType4 != null : !originalType.equals(originalType4))) break block29;
                                OriginalType originalType5 = pt.getOriginalType();
                                OriginalType originalType6 = OriginalType.TIMESTAMP_MILLIS;
                                if (originalType5 != null ? !originalType5.equals(originalType6) : originalType6 != null) break block30;
                            }
                            return;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block27;
                    }
                    if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
                        DataType dataType = dt;
                        DataType dataType13 = DataTypes.FloatType;
                        if (!(dataType != null ? !dataType.equals(dataType13) : dataType13 != null)) {
                            return;
                        }
                    }
                    if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
                        DataType dataType = dt;
                        DataType dataType14 = DataTypes.DoubleType;
                        if (!(dataType != null ? !dataType.equals(dataType14) : dataType14 != null)) {
                            return;
                        }
                    }
                    if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
                        DataType dataType = dt;
                        DataType dataType15 = DataTypes.TimestampType;
                        if (!(dataType != null ? !dataType.equals(dataType15) : dataType15 != null)) {
                            return;
                        }
                    }
                    if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) break block31;
                    DataType dataType = dt;
                    DataType dataType16 = DataTypes.StringType;
                    if (!(dataType == null ? dataType16 != null : !dataType.equals(dataType16))) break block32;
                    DataType dataType17 = dt;
                    DataType dataType18 = DataTypes.BinaryType;
                    if ((dataType17 == null ? dataType18 != null : !dataType17.equals(dataType18)) && !this.canReadAsBinaryDecimal(pt, dt)) break block31;
                }
                return;
            }
            if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName) && (this.canReadAsIntDecimal(pt, dt) || this.canReadAsLongDecimal(pt, dt) || this.canReadAsBinaryDecimal(pt, dt))) {
                return;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        errorCallback.apply$mcV$sp();
    }

    private void throwTypeIncompatibleError(Type parquetType, DataType sparkType, String filePath) {
        SchemaColumnConvertNotSupportedException exception = new SchemaColumnConvertNotSupportedException(parquetType.getName(), parquetType.toString(), sparkType.catalogString());
        String message = new StringBuilder(74).append("Parquet column cannot be converted in ").append("file ").append(filePath).append(". Column: ").append(parquetType.getName()).append(", ").append("Expected: ").append(sparkType.catalogString()).append(", Found: ").append(parquetType).toString();
        throw new QueryExecutionException(message, (Throwable)exception);
    }

    private boolean isLongDecimal(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        boolean bl = dataType instanceof DecimalType ? (decimalType = (DecimalType)dataType).precision() == 20 && decimalType.scale() == 0 : false;
        return bl;
    }

    private boolean canReadAsIntDecimal(PrimitiveType pt, DataType dt) {
        return DecimalType$.MODULE$.is32BitDecimalType(dt) && this.isDecimalTypeMatched(pt.getDecimalMetadata(), dt);
    }

    private boolean canReadAsLongDecimal(PrimitiveType pt, DataType dt) {
        return DecimalType$.MODULE$.is64BitDecimalType(dt) && this.isDecimalTypeMatched(pt.getDecimalMetadata(), dt);
    }

    private boolean canReadAsBinaryDecimal(PrimitiveType pt, DataType dt) {
        return DecimalType$.MODULE$.isByteArrayDecimalType(dt) && this.isDecimalTypeMatched(pt.getDecimalMetadata(), dt);
    }

    private boolean isDecimalTypeMatched(DecimalMetadata metadata, DataType sparkType) {
        boolean bl;
        if (metadata == null) {
            bl = false;
        } else {
            DecimalType dt = (DecimalType)sparkType;
            bl = metadata.getPrecision() <= dt.precision() && metadata.getScale() == dt.scale();
        }
        return bl;
    }

    public GpuParquetFileFilterHandler copy(SQLConf sqlConf) {
        return new GpuParquetFileFilterHandler(sqlConf);
    }

    public SQLConf copy$default$1() {
        return this.sqlConf();
    }

    public String productPrefix() {
        return "GpuParquetFileFilterHandler";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.sqlConf();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GpuParquetFileFilterHandler;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GpuParquetFileFilterHandler)) return false;
        boolean bl = true;
        if (!bl) return false;
        GpuParquetFileFilterHandler gpuParquetFileFilterHandler = (GpuParquetFileFilterHandler)x$1;
        SQLConf sQLConf = this.sqlConf();
        SQLConf sQLConf2 = gpuParquetFileFilterHandler.sqlConf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        if (!gpuParquetFileFilterHandler.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$filterBlocks$2(Configuration conf$2, String encryptConf) {
        block0: {
            if (conf$2.get(encryptConf) == null) break block0;
            conf$2.unset(encryptConf);
        }
    }

    public static final /* synthetic */ java.util.List $anonfun$filterBlocks$11(GpuParquetFileFilterHandler $this, Configuration conf$2, Option pushedFilters$1, ParquetMetadata footer$1, Path filePath$3, NvtxRange x$7) {
        ParquetInputFormat.setFilterPredicate((Configuration)conf$2, (FilterPredicate)((FilterPredicate)pushedFilters$1.get()));
        return (java.util.List)$this.withResource(new ParquetFileReader(conf$2, footer$1.getFileMetaData(), filePath$3, footer$1.getBlocks(), Collections.emptyList()), (Function1 & Serializable & scala.Serializable)parquetReader -> parquetReader.getRowGroups());
    }

    private static final Option getParquetType$1(StructField f, boolean useFieldId$1, scala.collection.immutable.Map fieldIdToFieldMap$1, scala.collection.immutable.Map fileFieldMap$1, boolean isCaseSensitive$1) {
        return useFieldId$1 && ParquetSchemaClipShims$.MODULE$.hasFieldId(f) ? fieldIdToFieldMap$1.get((Object)BoxesRunTime.boxToInteger((int)ParquetSchemaClipShims$.MODULE$.getFieldId(f))) : fileFieldMap$1.get((Object)(isCaseSensitive$1 ? f.name() : f.name().toLowerCase(Locale.ROOT)));
    }

    public static final /* synthetic */ void $anonfun$checkSchemaCompat$2(GpuParquetFileFilterHandler $this, Function2 errorCallback$1, boolean isCaseSensitive$1, boolean useFieldId$1, Option rootFileType$1, Option rootReadType$1, scala.collection.immutable.Map fieldIdToFieldMap$1, scala.collection.immutable.Map fileFieldMap$1, StructField f) {
        GpuParquetFileFilterHandler.getParquetType$1(f, useFieldId$1, fieldIdToFieldMap$1, fileFieldMap$1, isCaseSensitive$1).foreach((Function1 & Serializable & scala.Serializable)fieldType -> {
            $this.checkSchemaCompat(fieldType, f.dataType(), (Function2<Type, DataType, BoxedUnit>)errorCallback$1, isCaseSensitive$1, useFieldId$1, (Option<Type>)new Some(rootFileType$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> fieldType)), (Option<DataType>)new Some(rootReadType$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> f$1.dataType())));
            return BoxedUnit.UNIT;
        });
    }

    public GpuParquetFileFilterHandler(SQLConf sqlConf) {
        this.sqlConf = sqlConf;
        Arm.$init$(this);
        Product.$init$((Product)this);
        this.isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        this.enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        this.pushDownDate = sqlConf.parquetFilterPushDownDate();
        this.pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        this.pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        this.pushDownStringPredicate = ParquetStringPredShims$.MODULE$.pushDown(sqlConf);
        this.pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        this.rebaseMode = SparkShimImpl$.MODULE$.parquetRebaseRead(sqlConf);
        this.isCorrectedRebase = "CORRECTED".equals(this.rebaseMode());
        this.int96RebaseMode = SparkShimImpl$.MODULE$.int96ParquetRebaseRead(sqlConf);
        this.isInt96CorrectedRebase = "CORRECTED".equals(this.int96RebaseMode());
        this.readUseFieldId = ParquetSchemaClipShims$.MODULE$.useFieldId(sqlConf);
        this.ignoreMissingParquetFieldId = ParquetSchemaClipShims$.MODULE$.ignoreMissingIds(sqlConf);
        this.PARQUET_ENCRYPTION_CONFS = (Seq)new .colon.colon((Object)"parquet.encryption.kms.client.class", (List)new .colon.colon((Object)"parquet.encryption.kms.client.class", (List)new .colon.colon((Object)"parquet.crypto.factory.class", (List)Nil$.MODULE$)));
        this.PARQUET_MAGIC_ENCRYPTED = "PARE".getBytes(StandardCharsets.US_ASCII);
    }
}

