/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.DeviceMemoryBuffer;
import com.nvidia.spark.rapids.CompressedTable;
import com.nvidia.spark.rapids.GpuColumnVectorBase;
import com.nvidia.spark.rapids.WithTableBuffer;
import com.nvidia.spark.rapids.format.TableMeta;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public final class GpuCompressedColumnVector
extends GpuColumnVectorBase
implements WithTableBuffer {
    private static final String BAD_ACCESS_MSG = "Column is compressed";
    private final DeviceMemoryBuffer buffer;
    private final TableMeta tableMeta;

    public static ColumnarBatch from(CompressedTable compressedTable) {
        return GpuCompressedColumnVector.from(compressedTable.buffer(), compressedTable.meta());
    }

    public static boolean isBatchCompressed(ColumnarBatch batch) {
        return batch.numCols() == 1 && batch.column(0) instanceof GpuCompressedColumnVector;
    }

    public static ColumnarBatch from(DeviceMemoryBuffer compressedBuffer, TableMeta tableMeta) {
        int batchRows;
        long rows = tableMeta.rowCount();
        if (rows != (long)(batchRows = (int)rows)) {
            throw new IllegalStateException("Cannot support a batch larger that MAX INT rows");
        }
        GpuCompressedColumnVector column = new GpuCompressedColumnVector(compressedBuffer, tableMeta);
        return new ColumnarBatch(new ColumnVector[]{column}, batchRows);
    }

    private GpuCompressedColumnVector(DeviceMemoryBuffer buffer, TableMeta tableMeta) {
        super(DataTypes.NullType);
        this.buffer = buffer;
        this.tableMeta = tableMeta;
        this.buffer.incRefCount();
    }

    @Override
    public DeviceMemoryBuffer getTableBuffer() {
        return this.buffer;
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void close() {
        this.buffer.close();
    }

    public boolean hasNull() {
        throw new IllegalStateException(BAD_ACCESS_MSG);
    }

    public int numNulls() {
        throw new IllegalStateException(BAD_ACCESS_MSG);
    }
}

