/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.RapidsBuffer;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;

public final class GatherUtils$
implements Arm {
    public static GatherUtils$ MODULE$;

    static {
        new GatherUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public ColumnarBatch gather(ColumnarBatch cb, ArrayBuffer<Object> rows) {
        ColumnarBatch columnarBatch;
        DataType[] colTypes = GpuColumnVector.extractTypes(cb);
        if (rows.isEmpty()) {
            columnarBatch = GpuColumnVector.emptyBatchFromTypes(colTypes);
        } else if (cb.numCols() == 0) {
            ColumnarBatch c = GpuColumnVector.emptyBatchFromTypes(colTypes);
            c.setNumRows(rows.length());
            columnarBatch = c;
        } else {
            columnarBatch = (ColumnarBatch)this.withResource(ColumnVector.fromInts((int[])((int[])rows.toArray(ClassTag$.MODULE$.Int()))), (Function1 & java.io.Serializable & Serializable)gatherCv -> (ColumnarBatch)MODULE$.withResource(GpuColumnVector.from(cb), (Function1 & java.io.Serializable & Serializable)table -> (ColumnarBatch)MODULE$.withResource(table.gather((ColumnView)gatherCv), (Function1 & java.io.Serializable & Serializable)gatheredTable -> GpuColumnVector.from(gatheredTable, colTypes))));
        }
        return columnarBatch;
    }

    private GatherUtils$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

