/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.ParquetDumper;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.File;
import java.io.Serializable;
import java.util.Random;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class DumpUtils$
implements Logging,
Arm {
    public static DumpUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DumpUtils$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<String> dumpToParquetFile(ColumnarBatch columnarBatch, String filePrefix) {
        Some some;
        if (columnarBatch.numCols() == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("dump to parquet failed, has no column, file prefix is ").append(filePrefix).toString());
            some = None$.MODULE$;
        } else {
            some = new Some((Object)this.dumpToParquetFileImpl(columnarBatch, filePrefix));
        }
        return some;
    }

    public Option<String> dumpToParquetFile(Table table, String filePrefix) {
        Some some;
        if (table.getNumberOfColumns() == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("dump to parquet failed, has no column, file prefix is ").append(filePrefix).toString());
            some = None$.MODULE$;
        } else {
            some = new Some((Object)this.dumpToParquetFileImp(table, filePrefix));
        }
        return some;
    }

    private String dumpToParquetFileImp(Table table, String filePrefix) {
        String path = this.genPath(filePrefix);
        return (String)this.withResource(new ParquetDumper(path, table), (Function1 & Serializable & scala.Serializable)dumper -> {
            dumper.writeTable(table);
            return path;
        });
    }

    private String dumpToParquetFileImpl(ColumnarBatch columnarBatch, String filePrefix) {
        return (String)this.withResource(GpuColumnVector.from(columnarBatch), (Function1 & Serializable & scala.Serializable)table -> MODULE$.dumpToParquetFileImp((Table)table, filePrefix));
    }

    /*
     * WARNING - void declaration
     */
    private String genPath(String filePrefix) {
        void var2_2;
        String path = "";
        Random random = new Random();
        boolean succeeded = false;
        while (!succeeded) {
            path = new StringBuilder(8).append(filePrefix).append(random.nextInt(Integer.MAX_VALUE)).append(".parquet").toString();
            if (new File(path).exists()) continue;
            succeeded = true;
        }
        return var2_2;
    }

    private DumpUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        Arm.$init$(this);
    }
}

