/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.Rmm;
import ai.rapids.cudf.RmmEventHandler;
import com.nvidia.spark.rapids.RapidsDeviceMemoryStore;
import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001D\u0007\u0001-!A1\u0007\u0001B\u0001B\u0003%A\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\"\u0002(\u0001\t\u0003y\u0005\"\u0002+\u0001\t\u0003*\u0006\"B.\u0001\t\u0003b\u0006\"\u00021\u0001\t\u0003b\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00025\u0001\t\u0003J\u0007\"B6\u0001\t\u0013a\u0007\"B8\u0001\t\u0013\u0001(\u0001\u0007#fm&\u001cW-T3n_JLXI^3oi\"\u000bg\u000e\u001a7fe*\u0011abD\u0001\u0007e\u0006\u0004\u0018\u000eZ:\u000b\u0005A\t\u0012!B:qCJ\\'B\u0001\n\u0014\u0003\u0019qg/\u001b3jC*\tA#A\u0002d_6\u001c\u0001a\u0005\u0003\u0001/}A\u0003C\u0001\r\u001e\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u0011a\u0017M\\4\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u00012S\"A\u0011\u000b\u0005\t\u001a\u0013\u0001B2vI\u001aT!A\u0004\u0013\u000b\u0003\u0015\n!!Y5\n\u0005\u001d\n#a\u0004*n[\u00163XM\u001c;IC:$G.\u001a:\u0011\u0005%\nT\"\u0001\u0016\u000b\u0005-b\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Ai#B\u0001\u00180\u0003\u0019\t\u0007/Y2iK*\t\u0001'A\u0002pe\u001eL!A\r\u0016\u0003\u000f1{wmZ5oO\u0006)1\u000f^8sKB\u0011QGN\u0007\u0002\u001b%\u0011q'\u0004\u0002\u0018%\u0006\u0004\u0018\u000eZ:EKZL7-Z'f[>\u0014\u0018p\u0015;pe\u0016\f!b\\8n\tVl\u0007\u000fR5s!\rQThP\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1q\n\u001d;j_:\u0004\"\u0001Q$\u000f\u0005\u0005+\u0005C\u0001\"<\u001b\u0005\u0019%B\u0001#\u0016\u0003\u0019a$o\\8u}%\u0011aiO\u0001\u0007!J,G-\u001a4\n\u0005!K%AB*ue&twM\u0003\u0002Gw\u0005\t\u0012n]$egN\u0003\u0018\u000e\u001c7F]\u0006\u0014G.\u001a3\u0011\u0005ib\u0015BA'<\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002)R%N\u0003\"!\u000e\u0001\t\u000bM\"\u0001\u0019\u0001\u001b\t\u000ba\"\u0001\u0019A\u001d\t\u000b)#\u0001\u0019A&\u0002\u001d=t\u0017\t\u001c7pG\u001a\u000b\u0017\u000e\\;sKR\u00111J\u0016\u0005\u0006/\u0016\u0001\r\u0001W\u0001\nC2dwnY*ju\u0016\u0004\"AO-\n\u0005i[$\u0001\u0002'p]\u001e\f!cZ3u\u00032dwn\u0019+ie\u0016\u001c\bn\u001c7egR\tQ\fE\u0002;=bK!aX\u001e\u0003\u000b\u0005\u0013(/Y=\u0002)\u001d,G\u000fR3bY2|7\r\u00165sKNDw\u000e\u001c3t\u0003Ayg.\u00117m_\u000e$\u0006N]3tQ>dG\r\u0006\u0002dMB\u0011!\bZ\u0005\u0003Kn\u0012A!\u00168ji\")q\r\u0003a\u00011\u0006qAo\u001c;bY\u0006cGn\\2bi\u0016$\u0017AE8o\t\u0016\fG\u000e\\8d)\"\u0014Xm\u001d5pY\u0012$\"a\u00196\t\u000b\u001dL\u0001\u0019\u0001-\u0002\u0011!,\u0017\r\u001d#v[B$\"aY7\t\u000b9T\u0001\u0019A \u0002\u000f\u0011,X\u000e\u001d#je\u0006Yq-\u001a;Ek6\u0004\b+\u0019;i)\ty\u0014\u000fC\u0003o\u0017\u0001\u0007q\b")
public class DeviceMemoryEventHandler
implements RmmEventHandler,
Logging {
    private final RapidsDeviceMemoryStore store;
    private final Option<String> oomDumpDir;
    private final boolean isGdsSpillEnabled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean onAllocFailure(long allocSize) {
        boolean bl;
        block9: {
            try {
                boolean bl2;
                block8: {
                    try (NvtxRange nvtx = new NvtxRange("onAllocFailure", NvtxColor.RED);){
                        long storeSize = this.store.currentSize();
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Device allocation of ").append(allocSize).append(" bytes failed, device store has ").append(storeSize).append(" bytes. Total RMM allocated is ").append(Rmm.getTotalBytesAllocated()).append(" bytes.").toString());
                        if (storeSize == 0L) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Device store exhausted, unable to allocate ").append(allocSize).append(" bytes. ").append("Total RMM allocated is ").append(Rmm.getTotalBytesAllocated()).append(" bytes.").toString());
                            this.oomDumpDir.foreach((Function1 & Serializable & scala.Serializable)dumpDir -> {
                                this.heapDump(dumpDir);
                                return BoxedUnit.UNIT;
                            });
                            bl2 = false;
                            break block8;
                        }
                        long targetSize = Math.max(storeSize - allocSize, 0L);
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Targeting device store size of ").append(targetSize).append(" bytes").toString());
                        long amountSpilled = this.store.synchronousSpill(targetSize);
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Spilled ").append(amountSpilled).append(" bytes from the device store").toString());
                        if (this.isGdsSpillEnabled) {
                            TrampolineUtil$.MODULE$.incTaskMetricsDiskBytesSpilled(amountSpilled);
                        } else {
                            TrampolineUtil$.MODULE$.incTaskMetricsMemoryBytesSpilled(amountSpilled);
                        }
                        bl = true;
                        break block9;
                    }
                }
                return bl2;
            }
            catch (Throwable t) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error handling allocation failure", t);
                bl = false;
            }
        }
        return bl;
    }

    public long[] getAllocThresholds() {
        return null;
    }

    public long[] getDeallocThresholds() {
        return null;
    }

    public void onAllocThreshold(long totalAllocated) {
    }

    public void onDeallocThreshold(long totalAllocated) {
    }

    private void heapDump(String dumpDir) {
        String dumpPath = this.getDumpPath(dumpDir);
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Dumping heap to ").append(dumpPath).toString());
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        mxBean.dumpHeap(dumpPath, false);
    }

    private String getDumpPath(String dumpDir) {
        String pid = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(ManagementFactory.getRuntimeMXBean().getName())).split('@'))).head();
        return new File(dumpDir, new StringBuilder(14).append("gpu-oom-").append(pid).append(".hprof").toString()).toString();
    }

    public DeviceMemoryEventHandler(RapidsDeviceMemoryStore store, Option<String> oomDumpDir, boolean isGdsSpillEnabled) {
        this.store = store;
        this.oomDumpDir = oomDumpDir;
        this.isGdsSpillEnabled = isGdsSpillEnabled;
        Logging.$init$((Logging)this);
    }
}

