/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.HostBufferConsumer;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.Table;
import ai.rapids.cudf.TableWriter;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.ColumnarOutputWriter$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.rapids.ColumnarWriteTaskStatsTracker;
import org.apache.spark.sql.rapids.GpuWriteTaskStatsTracker;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f!B\f\u0019\u0003\u0003\t\u0003\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\u00069\u0002!\t!\u0018\u0005\bE\u0002\u0011\rQ\"\u0001d\u0011\u001d9\u0007A1A\u0005\u0002!DaA\u001c\u0001!\u0002\u0013I\u0007BB8\u0001A\u0003%\u0001\u000f\u0003\u0004w\u0001\u0001\u0006Ia\u001e\u0005\u0007}\u0002\u0001\u000b\u0015B@\t\u0011\u0005\u0015\u0001\u0001)A\u0005\u0003\u000fAq!!\u000b\u0001\t\u0003\nY\u0003C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B!9\u00111\u000f\u0001\u0005\u0012\u0005U\u0004\u0002CAA\u0001\u0001&I!a!\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002>!9\u0011\u0011\u0012\u0001\u0007\u0002\u0005-uaBAG1!\u0005\u0011q\u0012\u0004\u0007/aA\t!!%\t\rq#B\u0011AAM\u0011\u001d\tY\u0004\u0006C\u0001\u00037\u0013AcQ8mk6t\u0017M](viB,Ho\u0016:ji\u0016\u0014(BA\r\u001b\u0003\u0019\u0011\u0018\r]5eg*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\taA\u001c<jI&\f'\"A\u0010\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001\u0011#f\r\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019y%M[3diB\u00111&M\u0007\u0002Y)\u0011QFL\u0001\u0005GV$gM\u0003\u0002\u001a_)\t\u0001'\u0001\u0002bS&\u0011!\u0007\f\u0002\u0013\u0011>\u001cHOQ;gM\u0016\u00148i\u001c8tk6,'\u000f\u0005\u00025k5\t\u0001$\u0003\u000271\t\u0019\u0011I]7\u0002\u000f\r|g\u000e^3yiB\u0011\u0011HQ\u0007\u0002u)\u00111\bP\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!!\u0010 \u0002\r!\fGm\\8q\u0015\ty\u0004)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0003\u0006\u0019qN]4\n\u0005\rS$A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\f!\u0002Z1uCN\u001b\u0007.Z7b!\t1E*D\u0001H\u0015\tA\u0015*A\u0003usB,7O\u0003\u0002K\u0017\u0006\u00191/\u001d7\u000b\u0005mq\u0014BA'H\u0005)\u0019FO];diRK\b/Z\u0001\ne\u0006tw-\u001a(b[\u0016\u0004\"\u0001U-\u000f\u0005E;\u0006C\u0001*V\u001b\u0005\u0019&B\u0001+!\u0003\u0019a$o\\8u})\ta+A\u0003tG\u0006d\u0017-\u0003\u0002Y+\u00061\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tAV+\u0001\u0004=S:LGO\u0010\u000b\u0005=~\u0003\u0017\r\u0005\u00025\u0001!)q\u0007\u0002a\u0001q!)A\t\u0002a\u0001\u000b\")a\n\u0002a\u0001\u001f\u0006YA/\u00192mK^\u0013\u0018\u000e^3s+\u0005!\u0007CA\u0016f\u0013\t1GFA\u0006UC\ndWm\u0016:ji\u0016\u0014\u0018\u0001B2p]\u001a,\u0012!\u001b\t\u0003U2l\u0011a\u001b\u0006\u0003OrJ!!\\6\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\u0015\u0019wN\u001c4!\u00031yW\u000f\u001e9viN#(/Z1n!\t\tH/D\u0001s\u0015\t\u0019H(\u0001\u0002gg&\u0011QO\u001d\u0002\u0013\rN#\u0015\r^1PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0006uK6\u0004()\u001e4gKJ\u00042\u0001_=|\u001b\u0005)\u0016B\u0001>V\u0005\u0015\t%O]1z!\tAH0\u0003\u0002~+\n!!)\u001f;f\u0003=\tg.\u001f;iS:<wK]5ui\u0016t\u0007c\u0001=\u0002\u0002%\u0019\u00111A+\u0003\u000f\t{w\u000e\\3b]\u00069!-\u001e4gKJ\u001c\bCBA\u0005\u0003'\t9\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003\u001diW\u000f^1cY\u0016T1!!\u0005V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003+\tYAA\u0003Rk\u0016,X\rE\u0004y\u00033\ti\"a\t\n\u0007\u0005mQK\u0001\u0004UkBdWM\r\t\u0004W\u0005}\u0011bAA\u0011Y\t\u0001\u0002j\\:u\u001b\u0016lwN]=Ck\u001a4WM\u001d\t\u0004q\u0006\u0015\u0012bAA\u0014+\n!Aj\u001c8h\u00031A\u0017M\u001c3mK\n+hMZ3s)\u0019\ti#a\r\u00028A\u0019\u00010a\f\n\u0007\u0005ERK\u0001\u0003V]&$\bbBA\u001b\u0019\u0001\u0007\u0011QD\u0001\u0007EV4g-\u001a:\t\u000f\u0005eB\u00021\u0001\u0002$\u0005\u0019A.\u001a8\u0002#]\u0014\u0018\u000e^3Ck\u001a4WM]3e\t\u0006$\u0018\r\u0006\u0002\u0002.\u0005)qO]5uKR1\u0011QFA\"\u0003'Bq!!\u0012\u000f\u0001\u0004\t9%A\u0003cCR\u001c\u0007\u000e\u0005\u0003\u0002J\u0005=SBAA&\u0015\r\ti%S\u0001\u000bm\u0016\u001cGo\u001c:ju\u0016$\u0017\u0002BA)\u0003\u0017\u0012QbQ8mk6t\u0017M\u001d\"bi\u000eD\u0007bBA+\u001d\u0001\u0007\u0011qK\u0001\u000egR\fGo\u001d+sC\u000e\\WM]:\u0011\r\u0005e\u00131MA5\u001d\u0011\tY&a\u0018\u000f\u0007I\u000bi&C\u0001W\u0013\r\t\t'V\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)'a\u001a\u0003\u0007M+\u0017OC\u0002\u0002bU\u0003B!a\u001b\u0002p5\u0011\u0011Q\u000e\u0006\u00033%KA!!\u001d\u0002n\ti2i\u001c7v[:\f'o\u0016:ji\u0016$\u0016m]6Ti\u0006$8\u000f\u0016:bG.,'/\u0001\u000btG\u0006tG+\u00192mK\n+gm\u001c:f/JLG/\u001a\u000b\u0005\u0003[\t9\bC\u0004\u0002z=\u0001\r!a\u001f\u0002\u000bQ\f'\r\\3\u0011\u0007-\ni(C\u0002\u0002\u00001\u0012Q\u0001V1cY\u0016\f!b\u001e:ji\u0016\u0014\u0015\r^2i)\u0011\t\u0019#!\"\t\u000f\u0005\u0015\u0003\u00031\u0001\u0002H\u0005)1\r\\8tK\u0006!\u0001/\u0019;i)\u0005y\u0015\u0001F\"pYVlg.\u0019:PkR\u0004X\u000f^,sSR,'\u000f\u0005\u00025)M\u0019A#a%\u0011\u0007a\f)*C\u0002\u0002\u0018V\u0013a!\u00118z%\u00164GCAAH)!\ti#!(\u0002 \u0006\u0005\u0006bBA\u0003-\u0001\u0007\u0011q\u0001\u0005\u0006mZ\u0001\ra\u001e\u0005\u0007_Z\u0001\r!a)\u0011\t\u0005\u0015\u00161V\u0007\u0003\u0003OS1!!+'\u0003\tIw.\u0003\u0003\u0002.\u0006\u001d&\u0001D(viB,Ho\u0015;sK\u0006l\u0007")
public abstract class ColumnarOutputWriter
implements HostBufferConsumer,
Arm {
    private final StructType dataSchema;
    private final String rangeName;
    private final Configuration conf;
    private final FSDataOutputStream outputStream;
    private final byte[] tempBuffer;
    private boolean anythingWritten;
    private final Queue<Tuple2<HostMemoryBuffer, Object>> buffers;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public void done() {
        super.done();
    }

    public abstract TableWriter tableWriter();

    public Configuration conf() {
        return this.conf;
    }

    public void handleBuffer(HostMemoryBuffer buffer, long len) {
        this.buffers.$plus$eq((Object)new Tuple2((Object)buffer, (Object)BoxesRunTime.boxToLong((long)len)));
    }

    public void writeBufferedData() {
        ColumnarOutputWriter$.MODULE$.writeBufferedData(this.buffers, this.tempBuffer, (OutputStream)this.outputStream);
    }

    public void write(ColumnarBatch batch, Seq<ColumnarWriteTaskStatsTracker> statsTrackers) {
        boolean needToCloseBatch = true;
        try {
            long l;
            long writeStartTimestamp = System.nanoTime();
            try (NvtxRange writeRange = new NvtxRange("File write", NvtxColor.YELLOW);){
                needToCloseBatch = false;
                l = this.writeBatch(batch);
            }
            long gpuTime = l;
            long writeTime = System.nanoTime() - writeStartTimestamp - gpuTime;
            statsTrackers.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ColumnarOutputWriter.$anonfun$write$1(writeTime, gpuTime, x0$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            if (needToCloseBatch) {
                batch.close();
            }
        }
    }

    public void scanTableBeforeWrite(Table table) {
    }

    private long writeBatch(ColumnarBatch batch) {
        long l;
        boolean needToCloseBatch = true;
        try {
            long startTimestamp = System.nanoTime();
            this.withResource(new NvtxRange(new StringBuilder(10).append("GPU ").append(this.rangeName).append(" write").toString(), NvtxColor.BLUE), (Function1 & Serializable & scala.Serializable)x$1 -> {
                this.withResource(GpuColumnVector.from(batch), (Function1 & Serializable & scala.Serializable)table -> {
                    ColumnarOutputWriter.$anonfun$writeBatch$2($this, table);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            batch.close();
            needToCloseBatch = false;
            GpuSemaphore$.MODULE$.releaseIfNecessary(TaskContext$.MODULE$.get());
            long gpuTime = System.nanoTime() - startTimestamp;
            this.writeBufferedData();
            l = gpuTime;
        }
        finally {
            if (needToCloseBatch) {
                batch.close();
            }
        }
        return l;
    }

    public void close() {
        Object object = !this.anythingWritten ? BoxesRunTime.boxToLong((long)this.writeBatch(GpuColumnVector.emptyBatch(this.dataSchema))) : BoxedUnit.UNIT;
        this.tableWriter().close();
        this.writeBufferedData();
        this.outputStream.close();
    }

    public abstract String path();

    public static final /* synthetic */ void $anonfun$write$1(long writeTime$1, long gpuTime$1, ColumnarWriteTaskStatsTracker x0$1) {
        ColumnarWriteTaskStatsTracker columnarWriteTaskStatsTracker = x0$1;
        if (columnarWriteTaskStatsTracker instanceof GpuWriteTaskStatsTracker) {
            GpuWriteTaskStatsTracker gpuWriteTaskStatsTracker = (GpuWriteTaskStatsTracker)columnarWriteTaskStatsTracker;
            gpuWriteTaskStatsTracker.addWriteTime(writeTime$1);
            gpuWriteTaskStatsTracker.addGpuTime(gpuTime$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$writeBatch$2(ColumnarOutputWriter $this, Table table) {
        $this.scanTableBeforeWrite(table);
        $this.anythingWritten = true;
        $this.tableWriter().write(table);
    }

    public ColumnarOutputWriter(TaskAttemptContext context, StructType dataSchema, String rangeName) {
        this.dataSchema = dataSchema;
        this.rangeName = rangeName;
        Arm.$init$(this);
        this.conf = context.getConfiguration();
        Path hadoopPath = new Path(this.path());
        FileSystem fs = hadoopPath.getFileSystem(this.conf());
        this.outputStream = fs.create(hadoopPath, false);
        this.tempBuffer = new byte[131072];
        this.anythingWritten = false;
        this.buffers = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

