/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.shims.SparkShimImpl$;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.rapids.execution.TrampolineUtil$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class RebaseHelper$
implements Arm {
    public static RebaseHelper$ MODULE$;

    static {
        new RebaseHelper$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    private boolean isDateRebaseNeeded(ColumnVector column, int startDay) {
        DType dtype;
        DType dType = dtype = column.getType();
        DType dType2 = DType.TIMESTAMP_DAYS;
        return !(dType != null ? !dType.equals(dType2) : dType2 != null) ? BoxesRunTime.unboxToBoolean(this.withResource(Scalar.timestampDaysFromInt((int)startDay), (Function1 & Serializable & scala.Serializable)minGood -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isDateRebaseNeeded$1(column, minGood)))) : false;
    }

    private boolean isTimeRebaseNeeded(ColumnVector column, long startTs) {
        boolean bl;
        DType dtype = column.getType();
        if (dtype.hasTimeResolution()) {
            DType dType = dtype;
            DType dType2 = DType.TIMESTAMP_MICROSECONDS;
            Predef$.MODULE$.require(!(dType != null ? !dType.equals(dType2) : dType2 != null));
            bl = BoxesRunTime.unboxToBoolean(this.withResource(Scalar.timestampFromLong((DType)DType.TIMESTAMP_MICROSECONDS, (long)startTs), (Function1 & Serializable & scala.Serializable)minGood -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isTimeRebaseNeeded$1(column, minGood))));
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isDateRebaseNeededInRead(ColumnVector column) {
        return this.isDateRebaseNeeded(column, RebaseDateTime$.MODULE$.lastSwitchJulianDay());
    }

    public boolean isTimeRebaseNeededInRead(ColumnVector column) {
        return this.isTimeRebaseNeeded(column, RebaseDateTime$.MODULE$.lastSwitchJulianTs());
    }

    public boolean isDateRebaseNeededInWrite(ColumnVector column) {
        return this.isDateRebaseNeeded(column, RebaseDateTime$.MODULE$.lastSwitchGregorianDay());
    }

    public boolean isTimeRebaseNeededInWrite(ColumnVector column) {
        return this.isTimeRebaseNeeded(column, RebaseDateTime$.MODULE$.lastSwitchGregorianTs());
    }

    public Exception newRebaseExceptionInRead(String format) {
        String string;
        String string2 = format;
        String string3 = "Parquet";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = SparkShimImpl$.MODULE$.parquetRebaseReadKey();
        } else {
            String string4 = format;
            String string5 = "Avro";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                string = SparkShimImpl$.MODULE$.avroRebaseReadKey();
            } else {
                throw new IllegalStateException(new StringBuilder(20).append("unrecognized format ").append(format).toString());
            }
        }
        String config = string;
        return TrampolineUtil$.MODULE$.makeSparkUpgradeException("3.0", new StringBuilder(501).append("reading dates before 1582-10-15 or timestamps before ").append("1900-01-01T00:00:00Z from ").append(format).append(" files can be ambiguous, as the files may be written by ").append("Spark 2.x or legacy versions of Hive, which uses a legacy hybrid calendar that is ").append("different from Spark 3.0+'s Proleptic Gregorian calendar. See more details in ").append("SPARK-31404. The RAPIDS Accelerator does not support reading these 'LEGACY' files. To do ").append("so you should disable ").append(format).append(" support in the RAPIDS Accelerator ").append("or set ").append(config).append(" to 'CORRECTED' to read the datetime values as it is.").toString(), null);
    }

    public static final /* synthetic */ boolean $anonfun$isDateRebaseNeeded$3(Scalar a) {
        return a.isValid() && a.getBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isDateRebaseNeeded$2(ColumnVector hasBad) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(hasBad.any(), (Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isDateRebaseNeeded$3(a))));
    }

    public static final /* synthetic */ boolean $anonfun$isDateRebaseNeeded$1(ColumnVector column$1, Scalar minGood) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(column$1.lessThan((BinaryOperable)minGood), (Function1 & Serializable & scala.Serializable)hasBad -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isDateRebaseNeeded$2(hasBad))));
    }

    public static final /* synthetic */ boolean $anonfun$isTimeRebaseNeeded$3(Scalar a) {
        return a.isValid() && a.getBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isTimeRebaseNeeded$2(ColumnVector hasBad) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(hasBad.any(), (Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isTimeRebaseNeeded$3(a))));
    }

    public static final /* synthetic */ boolean $anonfun$isTimeRebaseNeeded$1(ColumnVector column$2, Scalar minGood) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(column$2.lessThan((BinaryOperable)minGood), (Function1 & Serializable & scala.Serializable)hasBad -> BoxesRunTime.boxToBoolean((boolean)RebaseHelper$.$anonfun$isTimeRebaseNeeded$2(hasBad))));
    }

    private RebaseHelper$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

