/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tests.mortgage;

import com.nvidia.spark.rapids.ShimLoader$;
import com.nvidia.spark.rapids.tests.mortgage.AggregatesWithJoin$;
import com.nvidia.spark.rapids.tests.mortgage.AggregatesWithPercentiles$;
import com.nvidia.spark.rapids.tests.mortgage.ReadAcquisitionCsv$;
import com.nvidia.spark.rapids.tests.mortgage.ReadPerformanceCsv$;
import com.nvidia.spark.rapids.tests.mortgage.Run$;
import com.nvidia.spark.rapids.tests.mortgage.SimpleAggregates$;
import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I2A\u0001B\u0003\u0001%!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0001A!Aq\u0005\u0001EC\u0002\u0013\u0005\u0001F\u0001\nN_J$x-Y4f'B\f'o[*vSR,'B\u0001\u0004\b\u0003!iwN\u001d;hC\u001e,'B\u0001\u0005\n\u0003\u0015!Xm\u001d;t\u0015\tQ1\"\u0001\u0004sCBLGm\u001d\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r94\u0018\u000eZ5b\u0015\u0005\u0001\u0012aA2p[\u000e\u00011C\u0001\u0001\u0014!\t!\u0012$D\u0001\u0016\u0015\t1r#A\u0005tG\u0006d\u0017\r^3ti*\t\u0001$A\u0002pe\u001eL!AG\u000b\u0003\u0011\u0019+hnU;ji\u0016\fa\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"A\u0003\u0002)\u0005$\u0017\r\u001d;jm\u0016\fV/\u001a:z\u000b:\f'\r\\3e+\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#a\u0002\"p_2,\u0017M\\\u0001\bg\u0016\u001c8/[8o+\u0005I\u0003C\u0001\u00161\u001b\u0005Y#B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00199R!aL\f\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t4F\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e")
public class MortgageSparkSuite
extends FunSuite {
    private SparkSession session;
    private volatile boolean bitmap$0;

    public boolean adaptiveQueryEnabled() {
        return false;
    }

    private SparkSession session$lzycompute() {
        MortgageSparkSuite mortgageSparkSuite = this;
        synchronized (mortgageSparkSuite) {
            if (!this.bitmap$0) {
                SparkSession.Builder builder = SparkSession$.MODULE$.builder().master("local[2]").appName("MortgageTests").config("spark.sql.adaptive.enabled", this.adaptiveQueryEnabled()).config("spark.sql.join.preferSortMergeJoin", false).config("spark.sql.shuffle.partitions", 2L).config("spark.plugins", "com.nvidia.spark.SQLPlugin").config("spark.rapids.sql.explain", "ALL").config("spark.rapids.sql.test.enabled", false).config("spark.rapids.sql.incompatibleOps.enabled", true).config("spark.rapids.sql.hasNans", false);
                String rapidsShuffle = ShimLoader$.MODULE$.getRapidsShuffleManagerClass();
                String prop = System.getProperty("rapids.shuffle.manager.override", "false");
                if (prop.equalsIgnoreCase("true")) {
                    Predef$.MODULE$.println((Object)"RAPIDS SHUFFLE MANAGER ACTIVE");
                    builder = builder.config("spark.shuffle.manager", rapidsShuffle).config("spark.rapids.shuffle.mode", "CACHE_ONLY");
                } else {
                    Predef$.MODULE$.println((Object)"RAPIDS SHUFFLE MANAGER INACTIVE");
                }
                this.session = builder.getOrCreate();
                this.bitmap$0 = true;
            }
        }
        return this.session;
    }

    public SparkSession session() {
        return !this.bitmap$0 ? this.session$lzycompute() : this.session;
    }

    public MortgageSparkSuite() {
        this.test("extract mortgage data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = Run$.MODULE$.csv(this.session(), "src/test/resources/Performance_2007Q3.txt_0", "src/test/resources/Acquisition_2007Q3.txt").sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("loan_id"), functions$.MODULE$.col("monthly_reporting_period")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 10000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("convert data to parquet", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ReadPerformanceCsv$.MODULE$.apply(this.session(), "src/test/resources/Performance_2007Q3.txt_0").write().mode("overwrite").parquet("target/test_output/perf");
            ReadAcquisitionCsv$.MODULE$.apply(this.session(), "src/test/resources/Acquisition_2007Q3.txt").write().mode("overwrite").parquet("target/test_output/acq");
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("run on parquet data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = Run$.MODULE$.parquet(this.session(), "src/test/resources/parquet_perf", "src/test/resources/parquet_acq").sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("loan_id"), functions$.MODULE$.col("monthly_reporting_period")}));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 10000;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("compute some basic aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = SimpleAggregates$.MODULE$.csv(this.session(), "src/test/resources/Performance_2007Q3.txt_0", "src/test/resources/Acquisition_2007Q3.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 1660;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("compute aggregates with percentiles", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = AggregatesWithPercentiles$.MODULE$.csv(this.session(), "src/test/resources/Performance_2007Q3.txt_0");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 177;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("compute aggregates with joins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Dataset df = AggregatesWithJoin$.MODULE$.csv(this.session(), "src/test/resources/Performance_2007Q3.txt_0", "src/test/resources/Acquisition_2007Q3.txt");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)df.count()));
            int $org_scalatest_assert_macro_right = 177;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
        }, new Position("MortgageSparkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
    }
}

