/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tests.datasourcev2.parquet;

import com.nvidia.spark.rapids.tests.datasourcev2.parquet.ArrowInputPartition;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.util.Text;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ColumnarReaderFactory$
implements PartitionReaderFactory {
    public static ColumnarReaderFactory$ MODULE$;

    static {
        new ColumnarReaderFactory$();
    }

    private final int BATCH_SIZE() {
        return 20;
    }

    public boolean supportColumnarReads(InputPartition partition) {
        return true;
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        throw new UnsupportedOperationException();
    }

    public PartitionReader<ColumnarBatch> createColumnarReader(InputPartition partition) {
        InputPartition inputPartition = partition;
        if (!(inputPartition instanceof ArrowInputPartition)) {
            throw new MatchError((Object)inputPartition);
        }
        ArrowInputPartition arrowInputPartition = (ArrowInputPartition)inputPartition;
        Seq<DataType> dataTypes = arrowInputPartition.dt();
        int numRows = arrowInputPartition.numRows();
        int startNum = arrowInputPartition.startNum();
        Tuple3 tuple3 = new Tuple3(dataTypes, (Object)BoxesRunTime.boxToInteger((int)numRows), (Object)BoxesRunTime.boxToInteger((int)startNum));
        Tuple3 tuple32 = tuple3;
        Seq dataTypes2 = (Seq)tuple32._1();
        int numRows2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int startNum2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        return new PartitionReader<ColumnarBatch>(numRows2, dataTypes2, startNum2){
            private ColumnarBatch batch;
            private int current;
            private final int numRows$1;
            private final Seq dataTypes$1;
            private final int startNum$1;

            public CustomTaskMetric[] currentMetricsValues() {
                return super.currentMetricsValues();
            }

            private ColumnarBatch batch() {
                return this.batch;
            }

            private void batch_$eq(ColumnarBatch x$1) {
                this.batch = x$1;
            }

            private int current() {
                return this.current;
            }

            private void current_$eq(int x$1) {
                this.current = x$1;
            }

            public boolean next() {
                boolean bl;
                int batchSize;
                int n = this.current() < this.numRows$1 ? (this.current() + 20 > this.numRows$1 ? this.numRows$1 - this.current() : 20) : (batchSize = 0);
                if (batchSize == 0) {
                    bl = false;
                } else {
                    IntRef dtypeNum = IntRef.create((int)0);
                    Seq vecs = (Seq)this.dataTypes$1.map((Function1 & Serializable & scala.Serializable)dtype -> {
                        ValueVector vector = ColumnarReaderFactory$.MODULE$.com$nvidia$spark$rapids$tests$datasourcev2$parquet$ColumnarReaderFactory$$setupArrowVector(new StringBuilder(1).append("v").append(this.current()).append(dtypeNum$1.elem).toString(), (DataType)dtype);
                        int startVal = this.current() + $this.startNum$1 * (dtypeNum$1.elem + 2);
                        ColumnarReaderFactory$.MODULE$.com$nvidia$spark$rapids$tests$datasourcev2$parquet$ColumnarReaderFactory$$fillArrowVec((DataType)dtype, vector, startVal, $this.numRows$1);
                        ++dtypeNum$1.elem;
                        return new ArrowColumnVector(vector);
                    }, Seq$.MODULE$.canBuildFrom());
                    this.batch_$eq(new ColumnarBatch((ColumnVector[])vecs.toArray(ClassTag$.MODULE$.apply(ColumnVector.class))));
                    this.batch().setNumRows(batchSize);
                    this.current_$eq(this.current() + batchSize);
                    bl = true;
                }
                return bl;
            }

            public ColumnarBatch get() {
                return this.batch();
            }

            public void close() {
                this.batch().close();
            }
            {
                this.numRows$1 = numRows$1;
                this.dataTypes$1 = dataTypes$1;
                this.startNum$1 = startNum$1;
                this.current = 0;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(com.nvidia.spark.rapids.tests.datasourcev2.parquet.ColumnarReaderFactory$$anon$2 scala.runtime.IntRef org.apache.spark.sql.types.DataType )}, serializedLambda);
            }
        };
    }

    private ArrowType toArrowType(DataType dt, String timeZoneId) {
        ArrowType.Bool bool;
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Bool.INSTANCE;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(8, true);
        } else if (ShortType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(16, true);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(32, true);
        } else if (LongType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Int(64, true);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
        } else if (StringType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Utf8.INSTANCE;
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            bool = ArrowType.Binary.INSTANCE;
        } else if (DateType$.MODULE$.equals(dataType)) {
            bool = new ArrowType.Date(DateUnit.DAY);
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            if (timeZoneId == null) {
                throw new UnsupportedOperationException(new StringBuilder(33).append(TimestampType$.MODULE$.catalogString()).append(" must supply timeZoneId parameter").toString());
            }
            bool = new ArrowType.Timestamp(TimeUnit.MICROSECOND, timeZoneId);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
        }
        return bool;
    }

    private Field toArrowField(String name, DataType dt, boolean nullable, String timeZoneId) {
        Field field2;
        DataType dataType = dt;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.List.INSTANCE, null);
            field2 = new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("element", elementType, containsNull, timeZoneId), (List)Nil$.MODULE$)).asJava());
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            FieldType fieldType = new FieldType(nullable, (ArrowType)ArrowType.Struct.INSTANCE, null);
            field2 = new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.toArrowField(field.name(), field.dataType(), field.nullable(), timeZoneId), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Field.class))))).toSeq()).asJava());
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            FieldType mapType2 = new FieldType(nullable, (ArrowType)new ArrowType.Map(false), null);
            field2 = new Field(name, mapType2, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.toArrowField("entries", (DataType)new StructType().add("key", keyType, false).add("value", valueType, valueContainsNull), false, timeZoneId), (List)Nil$.MODULE$)).asJava());
        } else {
            FieldType fieldType = new FieldType(nullable, this.toArrowType(dataType, timeZoneId), null);
            field2 = new Field(name, fieldType, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
        }
        return field2;
    }

    public void com$nvidia$spark$rapids$tests$datasourcev2$parquet$ColumnarReaderFactory$$fillArrowVec(DataType dt, ValueVector vec, int start, int numRows) {
        DataType dataType = dt;
        if (BooleanType$.MODULE$.equals(dataType)) {
            BitVector vector = (BitVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, start + i & 1));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            TinyIntVector vector = (TinyIntVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, start + i));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            SmallIntVector vector = (SmallIntVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, start + i));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            IntVector vector = (IntVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, start + i));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (LongType$.MODULE$.equals(dataType)) {
            BigIntVector vector = (BigIntVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, (long)(start + i)));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (StringType$.MODULE$.equals(dataType)) {
            VarCharVector vector = (VarCharVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                int num = start + i;
                String toAdd = new StringBuilder(10).append(num).append("testString").toString();
                vector.setSafe(i, new Text(toAdd));
            });
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            Float4Vector vector = (Float4Vector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, (float)(start + i)));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            Float8Vector vector = (Float8Vector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, (double)(start + i)));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (DateType$.MODULE$.equals(dataType)) {
            DateDayVector vector = (DateDayVector)vec;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, start + i));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            TimeStampMicroTZVector vector = (TimeStampMicroTZVector)vec;
            long startms = 20145678912L;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRows).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> vector.setSafe(i, startms + (long)start + (long)i));
            vector.setNull(numRows);
            vector.setValueCount(numRows + 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(23).append("Unsupported data type: ").append(dt.catalogString()).toString());
        }
    }

    public ValueVector com$nvidia$spark$rapids$tests$datasourcev2$parquet$ColumnarReaderFactory$$setupArrowVector(String name, DataType dataType) {
        RootAllocator rootAllocator = new RootAllocator(Long.MAX_VALUE);
        BufferAllocator allocator = rootAllocator.newChildAllocator(String.valueOf(name), 0L, Long.MAX_VALUE);
        FieldVector vector = this.toArrowField(new StringBuilder(5).append("field").append(name).toString(), dataType, true, "Utc").createVector(allocator);
        return vector;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ColumnarReaderFactory$() {
        MODULE$ = this;
    }
}

