/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.tests.mortgage;

import com.nvidia.spark.rapids.tests.mortgage.ReadAcquisitionCsv$;
import com.nvidia.spark.rapids.tests.mortgage.ReadPerformanceCsv$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class AggregatesWithJoin$ {
    public static AggregatesWithJoin$ MODULE$;

    static {
        new AggregatesWithJoin$();
    }

    public Dataset<Row> csv(SparkSession spark, String mortgagePerformance, String mortgageAcquisition) {
        Dataset<Row> dfp = ReadPerformanceCsv$.MODULE$.apply(spark, mortgagePerformance);
        Dataset kindOfAnonPerf = dfp.withColumn("loan_id_hash", functions$.MODULE$.hex(functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("loan_id")})))).drop("loan_id");
        kindOfAnonPerf.createOrReplaceTempView("perf_data");
        Dataset<Row> dfa = ReadAcquisitionCsv$.MODULE$.apply(spark, mortgageAcquisition);
        Dataset kindOfAnonAcq = dfa.withColumn("loan_id_hash", functions$.MODULE$.hex(functions$.MODULE$.hash((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("loan_id")})))).drop("loan_id");
        kindOfAnonAcq.createOrReplaceTempView("acq_data");
        return spark.sql(new StringOps(Predef$.MODULE$.augmentString("\n        select * from (\n          select loan_id_hash,\n           min(interest_rate) as min_int_rate\n          from perf_data\n          group by loan_id_hash\n        ) a left join (\n          select loan_id_hash,\n           first(orig_interest_rate) as first_int_rate,\n           coalesce(max(dti), 0.0) as max_dti\n          from acq_data\n          group by loan_id_hash\n        ) b on a.loan_id_hash = b.loan_id_hash\n      ")).stripMargin());
    }

    private AggregatesWithJoin$() {
        MODULE$ = this;
    }
}

