/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized.rapids;

import java.math.BigDecimal;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.util.ArrowUtils;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public final class AccessibleArrowColumnVector
extends ColumnVector {
    private final AccessibleArrowVectorAccessor accessor;
    private AccessibleArrowColumnVector[] childColumns;

    public ValueVector getArrowValueVector() {
        return this.accessor.vector;
    }

    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.accessor.getNullCount();
    }

    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        this.accessor.close();
    }

    public boolean isNullAt(int rowId) {
        return this.accessor.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        return this.accessor.getByte(rowId);
    }

    public short getShort(int rowId) {
        return this.accessor.getShort(rowId);
    }

    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId, precision, scale);
    }

    public UTF8String getUTF8String(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getUTF8String(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public ColumnarArray getArray(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getArray(rowId);
    }

    public ColumnarMap getMap(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getMap(rowId);
    }

    public AccessibleArrowColumnVector getChild(int ordinal) {
        return this.childColumns[ordinal];
    }

    public AccessibleArrowColumnVector(ValueVector vector) {
        super(ArrowUtils.fromArrowField((Field)vector.getField()));
        if (vector instanceof BitVector) {
            this.accessor = new AccessibleBooleanAccessor((BitVector)vector);
        } else if (vector instanceof TinyIntVector) {
            this.accessor = new AccessibleByteAccessor((TinyIntVector)vector);
        } else if (vector instanceof SmallIntVector) {
            this.accessor = new AccessibleShortAccessor((SmallIntVector)vector);
        } else if (vector instanceof IntVector) {
            this.accessor = new AccessibleIntAccessor((IntVector)vector);
        } else if (vector instanceof BigIntVector) {
            this.accessor = new AccessibleLongAccessor((BigIntVector)vector);
        } else if (vector instanceof Float4Vector) {
            this.accessor = new AccessibleFloatAccessor((Float4Vector)vector);
        } else if (vector instanceof Float8Vector) {
            this.accessor = new AccessibleDoubleAccessor((Float8Vector)vector);
        } else if (vector instanceof DecimalVector) {
            this.accessor = new AccessibleDecimalAccessor((DecimalVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.accessor = new AccessibleStringAccessor((VarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.accessor = new AccessibleBinaryAccessor((VarBinaryVector)vector);
        } else if (vector instanceof DateDayVector) {
            this.accessor = new AccessibleDateAccessor((DateDayVector)vector);
        } else if (vector instanceof TimeStampMicroTZVector) {
            this.accessor = new AccessibleTimestampAccessor((TimeStampMicroTZVector)vector);
        } else if (vector instanceof MapVector) {
            MapVector mapVector = (MapVector)vector;
            this.accessor = new AccessibleMapAccessor(mapVector);
        } else if (vector instanceof ListVector) {
            ListVector listVector = (ListVector)vector;
            this.accessor = new AccessibleArrayAccessor(listVector);
        } else if (vector instanceof StructVector) {
            StructVector structVector = (StructVector)vector;
            this.accessor = new AccessibleStructAccessor(structVector);
            this.childColumns = new AccessibleArrowColumnVector[structVector.size()];
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i] = new AccessibleArrowColumnVector(structVector.getVectorById(i));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static class AccessibleMapAccessor
    extends AccessibleArrowVectorAccessor {
        private final MapVector accessor;
        private final AccessibleArrowColumnVector keys;
        private final AccessibleArrowColumnVector values;

        AccessibleMapAccessor(MapVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
            StructVector entries = (StructVector)vector.getDataVector();
            this.keys = new AccessibleArrowColumnVector((ValueVector)entries.getChild("key"));
            this.values = new AccessibleArrowColumnVector((ValueVector)entries.getChild("value"));
        }

        @Override
        final ColumnarMap getMap(int rowId) {
            int index = rowId * 4;
            int offset = this.accessor.getOffsetBuffer().getInt((long)index);
            int length = this.accessor.getInnerValueCountAt(rowId);
            return new ColumnarMap((ColumnVector)this.keys, (ColumnVector)this.values, offset, length);
        }
    }

    private static class AccessibleStructAccessor
    extends AccessibleArrowVectorAccessor {
        AccessibleStructAccessor(StructVector vector) {
            super((ValueVector)vector);
        }
    }

    private static class AccessibleArrayAccessor
    extends AccessibleArrowVectorAccessor {
        private final ListVector accessor;
        private final AccessibleArrowColumnVector arrayData;

        AccessibleArrayAccessor(ListVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
            this.arrayData = new AccessibleArrowColumnVector((ValueVector)vector.getDataVector());
        }

        @Override
        final boolean isNullAt(int rowId) {
            if (this.accessor.getValueCount() > 0 && this.accessor.getValidityBuffer().capacity() == 0L) {
                return false;
            }
            return super.isNullAt(rowId);
        }

        @Override
        final ColumnarArray getArray(int rowId) {
            int start = this.accessor.getElementStartIndex(rowId);
            int end = this.accessor.getElementEndIndex(rowId);
            return new ColumnarArray((ColumnVector)this.arrayData, start, end - start);
        }
    }

    private static class AccessibleTimestampAccessor
    extends AccessibleArrowVectorAccessor {
        private final TimeStampMicroTZVector accessor;

        AccessibleTimestampAccessor(TimeStampMicroTZVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleDateAccessor
    extends AccessibleArrowVectorAccessor {
        private final DateDayVector accessor;

        AccessibleDateAccessor(DateDayVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleBinaryAccessor
    extends AccessibleArrowVectorAccessor {
        private final VarBinaryVector accessor;

        AccessibleBinaryAccessor(VarBinaryVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }
    }

    private static class AccessibleStringAccessor
    extends AccessibleArrowVectorAccessor {
        private final VarCharVector accessor;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        AccessibleStringAccessor(VarCharVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final UTF8String getUTF8String(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return UTF8String.fromAddress(null, (long)(this.stringResult.buffer.memoryAddress() + (long)this.stringResult.start), (int)(this.stringResult.end - this.stringResult.start));
        }
    }

    private static class AccessibleDecimalAccessor
    extends AccessibleArrowVectorAccessor {
        private final DecimalVector accessor;

        AccessibleDecimalAccessor(DecimalVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final Decimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return Decimal.apply((BigDecimal)this.accessor.getObject(rowId), (int)precision, (int)scale);
        }
    }

    private static class AccessibleDoubleAccessor
    extends AccessibleArrowVectorAccessor {
        private final Float8Vector accessor;

        AccessibleDoubleAccessor(Float8Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final double getDouble(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleFloatAccessor
    extends AccessibleArrowVectorAccessor {
        private final Float4Vector accessor;

        AccessibleFloatAccessor(Float4Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final float getFloat(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleLongAccessor
    extends AccessibleArrowVectorAccessor {
        private final BigIntVector accessor;

        AccessibleLongAccessor(BigIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleIntAccessor
    extends AccessibleArrowVectorAccessor {
        private final IntVector accessor;

        AccessibleIntAccessor(IntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleShortAccessor
    extends AccessibleArrowVectorAccessor {
        private final SmallIntVector accessor;

        AccessibleShortAccessor(SmallIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final short getShort(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleByteAccessor
    extends AccessibleArrowVectorAccessor {
        private final TinyIntVector accessor;

        AccessibleByteAccessor(TinyIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte getByte(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    private static class AccessibleBooleanAccessor
    extends AccessibleArrowVectorAccessor {
        private final BitVector accessor;

        AccessibleBooleanAccessor(BitVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final boolean getBoolean(int rowId) {
            return this.accessor.get(rowId) == 1;
        }
    }

    private static abstract class AccessibleArrowVectorAccessor {
        private final ValueVector vector;

        AccessibleArrowVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        Decimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        UTF8String getUTF8String(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarArray getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        ColumnarMap getMap(int rowId) {
            throw new UnsupportedOperationException();
        }
    }
}

