/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids.execution;

import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.RapidsConf$;
import com.nvidia.spark.rapids.TargetSize;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.MapPartitionsRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.execution.SQLExecutionRDD;
import org.apache.spark.sql.rapids.execution.ExternalRowToColumnarIterator;
import org.apache.spark.sql.rapids.execution.GpuColumnToRowMapPartitionsRDD;
import org.apache.spark.sql.rapids.execution.GpuExternalRowToColumnConverter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class InternalColumnarRddConverter$
implements Logging {
    public static InternalColumnarRddConverter$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new InternalColumnarRddConverter$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Table> apply(Dataset<Row> df) {
        return this.convert(df);
    }

    public Tuple2<Option<RDD<ColumnarBatch>>, RDD<Row>> extractRDDColumnarBatch(Dataset<Row> df) {
        RDD rDD;
        StructType schema = df.schema();
        Set unsupported = ((TraversableOnce)((TraversableLike)schema.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)dt -> BoxesRunTime.boxToBoolean((boolean)InternalColumnarRddConverter$.$anonfun$extractRDDColumnarBatch$2(dt)))).toSet();
        if (unsupported.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(85).append("Cannot convert ").append(df).append(" to GPU columnar ").append(unsupported).append(" are ").append("not currently supported data types for columnar.").toString());
        }
        df.sqlContext().setConf(RapidsConf$.MODULE$.EXPORT_COLUMNAR_RDD().key(), "true");
        try {
            rDD = df.rdd();
        }
        finally {
            df.sqlContext().setConf(RapidsConf$.MODULE$.EXPORT_COLUMNAR_RDD().key(), "false");
        }
        RDD input = rDD;
        None$ batch = None$.MODULE$;
        RDD rDD2 = input;
        if (rDD2 instanceof MapPartitionsRDD) {
            MapPartitionsRDD mapPartitionsRDD = (MapPartitionsRDD)rDD2;
            RDD rDD3 = mapPartitionsRDD.prev();
            if (rDD3 instanceof SQLExecutionRDD) {
                SQLExecutionRDD sQLExecutionRDD = (SQLExecutionRDD)rDD3;
                RDD rDD4 = sQLExecutionRDD.sqlRDD();
                if (rDD4 instanceof MapPartitionsRDD) {
                    MapPartitionsRDD mapPartitionsRDD2 = (MapPartitionsRDD)rDD4;
                    RDD rDD5 = mapPartitionsRDD2.prev();
                    if (rDD5 instanceof GpuColumnToRowMapPartitionsRDD) {
                        GpuColumnToRowMapPartitionsRDD gpuColumnToRowMapPartitionsRDD = (GpuColumnToRowMapPartitionsRDD)rDD5;
                        batch = new Some((Object)gpuColumnToRowMapPartitionsRDD.prev());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Cannot extract columnar RDD directly. ").append("(column to row not found ").append(rDD5).append(")").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Cannot extract columnar RDD directly. ").append("(Internal row to row rdd not found ").append(rDD4).append(")").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Cannot extract columnar RDD directly. ").append("(SQLExecutionRDD not found ").append(rDD3).append(")").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Cannot extract columnar RDD directly. ").append("(First MapPartitionsRDD not found ").append(rDD2).append(")").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)batch, (Object)input);
    }

    public RDD<Table> convert(Dataset<Row> df) {
        StructType schema = df.schema();
        Tuple2<Option<RDD<ColumnarBatch>>, RDD<Row>> tuple2 = this.extractRDDColumnarBatch(df);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option batch = (Option)tuple2._1();
        RDD input = (RDD)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)batch, (Object)input);
        Tuple2 tuple23 = tuple22;
        Option batch2 = (Option)tuple23._1();
        RDD input2 = (RDD)tuple23._2();
        RDD b = (RDD)batch2.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            GpuExternalRowToColumnConverter converters = new GpuExternalRowToColumnConverter(schema);
            RapidsConf conf = new RapidsConf(df.sqlContext().conf());
            TargetSize goal = new TargetSize(conf.gpuTargetBatchSizeBytes());
            return input2.mapPartitions((Function1 & Serializable & scala.Serializable)rowIter -> new ExternalRowToColumnarIterator((Iterator<Row>)rowIter, schema, goal, converters), input2.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ColumnarBatch.class));
        });
        return b.map((Function1 & Serializable & scala.Serializable)cb -> {
            Table table;
            try {
                table = GpuColumnVector.from(cb);
            }
            finally {
                cb.close();
            }
            return table;
        }, ClassTag$.MODULE$.apply(Table.class));
    }

    public static final /* synthetic */ boolean $anonfun$extractRDDColumnarBatch$2(DataType dt) {
        DataType x$1 = dt;
        boolean x$2 = true;
        boolean x$3 = true;
        boolean x$4 = true;
        boolean x$5 = true;
        boolean x$6 = true;
        boolean x$7 = true;
        boolean x$8 = true;
        boolean x$9 = true;
        boolean x$10 = GpuOverrides$.MODULE$.isSupportedType$default$5();
        return !GpuOverrides$.MODULE$.isSupportedType(x$1, x$4, x$8, x$7, x$10, x$6, x$5, x$3, x$2, x$9);
    }

    private InternalColumnarRddConverter$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

