/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.spark.internal.Logging;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.sql.rapids.GpuShuffleHandle;
import org.apache.spark.sql.rapids.RapidsShuffleInternalManagerBase;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class RapidsShuffleInternalManagerBase$
implements Logging {
    public static RapidsShuffleInternalManagerBase$ MODULE$;
    private HashMap<Object, RapidsShuffleInternalManagerBase.Slot> slots;
    private int numSlots;
    private final AtomicInteger slotNumber;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new RapidsShuffleInternalManagerBase$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ShuffleHandle unwrapHandle(ShuffleHandle handle) {
        ShuffleHandle shuffleHandle;
        ShuffleHandle shuffleHandle2 = handle;
        if (shuffleHandle2 instanceof GpuShuffleHandle) {
            GpuShuffleHandle gpuShuffleHandle = (GpuShuffleHandle)shuffleHandle2;
            shuffleHandle = gpuShuffleHandle.wrapped();
        } else {
            shuffleHandle = shuffleHandle2;
        }
        return shuffleHandle;
    }

    private int numSlots() {
        return this.numSlots;
    }

    private void numSlots_$eq(int x$1) {
        this.numSlots = x$1;
    }

    private HashMap<Object, RapidsShuffleInternalManagerBase.Slot> slots$lzycompute() {
        RapidsShuffleInternalManagerBase$ rapidsShuffleInternalManagerBase$ = this;
        synchronized (rapidsShuffleInternalManagerBase$) {
            if (!this.bitmap$0) {
                this.slots = new HashMap();
                this.bitmap$0 = true;
            }
        }
        return this.slots;
    }

    private HashMap<Object, RapidsShuffleInternalManagerBase.Slot> slots() {
        return !this.bitmap$0 ? this.slots$lzycompute() : this.slots;
    }

    private AtomicInteger slotNumber() {
        return this.slotNumber;
    }

    public <T> Future<T> queueTask(int slotNum, Callable<T> task) {
        return ((RapidsShuffleInternalManagerBase.Slot)this.slots().apply((Object)BoxesRunTime.boxToInteger((int)(slotNum % this.numSlots())))).offer(task);
    }

    public synchronized void startThreadPoolIfNeeded(int numConfiguredThreads) {
        block0: {
            if (!this.slots().isEmpty()) break block0;
            this.numSlots_$eq(numConfiguredThreads);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numSlots()).foreach((Function1 & java.io.Serializable & Serializable)slotNum -> RapidsShuffleInternalManagerBase$.$anonfun$startThreadPoolIfNeeded$1(BoxesRunTime.unboxToInt((Object)slotNum)));
        }
    }

    public synchronized void stopThreadPool() {
        this.slots().values().foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            x$1.shutdownNow();
            return BoxedUnit.UNIT;
        });
        this.slots().clear();
    }

    public int getNextSlot() {
        return Math.abs(this.slotNumber().incrementAndGet());
    }

    public static final /* synthetic */ Option $anonfun$startThreadPoolIfNeeded$1(int slotNum) {
        return MODULE$.slots().put((Object)BoxesRunTime.boxToInteger((int)slotNum), (Object)new RapidsShuffleInternalManagerBase.Slot(slotNum));
    }

    private RapidsShuffleInternalManagerBase$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.numSlots = 0;
        this.slotNumber = new AtomicInteger(0);
    }
}

