/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuScalar;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;

public final class GpuDivModLike$
implements Arm {
    public static GpuDivModLike$ MODULE$;

    static {
        new GpuDivModLike$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public ColumnVector replaceZeroWithNull(ColumnVector v) {
        ColumnVector columnVector;
        Scalar zeroScalar = null;
        Scalar nullScalar = null;
        ColumnVector zeroVec = null;
        ColumnVector nullVec = null;
        try {
            DType dtype = v.getType();
            zeroScalar = this.makeZeroScalar(dtype);
            nullScalar = Scalar.fromNull((DType)dtype);
            zeroVec = ColumnVector.fromScalar((Scalar)zeroScalar, (int)1);
            nullVec = ColumnVector.fromScalar((Scalar)nullScalar, (int)1);
            columnVector = v.findAndReplaceAll((ColumnView)zeroVec, (ColumnView)nullVec);
        }
        finally {
            if (zeroScalar != null) {
                zeroScalar.close();
            }
            if (nullScalar != null) {
                nullScalar.close();
            }
            if (zeroVec != null) {
                zeroVec.close();
            }
            if (nullVec != null) {
                nullVec.close();
            }
        }
        return columnVector;
    }

    public boolean isScalarZero(Scalar s) {
        boolean bl;
        DType dType = s.getType();
        DType dType2 = DType.INT8;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            bl = s.getByte() == 0;
        } else {
            DType dType4 = DType.INT16;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                bl = s.getShort() == 0;
            } else {
                DType dType6 = DType.INT32;
                DType dType7 = dType;
                if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                    bl = s.getInt() == 0;
                } else {
                    DType dType8 = DType.INT64;
                    DType dType9 = dType;
                    if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                        bl = s.getLong() == 0L;
                    } else {
                        DType dType10 = DType.FLOAT32;
                        DType dType11 = dType;
                        if (!(dType10 != null ? !dType10.equals(dType11) : dType11 != null)) {
                            bl = s.getFloat() == 0.0f;
                        } else {
                            DType dType12 = DType.FLOAT64;
                            DType dType13 = dType;
                            if (!(dType12 != null ? !dType12.equals(dType13) : dType13 != null)) {
                                bl = s.getDouble() == 0.0;
                            } else {
                                DType.DTypeEnum dTypeEnum = dType.getTypeId();
                                DType.DTypeEnum dTypeEnum2 = DType.DTypeEnum.DECIMAL128;
                                if (!(dTypeEnum != null ? !dTypeEnum.equals(dTypeEnum2) : dTypeEnum2 != null)) {
                                    bl = s.getBigDecimal().toBigInteger().equals(BigInteger.ZERO);
                                } else {
                                    DType.DTypeEnum dTypeEnum3 = dType.getTypeId();
                                    DType.DTypeEnum dTypeEnum4 = DType.DTypeEnum.DECIMAL64;
                                    if (!(dTypeEnum3 != null ? !dTypeEnum3.equals(dTypeEnum4) : dTypeEnum4 != null)) {
                                        bl = s.getLong() == 0L;
                                    } else {
                                        DType.DTypeEnum dTypeEnum5 = dType.getTypeId();
                                        DType.DTypeEnum dTypeEnum6 = DType.DTypeEnum.DECIMAL32;
                                        if (!(dTypeEnum5 != null ? !dTypeEnum5.equals(dTypeEnum6) : dTypeEnum6 != null)) {
                                            bl = s.getInt() == 0;
                                        } else {
                                            throw new IllegalArgumentException(new StringBuilder(17).append("Unexpected type: ").append(dType).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return bl;
    }

    public Scalar makeZeroScalar(DType dtype) {
        Scalar scalar;
        DType dType = dtype;
        DType dType2 = DType.INT8;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            scalar = Scalar.fromByte((byte)((byte)0));
        } else {
            DType dType4 = DType.INT16;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                scalar = Scalar.fromShort((short)((short)0));
            } else {
                DType dType6 = DType.INT32;
                DType dType7 = dType;
                if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                    scalar = Scalar.fromInt((int)0);
                } else {
                    DType dType8 = DType.INT64;
                    DType dType9 = dType;
                    if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                        scalar = Scalar.fromLong((long)0L);
                    } else {
                        DType dType10 = DType.FLOAT32;
                        DType dType11 = dType;
                        if (!(dType10 != null ? !dType10.equals(dType11) : dType11 != null)) {
                            scalar = Scalar.fromFloat((float)0.0f);
                        } else {
                            DType dType12 = DType.FLOAT64;
                            DType dType13 = dType;
                            if (!(dType12 != null ? !dType12.equals(dType13) : dType13 != null)) {
                                scalar = Scalar.fromDouble((double)0.0);
                            } else {
                                DType.DTypeEnum dTypeEnum = dType.getTypeId();
                                DType.DTypeEnum dTypeEnum2 = DType.DTypeEnum.DECIMAL128;
                                if (!(dTypeEnum != null ? !dTypeEnum.equals(dTypeEnum2) : dTypeEnum2 != null)) {
                                    scalar = Scalar.fromDecimal((int)dType.getScale(), (BigInteger)BigInteger.ZERO);
                                } else {
                                    DType.DTypeEnum dTypeEnum3 = dType.getTypeId();
                                    DType.DTypeEnum dTypeEnum4 = DType.DTypeEnum.DECIMAL64;
                                    if (!(dTypeEnum3 != null ? !dTypeEnum3.equals(dTypeEnum4) : dTypeEnum4 != null)) {
                                        scalar = Scalar.fromDecimal((int)dType.getScale(), (long)0L);
                                    } else {
                                        DType.DTypeEnum dTypeEnum5 = dType.getTypeId();
                                        DType.DTypeEnum dTypeEnum6 = DType.DTypeEnum.DECIMAL32;
                                        if (!(dTypeEnum5 != null ? !dTypeEnum5.equals(dTypeEnum6) : dTypeEnum6 != null)) {
                                            scalar = Scalar.fromDecimal((int)dType.getScale(), (int)0);
                                        } else {
                                            throw new IllegalArgumentException(new StringBuilder(17).append("Unexpected type: ").append(dType).toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return scalar;
    }

    public boolean isDivOverflow(GpuColumnVector left, GpuColumnVector right) {
        DataType dataType = left.dataType();
        boolean bl = LongType$.MODULE$.equals(dataType) ? BoxesRunTime.unboxToBoolean(this.withResource(Scalar.fromLong((long)Long.MIN_VALUE), (Function1 & Serializable & scala.Serializable)minLong -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$1(left, right, minLong)))) : false;
        return bl;
    }

    public boolean isDivOverflow(GpuColumnVector left, GpuScalar right) {
        DataType dataType = left.dataType();
        boolean bl = LongType$.MODULE$.equals(dataType) ? right.isValid() && BoxesRunTime.equals((Object)right.getValue(), (Object)BoxesRunTime.boxToInteger((int)-1)) && BoxesRunTime.unboxToBoolean(this.withResource(Scalar.fromLong((long)Long.MIN_VALUE), (Function1 & Serializable & scala.Serializable)minLong -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$7(left, minLong)))) : false;
        return bl;
    }

    public boolean isDivOverflow(GpuScalar left, GpuColumnVector right) {
        return left.isValid() && BoxesRunTime.equals((Object)left.getValue(), (Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)) && BoxesRunTime.unboxToBoolean(this.withResource(Scalar.fromInt((int)-1), (Function1 & Serializable & scala.Serializable)minusOne -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$8(right, minusOne))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$6(Scalar isOverFlow) {
        return isOverFlow.isValid() && isOverFlow.getBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$5(ColumnVector overFlowVector) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(overFlowVector.any(), (Function1 & Serializable & scala.Serializable)isOverFlow -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$6(isOverFlow))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$4(ColumnVector eqToMinLong$1, ColumnVector eqToMinusOne) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(eqToMinLong$1.and((BinaryOperable)eqToMinusOne), (Function1 & Serializable & scala.Serializable)overFlowVector -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$5(overFlowVector))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$3(GpuColumnVector right$1, ColumnVector eqToMinLong$1, Scalar minusOne) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(right$1.getBase().equalTo((BinaryOperable)minusOne), (Function1 & Serializable & scala.Serializable)eqToMinusOne -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$4(eqToMinLong$1, eqToMinusOne))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$2(GpuColumnVector right$1, ColumnVector eqToMinLong) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(Scalar.fromInt((int)-1), (Function1 & Serializable & scala.Serializable)minusOne -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$3(right$1, eqToMinLong, minusOne))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$1(GpuColumnVector left$1, GpuColumnVector right$1, Scalar minLong) {
        return BoxesRunTime.unboxToBoolean(MODULE$.withResource(left$1.getBase().equalTo((BinaryOperable)minLong), (Function1 & Serializable & scala.Serializable)eqToMinLong -> BoxesRunTime.boxToBoolean((boolean)GpuDivModLike$.$anonfun$isDivOverflow$2(right$1, eqToMinLong))));
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$7(GpuColumnVector left$2, Scalar minLong) {
        return left$2.getBase().contains(minLong);
    }

    public static final /* synthetic */ boolean $anonfun$isDivOverflow$8(GpuColumnVector right$2, Scalar minusOne) {
        return right$2.getBase().contains(minusOne);
    }

    private GpuDivModLike$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

