/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.DecimalUtils;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.RapidsBuffer;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.rapids.GpuAdd;
import org.apache.spark.sql.rapids.shims.RapidsErrorUtils$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class GpuAdd$
implements Arm,
scala.Serializable {
    public static GpuAdd$ MODULE$;

    static {
        new GpuAdd$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public void basicOpOverflowCheck(BinaryOperable lhs, BinaryOperable rhs, ColumnVector ret) {
        ColumnVector signCV = (ColumnVector)this.withResource(ret.bitXor(lhs), (Function1 & Serializable & scala.Serializable)lXor -> (ColumnVector)MODULE$.withResource(ret.bitXor(rhs), (Function1 & Serializable & scala.Serializable)rXor -> lXor.bitAnd((BinaryOperable)rXor)));
        ColumnVector signDiffCV = (ColumnVector)this.withResource(signCV, (Function1 & Serializable & scala.Serializable)sign -> (ColumnVector)MODULE$.withResource(Scalar.fromInt((int)0), (Function1 & Serializable & scala.Serializable)zero -> sign.lessThan((BinaryOperable)zero)));
        this.withResource(signDiffCV, (Function1 & Serializable & scala.Serializable)signDiff -> {
            GpuAdd$.MODULE$.withResource(signDiff.any(), (Function1 & Serializable & scala.Serializable)any -> {
                GpuAdd$.$anonfun$basicOpOverflowCheck$6(any);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public ColumnVector didDecimalOverflow(BinaryOperable lhs, BinaryOperable rhs, ColumnVector ret) {
        int numRows = (int)ret.getRowCount();
        BigDecimal zero = package$.MODULE$.BigDecimal().apply(0).bigDecimal();
        return (ColumnVector)this.withResource(DecimalUtils.lessThan((BinaryOperable)rhs, (BigDecimal)zero, (int)numRows), (Function1 & Serializable & scala.Serializable)rhsLz -> {
            ColumnVector argsSignSame2 = (ColumnVector)MODULE$.withResource(DecimalUtils.lessThan((BinaryOperable)lhs, (BigDecimal)zero, (int)numRows), (Function1 & Serializable & scala.Serializable)lhsLz -> lhsLz.equalTo((BinaryOperable)rhsLz));
            return (ColumnVector)MODULE$.withResource(argsSignSame2, (Function1 & Serializable & scala.Serializable)argsSignSame -> {
                ColumnVector resultAndRhsDifferentSign2 = (ColumnVector)MODULE$.withResource(DecimalUtils.lessThan((ColumnView)ret, (BigDecimal)zero), (Function1 & Serializable & scala.Serializable)resultLz -> rhsLz.notEqualTo((BinaryOperable)resultLz));
                return (ColumnVector)MODULE$.withResource(resultAndRhsDifferentSign2, (Function1 & Serializable & scala.Serializable)resultAndRhsDifferentSign -> resultAndRhsDifferentSign.and((BinaryOperable)argsSignSame));
            });
        });
    }

    public ColumnVector decimalOpOverflowCheck(BinaryOperable lhs, BinaryOperable rhs, ColumnVector ret, boolean failOnError) {
        return (ColumnVector)this.withResource(this.didDecimalOverflow(lhs, rhs, ret), (Function1 & Serializable & scala.Serializable)overflow -> {
            ColumnVector columnVector;
            if (failOnError) {
                MODULE$.withResource(overflow.any(), (Function1 & Serializable & scala.Serializable)any -> {
                    GpuAdd$.$anonfun$decimalOpOverflowCheck$2(any);
                    return BoxedUnit.UNIT;
                });
                columnVector = ret.incRefCount();
            } else {
                columnVector = (ColumnVector)MODULE$.withResource(Scalar.fromNull((DType)ret.getType()), (Function1 & Serializable & scala.Serializable)nullVal -> overflow.ifElse(nullVal, (ColumnView)ret));
            }
            return columnVector;
        });
    }

    public GpuAdd apply(Expression left, Expression right, boolean failOnError) {
        return new GpuAdd(left, right, failOnError);
    }

    public Option<Tuple3<Expression, Expression, Object>> unapply(GpuAdd x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.left(), (Object)x$0.right(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.failOnError())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$basicOpOverflowCheck$6(Scalar any) {
        if (any.isValid() && any.getBoolean()) {
            throw RapidsErrorUtils$.MODULE$.arithmeticOverflowError("One or more rows overflow for Add operation.", RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$2(), RapidsErrorUtils$.MODULE$.arithmeticOverflowError$default$3());
        }
    }

    public static final /* synthetic */ void $anonfun$decimalOpOverflowCheck$2(Scalar any) {
        if (any.isValid() && any.getBoolean()) {
            throw new ArithmeticException("One or more rows overflow for Add operation.");
        }
    }

    private GpuAdd$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

