/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.rapids;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.rapids.DateFormatter;
import org.apache.spark.sql.catalyst.util.rapids.DateFormatter$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0007\u000f\u0001uA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015a\u0005\u0001\"\u0001N\u0011!\u0019\u0006\u0001#b\u0001\n\u0013!\u0006\u0002C1\u0001\u0011\u000b\u0007I\u0011\u00032\t\u000b\u0011\u0004A\u0011I3\t\u000ba\u0003A\u0011I6\t\u000ba\u0003A\u0011\t:\t\u000ba\u0003A\u0011I;\t\u000bm\u0004A\u0011\t?\u0003)%\u001bx\u000e\u000f\u001c1c\u0011\u000bG/\u001a$pe6\fG\u000f^3s\u0015\ty\u0001#\u0001\u0004sCBLGm\u001d\u0006\u0003#I\tA!\u001e;jY*\u00111\u0003F\u0001\tG\u0006$\u0018\r\\=ti*\u0011QCF\u0001\u0004gFd'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0004\u0001M!\u0001A\b\u0013)!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011QEJ\u0007\u0002\u001d%\u0011qE\u0004\u0002\u000e\t\u0006$XMR8s[\u0006$H/\u001a:\u0011\u0005%RS\"\u0001\t\n\u0005-\u0002\"a\u0006#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\"+G\u000e]3s\u0003\u001d\u0001\u0018\r\u001e;fe:\u0004\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019!\u001b\u0005\t$B\u0001\u001a\u001d\u0003\u0019a$o\\8u}%\u0011A\u0007I\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025A\u00051An\\2bY\u0016\u0004\"A\u000f \u000e\u0003mR!!\u0005\u001f\u000b\u0003u\nAA[1wC&\u0011qh\u000f\u0002\u0007\u0019>\u001c\u0017\r\\3\u0002\u00191,w-Y2z\r>\u0014X.\u0019;\u0011\u0005\t+eBA\u0015D\u0013\t!\u0005#A\tMK\u001e\f7-\u001f#bi\u00164uN]7biNL!AR$\u0003!1+w-Y2z\t\u0006$XMR8s[\u0006$(B\u0001#\u0011\u0003%I7\u000fU1sg&tw\r\u0005\u0002 \u0015&\u00111\n\t\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q)aj\u0014)R%B\u0011Q\u0005\u0001\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006q\u0015\u0001\r!\u000f\u0005\u0006\u0001\u0016\u0001\r!\u0011\u0005\u0006\u0011\u0016\u0001\r!S\u0001\nM>\u0014X.\u0019;uKJ,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000baAZ8s[\u0006$(B\u0001.=\u0003\u0011!\u0018.\\3\n\u0005q;&!\u0005#bi\u0016$\u0016.\\3G_Jl\u0017\r\u001e;fe\"\u0012aA\u0018\t\u0003?}K!\u0001\u0019\u0011\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018a\u00047fO\u0006\u001c\u0017PR8s[\u0006$H/\u001a:\u0016\u0003\u0011B#a\u00020\u0002\u000bA\f'o]3\u0015\u0005\u0019L\u0007CA\u0010h\u0013\tA\u0007EA\u0002J]RDQA\u001b\u0005A\u00025\n\u0011a\u001d\u000b\u0003[1DQ!\\\u0005A\u00029\f\u0011\u0002\\8dC2$\u0015\r^3\u0011\u0005=\u0004X\"A-\n\u0005EL&!\u0003'pG\u0006dG)\u0019;f)\ti3\u000fC\u0003u\u0015\u0001\u0007a-\u0001\u0003eCf\u001cHCA\u0017w\u0011\u001598\u00021\u0001y\u0003\u0011!\u0017\r^3\u0011\u0005iJ\u0018B\u0001><\u0005\u0011!\u0015\r^3\u0002+Y\fG.\u001b3bi\u0016\u0004\u0016\r\u001e;fe:\u001cFO]5oOR\tQ\u0010\u0005\u0002 }&\u0011q\u0010\t\u0002\u0005+:LG\u000f")
public class Iso8601DateFormatter
implements DateFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private transient DateFormatter legacyFormatter;
    private final String pattern;
    private final Locale locale;
    private final Enumeration.Value legacyFormat;
    private final boolean isParsing;
    private volatile transient byte bitmap$trans$0;

    public LocalDate toLocalDate(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalDate$((DateTimeFormatterHelper)this, (TemporalAccessor)accessor);
    }

    public LocalTime toLocalTime(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalTime$((DateTimeFormatterHelper)this, (TemporalAccessor)accessor);
    }

    public ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$((DateTimeFormatterHelper)this, (TemporalAccessor)accessor, (ZoneId)zoneId);
    }

    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale, boolean isParsing) {
        return DateTimeFormatterHelper.getOrCreateFormatter$((DateTimeFormatterHelper)this, (String)pattern, (Locale)locale, (boolean)isParsing);
    }

    public <T> PartialFunction<Throwable, T> checkParsedDiff(String s, Function1<String, T> legacyParseFunc) {
        return DateTimeFormatterHelper.checkParsedDiff$((DateTimeFormatterHelper)this, (String)s, legacyParseFunc);
    }

    public <T extends Date> PartialFunction<Throwable, String> checkFormattedDiff(T d, Function1<T, String> legacyFormatFunc) {
        return DateTimeFormatterHelper.checkFormattedDiff$((DateTimeFormatterHelper)this, d, legacyFormatFunc);
    }

    public PartialFunction<Throwable, DateTimeFormatter> checkLegacyFormatter(String pattern, Function0<BoxedUnit> tryLegacyFormatter) {
        return DateTimeFormatterHelper.checkLegacyFormatter$((DateTimeFormatterHelper)this, (String)pattern, tryLegacyFormatter);
    }

    public PartialFunction<Throwable, Nothing$> checkInvalidPattern(String pattern) {
        return DateTimeFormatterHelper.checkInvalidPattern$((DateTimeFormatterHelper)this, (String)pattern);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale, this.isParsing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    private DateTimeFormatter formatter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    private DateFormatter legacyFormatter$lzycompute() {
        Iso8601DateFormatter iso8601DateFormatter = this;
        synchronized (iso8601DateFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.legacyFormatter = DateFormatter$.MODULE$.getLegacyFormatter(this.pattern, this.locale, this.legacyFormat);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.legacyFormatter;
    }

    public DateFormatter legacyFormatter() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.legacyFormatter$lzycompute() : this.legacyFormatter;
    }

    @Override
    public int parse(String s2) {
        int n;
        try {
            LocalDate localDate = this.toLocalDate(this.formatter().parse(s2));
            n = DateTimeUtils$.MODULE$.localDateToDays(localDate);
        }
        catch (Throwable x$1) {
            PartialFunction catchExpr$1 = this.checkParsedDiff(s2, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)Iso8601DateFormatter.$anonfun$parse$1(this, s)));
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                n = BoxesRunTime.unboxToInt((Object)catchExpr$1.apply((Object)x$1));
            }
            throw x$1;
        }
        return n;
    }

    @Override
    public String format(LocalDate localDate) {
        String string;
        try {
            string = localDate.format(this.formatter());
        }
        catch (Throwable x$2) {
            PartialFunction<Throwable, String> catchExpr$2 = this.checkFormattedDiff(DateTimeUtils$.MODULE$.toJavaDate(DateTimeUtils$.MODULE$.localDateToDays(localDate)), (Function1 & Serializable & scala.Serializable)d -> this.format((Date)d));
            if (catchExpr$2.isDefinedAt((Object)x$2)) {
                string = (String)catchExpr$2.apply((Object)x$2);
            }
            throw x$2;
        }
        return string;
    }

    @Override
    public String format(int days) {
        return this.format(LocalDate.ofEpochDay(days));
    }

    @Override
    public String format(Date date) {
        return this.legacyFormatter().format(date);
    }

    @Override
    public void validatePatternString() {
        Object object;
        try {
            object = this.formatter();
        }
        catch (Throwable x$3) {
            PartialFunction<Throwable, DateTimeFormatter> catchExpr$3 = this.checkLegacyFormatter(this.pattern, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.legacyFormatter().validatePatternString());
            if (catchExpr$3.isDefinedAt((Object)x$3)) {
                object = catchExpr$3.apply((Object)x$3);
            }
            throw x$3;
        }
    }

    public static final /* synthetic */ int $anonfun$parse$1(Iso8601DateFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public Iso8601DateFormatter(String pattern, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        this.pattern = pattern;
        this.locale = locale;
        this.legacyFormat = legacyFormat;
        this.isParsing = isParsing;
        DateTimeFormatterHelper.$init$((DateTimeFormatterHelper)this);
    }
}

