/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.JSONOptions;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.GpuCast$;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuTextBasedPartitionReader;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.catalyst.json.GpuJsonUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.QueryExecutionException$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u000b\u0017\u0001\u0015B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tq\u0001\u0011\t\u0011)A\u0005s!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003C\u0011!I\u0005A!A!\u0002\u0013Q\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011]\u0003!\u0011!Q\u0001\naC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\u0006a\u0002!\t!\u001d\u0005\u0006y\u0002!\t! \u0005\b\u0003\u001f\u0001A\u0011IA\t\u0011\u001d\ti\u0004\u0001C!\u0003\u007fAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\r\u0001\u0005B\u0005\u001d\u0004bBA;\u0001\u0011\u0005\u0013q\u000f\u0005\b\u0003\u0007\u0003A\u0011IA \u0011\u001d\t)\t\u0001C!\u0003\u007fAa\"a\"\u0001!\u0003\r\t\u0011!C\u0005\u0003\u0013\u000byIA\nKg>t\u0007+\u0019:uSRLwN\u001c*fC\u0012,'O\u0003\u0002\u00181\u00051!/\u00199jINT!!\u0007\u000e\u0002\t)\u001cxN\u001c\u0006\u00037q\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0018\u000e\u0003!R!aF\u0015\u000b\u0005}Q#BA\u0016-\u0003\u0019qg/\u001b3jC*\tQ&A\u0002d_6L!a\f\u0015\u00037\u001d\u0003X\u000fV3yi\n\u000b7/\u001a3QCJ$\u0018\u000e^5p]J+\u0017\rZ3s\u0003\u0011\u0019wN\u001c4\u0011\u0005I2T\"A\u001a\u000b\u0005A\"$BA\u001b!\u0003\u0019A\u0017\rZ8pa&\u0011qg\r\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0011A\f'\u000f\u001e$jY\u0016\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003}q\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0001[$a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0002\u0015\u0011\fG/Y*dQ\u0016l\u0017\r\u0005\u0002D\r6\tAI\u0003\u0002F9\u0005)A/\u001f9fg&\u0011q\t\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017A\u0004:fC\u0012$\u0015\r^1TG\",W.Y\u0001\u000ea\u0006\u00148/\u001a3PaRLwN\\:\u0011\u0005-cU\"\u0001\r\n\u00055C\"a\u0003&T\u001f:{\u0005\u000f^5p]N\fq\"\\1y%><8\u000fU3s\u0007\",hn\u001b\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bA\u0001\\1oO*\tA+\u0001\u0003kCZ\f\u0017B\u0001,R\u0005\u001dIe\u000e^3hKJ\f\u0001#\\1y\u0005f$Xm\u001d)fe\u000eCWO\\6\u0011\u0005ecV\"\u0001.\u000b\u0003m\u000bQa]2bY\u0006L!!\u0018.\u0003\t1{gnZ\u0001\fKb,7-T3ue&\u001c7\u000f\u0005\u0003aO*lgBA1f!\t\u0011',D\u0001d\u0015\t!G%\u0001\u0004=e>|GOP\u0005\u0003Mj\u000ba\u0001\u0015:fI\u00164\u0017B\u00015j\u0005\ri\u0015\r\u001d\u0006\u0003Mj\u0003\"\u0001Y6\n\u00051L'AB*ue&tw\r\u0005\u0002(]&\u0011q\u000e\u000b\u0002\n\u000fB,X*\u001a;sS\u000e\fa\u0001P5oSRtD#\u0003:ukZ<\b0\u001f>|!\t\u0019\b!D\u0001\u0017\u0011\u0015\u0001\u0014\u00021\u00012\u0011\u0015A\u0014\u00021\u0001:\u0011\u0015\t\u0015\u00021\u0001C\u0011\u0015A\u0015\u00021\u0001C\u0011\u0015I\u0015\u00021\u0001K\u0011\u0015q\u0015\u00021\u0001P\u0011\u00159\u0016\u00021\u0001Y\u0011\u0015q\u0016\u00021\u0001`\u0003A\u0011W/\u001b7e\u0015N|gn\u00149uS>t7\u000fF\u0002\u007f\u0003\u001b\u00012a`A\u0006\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001B2vI\u001aT1aFA\u0004\u0015\t\tI!\u0001\u0002bS&\u0019Q*!\u0001\t\u000b%S\u0001\u0019\u0001&\u0002\u0017I,\u0017\r\u001a+p)\u0006\u0014G.\u001a\u000b\r\u0003'\tI\"a\t\u0002(\u0005E\u00121\u0007\t\u0004\u007f\u0006U\u0011\u0002BA\f\u0003\u0003\u0011Q\u0001V1cY\u0016Dq!a\u0007\f\u0001\u0004\ti\"\u0001\u0006eCR\f')\u001e4gKJ\u00042a`A\u0010\u0013\u0011\t\t#!\u0001\u0003!!{7\u000f^'f[>\u0014\u0018PQ;gM\u0016\u0014\bBBA\u0013\u0017\u0001\u0007\u0001,\u0001\u0005eCR\f7+\u001b>f\u0011\u001d\tIc\u0003a\u0001\u0003W\t!bY;eMN\u001b\u0007.Z7b!\ry\u0018QF\u0005\u0005\u0003_\t\tA\u0001\u0004TG\",W.\u0019\u0005\u0006\u0011.\u0001\rA\u0011\u0005\b\u0003kY\u0001\u0019AA\u001c\u0003%A\u0017m\u001d%fC\u0012,'\u000fE\u0002Z\u0003sI1!a\u000f[\u0005\u001d\u0011un\u001c7fC:\facZ3u\r&dWMR8s[\u0006$8\u000b[8si:\u000bW.Z\u000b\u0002U\u0006a\u0001.\u00198eY\u0016\u0014Vm];miR1\u0011QIA&\u0003\u001b\u0002R!WA$\u0003'I1!!\u0013[\u0005\u0019y\u0005\u000f^5p]\")\u0001*\u0004a\u0001\u0005\"9\u0011qJ\u0007A\u0002\u0005M\u0011!\u0002;bE2,\u0017\u0001E2bgR\u001cFO]5oOR{'i\\8m)\u0011\t)&a\u0017\u0011\u0007}\f9&\u0003\u0003\u0002Z\u0005\u0005!\u0001D\"pYVlgNV3di>\u0014\bbBA/\u001d\u0001\u0007\u0011QK\u0001\u0006S:\u0004X\u000f^\u0001\u0010g\u0006t\u0017\u000e^5{K:+XNY3sgR!\u0011QKA2\u0011\u001d\tif\u0004a\u0001\u0003+\n\u0011cY1tiN#(/\u001b8h)>4En\\1u)\u0019\t)&!\u001b\u0002l!9\u0011Q\f\tA\u0002\u0005U\u0003bBA7!\u0001\u0007\u0011qN\u0001\u0003IR\u00042a`A9\u0013\u0011\t\u0019(!\u0001\u0003\u000b\u0011#\u0016\u0010]3\u0002'\r\f7\u000f^*ue&tw\rV8EK\u000eLW.\u00197\u0015\r\u0005U\u0013\u0011PA>\u0011\u001d\ti&\u0005a\u0001\u0003+Bq!!\u001c\u0012\u0001\u0004\ti\bE\u0002D\u0003\u007fJ1!!!E\u0005-!UmY5nC2$\u0016\u0010]3\u0002\u0015\u0011\fG/\u001a$pe6\fG/A\buS6,7\u000f^1na\u001a{'/\\1u\u0003e\u0019X\u000f]3sI\r\f7\u000f^*ue&tw\rV8EK\u000eLW.\u00197\u0015\r\u0005U\u00131RAG\u0011\u001d\ti\u0006\u0006a\u0001\u0003+Bq!!\u001c\u0015\u0001\u0004\ti(C\u0002\u0002v9\u0002")
public class JsonPartitionReader
extends GpuTextBasedPartitionReader {
    private final StructType dataSchema;
    private final JSONOptions parsedOptions;

    private /* synthetic */ ColumnVector super$castStringToDecimal(ColumnVector input, DecimalType dt) {
        return super.castStringToDecimal(input, dt);
    }

    public ai.rapids.cudf.JSONOptions buildJsonOptions(JSONOptions parsedOptions) {
        JSONOptions.Builder builder = ai.rapids.cudf.JSONOptions.builder();
        return builder.build();
    }

    @Override
    public Table readToTable(HostMemoryBuffer dataBuffer, long dataSize, Schema cudfSchema, StructType readDataSchema, boolean hasHeader) {
        ai.rapids.cudf.JSONOptions jsonOpts = this.buildJsonOptions(this.parsedOptions);
        return (Table)this.withResource(Table.readJSON((Schema)cudfSchema, (ai.rapids.cudf.JSONOptions)jsonOpts, (HostMemoryBuffer)dataBuffer, (long)0L, (long)dataSize), (Function1 & Serializable & scala.Serializable)tbl -> {
            ListBuffer columns = new ListBuffer();
            this.closeOnExcept(columns, (Function1 & Serializable & scala.Serializable)x$4 -> {
                JsonPartitionReader.$anonfun$readToTable$2(readDataSchema, cudfSchema, columns, tbl, x$4);
                return BoxedUnit.UNIT;
            });
            return new Table((ColumnVector[])columns.toArray(ClassTag$.MODULE$.apply(ColumnVector.class)));
        });
    }

    @Override
    public String getFileFormatShortName() {
        return "JSON";
    }

    @Override
    public Option<Table> handleResult(StructType readDataSchema, Table table) {
        int tableCols = table.getNumberOfColumns();
        if (readDataSchema.length() == tableCols) {
            return new Some((Object)table);
        }
        return (Option)this.withResource(table, (Function1 & Serializable & scala.Serializable)x$5 -> {
            int[] prunedCols = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDataSchema.fieldNames())).map((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToInteger((int)JsonPartitionReader.$anonfun$handleResult$2(this, tableCols, name)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            ColumnVector[] prunedColumnVectors = (ColumnVector[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(prunedCols)).map((Function1 & Serializable & scala.Serializable)i -> table.getColumn(BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ColumnVector.class)));
            return new Some((Object)new Table(prunedColumnVectors));
        });
    }

    @Override
    public ColumnVector castStringToBool(ColumnVector input) {
        return (ColumnVector)this.withResource(Scalar.fromString((String)"true"), (Function1 & Serializable & scala.Serializable)t -> (ColumnVector)this.withResource(Scalar.fromString((String)"false"), (Function1 & Serializable & scala.Serializable)f -> (ColumnVector)this.withResource(input.equalTo((BinaryOperable)t), (Function1 & Serializable & scala.Serializable)isTrue -> (ColumnVector)this.withResource(input.equalTo((BinaryOperable)f), (Function1 & Serializable & scala.Serializable)isFalse -> (ColumnVector)this.withResource(isTrue.or((BinaryOperable)isFalse), (Function1 & Serializable & scala.Serializable)isValidBool -> (ColumnVector)this.withResource(Scalar.fromNull((DType)DType.BOOL8), (Function1 & Serializable & scala.Serializable)nullBool -> isValidBool.ifElse((ColumnView)isTrue, nullBool)))))));
    }

    private ColumnVector sanitizeNumbers(ColumnVector input) {
        String jsonNumberRegexp = "^-?[0-9]+(?:\\.[0-9]+)?(?:[eE][\\-\\+]?[0-9]+)?$";
        ColumnVector isValid = this.parsedOptions.allowNonNumericNumbers() ? (ColumnVector)this.withResource(ColumnVector.fromStrings((String[])new String[]{"NaN", "+INF", "-INF", "+Infinity", "Infinity", "-Infinity"}), (Function1 & Serializable & scala.Serializable)nonNumeric -> (ColumnVector)this.withResource(input.matchesRe(jsonNumberRegexp), (Function1 & Serializable & scala.Serializable)isJsonNumber -> (ColumnVector)this.withResource(input.contains((ColumnView)nonNumeric), (Function1 & Serializable & scala.Serializable)nonNumeric -> isJsonNumber.or((BinaryOperable)nonNumeric)))) : input.matchesRe(jsonNumberRegexp);
        return (ColumnVector)this.withResource(isValid, (Function1 & Serializable & scala.Serializable)x$6 -> (ColumnVector)this.withResource(Scalar.fromNull((DType)DType.STRING), (Function1 & Serializable & scala.Serializable)nullString -> isValid.ifElse((ColumnView)input, nullString)));
    }

    @Override
    public ColumnVector castStringToFloat(ColumnVector input, DType dt) {
        return (ColumnVector)this.withResource(this.sanitizeNumbers(input), (Function1 & Serializable & scala.Serializable)sanitizedInput -> GpuCast$.MODULE$.castStringToFloats((ColumnVector)sanitizedInput, false, dt, true));
    }

    @Override
    public ColumnVector castStringToDecimal(ColumnVector input, DecimalType dt) {
        return (ColumnVector)this.withResource(this.sanitizeNumbers(input), (Function1 & Serializable & scala.Serializable)sanitizedInput -> this.super$castStringToDecimal((ColumnVector)sanitizedInput, dt));
    }

    @Override
    public String dateFormat() {
        return GpuJsonUtils$.MODULE$.dateFormatInRead(this.parsedOptions);
    }

    @Override
    public String timestampFormat() {
        return GpuJsonUtils$.MODULE$.timestampFormatInRead(this.parsedOptions);
    }

    public static final /* synthetic */ void $anonfun$readToTable$2(StructType readDataSchema$1, Schema cudfSchema$1, ListBuffer columns$1, Table tbl$1, Seq x$4) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readDataSchema$1.fieldNames())).foreach((Function1 & Serializable & scala.Serializable)name -> {
            int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cudfSchema$1.getColumnNames())).indexOf(name);
            if (i == -1) {
                throw new IllegalStateException(new StringBuilder(66).append("read schema contains field named '").append((String)name).append("' that is not in the data schema").toString());
            }
            return columns$1.$plus$eq((Object)tbl$1.getColumn(i));
        });
    }

    public static final /* synthetic */ int $anonfun$handleResult$2(JsonPartitionReader $this, int tableCols$1, String name) {
        Option optionIndex = $this.dataSchema.getFieldIndex(name);
        if (optionIndex.isEmpty() || BoxesRunTime.unboxToInt((Object)optionIndex.get()) >= tableCols$1) {
            throw new QueryExecutionException(new StringBuilder(46).append("Something wrong for ").append(name).append(" columns in readDataSchema").toString(), QueryExecutionException$.MODULE$.$lessinit$greater$default$2());
        }
        return BoxesRunTime.unboxToInt((Object)optionIndex.get());
    }

    public JsonPartitionReader(Configuration conf, PartitionedFile partFile, StructType dataSchema, StructType readDataSchema, JSONOptions parsedOptions, Integer maxRowsPerChunk, long maxBytesPerChunk, Map<String, GpuMetric> execMetrics) {
        this.dataSchema = dataSchema;
        this.parsedOptions = parsedOptions;
        super(conf, partFile, dataSchema, readDataSchema, (Option<byte[]>)parsedOptions.lineSeparatorInRead(), maxRowsPerChunk, maxBytesPerChunk, execMetrics);
    }
}

