/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcStruct;

public final class OrcUnion
implements WritableComparable<OrcUnion> {
    private byte tag;
    private WritableComparable object;
    private final TypeDescription schema;

    public OrcUnion(TypeDescription schema) {
        this.schema = schema;
    }

    public void set(int tag, WritableComparable object) {
        this.tag = (byte)tag;
        this.object = object;
    }

    public byte getTag() {
        return this.tag;
    }

    public Writable getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != OrcUnion.class) {
            return false;
        }
        OrcUnion oth = (OrcUnion)other;
        if (this.tag != oth.tag) {
            return false;
        }
        if (this.object == null) {
            return oth.object == null;
        }
        return this.object.equals(oth.object);
    }

    public int hashCode() {
        int result = this.tag;
        if (this.object != null) {
            result ^= this.object.hashCode();
        }
        return result;
    }

    public String toString() {
        return "uniontype(" + Integer.toString(this.tag & 0xFF) + ", " + this.object + ")";
    }

    public void write(DataOutput output2) throws IOException {
        output2.writeByte(this.tag);
        output2.writeBoolean(this.object != null);
        if (this.object != null) {
            this.object.write(output2);
        }
    }

    public void readFields(DataInput input) throws IOException {
        byte oldTag = this.tag;
        this.tag = input.readByte();
        if (input.readBoolean()) {
            if (oldTag != this.tag || this.object == null) {
                this.object = OrcStruct.createValue(this.schema.getChildren().get(this.tag));
            }
            this.object.readFields(input);
        } else {
            this.object = null;
        }
    }

    public int compareTo(OrcUnion other) {
        if (other == null) {
            return -1;
        }
        int result = this.schema.compareTo(other.schema);
        if (result != 0) {
            return result;
        }
        if (this.tag != other.tag) {
            return this.tag - other.tag;
        }
        if (this.object == null) {
            return other.object == null ? 0 : 1;
        }
        return this.object.compareTo((Object)other.object);
    }
}

