/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.io.WritableComparable;
import org.apache.orc.TypeDescription;
import org.apache.orc.mapred.OrcStruct;

public final class OrcMap<K extends WritableComparable, V extends WritableComparable>
extends TreeMap<K, V>
implements WritableComparable<OrcMap<K, V>> {
    private final TypeDescription keySchema;
    private final TypeDescription valueSchema;

    public OrcMap(TypeDescription schema) {
        this.keySchema = schema.getChildren().get(0);
        this.valueSchema = schema.getChildren().get(1);
    }

    public void write(DataOutput output2) throws IOException {
        output2.writeInt(this.size());
        for (Map.Entry entry : this.entrySet()) {
            WritableComparable key = (WritableComparable)entry.getKey();
            WritableComparable value = (WritableComparable)entry.getValue();
            output2.writeByte((key == null ? 0 : 2) | (value == null ? 0 : 1));
            if (key != null) {
                key.write(output2);
            }
            if (value == null) continue;
            value.write(output2);
        }
    }

    public void readFields(DataInput input) throws IOException {
        this.clear();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            WritableComparable value;
            WritableComparable key;
            byte flag = input.readByte();
            if ((flag & 2) != 0) {
                key = OrcStruct.createValue(this.keySchema);
                key.readFields(input);
            } else {
                key = null;
            }
            if ((flag & 1) != 0) {
                value = OrcStruct.createValue(this.valueSchema);
                value.readFields(input);
            } else {
                value = null;
            }
            this.put(key, value);
        }
    }

    public int compareTo(OrcMap<K, V> other) {
        if (other == null) {
            return -1;
        }
        int result = this.keySchema.compareTo(other.keySchema);
        if (result != 0) {
            return result;
        }
        result = this.valueSchema.compareTo(other.valueSchema);
        if (result != 0) {
            return result;
        }
        Iterator ourItr = this.entrySet().iterator();
        Iterator theirItr = other.entrySet().iterator();
        while (ourItr.hasNext() && theirItr.hasNext()) {
            WritableComparable theirKey;
            Map.Entry ourItem = ourItr.next();
            Map.Entry theirItem = theirItr.next();
            WritableComparable ourKey = (WritableComparable)ourItem.getKey();
            int val = ourKey.compareTo((Object)(theirKey = (WritableComparable)theirItem.getKey()));
            if (val != 0) {
                return val;
            }
            Comparable ourValue = (Comparable)ourItem.getValue();
            WritableComparable theirValue = (WritableComparable)theirItem.getValue();
            if (ourValue == null) {
                if (theirValue == null) continue;
                return 1;
            }
            if (theirValue == null) {
                return -1;
            }
            val = ((WritableComparable)ourItem.getValue()).compareTo(theirItem.getValue());
            if (val == 0) continue;
            return val;
        }
        if (ourItr.hasNext()) {
            return 1;
        }
        if (theirItr.hasNext()) {
            return -1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && this.compareTo((OrcMap)other) == 0;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

