/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.shuffle;

import ai.rapids.cudf.DeviceMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.DegenerateRapidsBuffer;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsDeviceMemoryStore;
import com.nvidia.spark.rapids.ShuffleMetadata$;
import com.nvidia.spark.rapids.ShuffleReceivedBufferCatalog;
import com.nvidia.spark.rapids.ShuffleReceivedBufferId;
import com.nvidia.spark.rapids.SpillCallback;
import com.nvidia.spark.rapids.SpillPriorities$;
import com.nvidia.spark.rapids.format.BufferTransferResponse;
import com.nvidia.spark.rapids.format.MetadataResponse;
import com.nvidia.spark.rapids.format.TableMeta;
import com.nvidia.spark.rapids.format.TransferResponse;
import com.nvidia.spark.rapids.shuffle.BufferReceiveState;
import com.nvidia.spark.rapids.shuffle.ClientConnection;
import com.nvidia.spark.rapids.shuffle.ConsumedBatchFromBounceBuffer;
import com.nvidia.spark.rapids.shuffle.MessageType$;
import com.nvidia.spark.rapids.shuffle.MetadataTransportBuffer;
import com.nvidia.spark.rapids.shuffle.PendingTransferRequest;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleClient;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleClient$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleClient$ShuffleClientOps$;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleFetchHandler;
import com.nvidia.spark.rapids.shuffle.RapidsShuffleTransport;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer;
import com.nvidia.spark.rapids.shuffle.RefCountedDirectByteBuffer$;
import com.nvidia.spark.rapids.shuffle.Transaction;
import com.nvidia.spark.rapids.shuffle.TransactionStatus$;
import com.nvidia.spark.rapids.shuffle.TransportUtils$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015h\u0001\u00025j\u0001QD!\"!\n\u0001\u0005\u000b\u0007I\u0011AA\u0014\u0011)\t\t\u0004\u0001B\u0001B\u0003%\u0011\u0011\u0006\u0005\u000b\u0003g\u0001!\u0011!Q\u0001\n\u0005U\u0002BCA\u001e\u0001\t\u0005\t\u0015!\u0003\u0002>!Q\u0011Q\n\u0001\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005=\u0003A!A!\u0002\u0013\t\t\u0006\u0003\u0006\u0002X\u0001\u0011\t\u0011)A\u0005\u00033Bq!a\u0018\u0001\t\u0003\t\t\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011q\u0012\u0001!\u0002\u0013\t)hB\u0004\u0002\u0012\u0002A\t!a%\u0007\u000f\u0005]\u0005\u0001#\u0001\u0002\u001a\"9\u0011q\f\u0007\u0005\u0002\u0005meABAO\u0019\u0001\u000by\n\u0003\u0006\u0002.:\u0011)\u001a!C\u0001\u0003_C!\"a.\u000f\u0005#\u0005\u000b\u0011BAY\u0011)\tIL\u0004BK\u0002\u0013\u0005\u00111\u0018\u0005\u000b\u0003Ct!\u0011#Q\u0001\n\u0005u\u0006BCAr\u001d\tU\r\u0011\"\u0001\u0002f\"Q\u0011q\u001d\b\u0003\u0012\u0003\u0006I!a!\t\u000f\u0005}c\u0002\"\u0001\u0002j\"I\u0011Q\u001f\b\u0002\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003\u007ft\u0011\u0013!C\u0001\u0005\u0003A\u0011Ba\u0006\u000f#\u0003%\tA!\u0007\t\u0013\tua\"%A\u0005\u0002\t}\u0001\"\u0003B\u0012\u001d\u0005\u0005I\u0011\tB\u0013\u0011%\u0011iCDA\u0001\n\u0003\u0011y\u0003C\u0005\u000389\t\t\u0011\"\u0001\u0003:!I!Q\t\b\u0002\u0002\u0013\u0005#q\t\u0005\n\u0005+r\u0011\u0011!C\u0001\u0005/B\u0011Ba\u0018\u000f\u0003\u0003%\tE!\u0019\t\u0013\t\rd\"!A\u0005B\t\u0015\u0004\"\u0003B4\u001d\u0005\u0005I\u0011\tB5\u000f%\u0011i\u0007DA\u0001\u0012\u0003\u0011yGB\u0005\u0002\u001e2\t\t\u0011#\u0001\u0003r!9\u0011qL\u0012\u0005\u0002\t}\u0004\"\u0003B2G\u0005\u0005IQ\tB3\u0011%\u0011\tiIA\u0001\n\u0003\u0013\u0019\tC\u0005\u0003\f\u000e\n\t\u0011\"!\u0003\u000e\u001a1!q\u0014\u0007A\u0005CC!Ba))\u0005+\u0007I\u0011\u0001BS\u0011)\u0011i\u000b\u000bB\tB\u0003%!q\u0015\u0005\b\u0003?BC\u0011\u0001BX\u0011%\t)\u0010KA\u0001\n\u0003\u0011)\fC\u0005\u0002\u0000\"\n\n\u0011\"\u0001\u0003:\"I!1\u0005\u0015\u0002\u0002\u0013\u0005#Q\u0005\u0005\n\u0005[A\u0013\u0011!C\u0001\u0005_A\u0011Ba\u000e)\u0003\u0003%\tA!0\t\u0013\t\u0015\u0003&!A\u0005B\t\u001d\u0003\"\u0003B+Q\u0005\u0005I\u0011\u0001Ba\u0011%\u0011y\u0006KA\u0001\n\u0003\u0012\t\u0007C\u0005\u0003d!\n\t\u0011\"\u0011\u0003f!I!q\r\u0015\u0002\u0002\u0013\u0005#QY\u0004\n\u0005\u0013d\u0011\u0011!E\u0001\u0005\u00174\u0011Ba(\r\u0003\u0003E\tA!4\t\u000f\u0005}s\u0007\"\u0001\u0003V\"I!1M\u001c\u0002\u0002\u0013\u0015#Q\r\u0005\n\u0005\u0003;\u0014\u0011!CA\u0005/D\u0011Ba#8\u0003\u0003%\tIa7\u0007\r\t\u0005H\u0002\u0011Br\u0011)\ti\u000b\u0010BK\u0002\u0013\u0005\u0011q\u0016\u0005\u000b\u0003oc$\u0011#Q\u0001\n\u0005E\u0006B\u0003BRy\tU\r\u0011\"\u0001\u0003&\"Q!Q\u0016\u001f\u0003\u0012\u0003\u0006IAa*\t\u000f\u0005}C\b\"\u0001\u0003f\"I\u0011Q\u001f\u001f\u0002\u0002\u0013\u0005!Q\u001e\u0005\n\u0003\u007fd\u0014\u0013!C\u0001\u0005\u0003A\u0011Ba\u0006=#\u0003%\tA!/\t\u0013\t\rB(!A\u0005B\t\u0015\u0002\"\u0003B\u0017y\u0005\u0005I\u0011\u0001B\u0018\u0011%\u00119\u0004PA\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0003Fq\n\t\u0011\"\u0011\u0003H!I!Q\u000b\u001f\u0002\u0002\u0013\u0005!q\u001f\u0005\n\u0005?b\u0014\u0011!C!\u0005CB\u0011Ba\u0019=\u0003\u0003%\tE!\u001a\t\u0013\t\u001dD(!A\u0005B\tmx!\u0003B\u0000\u0019\u0005\u0005\t\u0012AB\u0001\r%\u0011\t\u000fDA\u0001\u0012\u0003\u0019\u0019\u0001C\u0004\u0002`9#\taa\u0003\t\u0013\t\rd*!A\u0005F\t\u0015\u0004\"\u0003BA\u001d\u0006\u0005I\u0011QB\u0007\u0011%\u0011YITA\u0001\n\u0003\u001b\u0019\u0002\u0003\u0005\u0004 \u0001\u0001K\u0011BB\u0011\u0011!\u0019i\u0003\u0001Q\u0005\n\r=\u0002\u0002CB\u001a\u0001\u0001&Ia!\u000e\t\u000f\re\u0002\u0001\"\u0001\u0004<!A11\t\u0001!\n\u0013\u0019)\u0005C\u0004\u0004N\u0001!\taa\u0014\t\u000f\rM\u0003\u0001\"\u0001\u0004V!A11\f\u0001\u0005\u0002%\u001ci\u0006\u0003\u0005\u0004b\u0001\u0001K\u0011BB2\u0011\u001d\u0019\u0019\b\u0001C\u0005\u0007kBqa!#\u0001\t\u0003\u0019Y\tC\u0004\u0004\u0010\u0002!\ta!%\t\u0011\r]\u0005\u0001\"\u0001j\u00073Cqa!1\u0001\t\u0003\u001a\u0019\rC\u0004\u0004F\u0002!\taa2\t\u000f\r-\u0007\u0001\"\u0001\u0004N\u001eI1\u0011[5\u0002\u0002#\u000511\u001b\u0004\tQ&\f\t\u0011#\u0001\u0004V\"9\u0011q\f3\u0005\u0002\r]\u0007\"CBmIF\u0005I\u0011ABn\u0011%\u0019y\u000eZI\u0001\n\u0003\u0019\tOA\nSCBLGm]*ik\u001a4G.Z\"mS\u0016tGO\u0003\u0002kW\u000691\u000f[;gM2,'B\u00017n\u0003\u0019\u0011\u0018\r]5eg*\u0011an\\\u0001\u0006gB\f'o\u001b\u0006\u0003aF\faA\u001c<jI&\f'\"\u0001:\u0002\u0007\r|Wn\u0001\u0001\u0014\u000f\u0001)80!\u0004\u0002\u0016A\u0011a/_\u0007\u0002o*\t\u00010A\u0003tG\u0006d\u0017-\u0003\u0002{o\n1\u0011I\\=SK\u001a\u00042\u0001`A\u0005\u001b\u0005i(B\u0001@\u0000\u0003!Ig\u000e^3s]\u0006d'b\u00018\u0002\u0002)!\u00111AA\u0003\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qA\u0001\u0004_J<\u0017bAA\u0006{\n9Aj\\4hS:<\u0007\u0003BA\b\u0003#i\u0011a[\u0005\u0004\u0003'Y'aA!s[B!\u0011qCA\u0011\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00027b]\u001eT!!a\b\u0002\t)\fg/Y\u0005\u0005\u0003G\tIBA\u0007BkR|7\t\\8tK\u0006\u0014G.Z\u0001\u000bG>tg.Z2uS>tWCAA\u0015!\u0011\tY#!\f\u000e\u0003%L1!a\fj\u0005A\u0019E.[3oi\u000e{gN\\3di&|g.A\u0006d_:tWm\u0019;j_:\u0004\u0013!\u0003;sC:\u001c\bo\u001c:u!\u0011\tY#a\u000e\n\u0007\u0005e\u0012N\u0001\fSCBLGm]*ik\u001a4G.\u001a+sC:\u001c\bo\u001c:u\u0003\u0011)\u00070Z2\u0011\t\u0005}\u0012\u0011J\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u001d\u0013QD\u0001\u0005kRLG.\u0003\u0003\u0002L\u0005\u0005#\u0001C#yK\u000e,Ho\u001c:\u0002%\rd\u0017.\u001a8u\u0007>\u0004\u00180\u0012=fGV$xN]\u0001\u000bI\u001648\u000b^8sC\u001e,\u0007\u0003BA\b\u0003'J1!!\u0016l\u0005]\u0011\u0016\r]5eg\u0012+g/[2f\u001b\u0016lwN]=Ti>\u0014X-A\u0004dCR\fGn\\4\u0011\t\u0005=\u00111L\u0005\u0004\u0003;Z'\u0001H*ik\u001a4G.\u001a*fG\u0016Lg/\u001a3Ck\u001a4WM]\"bi\u0006dwnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001d\u0005\r\u0014QMA4\u0003S\nY'!\u001c\u0002pA\u0019\u00111\u0006\u0001\t\u000f\u0005\u0015\u0002\u00021\u0001\u0002*!9\u00111\u0007\u0005A\u0002\u0005U\u0002bBA\u001e\u0011\u0001\u0007\u0011Q\b\u0005\b\u0003\u001bB\u0001\u0019AA\u001f\u0011%\ty\u0005\u0003I\u0001\u0002\u0004\t\t\u0006C\u0005\u0002X!\u0001\n\u00111\u0001\u0002Z\u0005aA.\u001b<f\u0011\u0006tG\r\\3sgV\u0011\u0011Q\u000f\t\t\u0003o\ni(a!\u0002\n:!\u0011qHA=\u0013\u0011\tY(!\u0011\u0002#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007/\u0003\u0003\u0002\u0000\u0005\u0005%AC&fsN+GOV5fo*!\u00111PA!!\u0011\tY#!\"\n\u0007\u0005\u001d\u0015NA\rSCBLGm]*ik\u001a4G.\u001a$fi\u000eD\u0007*\u00198eY\u0016\u0014\b\u0003BA\f\u0003\u0017KA!!$\u0002\u001a\t9!i\\8mK\u0006t\u0017!\u00047jm\u0016D\u0015M\u001c3mKJ\u001c\b%\u0001\tTQV4g\r\\3DY&,g\u000e^(qgB\u0019\u0011Q\u0013\u0007\u000e\u0003\u0001\u0011\u0001c\u00155vM\u001adWm\u00117jK:$x\n]:\u0014\u00051)HCAAJ\u0005YA\u0015M\u001c3mK6+G/\u00193bi\u0006\u0014Vm\u001d9p]N,7C\u0002\bv\u0003C\u000b9\u000bE\u0002w\u0003GK1!!*x\u0005\u001d\u0001&o\u001c3vGR\u00042A^AU\u0013\r\tYk\u001e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003ib,\"!!-\u0011\t\u0005-\u00121W\u0005\u0004\u0003kK'a\u0003+sC:\u001c\u0018m\u0019;j_:\f1\u0001\u001e=!\u0003=\u0019\b.\u001e4gY\u0016\u0014V-];fgR\u001cXCAA_!\u0019\ty,a4\u0002V:!\u0011\u0011YAf\u001d\u0011\t\u0019-!3\u000e\u0005\u0005\u0015'bAAdg\u00061AH]8pizJ\u0011\u0001_\u0005\u0004\u0003\u001b<\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003#\f\u0019NA\u0002TKFT1!!4x!\u0011\t9.!8\u000e\u0005\u0005e'bAAn\u007f\u000691\u000f^8sC\u001e,\u0017\u0002BAp\u00033\u00141c\u00155vM\u001adWM\u00117pG.\u0014\u0015\r^2i\u0013\u0012\f\u0001c\u001d5vM\u001adWMU3rk\u0016\u001cHo\u001d\u0011\u00023I\f\u0007/\u001b3t'\",hM\u001a7f\r\u0016$8\r\u001b%b]\u0012dWM]\u000b\u0003\u0003\u0007\u000b!D]1qS\u0012\u001c8\u000b[;gM2,g)\u001a;dQ\"\u000bg\u000e\u001a7fe\u0002\"\u0002\"a;\u0002p\u0006E\u00181\u001f\t\u0004\u0003[tQ\"\u0001\u0007\t\u000f\u00055V\u00031\u0001\u00022\"9\u0011\u0011X\u000bA\u0002\u0005u\u0006bBAr+\u0001\u0007\u00111Q\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002l\u0006e\u00181`A\u007f\u0011%\tiK\u0006I\u0001\u0002\u0004\t\t\fC\u0005\u0002:Z\u0001\n\u00111\u0001\u0002>\"I\u00111\u001d\f\u0011\u0002\u0003\u0007\u00111Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011\u0019A\u000b\u0003\u00022\n\u00151F\u0001B\u0004!\u0011\u0011IAa\u0005\u000e\u0005\t-!\u0002\u0002B\u0007\u0005\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tEq/\u0001\u0006b]:|G/\u0019;j_:LAA!\u0006\u0003\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!1\u0004\u0016\u0005\u0003{\u0013)!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0005\"\u0006BAB\u0005\u000b\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u0014!\u0011\t9B!\u000b\n\t\t-\u0012\u0011\u0004\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\tE\u0002c\u0001<\u00034%\u0019!QG<\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tm\"\u0011\t\t\u0004m\nu\u0012b\u0001B o\n\u0019\u0011I\\=\t\u0013\t\rC$!AA\u0002\tE\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003JA1!1\nB)\u0005wi!A!\u0014\u000b\u0007\t=s/\u0001\u0006d_2dWm\u0019;j_:LAAa\u0015\u0003N\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011IF!\u0018\u0011\u0007Y\u0014Y&C\u0002\u0002\u000e^D\u0011Ba\u0011\u001f\u0003\u0003\u0005\rAa\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\r\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\n\u0002\r\u0015\fX/\u00197t)\u0011\u0011IFa\u001b\t\u0013\t\r\u0013%!AA\u0002\tm\u0012A\u0006%b]\u0012dW-T3uC\u0012\fG/\u0019*fgB|gn]3\u0011\u0007\u000558eE\u0003$\u0005g\n9\u000b\u0005\u0007\u0003v\tm\u0014\u0011WA_\u0003\u0007\u000bY/\u0004\u0002\u0003x)\u0019!\u0011P<\u0002\u000fI,h\u000e^5nK&!!Q\u0010B<\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0005_\nQ!\u00199qYf$\u0002\"a;\u0003\u0006\n\u001d%\u0011\u0012\u0005\b\u0003[3\u0003\u0019AAY\u0011\u001d\tIL\na\u0001\u0003{Cq!a9'\u0001\u0004\t\u0019)A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t=%1\u0014\t\u0006m\nE%QS\u0005\u0004\u0005';(AB(qi&|g\u000eE\u0005w\u0005/\u000b\t,!0\u0002\u0004&\u0019!\u0011T<\u0003\rQ+\b\u000f\\34\u0011%\u0011ijJA\u0001\u0002\u0004\tY/A\u0002yIA\u00121#S:tk\u0016\u0014UO\u001a4feJ+7-Z5wKN\u001cb\u0001K;\u0002\"\u0006\u001d\u0016A\u00052vM\u001a,'OU3dK&4Xm\u0015;bi\u0016,\"Aa*\u0011\t\u0005-\"\u0011V\u0005\u0004\u0005WK'A\u0005\"vM\u001a,'OU3dK&4Xm\u0015;bi\u0016\f1CY;gM\u0016\u0014(+Z2fSZ,7\u000b^1uK\u0002\"BA!-\u00034B\u0019\u0011Q\u001e\u0015\t\u000f\t\r6\u00061\u0001\u0003(R!!\u0011\u0017B\\\u0011%\u0011\u0019\u000b\fI\u0001\u0002\u0004\u00119+\u0006\u0002\u0003<*\"!q\u0015B\u0003)\u0011\u0011YDa0\t\u0013\t\r\u0003'!AA\u0002\tEB\u0003\u0002B-\u0005\u0007D\u0011Ba\u00113\u0003\u0003\u0005\rAa\u000f\u0015\t\te#q\u0019\u0005\n\u0005\u0007*\u0014\u0011!a\u0001\u0005w\t1#S:tk\u0016\u0014UO\u001a4feJ+7-Z5wKN\u00042!!<8'\u00159$qZAT!!\u0011)H!5\u0003(\nE\u0016\u0002\u0002Bj\u0005o\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\u0011Y\r\u0006\u0003\u00032\ne\u0007b\u0002BRu\u0001\u0007!q\u0015\u000b\u0005\u0005;\u0014y\u000eE\u0003w\u0005#\u00139\u000bC\u0005\u0003\u001en\n\t\u00111\u0001\u00032\nI\u0002*\u00198eY\u0016\u0014u.\u001e8dK\n+hMZ3s%\u0016\u001cW-\u001b<f'\u0019aT/!)\u0002(R1!q\u001dBu\u0005W\u00042!!<=\u0011\u001d\ti+\u0011a\u0001\u0003cCqAa)B\u0001\u0004\u00119\u000b\u0006\u0004\u0003h\n=(\u0011\u001f\u0005\n\u0003[\u0013\u0005\u0013!a\u0001\u0003cC\u0011Ba)C!\u0003\u0005\rAa*\u0015\t\tm\"Q\u001f\u0005\n\u0005\u0007:\u0015\u0011!a\u0001\u0005c!BA!\u0017\u0003z\"I!1I%\u0002\u0002\u0003\u0007!1\b\u000b\u0005\u00053\u0012i\u0010C\u0005\u0003D1\u000b\t\u00111\u0001\u0003<\u0005I\u0002*\u00198eY\u0016\u0014u.\u001e8dK\n+hMZ3s%\u0016\u001cW-\u001b<f!\r\tiOT\n\u0006\u001d\u000e\u0015\u0011q\u0015\t\u000b\u0005k\u001a9!!-\u0003(\n\u001d\u0018\u0002BB\u0005\u0005o\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0019\t\u0001\u0006\u0004\u0003h\u000e=1\u0011\u0003\u0005\b\u0003[\u000b\u0006\u0019AAY\u0011\u001d\u0011\u0019+\u0015a\u0001\u0005O#Ba!\u0006\u0004\u001eA)aO!%\u0004\u0018A9ao!\u0007\u00022\n\u001d\u0016bAB\u000eo\n1A+\u001e9mKJB\u0011B!(S\u0003\u0003\u0005\rAa:\u0002\u0011!\fg\u000e\u001a7f\u001fB$Baa\t\u0004*A\u0019ao!\n\n\u0007\r\u001drO\u0001\u0003V]&$\bbBB\u0016'\u0002\u0007!1H\u0001\u0003_B\fA\"Y:z]\u000e|%O\u00117pG.$Baa\t\u00042!911\u0006+A\u0002\tm\u0012!E1ts:\u001cwJ\\\"paf$\u0006N]3bIR!11EB\u001c\u0011\u001d\u0019Y#\u0016a\u0001\u0005w\tq\u0001Z8GKR\u001c\u0007\u000e\u0006\u0004\u0004$\ru2q\b\u0005\b\u0003s3\u0006\u0019AA_\u0011\u001d\u0019\tE\u0016a\u0001\u0003\u0007\u000bq\u0001[1oI2,'/\u0001\re_\"\u000bg\u000e\u001a7f\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016$\u0002ba\t\u0004H\r%31\n\u0005\b\u0003[;\u0006\u0019AAY\u0011\u001d\tIl\u0016a\u0001\u0003{Cqa!\u0011X\u0001\u0004\t\u0019)A\njgN,XMQ;gM\u0016\u0014(+Z2fSZ,7\u000f\u0006\u0003\u0004$\rE\u0003b\u0002BR1\u0002\u0007!qU\u0001\u0014Q\u0006tG\r\\3Ck\u001a4WM\u001d*fG\u0016Lg/\u001a\u000b\u0007\u0007G\u00199f!\u0017\t\u000f\u00055\u0016\f1\u0001\u00022\"9!1U-A\u0002\t\u001d\u0016!\u00063p\u0013N\u001cX/\u001a\"vM\u001a,'OU3dK&4Xm\u001d\u000b\u0005\u0007G\u0019y\u0006C\u0004\u0003$j\u0003\rAa*\u0002'M,g\u000e\u001a+sC:\u001ch-\u001a:SKF,Xm\u001d;\u0015\r\r\r2QMB8\u0011\u001d\u00199g\u0017a\u0001\u0007S\n!!\u001b3\u0011\u0007Y\u001cY'C\u0002\u0004n]\u0014A\u0001T8oO\"91\u0011O.A\u0002\t\u001d\u0016a\u0002;p\u0013N\u001cX/Z\u0001\u0016cV,W/\u001a+sC:\u001ch-\u001a:SKF,Xm\u001d;t)\u0019\u0019\u0019ca\u001e\u0004\b\"91\u0011\u0010/A\u0002\rm\u0014\u0001D7fi\u0006\u0014Vm\u001d9p]N,\u0007\u0003BB?\u0007\u0007k!aa \u000b\u0007\r\u00055.\u0001\u0004g_Jl\u0017\r^\u0005\u0005\u0007\u000b\u001byH\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\"91\u0011\t/A\u0002\u0005\r\u0015!D2b]\u000e,G\u000eU3oI&tw\r\u0006\u0003\u0004$\r5\u0005bBB!;\u0002\u0007\u00111Q\u0001\u001cI>D\u0015M\u001c3mK\n{WO\\2f\u0005V4g-\u001a:SK\u000e,\u0017N^3\u0015\r\r\r21SBK\u0011\u001d\tiK\u0018a\u0001\u0003cCqAa)_\u0001\u0004\u00119+A\u0003ue\u0006\u001c7\u000e\u0006\u0004\u0004\u001c\u000e\u00056q\u0017\t\u0005\u0003\u001f\u0019i*C\u0002\u0004 .\u0014qc\u00155vM\u001adWMU3dK&4X\r\u001a\"vM\u001a,'/\u00133\t\u000f\r\rv\f1\u0001\u0004&\u00061!-\u001e4gKJ\u0004Baa*\u000446\u00111\u0011\u0016\u0006\u0005\u0007W\u001bi+\u0001\u0003dk\u00124'b\u00017\u00040*\u00111\u0011W\u0001\u0003C&LAa!.\u0004*\n\u0011B)\u001a<jG\u0016lU-\\8ss\n+hMZ3s\u0011\u001d\u0019Il\u0018a\u0001\u0007w\u000bA!\\3uCB!1QPB_\u0013\u0011\u0019yla \u0003\u0013Q\u000b'\r\\3NKR\f\u0017!B2m_N,GCAB\u0012\u0003e\u0011XmZ5ti\u0016\u0014\b+Z3s\u000bJ\u0014xN\u001d'jgR,g.\u001a:\u0015\t\r\r2\u0011\u001a\u0005\b\u0007\u0003\n\u0007\u0019AAB\u0003m)hN]3hSN$XM\u001d)fKJ,%O]8s\u0019&\u001cH/\u001a8feR!11EBh\u0011\u001d\u0019\tE\u0019a\u0001\u0003\u0007\u000b1CU1qS\u0012\u001c8\u000b[;gM2,7\t\\5f]R\u00042!a\u000be'\t!W\u000f\u0006\u0002\u0004T\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"a!8+\t\u0005E#QA\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\r\r(\u0006BA-\u0005\u000b\u0001")
public class RapidsShuffleClient
implements Logging,
Arm,
AutoCloseable {
    private volatile RapidsShuffleClient$ShuffleClientOps$ ShuffleClientOps$module;
    private final ClientConnection connection;
    private final RapidsShuffleTransport transport;
    private final Executor exec;
    private final Executor clientCopyExecutor;
    private final RapidsDeviceMemoryStore devStorage;
    private final ShuffleReceivedBufferCatalog catalog;
    private final ConcurrentHashMap.KeySetView<RapidsShuffleFetchHandler, Boolean> liveHandlers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ShuffleReceivedBufferCatalog $lessinit$greater$default$6() {
        return RapidsShuffleClient$.MODULE$.$lessinit$greater$default$6();
    }

    public static RapidsDeviceMemoryStore $lessinit$greater$default$5() {
        return RapidsShuffleClient$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public RapidsShuffleClient$ShuffleClientOps$ ShuffleClientOps() {
        if (this.ShuffleClientOps$module == null) {
            this.ShuffleClientOps$lzycompute$1();
        }
        return this.ShuffleClientOps$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ClientConnection connection() {
        return this.connection;
    }

    private ConcurrentHashMap.KeySetView<RapidsShuffleFetchHandler, Boolean> liveHandlers() {
        return this.liveHandlers;
    }

    private void handleOp(Object op) {
        Object object = op;
        if (object instanceof ShuffleClientOps.HandleMetadataResponse && ((ShuffleClientOps.HandleMetadataResponse)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleClient$ShuffleClientOps$HandleMetadataResponse$$$outer() == this.ShuffleClientOps()) {
            ShuffleClientOps.HandleMetadataResponse handleMetadataResponse = (ShuffleClientOps.HandleMetadataResponse)object;
            Transaction tx = handleMetadataResponse.tx();
            Seq<ShuffleBlockBatchId> shuffleRequests = handleMetadataResponse.shuffleRequests();
            RapidsShuffleFetchHandler rapidsShuffleFetchHandler = handleMetadataResponse.rapidsShuffleFetchHandler();
            this.doHandleMetadataResponse(tx, shuffleRequests, rapidsShuffleFetchHandler);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof ShuffleClientOps.IssueBufferReceives && ((ShuffleClientOps.IssueBufferReceives)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleClient$ShuffleClientOps$IssueBufferReceives$$$outer() == this.ShuffleClientOps()) {
            ShuffleClientOps.IssueBufferReceives issueBufferReceives = (ShuffleClientOps.IssueBufferReceives)object;
            BufferReceiveState bufferReceiveState = issueBufferReceives.bufferReceiveState();
            this.doIssueBufferReceives(bufferReceiveState);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object instanceof ShuffleClientOps.HandleBounceBufferReceive && ((ShuffleClientOps.HandleBounceBufferReceive)object).com$nvidia$spark$rapids$shuffle$RapidsShuffleClient$ShuffleClientOps$HandleBounceBufferReceive$$$outer() == this.ShuffleClientOps()) {
            ShuffleClientOps.HandleBounceBufferReceive handleBounceBufferReceive = (ShuffleClientOps.HandleBounceBufferReceive)object;
            Transaction tx = handleBounceBufferReceive.tx();
            BufferReceiveState bufferReceiveState = handleBounceBufferReceive.bufferReceiveState();
            this.doHandleBounceBufferReceive(tx, bufferReceiveState);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(object);
        }
    }

    private void asyncOrBlock(Object op) {
        this.exec.execute(() -> this.handleOp(op));
    }

    private void asyncOnCopyThread(Object op) {
        this.clientCopyExecutor.execute(() -> this.handleOp(op));
    }

    public void doFetch(Seq<ShuffleBlockBatchId> shuffleRequests, RapidsShuffleFetchHandler handler) {
        try {
            this.withResource(new NvtxRange("Client.fetch", NvtxColor.PURPLE), (Function1 & Serializable & scala.Serializable)x$1 -> {
                Predef$.MODULE$.require(shuffleRequests.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Sending empty blockIds in the MetadataRequest?");
                RefCountedDirectByteBuffer metaReq = new RefCountedDirectByteBuffer(ShuffleMetadata$.MODULE$.buildShuffleMetadataRequest(shuffleRequests), RefCountedDirectByteBuffer$.MODULE$.$lessinit$greater$default$2());
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting block_ids=[").append(shuffleRequests).append("] from connection ").append(this.connection()).append(", req: \n ").append(ShuffleMetadata$.MODULE$.printRequest(ShuffleMetadata$.MODULE$.getMetadataRequest(metaReq.getBuffer()))).toString());
                return this.connection().request(MessageType$.MODULE$.MetadataRequest(), metaReq.acquire(), tx -> this.withResource(metaReq, (Function1 & Serializable & scala.Serializable)x$2 -> {
                    this.asyncOrBlock(new ShuffleClientOps.HandleMetadataResponse(this.ShuffleClientOps(), tx, (Seq<ShuffleBlockBatchId>)shuffleRequests, handler));
                    return BoxedUnit.UNIT;
                }));
            });
        }
        catch (Throwable t) {
            handler.transferError("Error occurred while requesting metadata", t);
        }
    }

    private void doHandleMetadataResponse(Transaction tx, Seq<ShuffleBlockBatchId> shuffleRequests, RapidsShuffleFetchHandler handler) {
        try {
            this.withResource(tx, (Function1 & Serializable & scala.Serializable)x$3 -> {
                RapidsShuffleClient.$anonfun$doHandleMetadataResponse$1(this, tx, handler, x$3);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            handler.transferError(new StringBuilder(43).append("Exception while handling metadata response ").append(tx).toString(), t);
        }
    }

    public void issueBufferReceives(BufferReceiveState bufferReceiveState) {
        this.doIssueBufferReceives(bufferReceiveState);
    }

    public void handleBufferReceive(Transaction tx, BufferReceiveState bufferReceiveState) {
        this.asyncOnCopyThread(new ShuffleClientOps.HandleBounceBufferReceive(this.ShuffleClientOps(), tx, bufferReceiveState));
    }

    public void doIssueBufferReceives(BufferReceiveState bufferReceiveState) {
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Adding ").append(this.connection().getPeerExecutorId()).append(" BRS ").append(TransportUtils$.MODULE$.toHex(bufferReceiveState.id())).toString());
            this.sendTransferRequest(bufferReceiveState.id(), bufferReceiveState);
        }
        catch (Throwable t) {
            this.withResource(bufferReceiveState, (Function1 & Serializable & scala.Serializable)x$5 -> {
                bufferReceiveState.errorOccurred("Error issuing buffer receives", t);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void sendTransferRequest(long id, BufferReceiveState toIssue) {
        Seq<PendingTransferRequest> requestsToIssue = toIssue.getRequests();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending a transfer request for ").append(TransportUtils$.MODULE$.toHex(toIssue.id())).toString());
        RefCountedDirectByteBuffer transferReq = new RefCountedDirectByteBuffer(ShuffleMetadata$.MODULE$.buildTransferRequest(id, (Seq<Object>)((Seq)requestsToIssue.map((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToInteger((int)RapidsShuffleClient.$anonfun$sendTransferRequest$2(i)), Seq$.MODULE$.canBuildFrom()))), RefCountedDirectByteBuffer$.MODULE$.$lessinit$greater$default$2());
        this.connection().request(MessageType$.MODULE$.TransferRequest(), transferReq.acquire(), x$6 -> this.withResource(x$6, (Function1 & Serializable & scala.Serializable)tx -> {
            this.withResource(transferReq, (Function1 & Serializable & scala.Serializable)x$7 -> {
                RapidsShuffleClient.$anonfun$sendTransferRequest$5($this, tx, toIssue$1, x$7);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }));
    }

    private void queueTransferRequests(MetadataResponse metaResponse, RapidsShuffleFetchHandler handler) {
        block0: {
            int allTables = metaResponse.tableMetasLength();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Queueing transfer requests for ").append(allTables).append(" tables ").append("from ").append(this.connection().getPeerExecutorId()).toString());
            ArrayBuffer ptrs = new ArrayBuffer(allTables);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), allTables).foreach((Function1 & Serializable & scala.Serializable)i -> RapidsShuffleClient.$anonfun$queueTransferRequests$2(this, metaResponse, ptrs, handler, BoxesRunTime.unboxToInt((Object)i)));
            if (!ptrs.nonEmpty()) break block0;
            this.transport.queuePending((Seq<PendingTransferRequest>)ptrs);
        }
    }

    public void cancelPending(RapidsShuffleFetchHandler handler) {
        this.transport.cancelPending(handler);
    }

    public void doHandleBounceBufferReceive(Transaction tx, BufferReceiveState bufferReceiveState) {
        try {
            this.withResource(tx, (Function1 & Serializable & scala.Serializable)x$8 -> {
                RapidsShuffleClient.$anonfun$doHandleBounceBufferReceive$1(this, tx, bufferReceiveState, x$8);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.withResource(bufferReceiveState, (Function1 & Serializable & scala.Serializable)x$10 -> {
                bufferReceiveState.errorOccurred(new StringBuilder(45).append("Error while handling buffer receive for BRS: ").append(TransportUtils$.MODULE$.toHex(bufferReceiveState.id())).toString(), t);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public ShuffleReceivedBufferId track(DeviceMemoryBuffer buffer, TableMeta meta) {
        void var3_3;
        ShuffleReceivedBufferId id = this.catalog.nextShuffleReceivedBufferId();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Adding buffer id ").append(id).append(" to catalog").toString());
        if (buffer != null) {
            ShuffleReceivedBufferId x$1 = id;
            DeviceMemoryBuffer x$2 = buffer;
            TableMeta x$3 = meta;
            long x$4 = SpillPriorities$.MODULE$.INPUT_FROM_SHUFFLE_PRIORITY();
            boolean x$5 = false;
            SpillCallback x$6 = this.devStorage.addBuffer$default$5();
            this.devStorage.addBuffer(x$1, x$2, x$3, x$4, x$6, x$5);
        } else {
            this.catalog.registerNewBuffer(new DegenerateRapidsBuffer(id, meta));
        }
        return var3_3;
    }

    @Override
    public void close() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing pending requests for ").append(this.connection().getPeerExecutorId()).toString());
        this.liveHandlers().forEach(handler -> {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Signaling ").append(handler).append(" that ").append(this.connection().getPeerExecutorId()).append(" errored").toString());
            handler.transferError(new StringBuilder(21).append("Connection to ").append(this.connection().getPeerExecutorId()).append(" closed").toString(), handler.transferError$default$2());
        });
        this.liveHandlers().clear();
    }

    public void registerPeerErrorListener(RapidsShuffleFetchHandler handler) {
        this.liveHandlers().add(handler);
    }

    public void unregisterPeerErrorListener(RapidsShuffleFetchHandler handler) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Unregister ").append(handler).append(" from client for ").append(this.connection().getPeerExecutorId()).toString());
        this.liveHandlers().remove(handler);
    }

    private final void ShuffleClientOps$lzycompute$1() {
        RapidsShuffleClient rapidsShuffleClient = this;
        synchronized (rapidsShuffleClient) {
            if (this.ShuffleClientOps$module == null) {
                this.ShuffleClientOps$module = new RapidsShuffleClient$ShuffleClientOps$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleMetadataResponse$3(RapidsShuffleClient $this, MetadataTransportBuffer resp$1, Transaction tx$2, RapidsShuffleFetchHandler handler$2, NvtxRange x$4) {
        try {
            MetadataResponse metadataResponse = ShuffleMetadata$.MODULE$.getMetadataResponse(resp$1.getBuffer());
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Received from ").append(tx$2).append(" response: \n:").append(ShuffleMetadata$.MODULE$.printResponse("received response", metadataResponse)).toString());
            handler$2.start(metadataResponse.tableMetasLength());
            $this.queueTransferRequests(metadataResponse, handler$2);
        }
        catch (Throwable t) {
            handler$2.transferError("Error occurred while handling metadata", t);
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleMetadataResponse$1(RapidsShuffleClient $this, Transaction tx$2, RapidsShuffleFetchHandler handler$2, Transaction x$3) {
        Enumeration.Value value = tx$2.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Success();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit = (BoxedUnit)$this.withResource(tx$2.releaseMessage(), (Function1 & Serializable & scala.Serializable)resp -> {
                $this.withResource(new NvtxRange("Client.handleMeta", NvtxColor.CYAN), (Function1 & Serializable & scala.Serializable)x$4 -> {
                    RapidsShuffleClient.$anonfun$doHandleMetadataResponse$3($this, resp, tx$2, handler$2, x$4);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
        } else {
            handler$2.transferError((String)tx$2.getErrorMessage().getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Unsuccessful metadata request ").append(tx$2).toString()), handler$2.transferError$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ int $anonfun$sendTransferRequest$2(PendingTransferRequest i) {
        return i.tableMeta().bufferMeta().id();
    }

    public static final /* synthetic */ void $anonfun$sendTransferRequest$6(MetadataTransportBuffer mtb) {
        TransferResponse transferResponse = ShuffleMetadata$.MODULE$.getTransferResponse(mtb.getBuffer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), transferResponse.responsesLength()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)r -> {
            BufferTransferResponse response = transferResponse.responses(r);
            if (response.state() != 0) {
                throw new IllegalStateException("NOT IMPLEMENTED");
            }
        });
    }

    public static final /* synthetic */ void $anonfun$sendTransferRequest$5(RapidsShuffleClient $this, Transaction tx$3, BufferReceiveState toIssue$1, RefCountedDirectByteBuffer x$7) {
        Enumeration.Value value = tx$3.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Success();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit = (BoxedUnit)$this.withResource(tx$3.releaseMessage(), (Function1 & Serializable & scala.Serializable)mtb -> {
                RapidsShuffleClient.$anonfun$sendTransferRequest$6(mtb);
                return BoxedUnit.UNIT;
            });
        } else {
            toIssue$1.errorOccurred((String)tx$3.getErrorMessage().getOrElse((Function0 & Serializable & scala.Serializable)() -> "TransferRequest failed"), toIssue$1.errorOccurred$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ Object $anonfun$queueTransferRequests$2(RapidsShuffleClient $this, MetadataResponse metaResponse$1, ArrayBuffer ptrs$1, RapidsShuffleFetchHandler handler$3, int i) {
        TableMeta tableMeta = ShuffleMetadata$.MODULE$.copyTableMetaToHeap(metaResponse$1.tableMetas(i));
        return tableMeta.bufferMeta() != null ? ptrs$1.$plus$eq((Object)new PendingTransferRequest($this, tableMeta, handler$3)) : BoxesRunTime.boxToBoolean((boolean)handler$3.batchReceived($this.track(null, tableMeta)));
    }

    public static final /* synthetic */ void $anonfun$doHandleBounceBufferReceive$3(RapidsShuffleClient $this, IntRef numBatchesRejected$1, ConsumedBatchFromBounceBuffer consumed) {
        ShuffleReceivedBufferId bId = $this.track(consumed.contigBuffer(), consumed.meta());
        if (!consumed.handler().batchReceived(bId)) {
            $this.catalog.removeBuffer(bId);
            ++numBatchesRejected$1.elem;
        }
        $this.transport.doneBytesInFlight(consumed.contigBuffer().getLength());
    }

    public static final /* synthetic */ void $anonfun$doHandleBounceBufferReceive$2(RapidsShuffleClient $this, BufferReceiveState bufferReceiveState$2, NvtxRange x$9) {
        Seq<ConsumedBatchFromBounceBuffer> buffMetas = bufferReceiveState$2.consumeWindow();
        IntRef numBatchesRejected = IntRef.create((int)0);
        buffMetas.foreach((Function1 & Serializable & scala.Serializable)consumed -> {
            RapidsShuffleClient.$anonfun$doHandleBounceBufferReceive$3($this, numBatchesRejected, consumed);
            return BoxedUnit.UNIT;
        });
        if (numBatchesRejected.elem > 0) {
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Removed ").append(numBatchesRejected$1.elem).append(" batches that were received after ").append("tasks completed.").toString());
        }
        if (!bufferReceiveState$2.hasMoreBlocks()) {
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("BufferReceiveState: ").append(TransportUtils$.MODULE$.toHex(bufferReceiveState$2.id())).append(" is DONE, closing.").toString());
            bufferReceiveState$2.close();
        } else {
            $this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("BufferReceiveState: ").append(TransportUtils$.MODULE$.toHex(bufferReceiveState$2.id())).append(" is NOT done, continuing.").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$doHandleBounceBufferReceive$1(RapidsShuffleClient $this, Transaction tx$4, BufferReceiveState bufferReceiveState$2, Transaction x$8) {
        Enumeration.Value value = tx$4.getStatus();
        Enumeration.Value value2 = TransactionStatus$.MODULE$.Success();
        Enumeration.Value value3 = value;
        if (value2 != null ? !value2.equals(value3) : value3 != null) {
            Enumeration.Value value4 = TransactionStatus$.MODULE$.Error();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                throw new IllegalStateException(new StringBuilder(25).append("Transaction errored with ").append(tx$4.getErrorMessage()).toString());
            }
            Enumeration.Value value6 = TransactionStatus$.MODULE$.Cancelled();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                throw new IllegalStateException("Transaction cancelled");
            }
            throw new MatchError((Object)value);
        }
        BoxedUnit boxedUnit = (BoxedUnit)$this.withResource(new NvtxRange("Buffer Callback", NvtxColor.RED), (Function1 & Serializable & scala.Serializable)x$9 -> {
            RapidsShuffleClient.$anonfun$doHandleBounceBufferReceive$2($this, bufferReceiveState$2, x$9);
            return BoxedUnit.UNIT;
        });
    }

    public RapidsShuffleClient(ClientConnection connection, RapidsShuffleTransport transport, Executor exec, Executor clientCopyExecutor, RapidsDeviceMemoryStore devStorage, ShuffleReceivedBufferCatalog catalog) {
        this.connection = connection;
        this.transport = transport;
        this.exec = exec;
        this.clientCopyExecutor = clientCopyExecutor;
        this.devStorage = devStorage;
        this.catalog = catalog;
        Logging.$init$((Logging)this);
        Arm.$init$(this);
        this.liveHandlers = ConcurrentHashMap.newKeySet();
    }
}

