/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark.source;

import com.nvidia.spark.rapids.RapidsConf;
import com.nvidia.spark.rapids.iceberg.spark.SparkReadConf;
import com.nvidia.spark.rapids.iceberg.spark.source.GpuSparkScan;
import java.util.List;
import java.util.Objects;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.util.SerializableConfiguration;

public class SparkBatch
implements Batch {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final List<CombinedScanTask> tasks;
    private final Schema expectedSchema;
    private final boolean caseSensitive;
    private final boolean localityEnabled;
    private final RapidsConf rapidsConf;
    private final GpuSparkScan parentScan;

    SparkBatch(JavaSparkContext sparkContext, Table table, SparkReadConf readConf, List<CombinedScanTask> tasks, Schema expectedSchema, RapidsConf rapidsConf, GpuSparkScan parentScan) {
        this.sparkContext = sparkContext;
        this.table = table;
        this.tasks = tasks;
        this.expectedSchema = expectedSchema;
        this.caseSensitive = readConf.caseSensitive();
        this.localityEnabled = readConf.localityEnabled();
        this.rapidsConf = rapidsConf;
        this.parentScan = parentScan;
    }

    public InputPartition[] planInputPartitions() {
        Broadcast tableBroadcast = this.sparkContext.broadcast((Object)SerializableTable.copyOf((Table)this.table));
        Broadcast confBroadcast = this.sparkContext.broadcast((Object)new SerializableConfiguration(this.sparkContext.hadoopConfiguration()));
        String expectedSchemaString = SchemaParser.toJson((Schema)this.expectedSchema);
        InputPartition[] readTasks = new InputPartition[this.tasks.size()];
        Tasks.range((int)readTasks.length).stopOnFailure().executeWith(this.localityEnabled ? ThreadPools.getWorkerPool() : null).run(index -> {
            readTasks[index.intValue()] = new GpuSparkScan.ReadTask(this.tasks.get((int)index), (Broadcast<Table>)tableBroadcast, expectedSchemaString, this.caseSensitive, this.localityEnabled, this.rapidsConf, (Broadcast<SerializableConfiguration>)confBroadcast);
        });
        return readTasks;
    }

    public PartitionReaderFactory createReaderFactory() {
        return new GpuSparkScan.ReaderFactory(this.parentScan.metrics());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SparkBatch that = (SparkBatch)o;
        return this.parentScan.equals(that.parentScan);
    }

    public int hashCode() {
        return Objects.hash(this.parentScan);
    }
}

