/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark.source;

import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.iceberg.data.GpuDeleteFilter;
import com.nvidia.spark.rapids.iceberg.parquet.GpuParquet;
import com.nvidia.spark.rapids.iceberg.spark.source.BaseDataReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.spark.rdd.InputFileBlockHolder;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.collection.immutable.Map;

class GpuBatchDataReader
extends BaseDataReader<ColumnarBatch> {
    private final Schema expectedSchema;
    private final String nameMapping;
    private final boolean caseSensitive;
    private final Configuration conf;
    private final int maxBatchSizeRows;
    private final long maxBatchSizeBytes;
    private final String parquetDebugDumpPrefix;
    private final Map<String, GpuMetric> metrics;

    GpuBatchDataReader(CombinedScanTask task, Table table, Schema expectedSchema, boolean caseSensitive, Configuration conf, int maxBatchSizeRows, long maxBatchSizeBytes, String parquetDebugDumpPrefix, Map<String, GpuMetric> metrics) {
        super(table, task);
        this.expectedSchema = expectedSchema;
        this.nameMapping = (String)table.properties().get("schema.name-mapping.default");
        this.caseSensitive = caseSensitive;
        this.conf = conf;
        this.maxBatchSizeRows = maxBatchSizeRows;
        this.maxBatchSizeBytes = maxBatchSizeBytes;
        this.parquetDebugDumpPrefix = parquetDebugDumpPrefix;
        this.metrics = metrics;
    }

    @Override
    CloseableIterator<ColumnarBatch> open(FileScanTask task) {
        GpuParquet.ReadBuilder builder;
        DataFile file = task.file();
        InputFileBlockHolder.set((String)file.path().toString(), (long)task.start(), (long)task.length());
        java.util.Map<Integer, ?> idToConstant = this.constantsMap(task, this.expectedSchema);
        InputFile location = this.getInputFile(task);
        Preconditions.checkNotNull((Object)location, (Object)"Could not find InputFile associated with FileScanTask");
        if (task.file().format() == FileFormat.PARQUET) {
            GpuDeleteFilter deleteFilter = this.deleteFilter(task);
            Schema requiredSchema = this.requiredSchema(deleteFilter);
            builder = GpuParquet.read(location).project(requiredSchema).split(task.start(), task.length()).constants(idToConstant).deleteFilter(deleteFilter).filter(task.residual()).caseSensitive(this.caseSensitive).withConfiguration(this.conf).withMaxBatchSizeRows(this.maxBatchSizeRows).withMaxBatchSizeBytes(this.maxBatchSizeBytes).withDebugDumpPrefix(this.parquetDebugDumpPrefix).withMetrics(this.metrics);
            if (this.nameMapping != null) {
                builder.withNameMapping(NameMappingParser.fromJson((String)this.nameMapping));
            }
        } else {
            throw new UnsupportedOperationException("Format: " + task.file().format() + " not supported for batched reads");
        }
        CloseableIterable<ColumnarBatch> iter = builder.build();
        return iter.iterator();
    }

    private GpuDeleteFilter deleteFilter(FileScanTask task) {
        if (task.deletes().isEmpty()) {
            return null;
        }
        return new GpuDeleteFilter(task.file().path().toString(), task.deletes(), this.table().schema(), this.expectedSchema);
    }

    private Schema requiredSchema(GpuDeleteFilter deleteFilter) {
        if (deleteFilter != null && deleteFilter.hasEqDeletes()) {
            return deleteFilter.requiredSchema();
        }
        return this.expectedSchema;
    }
}

