/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.spark;

import org.apache.iceberg.Schema;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

public class SparkUtil {
    public static final String TIMESTAMP_WITHOUT_TIMEZONE_ERROR = String.format("Cannot handle timestamp without timezone fields in Spark. Spark does not natively support this type but if you would like to handle all timestamps as timestamp with timezone set '%s' to true. This will not change the underlying values stored but will change their displayed values in Spark. For more information please see https://docs.databricks.com/spark/latest/dataframes-datasets/dates-timestamps.html#ansi-sql-and-spark-sql-timestamps", "spark.sql.iceberg.handle-timestamp-without-timezone");

    private SparkUtil() {
    }

    public static boolean hasTimestampWithoutZone(Schema schema) {
        return TypeUtil.find((Schema)schema, t -> Types.TimestampType.withoutZone().equals(t)) != null;
    }
}

