/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids.iceberg.parquet;

import com.nvidia.spark.rapids.iceberg.parquet.ApplyNameMapping;
import com.nvidia.spark.rapids.iceberg.parquet.ParquetTypeVisitor;
import java.util.List;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetSchemaUtil {
    private ParquetSchemaUtil() {
    }

    public static boolean hasIds(MessageType fileSchema) {
        return ParquetTypeVisitor.visit((Type)fileSchema, new HasIds());
    }

    public static MessageType addFallbackIds(MessageType fileSchema) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        int ordinal = 1;
        for (Type type : fileSchema.getFields()) {
            builder.addField(type.withId(ordinal));
            ++ordinal;
        }
        return builder.named(fileSchema.getName());
    }

    public static MessageType applyNameMapping(MessageType fileSchema, NameMapping nameMapping) {
        return (MessageType)ParquetTypeVisitor.visit((Type)fileSchema, new ApplyNameMapping(nameMapping));
    }

    public static Type determineListElementType(GroupType array) {
        Type repeated = (Type)array.getFields().get(0);
        boolean isOldListElementType = ParquetSchemaUtil.isOldListElementType(array);
        return isOldListElementType ? repeated : repeated.asGroupType().getType(0);
    }

    static boolean isOldListElementType(GroupType list) {
        Type repeatedType = (Type)list.getFields().get(0);
        String parentName = list.getName();
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple");
    }

    public static class HasIds
    extends ParquetTypeVisitor<Boolean> {
        @Override
        public Boolean message(MessageType message, List<Boolean> fields) {
            return this.struct((GroupType)message, (List)fields);
        }

        @Override
        public Boolean struct(GroupType struct, List<Boolean> hasIds) {
            for (Boolean hasId : hasIds) {
                if (!hasId.booleanValue()) continue;
                return true;
            }
            return struct.getId() != null;
        }

        @Override
        public Boolean list(GroupType array, Boolean hasId) {
            return hasId != false || array.getId() != null;
        }

        @Override
        public Boolean map(GroupType map, Boolean keyHasId, Boolean valueHasId) {
            return keyHasId != false || valueHasId != false || map.getId() != null;
        }

        @Override
        public Boolean primitive(PrimitiveType primitive) {
            return primitive.getId() != null;
        }
    }
}

