/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVectorCore;
import java.math.BigDecimal;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class RapidsHostColumnVectorCore
extends ColumnVector {
    private final HostColumnVectorCore cudfCv;
    private final RapidsHostColumnVectorCore[] cachedChildren;

    RapidsHostColumnVectorCore(DataType type, HostColumnVectorCore cudfCv) {
        super(type);
        this.cudfCv = cudfCv;
        this.cachedChildren = type instanceof MapType ? new RapidsHostColumnVectorCore[2] : new RapidsHostColumnVectorCore[cudfCv.getNumChildren()];
    }

    public final void close() {
        for (int i = 0; i < this.cachedChildren.length; ++i) {
            RapidsHostColumnVectorCore cv = this.cachedChildren[i];
            if (cv == null) continue;
            cv.close();
            this.cachedChildren[i] = null;
        }
        this.cudfCv.close();
    }

    public final boolean hasNull() {
        return this.cudfCv.hasNulls();
    }

    public final int numNulls() {
        return (int)this.cudfCv.getNullCount();
    }

    public final boolean isNullAt(int rowId) {
        return this.cudfCv.isNull((long)rowId);
    }

    public final boolean getBoolean(int rowId) {
        return this.cudfCv.getBoolean((long)rowId);
    }

    public final byte getByte(int rowId) {
        return this.cudfCv.getByte((long)rowId);
    }

    public final short getShort(int rowId) {
        return this.cudfCv.getShort((long)rowId);
    }

    public final int getInt(int rowId) {
        return this.cudfCv.getInt((long)rowId);
    }

    public final long getLong(int rowId) {
        return this.cudfCv.getLong((long)rowId);
    }

    public final float getFloat(int rowId) {
        return this.cudfCv.getFloat((long)rowId);
    }

    public final double getDouble(int rowId) {
        return this.cudfCv.getDouble((long)rowId);
    }

    public final ColumnarArray getArray(int rowId) {
        if (this.cachedChildren[0] == null) {
            ArrayType at = (ArrayType)this.dataType();
            HostColumnVectorCore data = this.cudfCv.getChildColumnView(0);
            this.cachedChildren[0] = new RapidsHostColumnVectorCore(at.elementType(), data);
        }
        RapidsHostColumnVectorCore data = this.cachedChildren[0];
        int startOffset = (int)this.cudfCv.getStartListOffset((long)rowId);
        int endOffset = (int)this.cudfCv.getEndListOffset((long)rowId);
        return new ColumnarArray((ColumnVector)data, startOffset, endOffset - startOffset);
    }

    public final ColumnarMap getMap(int ordinal) {
        if (this.cachedChildren[0] == null) {
            MapType mt = (MapType)this.dataType();
            HostColumnVectorCore structHcv = this.cudfCv.getChildColumnView(0);
            HostColumnVectorCore firstHcvCore = structHcv.getChildColumnView(0);
            HostColumnVectorCore secondHcvCore = structHcv.getChildColumnView(1);
            this.cachedChildren[0] = new RapidsHostColumnVectorCore(mt.keyType(), firstHcvCore);
            this.cachedChildren[1] = new RapidsHostColumnVectorCore(mt.valueType(), secondHcvCore);
        }
        RapidsHostColumnVectorCore keys = this.cachedChildren[0];
        RapidsHostColumnVectorCore values = this.cachedChildren[1];
        int startOffset = (int)this.cudfCv.getStartListOffset((long)ordinal);
        int endOffset = (int)this.cudfCv.getEndListOffset((long)ordinal);
        return new ColumnarMap((ColumnVector)keys, (ColumnVector)values, startOffset, endOffset - startOffset);
    }

    public final Decimal getDecimal(int rowId, int precision, int scale) {
        assert (precision <= 38) : "Assert " + precision + " <= DECIMAL128_MAX_PRECISION(" + 38 + ")";
        assert (scale == -this.cudfCv.getType().getScale()) : "Assert fetch decimal with its original scale " + scale + " expected " + -this.cudfCv.getType().getScale();
        if (precision <= Decimal.MAX_INT_DIGITS()) {
            assert (this.cudfCv.getType().getTypeId() == DType.DTypeEnum.DECIMAL32) : "type should be DECIMAL32";
            return Decimal.createUnsafe((long)this.cudfCv.getInt((long)rowId), (int)precision, (int)scale);
        }
        if (precision <= Decimal.MAX_LONG_DIGITS()) {
            assert (this.cudfCv.getType().getTypeId() == DType.DTypeEnum.DECIMAL64) : "type should be DECIMAL64";
            return Decimal.createUnsafe((long)this.cudfCv.getLong((long)rowId), (int)precision, (int)scale);
        }
        assert (this.cudfCv.getType().getTypeId() == DType.DTypeEnum.DECIMAL128) : "type should be DECIMAL128";
        return Decimal.fromDecimal((Object)new BigDecimal(this.cudfCv.getBigDecimal((long)rowId).unscaledValue(), scale));
    }

    public final UTF8String getUTF8String(int rowId) {
        return UTF8String.fromBytes((byte[])this.cudfCv.getUTF8((long)rowId));
    }

    public final byte[] getBinary(int rowId) {
        Object data;
        if (this.cachedChildren[0] == null) {
            data = this.cudfCv.getChildColumnView(0);
            this.cachedChildren[0] = new RapidsHostColumnVectorCore(DataTypes.ByteType, (HostColumnVectorCore)data);
        }
        data = this.cachedChildren[0];
        int startOffset = (int)this.cudfCv.getStartListOffset((long)rowId);
        int endOffset = (int)this.cudfCv.getEndListOffset((long)rowId);
        return new ColumnarArray((ColumnVector)data, startOffset, endOffset - startOffset).toByteArray();
    }

    public final ColumnVector getChild(int ordinal) {
        if (this.cachedChildren[ordinal] == null) {
            StructType st = (StructType)this.dataType();
            StructField[] fields = st.fields();
            for (int i = 0; i < fields.length; ++i) {
                HostColumnVectorCore tmp = this.cudfCv.getChildColumnView(i);
                this.cachedChildren[i] = new RapidsHostColumnVectorCore(fields[i].dataType(), tmp);
            }
        }
        return this.cachedChildren[ordinal];
    }

    public HostColumnVectorCore getBase() {
        return this.cudfCv;
    }

    public final long getRowCount() {
        return this.cudfCv.getRowCount();
    }
}

