/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.OrcPartitionReaderContext;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.shims.OrcShims$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.CompressionKind;
import org.apache.orc.DataReader;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcUtils;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.RecordReaderUtils;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;

public final class OrcTools$
implements Arm {
    public static OrcTools$ MODULE$;

    static {
        new OrcTools$();
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public DataReader buildDataReader(OrcPartitionReaderContext ctx) {
        FileSystem fs = ctx.filePath().getFileSystem(ctx.conf());
        return this.buildDataReader(ctx.compressionSize(), ctx.compressionKind(), ctx.fileSchema(), ctx.readerOpts(), ctx.filePath(), fs, ctx.conf());
    }

    public DataReader buildDataReader(int compressionSize, CompressionKind compressionKind, TypeDescription fileSchema, Reader.Options readerOpts, Path filePath, FileSystem fs, Configuration conf) {
        DataReader dataReader;
        if (readerOpts.getDataReader() != null) {
            dataReader = readerOpts.getDataReader();
        } else {
            boolean zeroCopy = readerOpts.getUseZeroCopy() != null ? Predef$.MODULE$.Boolean2boolean(readerOpts.getUseZeroCopy()) : OrcConf.USE_ZEROCOPY.getBoolean(conf);
            int maxDiskRangeChunkLimit = OrcConf.ORC_MAX_DISK_RANGE_CHUNK_LIMIT.getInt(conf);
            FSDataInputStream file = filePath.getFileSystem(conf).open(filePath);
            int typeCount = OrcUtils.getOrcTypes(fileSchema).size();
            DataReader reader = RecordReaderUtils.createDefaultDataReader(OrcShims$.MODULE$.newDataReaderPropertiesBuilder(compressionSize, compressionKind, typeCount).withFileSystem(fs).withPath(filePath).withZeroCopy(zeroCopy).withMaxDiskRangeChunkLimit(maxDiskRangeChunkLimit).build());
            reader.open();
            dataReader = reader;
        }
        return dataReader;
    }

    private OrcTools$() {
        MODULE$ = this;
        Arm.$init$(this);
    }
}

