/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ArrowColumnBuilder;
import ai.rapids.cudf.HostColumnVector;
import com.nvidia.spark.rapids.CoalesceSizeGoal;
import com.nvidia.spark.rapids.ColumnarCopyHelper;
import com.nvidia.spark.rapids.HostColumnarToGpu;
import com.nvidia.spark.rapids.ShimLoader$;
import com.nvidia.spark.rapids.shims.GpuTypeShims$;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.ReferenceManager;
import org.apache.arrow.vector.ValueVector;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.vectorized.ArrowColumnVector;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.rapids.AccessibleArrowColumnVector;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HostColumnarToGpu$
implements Logging,
scala.Serializable {
    public static HostColumnarToGpu$ MODULE$;
    private Field accessorField;
    private Field vecField;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new HostColumnarToGpu$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Field getClassFieldAccessible(String className, String fieldName) {
        Class<?> classObj = ShimLoader$.MODULE$.loadClass(className);
        List fields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])classObj.getDeclaredFields())).toList();
        Field field = (Field)((IterableLike)fields.filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HostColumnarToGpu$.$anonfun$getClassFieldAccessible$1(fieldName, x)))).head();
        field.setAccessible(true);
        return field;
    }

    private Field accessorField$lzycompute() {
        HostColumnarToGpu$ hostColumnarToGpu$ = this;
        synchronized (hostColumnarToGpu$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accessorField = this.getClassFieldAccessible("org.apache.spark.sql.vectorized.ArrowColumnVector", "accessor");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.accessorField;
    }

    private Field accessorField() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accessorField$lzycompute() : this.accessorField;
    }

    private Field vecField$lzycompute() {
        HostColumnarToGpu$ hostColumnarToGpu$ = this;
        synchronized (hostColumnarToGpu$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.vecField = this.getClassFieldAccessible("org.apache.spark.sql.vectorized.ArrowColumnVector$ArrowVectorAccessor", "vector");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.vecField;
    }

    private Field vecField() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.vecField$lzycompute() : this.vecField;
    }

    private ValueVector getArrowValueVector(ColumnVector cv) {
        ArrowColumnVector arrowCV = (ArrowColumnVector)cv;
        Object accessor = this.accessorField().get(arrowCV);
        return (ValueVector)this.vecField().get(accessor);
    }

    public java.util.List<ReferenceManager> arrowColumnarCopy(ColumnVector cv, ArrowColumnBuilder ab, int rows) {
        ValueVector valueVector;
        ColumnVector columnVector = cv;
        if (columnVector instanceof ArrowColumnVector) {
            ValueVector valueVector2;
            ArrowColumnVector arrowColumnVector = (ArrowColumnVector)columnVector;
            try {
                valueVector2 = this.getArrowValueVector((ColumnVector)arrowColumnVector);
            }
            catch (Exception e) {
                throw new IllegalStateException("Trying to read from a ArrowColumnVector but can't access its Arrow ValueVector", e);
            }
            valueVector = valueVector2;
        } else if (columnVector instanceof AccessibleArrowColumnVector) {
            AccessibleArrowColumnVector accessibleArrowColumnVector = (AccessibleArrowColumnVector)columnVector;
            valueVector = accessibleArrowColumnVector.getArrowValueVector();
        } else {
            throw new IllegalStateException(new StringBuilder(28).append("Illegal column vector type: ").append(cv.getClass()).toString());
        }
        ValueVector valVector = valueVector;
        ListBuffer referenceManagers = new ListBuffer();
        int nullCount = valVector.getNullCount();
        ByteBuffer dataBuf = HostColumnarToGpu$.getBufferAndAddReference$1(valVector.getDataBuffer(), referenceManagers);
        ByteBuffer validity = HostColumnarToGpu$.getBufferAndAddReference$1(valVector.getValidityBuffer(), referenceManagers);
        ByteBuffer offsets = null;
        try {
            offsets = HostColumnarToGpu$.getBufferAndAddReference$1(valVector.getOffsetBuffer(), referenceManagers);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        ab.addBatch((long)rows, (long)nullCount, dataBuf, validity, offsets);
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)referenceManagers.result()).asJava();
    }

    public void columnarCopy(ColumnVector cv, HostColumnVector.ColumnBuilder b, int rows) {
        DataType dataType = cv.dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            ColumnarCopyHelper.nullCopy(b, rows);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType) && cv instanceof ArrowColumnVector) {
            ColumnarCopyHelper.booleanCopy(cv, b, rows);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = ByteType$.MODULE$.equals(dataType) ? true : BooleanType$.MODULE$.equals(dataType);
            if (bl) {
                ColumnarCopyHelper.byteCopy(cv, b, rows);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (ShortType$.MODULE$.equals(dataType)) {
                ColumnarCopyHelper.shortCopy(cv, b, rows);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
                if (bl2) {
                    ColumnarCopyHelper.intCopy(cv, b, rows);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    boolean bl3 = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                    if (bl3) {
                        ColumnarCopyHelper.longCopy(cv, b, rows);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (FloatType$.MODULE$.equals(dataType)) {
                        ColumnarCopyHelper.floatCopy(cv, b, rows);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (DoubleType$.MODULE$.equals(dataType)) {
                        ColumnarCopyHelper.doubleCopy(cv, b, rows);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (StringType$.MODULE$.equals(dataType)) {
                        ColumnarCopyHelper.stringCopy(cv, b, rows);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (dataType instanceof DecimalType) {
                        DecimalType decimalType = (DecimalType)dataType;
                        ColumnVector columnVector = cv;
                        if (columnVector instanceof WritableColumnVector) {
                            BoxedUnit boxedUnit;
                            WritableColumnVector writableColumnVector = (WritableColumnVector)columnVector;
                            if (DecimalType$.MODULE$.is32BitDecimalType((DataType)decimalType)) {
                                ColumnarCopyHelper.decimal32Copy(writableColumnVector, b, rows);
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (DecimalType$.MODULE$.is64BitDecimalType((DataType)decimalType)) {
                                ColumnarCopyHelper.decimal64Copy(writableColumnVector, b, rows);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                ColumnarCopyHelper.decimal128Copy(writableColumnVector, b, rows);
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        } else {
                            BoxedUnit boxedUnit;
                            if (DecimalType$.MODULE$.is32BitDecimalType((DataType)decimalType)) {
                                ColumnarCopyHelper.decimal32Copy(cv, b, rows, decimalType.precision(), decimalType.scale());
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (DecimalType$.MODULE$.is64BitDecimalType((DataType)decimalType)) {
                                ColumnarCopyHelper.decimal64Copy(cv, b, rows, decimalType.precision(), decimalType.scale());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                ColumnarCopyHelper.decimal128Copy(cv, b, rows, decimalType.precision(), decimalType.scale());
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit3 = boxedUnit;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (GpuTypeShims$.MODULE$.isColumnarCopySupportedForType(dataType)) {
                        GpuTypeShims$.MODULE$.columnarCopy(cv, b, rows);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new UnsupportedOperationException(new StringBuilder(49).append("Converting to GPU for ").append(dataType).append(" is not currently supported").toString());
                    }
                }
            }
        }
    }

    public HostColumnarToGpu apply(SparkPlan child, CoalesceSizeGoal goal) {
        return new HostColumnarToGpu(child, goal);
    }

    public Option<Tuple2<SparkPlan, CoalesceSizeGoal>> unapply(HostColumnarToGpu x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.child(), (Object)x$0.goal()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getClassFieldAccessible$1(String fieldName$1, Field x) {
        return x.getName().contains(fieldName$1);
    }

    private static final ByteBuffer getBufferAndAddReference$1(ArrowBuf buf, ListBuffer referenceManagers$1) {
        referenceManagers$1.$plus$eq((Object)buf.getReferenceManager());
        return buf.nioBuffer();
    }

    private HostColumnarToGpu$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

