/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.BinaryOperable;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.NvtxColor;
import ai.rapids.cudf.NvtxRange;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.Table;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.DateUtils$;
import com.nvidia.spark.rapids.GpuCast$;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuMetric;
import com.nvidia.spark.rapids.GpuMetric$;
import com.nvidia.spark.rapids.GpuOverrides$;
import com.nvidia.spark.rapids.GpuSemaphore$;
import com.nvidia.spark.rapids.GpuTextBasedDateUtils$;
import com.nvidia.spark.rapids.NvtxWithMetrics;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.ScanWithMetrics;
import com.nvidia.spark.rapids.shims.GpuTypeShims$;
import java.io.Serializable;
import java.time.DateTimeException;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.QueryExecutionException$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.rapids.ExceptionTimeParserPolicy$;
import org.apache.spark.sql.rapids.TimeParserPolicy;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\tmc!B\u0016-\u0003\u0003)\u0004\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001b\u001b\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u0002\u0011\t\u0011)A\u0005Y\"A1\u000f\u0001B\u0001B\u0003%A\u000f\u0003\u0006\u0002\u0002\u0001\u0011\t\u0011)A\u0005\u0003\u0007A!\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011BA\u0006\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0003\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011%\tY\u0005\u0001a\u0001\n\u0013\ti\u0005C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!A\u0011q\f\u0001!B\u0013\ty\u0005C\u0005\u0002b\u0001\u0011\r\u0011\"\u0003\u0002d!A\u00111\u000e\u0001!\u0002\u0013\t)\u0007C\u0005\u0002n\u0001\u0001\r\u0011\"\u0003\u0002p!I\u0011q\u000f\u0001A\u0002\u0013%\u0011\u0011\u0010\u0005\t\u0003{\u0002\u0001\u0015)\u0003\u0002r!I\u0011q\u0010\u0001A\u0002\u0013%\u0011q\u000e\u0005\n\u0003\u0003\u0003\u0001\u0019!C\u0005\u0003\u0007C\u0001\"a\"\u0001A\u0003&\u0011\u0011\u000f\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0005\u0003\u0017C\u0011\"!$\u0001\u0001\u0004%I!a$\t\u0011\u0005M\u0005\u0001)Q\u0005\u0003\u0017A!\"!&\u0001\u0011\u000b\u0007I\u0011BAF\u0011\u001d\t9\n\u0001C\u0005\u00033Cq!!.\u0001\t\u0013\t9\fC\u0004\u0002@\u0002!I!!1\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u00111\u001b\u0001\u0007\u0002\u0005U\u0007bBAl\u0001\u0019\u0005\u0011Q\u001b\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t)\u0010\u0001C\u0001\u0003oDqA!\u0002\u0001\r\u0003\u00119\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tM\u0001\u0001\"\u0001\u0003\u0016!9!\u0011\u0005\u0001\u0005\u0002\t\r\u0002bBAb\u0001\u0019\u0005!1\u0006\u0005\b\u0005\u0007\u0002a\u0011AAk\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBqAa\u0014\u0001\t\u0003\u0012\t\u0006C\u0004\u0003T\u0001!\tE!\u0016\t\u000f\t]\u0003\u0001\"\u0011\u0003Z\tYr\t];UKb$()Y:fIB\u000b'\u000f^5uS>t'+Z1eKJT!!\f\u0018\u0002\rI\f\u0007/\u001b3t\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051aN^5eS\u0006T\u0011aM\u0001\u0004G>l7\u0001A\n\u0006\u0001Yr4k\u0016\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nA\u0001\\1oO*\t1(\u0001\u0003kCZ\f\u0017BA\u001f9\u0005\u0019y%M[3diB\u0019qhS'\u000e\u0003\u0001S!!\u0011\"\u0002\tI,\u0017\r\u001a\u0006\u0003\u0007\u0012\u000b\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u00153\u0015aA:rY*\u0011qf\u0012\u0006\u0003\u0011&\u000ba!\u00199bG\",'\"\u0001&\u0002\u0007=\u0014x-\u0003\u0002M\u0001\ny\u0001+\u0019:uSRLwN\u001c*fC\u0012,'\u000f\u0005\u0002O#6\tqJ\u0003\u0002Q\t\u0006Qa/Z2u_JL'0\u001a3\n\u0005I{%!D\"pYVlg.\u0019:CCR\u001c\u0007\u000e\u0005\u0002U+6\tA&\u0003\u0002WY\ty1kY1o/&$\b.T3ue&\u001c7\u000f\u0005\u0002U1&\u0011\u0011\f\f\u0002\u0004\u0003Jl\u0017\u0001B2p]\u001a\u0004\"\u0001\u00181\u000e\u0003uS!A\u00170\u000b\u0005};\u0015A\u00025bI>|\u0007/\u0003\u0002b;\ni1i\u001c8gS\u001e,(/\u0019;j_:\f\u0001\u0002]1si\u001aKG.\u001a\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f1\u0002Z1uCN|WO]2fg*\u0011\u0001\u000eR\u0001\nKb,7-\u001e;j_:L!A[3\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\f!\u0002Z1uCN\u001b\u0007.Z7b!\ti\u0007/D\u0001o\u0015\tyG)A\u0003usB,7/\u0003\u0002r]\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u001dI,\u0017\r\u001a#bi\u0006\u001c6\r[3nC\u0006\u0019B.\u001b8f'\u0016\u0004\u0018M]1u_JLeNU3bIB\u0019Q\u000f\u001f>\u000e\u0003YT\u0011a^\u0001\u0006g\u000e\fG.Y\u0005\u0003sZ\u0014aa\u00149uS>t\u0007cA;|{&\u0011AP\u001e\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003kzL!a <\u0003\t\tKH/Z\u0001\u0010[\u0006D(k\\<t!\u0016\u00148\t[;oWB\u0019q'!\u0002\n\u0007\u0005\u001d\u0001HA\u0004J]R,w-\u001a:\u0002!5\f\u0007PQ=uKN\u0004VM]\"ik:\\\u0007cA;\u0002\u000e%\u0019\u0011q\u0002<\u0003\t1{gnZ\u0001\fKb,7-T3ue&\u001c7\u000f\u0005\u0005\u0002\u0016\u0005\r\u0012\u0011FA\u0018\u001d\u0011\t9\"a\b\u0011\u0007\u0005ea/\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\t\tC^\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0012q\u0005\u0002\u0004\u001b\u0006\u0004(bAA\u0011mB!\u0011QCA\u0016\u0013\u0011\ti#a\n\u0003\rM#(/\u001b8h!\r!\u0016\u0011G\u0005\u0004\u0003ga#!C$qk6+GO]5d\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%!\t!\u0006\u0001C\u0003[\u0013\u0001\u00071\fC\u0003c\u0013\u0001\u00071\rC\u0003l\u0013\u0001\u0007A\u000eC\u0003s\u0013\u0001\u0007A\u000eC\u0003t\u0013\u0001\u0007A\u000fC\u0004\u0002\u0002%\u0001\r!a\u0001\t\u000f\u0005%\u0011\u00021\u0001\u0002\f!9\u0011\u0011C\u0005A\u0002\u0005M\u0011!\u00022bi\u000eDWCAA(!\r)\b0T\u0001\nE\u0006$8\r[0%KF$B!!\u0016\u0002\\A\u0019Q/a\u0016\n\u0007\u0005ecO\u0001\u0003V]&$\b\"CA/\u0017\u0005\u0005\t\u0019AA(\u0003\rAH%M\u0001\u0007E\u0006$8\r\u001b\u0011\u0002\u00151Lg.\u001a*fC\u0012,'/\u0006\u0002\u0002fA\u0019A-a\u001a\n\u0007\u0005%TMA\u000bIC\u0012|w\u000e\u001d$jY\u0016d\u0015N\\3t%\u0016\fG-\u001a:\u0002\u00171Lg.\u001a*fC\u0012,'\u000fI\u0001\u0018SN4\u0015N]:u\u0007\",hn\u001b$pe&#XM]1u_J,\"!!\u001d\u0011\u0007U\f\u0019(C\u0002\u0002vY\u0014qAQ8pY\u0016\fg.A\u000ejg\u001aK'o\u001d;DQVt7NR8s\u0013R,'/\u0019;pe~#S-\u001d\u000b\u0005\u0003+\nY\bC\u0005\u0002^A\t\t\u00111\u0001\u0002r\u0005A\u0012n\u001d$jeN$8\t[;oW\u001a{'/\u0013;fe\u0006$xN\u001d\u0011\u0002\u0017%\u001cX\t\u001f5bkN$X\rZ\u0001\u0010SN,\u0005\u0010[1vgR,Gm\u0018\u0013fcR!\u0011QKAC\u0011%\tifEA\u0001\u0002\u0004\t\t(\u0001\u0007jg\u0016C\b.Y;ti\u0016$\u0007%A\bnCb$UM^5dK6+Wn\u001c:z+\t\tY!A\nnCb$UM^5dK6+Wn\u001c:z?\u0012*\u0017\u000f\u0006\u0003\u0002V\u0005E\u0005\"CA/-\u0005\u0005\t\u0019AA\u0006\u0003Ai\u0017\r\u001f#fm&\u001cW-T3n_JL\b%A\ffgRLW.\u0019;fI\"{7\u000f\u001e\"vM\u001a,'oU5{K\u0006qqM]8x\u0011>\u001cHOQ;gM\u0016\u0014HCBAN\u0003[\u000b\t\f\u0005\u0003\u0002\u001e\u0006%VBAAP\u0015\u0011\t\t+a)\u0002\t\r,HM\u001a\u0006\u0004[\u0005\u0015&BAAT\u0003\t\t\u0017.\u0003\u0003\u0002,\u0006}%\u0001\u0005%pgRlU-\\8ss\n+hMZ3s\u0011\u001d\ty+\u0007a\u0001\u00037\u000b\u0001b\u001c:jO&t\u0017\r\u001c\u0005\b\u0003gK\u0002\u0019AA\u0006\u0003\u0019qW-\u001a3fI\u0006a!/Z1e!\u0006\u0014HOR5mKR\u0011\u0011\u0011\u0018\t\bk\u0006m\u00161TA\u0006\u0013\r\tiL\u001e\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0013I,\u0017\r\u001a\"bi\u000eDGCAA(\u0003-\u0011X-\u00193U_R\u000b'\r\\3\u0015\t\u0005\u001d\u0017q\u001a\t\u0005kb\fI\r\u0005\u0003\u0002\u001e\u0006-\u0017\u0002BAg\u0003?\u0013Q\u0001V1cY\u0016Dq!!5\u001d\u0001\u0004\t\t(\u0001\u0007jg\u001aK'o\u001d;DQVt7.\u0001\u0006eCR,gi\u001c:nCR,\"!!\u000b\u0002\u001fQLW.Z:uC6\u0004hi\u001c:nCR\f\u0001cY1tiN#(/\u001b8h)>$\u0015\r^3\u0015\u0011\u0005u\u00171]At\u0003c\u0004B!!(\u0002`&!\u0011\u0011]AP\u00051\u0019u\u000e\\;n]Z+7\r^8s\u0011\u001d\t)o\ba\u0001\u0003;\fQ!\u001b8qkRDq!!; \u0001\u0004\tY/\u0001\u0002eiB!\u0011QTAw\u0013\u0011\ty/a(\u0003\u000b\u0011#\u0016\u0010]3\t\u000f\u0005Mx\u00041\u0001\u0002r\u0005ia-Y5m\u001f:LeN^1mS\u0012\fQcY1tiN#(/\u001b8h)>$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0005\u0002^\u0006e\u0018Q B\u0001\u0011\u001d\tY\u0010\ta\u0001\u0003;\f1\u0001\u001c5t\u0011\u001d\ty\u0010\ta\u0001\u0003S\t1b\u001d9be.4uN]7bi\"9!1\u0001\u0011A\u0002\u0005-\u0018!\u00023usB,\u0017\u0001E2bgR\u001cFO]5oOR{'i\\8m)\u0011\tiN!\u0003\t\u000f\u0005\u0015\u0018\u00051\u0001\u0002^\u0006\t2-Y:u'R\u0014\u0018N\\4U_\u001acw.\u0019;\u0015\r\u0005u'q\u0002B\t\u0011\u001d\t)O\ta\u0001\u0003;Dq!!;#\u0001\u0004\tY/A\ndCN$8\u000b\u001e:j]\u001e$v\u000eR3dS6\fG\u000e\u0006\u0004\u0002^\n]!\u0011\u0004\u0005\b\u0003K\u001c\u0003\u0019AAo\u0011\u001d\tIo\ta\u0001\u00057\u00012!\u001cB\u000f\u0013\r\u0011yB\u001c\u0002\f\t\u0016\u001c\u0017.\\1m)f\u0004X-A\bdCN$8\u000b\u001e:j]\u001e$v.\u00138u)\u0019\tiN!\n\u0003(!9\u0011Q\u001d\u0013A\u0002\u0005u\u0007b\u0002B\u0015I\u0001\u0007\u00111^\u0001\bS:$H+\u001f9f)1\tIM!\f\u00032\tU\"q\bB!\u0011\u001d\u0011y#\na\u0001\u00037\u000b!\u0002Z1uC\n+hMZ3s\u0011\u001d\u0011\u0019$\na\u0001\u0003\u0017\t\u0001\u0002Z1uCNK'0\u001a\u0005\b\u0005o)\u0003\u0019\u0001B\u001d\u0003)\u0019W\u000f\u001a4TG\",W.\u0019\t\u0005\u0003;\u0013Y$\u0003\u0003\u0003>\u0005}%AB*dQ\u0016l\u0017\rC\u0003sK\u0001\u0007A\u000eC\u0004\u0002R\u0016\u0002\r!!\u001d\u0002-\u001d,GOR5mK\u001a{'/\\1u'\"|'\u000f\u001e(b[\u0016\fA\u0002[1oI2,'+Z:vYR$b!a2\u0003J\t-\u0003\"\u0002:(\u0001\u0004a\u0007b\u0002B'O\u0001\u0007\u0011\u0011Z\u0001\u0006i\u0006\u0014G.Z\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002r\u0005\u0019q-\u001a;\u0015\u00035\u000bQa\u00197pg\u0016$\"!!\u0016")
public abstract class GpuTextBasedPartitionReader
implements PartitionReader<ColumnarBatch>,
ScanWithMetrics,
Arm {
    private long estimatedHostBufferSize;
    private final Configuration conf;
    private final PartitionedFile partFile;
    private final StructType dataSchema;
    private final StructType readDataSchema;
    private final Option<byte[]> lineSeparatorInRead;
    private final Integer maxRowsPerChunk;
    private final long maxBytesPerChunk;
    private Option<ColumnarBatch> batch;
    private final HadoopFileLinesReader lineReader;
    private boolean isFirstChunkForIterator;
    private boolean isExhausted;
    private long maxDeviceMemory;
    private Map<String, GpuMetric> metrics;
    private volatile boolean bitmap$0;

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public CustomTaskMetric[] currentMetricsValues() {
        return super.currentMetricsValues();
    }

    @Override
    public Map<String, GpuMetric> metrics() {
        return this.metrics;
    }

    @Override
    public void metrics_$eq(Map<String, GpuMetric> x$1) {
        this.metrics = x$1;
    }

    private Option<ColumnarBatch> batch() {
        return this.batch;
    }

    private void batch_$eq(Option<ColumnarBatch> x$1) {
        this.batch = x$1;
    }

    private HadoopFileLinesReader lineReader() {
        return this.lineReader;
    }

    private boolean isFirstChunkForIterator() {
        return this.isFirstChunkForIterator;
    }

    private void isFirstChunkForIterator_$eq(boolean x$1) {
        this.isFirstChunkForIterator = x$1;
    }

    private boolean isExhausted() {
        return this.isExhausted;
    }

    private void isExhausted_$eq(boolean x$1) {
        this.isExhausted = x$1;
    }

    private long maxDeviceMemory() {
        return this.maxDeviceMemory;
    }

    private void maxDeviceMemory_$eq(long x$1) {
        this.maxDeviceMemory = x$1;
    }

    private long estimatedHostBufferSize$lzycompute() {
        GpuTextBasedPartitionReader gpuTextBasedPartitionReader = this;
        synchronized (gpuTextBasedPartitionReader) {
            if (!this.bitmap$0) {
                Path rawPath = new Path(this.partFile.filePath());
                FileSystem fs = rawPath.getFileSystem(this.conf);
                Path path = fs.makeQualified(rawPath);
                long fileSize = fs.getFileStatus(path).getLen();
                CompressionCodecFactory codecFactory = new CompressionCodecFactory(this.conf);
                CompressionCodec codec = codecFactory.getCodec(path);
                this.estimatedHostBufferSize = codec != null ? this.partFile.length() * 2L : (this.partFile.start() + this.partFile.length() == fileSize ? this.partFile.length() : this.partFile.length() + 131072L);
                this.bitmap$0 = true;
            }
        }
        return this.estimatedHostBufferSize;
    }

    private long estimatedHostBufferSize() {
        return !this.bitmap$0 ? this.estimatedHostBufferSize$lzycompute() : this.estimatedHostBufferSize;
    }

    private HostMemoryBuffer growHostBuffer(HostMemoryBuffer original, long needed) {
        long newSize = Math.max(original.getLength() * 2L, needed);
        return (HostMemoryBuffer)this.closeOnExcept(HostMemoryBuffer.allocate((long)newSize), (Function1 & Serializable & scala.Serializable)result -> {
            result.copyFromHostBuffer(0L, original, 0L, original.getLength());
            original.close();
            return result;
        });
    }

    private Tuple2<HostMemoryBuffer, Object> readPartFile() {
        return (Tuple2)this.withResource(new NvtxWithMetrics("Buffer file split", NvtxColor.YELLOW, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{(GpuMetric)this.metrics().apply((Object)"bufferTime")})), (Function1 & Serializable & scala.Serializable)x$1 -> {
            this.isFirstChunkForIterator_$eq(false);
            byte[] separator = (byte[])$this.lineSeparatorInRead.getOrElse((Function0 & Serializable & scala.Serializable)() -> new byte[]{(byte)10});
            boolean succeeded = false;
            long totalSize = 0L;
            Integer totalRows = Predef$.MODULE$.int2Integer(0);
            HostMemoryBuffer hmb = HostMemoryBuffer.allocate((long)this.estimatedHostBufferSize());
            try {
                while (this.lineReader().hasNext()) {
                    Integer n = totalRows;
                    Integer n2 = $this.maxRowsPerChunk;
                    if (!(n == null ? n2 != null : !((Object)n).equals(n2)) || totalSize > $this.maxBytesPerChunk) break;
                    Text line = this.lineReader().next();
                    int lineSize = line.getLength();
                    long newTotal = totalSize + (long)lineSize + (long)separator.length;
                    if (newTotal > hmb.getLength()) {
                        hmb = this.growHostBuffer(hmb, newTotal);
                    }
                    if (lineSize != 0) {
                        hmb.setBytes(totalSize, line.getBytes(), 0L, (long)lineSize);
                    }
                    hmb.setBytes(totalSize + (long)lineSize, separator, 0L, (long)separator.length);
                    totalRows = Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(totalRows) + 1);
                    totalSize = newTotal;
                }
                this.isExhausted_$eq(!this.lineReader().hasNext());
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    hmb.close();
                }
            }
            return new Tuple2((Object)hmb, (Object)BoxesRunTime.boxToLong((long)totalSize));
        });
    }

    private Option<ColumnarBatch> readBatch() {
        return (Option)this.withResource(new NvtxRange(new StringBuilder(10).append(this.getFileFormatShortName()).append(" readBatch").toString(), NvtxColor.GREEN), (Function1 & Serializable & scala.Serializable)x$2 -> {
            Option option;
            boolean isFirstChunk = $this.partFile.start() == 0L && this.isFirstChunkForIterator();
            Option<Table> table = this.readToTable(isFirstChunk);
            try {
                option = $this.readDataSchema.isEmpty() ? table.map((Function1 & Serializable & scala.Serializable)t -> new ColumnarBatch((ColumnVector[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ColumnVector.class)), (int)t.getRowCount())) : table.map((Function1 & Serializable & scala.Serializable)x$3 -> GpuColumnVector.from(x$3, (DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.readDataSchema.toArray(ClassTag$.MODULE$.apply(StructField.class)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.dataType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class)))));
            }
            finally {
                ((GpuMetric)this.metrics().apply((Object)GpuMetric$.MODULE$.NUM_OUTPUT_BATCHES())).$plus$eq(1L);
                table.foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    x$5.close();
                    return BoxedUnit.UNIT;
                });
            }
            return option;
        });
    }

    private Option<Table> readToTable(boolean isFirstChunk) {
        Option<Table> option;
        Tuple2<HostMemoryBuffer, Object> tuple2 = this.readPartFile();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HostMemoryBuffer dataBuffer = (HostMemoryBuffer)tuple2._1();
        long dataSize = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)dataBuffer, (Object)BoxesRunTime.boxToLong((long)dataSize));
        Tuple2 tuple23 = tuple22;
        HostMemoryBuffer dataBuffer2 = (HostMemoryBuffer)tuple23._1();
        long dataSize2 = tuple23._2$mcJ$sp();
        try {
            if (dataSize2 == 0L) {
                option = None$.MODULE$;
            } else {
                StructType structType;
                if (this.readDataSchema.isEmpty()) {
                    StructField smallestField = (StructField)this.dataSchema.min(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$7 -> Predef$.MODULE$.int2Integer(x$7.dataType().defaultSize()), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())));
                    structType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)smallestField, (List)Nil$.MODULE$));
                } else {
                    structType = this.readDataSchema;
                }
                StructType newReadDataSchema = structType;
                StructType dataSchemaWithStrings = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataSchema.fields())).map((Function1 & Serializable & scala.Serializable)f -> {
                    StructField structField;
                    boolean bl;
                    DataType dataType = f.dataType();
                    DataType dataType2 = DataTypes.BooleanType;
                    DataType dataType3 = dataType;
                    if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
                        bl = true;
                    } else {
                        DataType dataType4 = DataTypes.ByteType;
                        DataType dataType5 = dataType;
                        if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                            bl = true;
                        } else {
                            DataType dataType6 = DataTypes.ShortType;
                            DataType dataType7 = dataType;
                            if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                                bl = true;
                            } else {
                                DataType dataType8 = DataTypes.IntegerType;
                                DataType dataType9 = dataType;
                                if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                                    bl = true;
                                } else {
                                    DataType dataType10 = DataTypes.LongType;
                                    DataType dataType11 = dataType;
                                    if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                                        bl = true;
                                    } else {
                                        DataType dataType12 = DataTypes.FloatType;
                                        DataType dataType13 = dataType;
                                        if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                                            bl = true;
                                        } else {
                                            DataType dataType14 = DataTypes.DoubleType;
                                            DataType dataType15 = dataType;
                                            if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                                                bl = true;
                                            } else if (dataType instanceof DecimalType) {
                                                bl = true;
                                            } else {
                                                DataType dataType16 = DataTypes.DateType;
                                                DataType dataType17 = dataType;
                                                if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                                                    bl = true;
                                                } else {
                                                    DataType dataType18 = DataTypes.TimestampType;
                                                    DataType dataType19 = dataType;
                                                    bl = !(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (bl) {
                        DataType x$1 = DataTypes.StringType;
                        String x$2 = f.copy$default$1();
                        boolean x$3 = f.copy$default$3();
                        Metadata x$4 = f.copy$default$4();
                        structField = f.copy(x$2, x$1, x$3, x$4);
                    } else if (GpuTypeShims$.MODULE$.supportCsvRead(dataType)) {
                        DataType x$5 = DataTypes.StringType;
                        String x$6 = f.copy$default$1();
                        boolean x$7 = f.copy$default$3();
                        Metadata x$8 = f.copy$default$4();
                        structField = f.copy(x$6, x$5, x$7, x$8);
                    } else {
                        structField = f;
                    }
                    return structField;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                Schema cudfSchema = GpuColumnVector.from(dataSchemaWithStrings);
                GpuSemaphore$.MODULE$.acquireIfNecessary(TaskContext$.MODULE$.get(), (GpuMetric)this.metrics().apply((Object)GpuMetric$.MODULE$.SEMAPHORE_WAIT_TIME()));
                Table table = (Table)this.withResource(new NvtxWithMetrics(new StringBuilder(7).append(this.getFileFormatShortName()).append(" decode").toString(), NvtxColor.DARK_GREEN, (Seq<GpuMetric>)Predef$.MODULE$.wrapRefArray((Object[])new GpuMetric[]{(GpuMetric)this.metrics().apply((Object)GpuMetric$.MODULE$.GPU_DECODE_TIME())})), (Function1 & Serializable & scala.Serializable)x$8 -> this.readToTable(dataBuffer2, dataSize2, cudfSchema, newReadDataSchema, isFirstChunk));
                this.maxDeviceMemory_$eq(scala.math.package$.MODULE$.max(GpuColumnVector.getTotalDeviceMemoryUsed(table), this.maxDeviceMemory()));
                Table castTable = (Table)this.withResource(table, (Function1 & Serializable & scala.Serializable)x$9 -> {
                    ListBuffer columns = new ListBuffer();
                    return (Table)this.withResource((Seq)columns, (Function1)(Function1 & Serializable & scala.Serializable)x$10 -> {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), table.getNumberOfColumns()).foreach((Function1 & Serializable & scala.Serializable)i -> GpuTextBasedPartitionReader.$anonfun$readToTable$6(this, newReadDataSchema, table, columns, BoxesRunTime.unboxToInt((Object)i)));
                        return new Table((ai.rapids.cudf.ColumnVector[])columns.toArray(ClassTag$.MODULE$.apply(ai.rapids.cudf.ColumnVector.class)));
                    });
                });
                option = this.handleResult(newReadDataSchema, castTable);
            }
        }
        finally {
            dataBuffer2.close();
        }
        return option;
    }

    public abstract String dateFormat();

    public abstract String timestampFormat();

    public ai.rapids.cudf.ColumnVector castStringToDate(ai.rapids.cudf.ColumnVector input, DType dt, boolean failOnInvalid) {
        String cudfFormat = DateUtils$.MODULE$.toStrf(this.dateFormat(), true);
        return (ai.rapids.cudf.ColumnVector)this.withResource(input.strip(), (Function1 & Serializable & scala.Serializable)stripped -> (ai.rapids.cudf.ColumnVector)this.withResource(stripped.isTimestamp(cudfFormat), (Function1 & Serializable & scala.Serializable)isDate -> {
            Object object;
            if (failOnInvalid) {
                TimeParserPolicy timeParserPolicy = GpuOverrides$.MODULE$.getTimeParserPolicy();
                ExceptionTimeParserPolicy$ exceptionTimeParserPolicy$ = ExceptionTimeParserPolicy$.MODULE$;
                if (!(timeParserPolicy != null ? !timeParserPolicy.equals(exceptionTimeParserPolicy$) : exceptionTimeParserPolicy$ != null)) {
                    object = this.withResource(isDate.all(), (Function1 & Serializable & scala.Serializable)all -> {
                        GpuTextBasedPartitionReader.$anonfun$castStringToDate$3(all);
                        return BoxedUnit.UNIT;
                    });
                    return (ai.rapids.cudf.ColumnVector)this.withResource(stripped.asTimestamp(dt, cudfFormat), (Function1 & Serializable & scala.Serializable)asDate -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromNull((DType)dt), (Function1 & Serializable & scala.Serializable)nullScalar -> isDate.ifElse((ColumnView)asDate, nullScalar)));
                }
            }
            object = BoxedUnit.UNIT;
            return (ai.rapids.cudf.ColumnVector)this.withResource(stripped.asTimestamp(dt, cudfFormat), (Function1 & Serializable & scala.Serializable)asDate -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromNull((DType)dt), (Function1 & Serializable & scala.Serializable)nullScalar -> isDate.ifElse((ColumnView)asDate, nullScalar)));
        }));
    }

    public ai.rapids.cudf.ColumnVector castStringToTimestamp(ai.rapids.cudf.ColumnVector lhs, String sparkFormat, DType dtype) {
        String string;
        String optionalSeconds = "(?:\\:\\d{2})?";
        String optionalMicros = "(?:\\.\\d{1,6})?";
        String twoDigits = "\\d{2}";
        String fourDigits = "\\d{4}";
        String regexRoot = sparkFormat.replace("'T'", "T").replace("yyyy", fourDigits).replace("MM", twoDigits).replace("dd", twoDigits).replace("HH", twoDigits).replace("mm", twoDigits).replace("[:ss]", optionalSeconds).replace(":ss", optionalSeconds).replace("[.SSSXXX]", optionalMicros).replace("[.SSS][XXX]", optionalMicros).replace("[.SSS]", optionalMicros).replace("[.SSSSSS]", optionalMicros).replace(".SSSXXX", optionalMicros).replace(".SSSSSS", optionalMicros).replace(".SSS", optionalMicros);
        String[] stringArray = new StringOps(Predef$.MODULE$.augmentString(regexRoot)).split('T');
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
            String d = (String)((SeqLike)option.get()).apply(0);
            String t = (String)((SeqLike)option.get()).apply(1);
            string = new StringBuilder(9).append(d).append("(?:[ T]").append(t).append(")?").toString();
        } else {
            string = regexRoot;
        }
        String regexOptionalTime = string;
        String regex = new StringBuilder(4).append(regexOptionalTime).append("Z?\\Z").toString();
        Seq<String> cudfFormats = GpuTextBasedDateUtils$.MODULE$.toCudfFormats(sparkFormat, true);
        ai.rapids.cudf.ColumnVector regexpFiltered = (ai.rapids.cudf.ColumnVector)this.withResource(lhs.strip(), (Function1 & Serializable & scala.Serializable)stripped -> (ai.rapids.cudf.ColumnVector)this.withResource(stripped.matchesRe(regex), (Function1 & Serializable & scala.Serializable)matchesRe -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromNull((DType)DType.STRING), (Function1 & Serializable & scala.Serializable)nullString -> matchesRe.ifElse((ColumnView)stripped, nullString))));
        ai.rapids.cudf.ColumnVector sanitized = (ai.rapids.cudf.ColumnVector)this.withResource(regexpFiltered, (Function1 & Serializable & scala.Serializable)x$11 -> {
            String placeholder = "@";
            return (ai.rapids.cudf.ColumnVector)this.withResource(regexpFiltered.stringReplaceWithBackrefs("(\\.\\d{3})(Z?)\\Z", new StringBuilder(4).append("\\1").append(placeholder).append("\\2").toString()), (Function1 & Serializable & scala.Serializable)tmp -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromString((String)placeholder), (Function1 & Serializable & scala.Serializable)from -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromString((String)"000"), (Function1 & Serializable & scala.Serializable)to -> tmp.stringReplace(from, to))));
        });
        return (ai.rapids.cudf.ColumnVector)this.withResource(sanitized, (Function1 & Serializable & scala.Serializable)x$13 -> cudfFormats.length() == 1 ? this.asTimestampOrNull$1((String)cudfFormats.head(), dtype, sanitized) : (ai.rapids.cudf.ColumnVector)((TraversableOnce)cudfFormats.tail()).foldLeft((Object)this.asTimestampOrNull$1((String)cudfFormats.head(), dtype, sanitized), (Function2 & Serializable & scala.Serializable)(input, fmt) -> this.asTimestampOr$1((String)fmt, (ai.rapids.cudf.ColumnVector)input, sanitized, dtype)));
    }

    public abstract ai.rapids.cudf.ColumnVector castStringToBool(ai.rapids.cudf.ColumnVector var1);

    public ai.rapids.cudf.ColumnVector castStringToFloat(ai.rapids.cudf.ColumnVector input, DType dt) {
        return GpuCast$.MODULE$.castStringToFloats(input, false, dt, GpuCast$.MODULE$.castStringToFloats$default$4());
    }

    public ai.rapids.cudf.ColumnVector castStringToDecimal(ai.rapids.cudf.ColumnVector input, DecimalType dt) {
        return GpuCast$.MODULE$.castStringToDecimal((ColumnView)input, false, dt);
    }

    public ai.rapids.cudf.ColumnVector castStringToInt(ai.rapids.cudf.ColumnVector input, DType intType) {
        return (ai.rapids.cudf.ColumnVector)this.withResource(input.isInteger(intType), (Function1 & Serializable & scala.Serializable)isInt -> (ai.rapids.cudf.ColumnVector)this.withResource(input.castTo(intType), (Function1 & Serializable & scala.Serializable)asInt -> (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromNull((DType)intType), (Function1 & Serializable & scala.Serializable)nullValue -> isInt.ifElse((ColumnView)asInt, nullValue))));
    }

    public abstract Table readToTable(HostMemoryBuffer var1, long var2, Schema var4, StructType var5, boolean var6);

    public abstract String getFileFormatShortName();

    public Option<Table> handleResult(StructType readDataSchema, Table table) {
        int numColumns = table.getNumberOfColumns();
        this.closeOnExcept(table, (Function1 & Serializable & scala.Serializable)x$14 -> {
            GpuTextBasedPartitionReader.$anonfun$handleResult$1(this, readDataSchema, numColumns, table, x$14);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)table);
    }

    public boolean next() {
        None$ none$;
        this.batch().foreach((Function1 & Serializable & scala.Serializable)x$15 -> {
            x$15.close();
            return BoxedUnit.UNIT;
        });
        if (this.isExhausted()) {
            ((GpuMetric)this.metrics().apply((Object)GpuMetric$.MODULE$.PEAK_DEVICE_MEMORY())).set(this.maxDeviceMemory());
            none$ = None$.MODULE$;
        } else {
            none$ = this.readBatch();
        }
        this.batch_$eq((Option<ColumnarBatch>)none$);
        return this.batch().isDefined();
    }

    /*
     * WARNING - void declaration
     */
    public ColumnarBatch get() {
        void var1_1;
        ColumnarBatch ret = (ColumnarBatch)this.batch().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NoSuchElementException();
        });
        this.batch_$eq((Option<ColumnarBatch>)None$.MODULE$);
        return var1_1;
    }

    public void close() {
        this.lineReader().close();
        this.batch().foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            x$16.close();
            return BoxedUnit.UNIT;
        });
        this.batch_$eq((Option<ColumnarBatch>)None$.MODULE$);
        this.isExhausted_$eq(true);
    }

    public static final /* synthetic */ ListBuffer $anonfun$readToTable$6(GpuTextBasedPartitionReader $this, StructType newReadDataSchema$1, Table table$1, ListBuffer columns$1, int i) {
        ai.rapids.cudf.ColumnVector columnVector;
        DataType dataType = newReadDataSchema$1.fields()[i].dataType();
        DataType dataType2 = DataTypes.BooleanType;
        DataType dataType3 = dataType;
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            columnVector = $this.castStringToBool(table$1.getColumn(i));
        } else {
            DataType dataType4 = DataTypes.ByteType;
            DataType dataType5 = dataType;
            if (!(dataType4 != null ? !dataType4.equals(dataType5) : dataType5 != null)) {
                columnVector = $this.castStringToInt(table$1.getColumn(i), DType.INT8);
            } else {
                DataType dataType6 = DataTypes.ShortType;
                DataType dataType7 = dataType;
                if (!(dataType6 != null ? !dataType6.equals(dataType7) : dataType7 != null)) {
                    columnVector = $this.castStringToInt(table$1.getColumn(i), DType.INT16);
                } else {
                    DataType dataType8 = DataTypes.IntegerType;
                    DataType dataType9 = dataType;
                    if (!(dataType8 != null ? !dataType8.equals(dataType9) : dataType9 != null)) {
                        columnVector = $this.castStringToInt(table$1.getColumn(i), DType.INT32);
                    } else {
                        DataType dataType10 = DataTypes.LongType;
                        DataType dataType11 = dataType;
                        if (!(dataType10 != null ? !dataType10.equals(dataType11) : dataType11 != null)) {
                            columnVector = $this.castStringToInt(table$1.getColumn(i), DType.INT64);
                        } else {
                            DataType dataType12 = DataTypes.FloatType;
                            DataType dataType13 = dataType;
                            if (!(dataType12 != null ? !dataType12.equals(dataType13) : dataType13 != null)) {
                                columnVector = $this.castStringToFloat(table$1.getColumn(i), DType.FLOAT32);
                            } else {
                                DataType dataType14 = DataTypes.DoubleType;
                                DataType dataType15 = dataType;
                                if (!(dataType14 != null ? !dataType14.equals(dataType15) : dataType15 != null)) {
                                    columnVector = $this.castStringToFloat(table$1.getColumn(i), DType.FLOAT64);
                                } else if (dataType instanceof DecimalType) {
                                    DecimalType decimalType = (DecimalType)dataType;
                                    columnVector = $this.castStringToDecimal(table$1.getColumn(i), decimalType);
                                } else {
                                    DataType dataType16 = DataTypes.DateType;
                                    DataType dataType17 = dataType;
                                    if (!(dataType16 != null ? !dataType16.equals(dataType17) : dataType17 != null)) {
                                        columnVector = $this.castStringToDate(table$1.getColumn(i), DType.TIMESTAMP_DAYS, true);
                                    } else {
                                        DataType dataType18 = DataTypes.TimestampType;
                                        DataType dataType19 = dataType;
                                        columnVector = !(dataType18 != null ? !dataType18.equals(dataType19) : dataType19 != null) ? $this.castStringToTimestamp(table$1.getColumn(i), $this.timestampFormat(), DType.TIMESTAMP_MICROSECONDS) : (GpuTypeShims$.MODULE$.supportCsvRead(dataType) ? GpuTypeShims$.MODULE$.csvRead(table$1.getColumn(i), dataType) : table$1.getColumn(i).incRefCount());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ai.rapids.cudf.ColumnVector castColumn = columnVector;
        return columns$1.$plus$eq((Object)castColumn);
    }

    public static final /* synthetic */ void $anonfun$castStringToDate$3(Scalar all) {
        if (all.isValid() && !all.getBoolean()) {
            throw new DateTimeException("One or more values is not a valid date");
        }
    }

    private final ai.rapids.cudf.ColumnVector isTimestamp$1(String fmt, ai.rapids.cudf.ColumnVector sanitized$1) {
        ai.rapids.cudf.ColumnVector columnVector;
        int pos = fmt.indexOf(84);
        if (pos == -1) {
            columnVector = sanitized$1.isTimestamp(fmt);
        } else {
            String withSpaceDelim = new StringBuilder(0).append(fmt.substring(0, pos)).append(' ').append(fmt.substring(pos + 1)).toString();
            columnVector = (ai.rapids.cudf.ColumnVector)this.withResource(sanitized$1.isTimestamp(fmt), (Function1 & Serializable & scala.Serializable)isValidFmt1 -> (ai.rapids.cudf.ColumnVector)this.withResource(sanitized$1.isTimestamp(withSpaceDelim), (Function1 & Serializable & scala.Serializable)isValidFmt2 -> isValidFmt1.or((BinaryOperable)isValidFmt2)));
        }
        return columnVector;
    }

    private final ai.rapids.cudf.ColumnVector asTimestampOrNull$1(String fmt, DType dtype$1, ai.rapids.cudf.ColumnVector sanitized$1) {
        return (ai.rapids.cudf.ColumnVector)this.withResource(Scalar.fromNull((DType)dtype$1), (Function1 & Serializable & scala.Serializable)nullScalar -> (ai.rapids.cudf.ColumnVector)this.withResource(this.isTimestamp$1(fmt, sanitized$1), (Function1 & Serializable & scala.Serializable)isValid -> (ai.rapids.cudf.ColumnVector)this.withResource(sanitized$1.asTimestamp(dtype$1, fmt), (Function1 & Serializable & scala.Serializable)ts -> isValid.ifElse((ColumnView)ts, nullScalar))));
    }

    private final ai.rapids.cudf.ColumnVector asTimestampOr$1(String fmt, ai.rapids.cudf.ColumnVector orValue, ai.rapids.cudf.ColumnVector sanitized$1, DType dtype$1) {
        return (ai.rapids.cudf.ColumnVector)this.withResource(orValue, (Function1 & Serializable & scala.Serializable)x$12 -> (ai.rapids.cudf.ColumnVector)this.withResource(this.isTimestamp$1(fmt, sanitized$1), (Function1 & Serializable & scala.Serializable)isValid -> (ai.rapids.cudf.ColumnVector)this.withResource(sanitized$1.asTimestamp(dtype$1, fmt), (Function1 & Serializable & scala.Serializable)ts -> isValid.ifElse((ColumnView)ts, (ColumnView)orValue))));
    }

    public static final /* synthetic */ void $anonfun$handleResult$1(GpuTextBasedPartitionReader $this, StructType readDataSchema$1, int numColumns$1, Table table$2, Table x$14) {
        if (readDataSchema$1.length() != numColumns$1) {
            throw new QueryExecutionException(new StringBuilder(38).append("Expected ").append(readDataSchema$1.length()).append(" columns ").append("but only read ").append(table$2.getNumberOfColumns()).append(" from ").append($this.partFile).toString(), QueryExecutionException$.MODULE$.$lessinit$greater$default$2());
        }
    }

    public GpuTextBasedPartitionReader(Configuration conf, PartitionedFile partFile, StructType dataSchema, StructType readDataSchema, Option<byte[]> lineSeparatorInRead, Integer maxRowsPerChunk, long maxBytesPerChunk, Map<String, GpuMetric> execMetrics) {
        this.conf = conf;
        this.partFile = partFile;
        this.dataSchema = dataSchema;
        this.readDataSchema = readDataSchema;
        this.lineSeparatorInRead = lineSeparatorInRead;
        this.maxRowsPerChunk = maxRowsPerChunk;
        this.maxBytesPerChunk = maxBytesPerChunk;
        ScanWithMetrics.$init$(this);
        Arm.$init$(this);
        this.batch = None$.MODULE$;
        this.lineReader = new HadoopFileLinesReader(partFile, lineSeparatorInRead, conf);
        this.isFirstChunkForIterator = true;
        this.isExhausted = false;
        this.maxDeviceMemory = 0L;
        this.metrics_$eq(execMetrics);
    }
}

