/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.spark.rapids;

import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.ColumnView;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostColumnVector;
import ai.rapids.cudf.Scalar;
import com.nvidia.spark.rapids.Arm;
import com.nvidia.spark.rapids.CloseableHolder;
import com.nvidia.spark.rapids.GpuColumnVector;
import com.nvidia.spark.rapids.GpuScalar;
import com.nvidia.spark.rapids.GpuUnsignedIntegerType$;
import com.nvidia.spark.rapids.GpuUnsignedLongType$;
import com.nvidia.spark.rapids.RapidsBuffer;
import com.nvidia.spark.rapids.RapidsPluginImplicits$;
import com.nvidia.spark.rapids.shims.GpuTypeShims$;
import java.io.Serializable;
import java.math.BigInteger;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GpuScalar$
implements Arm,
Logging {
    public static GpuScalar$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GpuScalar$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T r, Function1<T, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(T[] r, Function1<T[], V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, r, block);
    }

    @Override
    public <T, V> V withResourceIfAllowed(T r, Function1<T, V> block) {
        return (V)Arm.withResourceIfAllowed$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Seq<T> r, Function1<Seq<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(T[] r, Function1<T[], V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(ArrayBuffer<T> r, Function1<ArrayBuffer<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V closeOnExcept(Option<T> r, Function1<Option<T>, V> block) {
        return (V)Arm.closeOnExcept$((Arm)this, r, block);
    }

    @Override
    public <T extends RapidsBuffer, V> V freeOnExcept(T r, Function1<T, V> block) {
        return (V)Arm.freeOnExcept$(this, r, block);
    }

    @Override
    public <T extends AutoCloseable, V> V withResource(CloseableHolder<T> h, Function1<CloseableHolder<T>, V> block) {
        return (V)Arm.withResource$((Arm)this, h, block);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object extract(Scalar v) {
        Boolean bl;
        if (v != null && v.isValid()) {
            Comparable<Boolean> comparable;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Extracting data from the Scalar ").append(v).append(".").toString());
            DType dType = v.getType();
            DType dType2 = DType.BOOL8;
            DType dType3 = dType;
            if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
                comparable = BoxesRunTime.boxToBoolean((boolean)v.getBoolean());
            } else {
                DType dType4 = DType.FLOAT32;
                DType dType5 = dType;
                if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                    comparable = BoxesRunTime.boxToFloat((float)v.getFloat());
                } else {
                    DType dType6 = DType.FLOAT64;
                    DType dType7 = dType;
                    if (!(dType6 != null ? !dType6.equals(dType7) : dType7 != null)) {
                        comparable = BoxesRunTime.boxToDouble((double)v.getDouble());
                    } else {
                        DType dType8 = DType.INT8;
                        DType dType9 = dType;
                        if (!(dType8 != null ? !dType8.equals(dType9) : dType9 != null)) {
                            comparable = BoxesRunTime.boxToByte((byte)v.getByte());
                        } else {
                            DType dType10 = DType.INT16;
                            DType dType11 = dType;
                            if (!(dType10 != null ? !dType10.equals(dType11) : dType11 != null)) {
                                comparable = BoxesRunTime.boxToShort((short)v.getShort());
                            } else {
                                boolean bl2;
                                DType dType12 = DType.INT32;
                                DType dType13 = dType;
                                if (!(dType12 != null ? !dType12.equals(dType13) : dType13 != null)) {
                                    bl2 = true;
                                } else {
                                    DType dType14 = DType.UINT32;
                                    DType dType15 = dType;
                                    bl2 = !(dType14 != null ? !dType14.equals(dType15) : dType15 != null);
                                }
                                if (bl2) {
                                    comparable = BoxesRunTime.boxToInteger((int)v.getInt());
                                } else {
                                    boolean bl3;
                                    DType dType16 = DType.INT64;
                                    DType dType17 = dType;
                                    if (!(dType16 != null ? !dType16.equals(dType17) : dType17 != null)) {
                                        bl3 = true;
                                    } else {
                                        DType dType18 = DType.UINT64;
                                        DType dType19 = dType;
                                        bl3 = !(dType18 != null ? !dType18.equals(dType19) : dType19 != null);
                                    }
                                    if (bl3) {
                                        comparable = BoxesRunTime.boxToLong((long)v.getLong());
                                    } else {
                                        DType dType20 = DType.TIMESTAMP_DAYS;
                                        DType dType21 = dType;
                                        if (!(dType20 != null ? !dType20.equals(dType21) : dType21 != null)) {
                                            comparable = BoxesRunTime.boxToInteger((int)v.getInt());
                                        } else {
                                            DType dType22 = DType.TIMESTAMP_MICROSECONDS;
                                            DType dType23 = dType;
                                            if (!(dType22 != null ? !dType22.equals(dType23) : dType23 != null)) {
                                                comparable = BoxesRunTime.boxToLong((long)v.getLong());
                                            } else {
                                                DType dType24;
                                                DType dType25 = DType.STRING;
                                                DType dType26 = dType;
                                                if (!(dType25 != null ? !dType25.equals(dType26) : dType26 != null)) {
                                                    comparable = UTF8String.fromBytes((byte[])v.getUTF8());
                                                } else if (dType != null && (dType24 = dType).isDecimalType()) {
                                                    comparable = Decimal$.MODULE$.apply(v.getBigDecimal());
                                                } else {
                                                    throw new UnsupportedOperationException(new StringBuilder(62).append("Extracting data from a cudf Scalar").append(" is not supported for type ").append(dType).append(".").toString());
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            bl = comparable;
        } else {
            bl = null;
        }
        return bl;
    }

    public HostColumnVector.DataType resolveElementType(DataType dt, boolean nullable) {
        return GpuColumnVector.convertFrom(dt, nullable);
    }

    public boolean resolveElementType$default$2() {
        return true;
    }

    private Object convertDecimalTo(Decimal dec, DecimalType dt) {
        if (dec.scale() > dt.scale()) {
            throw new IllegalArgumentException("Unexpected decimals rounding.");
        }
        if (!dec.changePrecision(dt.precision(), dt.scale())) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Cannot change precision to ").append(dt).append(" for decimal: ").append(dec).toString());
        }
        return DecimalType$.MODULE$.is32BitDecimalType((DataType)dt) ? (Number)BoxesRunTime.boxToInteger((int)((int)dec.toUnscaledLong())) : (Number)(DecimalType$.MODULE$.is64BitDecimalType((DataType)dt) ? BoxesRunTime.boxToLong((long)dec.toUnscaledLong()) : dec.toBigDecimal().bigDecimal().unscaledValue());
    }

    private Object getArrayData(ArrayData data, DataType eType) {
        Object[] objectArray;
        ArrayData arrayData = data;
        if (arrayData instanceof UnsafeArrayData) {
            UnsafeArrayData unsafeArrayData = (UnsafeArrayData)arrayData;
            objectArray = unsafeArrayData.toObjectArray(eType);
        } else if (arrayData != null) {
            ArrayData arrayData2 = arrayData;
            objectArray = arrayData2.array();
        } else {
            throw new MatchError((Object)arrayData);
        }
        return objectArray;
    }

    private Object convertElementTo(Object element, DataType elementType) {
        Object object;
        DataType dataType = elementType;
        if (element == null) {
            object = null;
        } else if (StringType$.MODULE$.equals(dataType)) {
            object = ((UTF8String)element).getBytes();
        } else if (dataType instanceof DecimalType) {
            Number number;
            DecimalType decimalType = (DecimalType)dataType;
            Object object2 = this.convertDecimalTo((Decimal)element, decimalType);
            if (object2 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object2);
                number = BoxesRunTime.boxToInteger((int)n);
            } else if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                number = BoxesRunTime.boxToLong((long)l);
            } else if (object2 instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object2;
                number = bigInteger;
            } else {
                throw new MatchError(object2);
            }
            object = number;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType eType = arrayType.elementType();
            Object data = this.getArrayData((ArrayData)element, eType);
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(data).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.convertElementTo(x$1, eType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toList()).asJava();
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            InternalRow data = (InternalRow)element;
            Object[] row = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int id = tuple2._2$mcI$sp();
                Object object = MODULE$.convertElementTo(data.get(id, f.dataType()), f.dataType());
                return object;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            object = new HostColumnVector.StructData(row);
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            MapData data = (MapData)element;
            Object keyData = this.getArrayData(data.keyArray(), keyType);
            Object valueData = this.getArrayData(data.valueArray(), valueType);
            List keys = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(keyData).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.convertElementTo(x$2, keyType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toList();
            List values = Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps(valueData).map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convertElementTo(x$3, valueType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).toList();
            object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)keys.zip((GenIterable)values, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                HostColumnVector.StructData structData = new HostColumnVector.StructData(new Object[]{k, v});
                return structData;
            }, List$.MODULE$.canBuildFrom())).asJava();
        } else {
            object = element;
        }
        return object;
    }

    public ColumnVector columnVectorFromLiterals(Seq<Object> seq, DataType elementType) {
        ColumnVector columnVector;
        DataType dataType = elementType;
        if (ByteType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedBytes((Byte[])((Byte[])seq.toArray(ClassTag$.MODULE$.apply(Byte.class))));
        } else if (LongType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedLongs((Long[])((Long[])seq.toArray(ClassTag$.MODULE$.apply(Long.class))));
        } else if (ShortType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedShorts((Short[])((Short[])seq.toArray(ClassTag$.MODULE$.apply(Short.class))));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedFloats((Float[])((Float[])seq.toArray(ClassTag$.MODULE$.apply(Float.class))));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedDoubles((Double[])((Double[])seq.toArray(ClassTag$.MODULE$.apply(Double.class))));
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedInts((Integer[])((Integer[])seq.toArray(ClassTag$.MODULE$.apply(Integer.class))));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromBoxedBooleans((Boolean[])((Boolean[])seq.toArray(ClassTag$.MODULE$.apply(Boolean.class))));
        } else if (DateType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.timestampDaysFromBoxedInts((Integer[])((Integer[])seq.toArray(ClassTag$.MODULE$.apply(Integer.class))));
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.timestampMicroSecondsFromBoxedLongs((Long[])((Long[])seq.toArray(ClassTag$.MODULE$.apply(Long.class))));
        } else if (StringType$.MODULE$.equals(dataType)) {
            columnVector = ColumnVector.fromUTF8Strings((byte[][])((byte[][])((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                UTF8String uTF8String = x0$1;
                byte[] byArray = uTF8String == null ? null : uTF8String.getBytes();
                return byArray;
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))));
        } else if (dataType instanceof DecimalType) {
            ColumnVector columnVector2;
            DecimalType decimalType = (DecimalType)dataType;
            Seq<Object> decs = seq;
            if (DecimalType$.MODULE$.is32BitDecimalType((DataType)decimalType)) {
                Seq rows = (Seq)decs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Decimal decimal = x0$2;
                    Object object = decimal == null ? null : MODULE$.convertDecimalTo(decimal, decimalType);
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                columnVector2 = ColumnVector.decimalFromBoxedInts((int)(-decimalType.scale()), (Integer[])((Integer[])rows.toArray(ClassTag$.MODULE$.apply(Integer.class))));
            } else if (DecimalType$.MODULE$.is64BitDecimalType((DataType)decimalType)) {
                Seq rows = (Seq)decs.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Decimal decimal = x0$3;
                    Object object = decimal == null ? null : MODULE$.convertDecimalTo(decimal, decimalType);
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                columnVector2 = ColumnVector.decimalFromBoxedLongs((int)(-decimalType.scale()), (Long[])((Long[])rows.toArray(ClassTag$.MODULE$.apply(Long.class))));
            } else {
                Seq rows = (Seq)decs.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Decimal decimal = x0$4;
                    Object object = decimal == null ? null : MODULE$.convertDecimalTo(decimal, decimalType);
                    return object;
                }, Seq$.MODULE$.canBuildFrom());
                columnVector2 = ColumnVector.decimalFromBigInt((int)(-decimalType.scale()), (BigInteger[])((BigInteger[])rows.toArray(ClassTag$.MODULE$.apply(BigInteger.class))));
            }
            columnVector = columnVector2;
        } else if (dataType instanceof ArrayType) {
            HostColumnVector.DataType colType = this.resolveElementType(elementType, this.resolveElementType$default$2());
            Seq rows = (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.convertElementTo(x$4, elementType), Seq$.MODULE$.canBuildFrom());
            columnVector = ColumnVector.fromLists((HostColumnVector.DataType)colType, (java.util.List[])((java.util.List[])rows.toArray(ClassTag$.MODULE$.apply(java.util.List.class))));
        } else if (dataType instanceof StructType) {
            HostColumnVector.DataType colType = this.resolveElementType(elementType, this.resolveElementType$default$2());
            Seq rows = (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.convertElementTo(x$5, elementType), Seq$.MODULE$.canBuildFrom());
            columnVector = ColumnVector.fromStructs((HostColumnVector.DataType)colType, (HostColumnVector.StructData[])((HostColumnVector.StructData[])rows.toArray(ClassTag$.MODULE$.apply(HostColumnVector.StructData.class))));
        } else if (dataType instanceof MapType) {
            HostColumnVector.DataType colType = this.resolveElementType(elementType, this.resolveElementType$default$2());
            Seq rows = (Seq)seq.map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.convertElementTo(x$6, elementType), Seq$.MODULE$.canBuildFrom());
            columnVector = ColumnVector.fromLists((HostColumnVector.DataType)colType, (java.util.List[])((java.util.List[])rows.toArray(ClassTag$.MODULE$.apply(java.util.List.class))));
        } else if (NullType$.MODULE$.equals(dataType)) {
            columnVector = GpuColumnVector.columnVectorFromNull(seq.size(), (DataType)NullType$.MODULE$);
        } else {
            throw new IllegalArgumentException(new StringBuilder(53).append("Unsupported element type (").append(dataType).append(") to create a").append(" ColumnVector.").toString());
        }
        return columnVector;
    }

    public Scalar from(Object v, DataType t) {
        Scalar scalar;
        DataType dataType = t;
        if (v == null) {
            Scalar scalar2;
            DataType dataType2 = dataType;
            if (dataType2 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType2;
                DataType elementType = arrayType.elementType();
                scalar2 = Scalar.listFromNull((HostColumnVector.DataType)this.resolveElementType(elementType, this.resolveElementType$default$2()));
            } else if (dataType2 instanceof StructType) {
                StructType structType = (StructType)dataType2;
                StructField[] fields = structType.fields();
                scalar2 = Scalar.structFromNull((HostColumnVector.DataType[])((HostColumnVector.DataType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.resolveElementType(f.dataType(), MODULE$.resolveElementType$default$2()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HostColumnVector.DataType.class)))));
            } else if (dataType2 instanceof MapType) {
                MapType mapType = (MapType)dataType2;
                DataType keyType = mapType.keyType();
                DataType valueType = mapType.valueType();
                scalar2 = Scalar.listFromNull((HostColumnVector.DataType)this.resolveElementType((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("key", keyType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("value", valueType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), this.resolveElementType$default$2()));
            } else {
                scalar2 = Scalar.fromNull((DType)GpuColumnVector.getNonNestedRapidsType(dataType));
            }
            scalar = scalar2;
        } else if (dataType instanceof DecimalType) {
            Scalar scalar3;
            Decimal decimal;
            DecimalType decimalType = (DecimalType)dataType;
            Object object = v;
            if (object instanceof Decimal) {
                Decimal decimal2;
                decimal = decimal2 = (Decimal)object;
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                decimal = Decimal$.MODULE$.apply((int)by);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                decimal = Decimal$.MODULE$.apply((int)s);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                decimal = Decimal$.MODULE$.apply(n);
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                decimal = Decimal$.MODULE$.apply(l);
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                decimal = Decimal$.MODULE$.apply(d);
            } else if (object instanceof String) {
                String string = (String)object;
                decimal = Decimal$.MODULE$.apply(string);
            } else if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                decimal = Decimal$.MODULE$.apply(bigDecimal);
            } else {
                throw new IllegalArgumentException(new StringBuilder(99).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for DecimalType, expecting Decimal, Int, Long, Double, String, or BigDecimal.").toString());
            }
            Decimal dec = decimal;
            Object object2 = this.convertDecimalTo(dec, decimalType);
            if (object2 instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object2);
                scalar3 = Scalar.fromDecimal((int)(-decimalType.scale()), (int)n);
            } else if (object2 instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object2);
                scalar3 = Scalar.fromDecimal((int)(-decimalType.scale()), (long)l);
            } else if (object2 instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)object2;
                scalar3 = Scalar.fromDecimal((int)(-decimalType.scale()), (BigInteger)bigInteger);
            } else {
                throw new IllegalArgumentException("Expecting Long, Int or BigInteger");
            }
            scalar = scalar3;
        } else if (LongType$.MODULE$.equals(dataType)) {
            Scalar scalar4;
            Object object = v;
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                scalar4 = Scalar.fromLong((long)l);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                scalar4 = Scalar.fromLong((long)n);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                scalar4 = Scalar.fromLong((long)s);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                scalar4 = Scalar.fromLong((long)by);
            } else {
                throw new IllegalArgumentException(new StringBuilder(59).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for LongType, expecting Long, or Int.").toString());
            }
            scalar = scalar4;
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            Scalar scalar5;
            Object object = v;
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                scalar5 = Scalar.fromDouble((double)d);
            } else if (object instanceof Float) {
                float f2 = BoxesRunTime.unboxToFloat((Object)object);
                scalar5 = Scalar.fromDouble((double)f2);
            } else {
                throw new IllegalArgumentException(new StringBuilder(64).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for DoubleType, expecting Double or Float.").toString());
            }
            scalar = scalar5;
        } else if (TimestampType$.MODULE$.equals(dataType)) {
            Object object = v;
            if (!(object instanceof Long)) {
                throw new IllegalArgumentException(new StringBuilder(56).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for TimestampType, expecting Long.").toString());
            }
            long l = BoxesRunTime.unboxToLong((Object)object);
            Scalar scalar6 = Scalar.timestampFromLong((DType)DType.TIMESTAMP_MICROSECONDS, (long)l);
            scalar = scalar6;
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            Scalar scalar7;
            Object object = v;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                scalar7 = Scalar.fromInt((int)n);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                scalar7 = Scalar.fromInt((int)s);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                scalar7 = Scalar.fromInt((int)by);
            } else {
                throw new IllegalArgumentException(new StringBuilder(53).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for IntegerType, expecting Int.").toString());
            }
            scalar = scalar7;
        } else if (DateType$.MODULE$.equals(dataType)) {
            Object object = v;
            if (!(object instanceof Integer)) {
                throw new IllegalArgumentException(new StringBuilder(50).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for DateType, expecting Int.").toString());
            }
            int n = BoxesRunTime.unboxToInt((Object)object);
            Scalar scalar8 = Scalar.timestampDaysFromInt((int)n);
            scalar = scalar8;
        } else if (FloatType$.MODULE$.equals(dataType)) {
            Object object = v;
            if (!(object instanceof Float)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for FloatType, expecting Float.").toString());
            }
            float f3 = BoxesRunTime.unboxToFloat((Object)object);
            Scalar scalar9 = Scalar.fromFloat((float)f3);
            scalar = scalar9;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            Scalar scalar10;
            Object object = v;
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                scalar10 = Scalar.fromShort((short)s);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                scalar10 = Scalar.fromShort((short)by);
            } else {
                throw new IllegalArgumentException(new StringBuilder(53).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for ShortType, expecting Short.").toString());
            }
            scalar = scalar10;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            Object object = v;
            if (!(object instanceof Byte)) {
                throw new IllegalArgumentException(new StringBuilder(51).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for ByteType, expecting Byte.").toString());
            }
            byte by = BoxesRunTime.unboxToByte((Object)object);
            Scalar scalar11 = Scalar.fromByte((byte)by);
            scalar = scalar11;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            Object object = v;
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(new StringBuilder(57).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for BooleanType, expecting Boolean.").toString());
            }
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            Scalar scalar12 = Scalar.fromBool((boolean)bl);
            scalar = scalar12;
        } else if (StringType$.MODULE$.equals(dataType)) {
            Scalar scalar13;
            Object object = v;
            if (object instanceof String) {
                String string = (String)object;
                scalar13 = Scalar.fromString((String)string);
            } else if (object instanceof UTF8String) {
                UTF8String uTF8String = (UTF8String)object;
                scalar13 = Scalar.fromUTF8String((byte[])uTF8String.getBytes());
            } else {
                throw new IllegalArgumentException(new StringBuilder(69).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for StringType, expecting String or UTF8String.").toString());
            }
            scalar = scalar13;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            Object object = v;
            if (!(object instanceof ArrayData)) {
                throw new IllegalArgumentException(new StringBuilder(56).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for ArrayType, expecting ArrayData").toString());
            }
            ArrayData arrayData = (ArrayData)object;
            Object data = this.getArrayData(arrayData, elementType);
            Scalar scalar14 = (Scalar)this.withResource(this.columnVectorFromLiterals((Seq<Object>)Predef$.MODULE$.genericWrapArray(data), elementType), (Function1 & Serializable & scala.Serializable)list -> Scalar.listFromColumnView((ColumnView)list));
            scalar = scalar14;
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Object object = v;
            if (!(object instanceof InternalRow)) {
                throw new IllegalArgumentException(new StringBuilder(59).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for StructType, expecting InternalRow").toString());
            }
            InternalRow internalRow = (InternalRow)object;
            ColumnVector[] cvs2 = (ColumnVector[])RapidsPluginImplicits$.MODULE$.AutoCloseableProducingArray(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).safeMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                StructField f = (StructField)tuple2._1();
                int i = tuple2._2$mcI$sp();
                DataType dt = f.dataType();
                ColumnVector columnVector = MODULE$.columnVectorFromLiterals((Seq<Object>)((Seq)new .colon.colon(internalRow.get(i, dt), (List)Nil$.MODULE$)), dt);
                return columnVector;
            }, ClassTag$.MODULE$.apply(ColumnVector.class));
            Scalar scalar15 = (Scalar)this.withResource((AutoCloseable)((AutoCloseable[])cvs2), (Function1)(Function1 & Serializable & scala.Serializable)cvs -> Scalar.structFromColumnViews((ColumnView[])((ColumnView[])cvs)));
            scalar = scalar15;
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            Object object = v;
            if (!(object instanceof MapData)) {
                throw new IllegalArgumentException(new StringBuilder(52).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for MapType, expecting MapData").toString());
            }
            MapData mapData = (MapData)object;
            Object keyArray = this.getArrayData(mapData.keyArray(), keyType);
            Object valueArray = this.getArrayData(mapData.valueArray(), valueType);
            ColumnVector struct2 = (ColumnVector)this.withResource(this.columnVectorFromLiterals((Seq<Object>)Predef$.MODULE$.genericWrapArray(keyArray), keyType), (Function1 & Serializable & scala.Serializable)keys -> (ColumnVector)MODULE$.withResource(MODULE$.columnVectorFromLiterals((Seq<Object>)Predef$.MODULE$.genericWrapArray(valueArray), valueType), (Function1 & Serializable & scala.Serializable)values -> ColumnVector.makeStruct((long)mapData.numElements(), (ColumnView[])new ColumnView[]{keys, values})));
            Scalar scalar16 = (Scalar)this.withResource(struct2, (Function1 & Serializable & scala.Serializable)struct -> Scalar.listFromColumnView((ColumnView)struct));
            scalar = scalar16;
        } else if (((Object)((Object)GpuUnsignedIntegerType$.MODULE$)).equals(dataType)) {
            Scalar scalar17;
            Object object = v;
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                scalar17 = Scalar.fromUnsignedInt((int)n);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                scalar17 = Scalar.fromUnsignedInt((int)s);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                scalar17 = Scalar.fromUnsignedInt((int)by);
            } else {
                throw new IllegalArgumentException(new StringBuilder(53).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for IntegerType, expecting Int.").toString());
            }
            scalar = scalar17;
        } else if (((Object)((Object)GpuUnsignedLongType$.MODULE$)).equals(dataType)) {
            Scalar scalar18;
            Object object = v;
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                scalar18 = Scalar.fromUnsignedLong((long)l);
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                scalar18 = Scalar.fromUnsignedLong((long)n);
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                scalar18 = Scalar.fromUnsignedLong((long)s);
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                scalar18 = Scalar.fromUnsignedLong((long)by);
            } else {
                throw new IllegalArgumentException(new StringBuilder(59).append("'").append(v).append(": ").append(v.getClass()).append("' is not supported").append(" for LongType, expecting Long, or Int.").toString());
            }
            scalar = scalar18;
        } else {
            if (GpuTypeShims$.MODULE$.supportToScalarForType(dataType)) {
                throw GpuTypeShims$.MODULE$.toScalarForType(dataType, v);
            }
            throw new UnsupportedOperationException(new StringBuilder(36).append(v.getClass()).append(" '").append(v).append("' is not supported").append(" as a Scalar yet").toString());
        }
        return scalar;
    }

    public boolean isNan(Scalar s) {
        boolean bl;
        DType dType = s.getType();
        DType dType2 = DType.FLOAT32;
        DType dType3 = dType;
        if (!(dType2 != null ? !dType2.equals(dType3) : dType3 != null)) {
            bl = s.isValid() && Float.isNaN(s.getFloat());
        } else {
            DType dType4 = DType.FLOAT64;
            DType dType5 = dType;
            if (!(dType4 != null ? !dType4.equals(dType5) : dType5 != null)) {
                bl = s.isValid() && Double.isNaN(s.getDouble());
            } else {
                throw new IllegalStateException(new StringBuilder(24).append(dType).append(" is doesn't support NaNs").toString());
            }
        }
        return bl;
    }

    public GpuScalar apply(Object any, DataType dataType) {
        GpuScalar gpuScalar;
        Object object = any;
        if (object instanceof Scalar) {
            Scalar scalar = (Scalar)object;
            gpuScalar = this.wrap(scalar, dataType);
        } else {
            gpuScalar = new GpuScalar((Option<Scalar>)None$.MODULE$, (Option<Object>)new Some(object), dataType);
        }
        return gpuScalar;
    }

    public GpuScalar wrap(Scalar scalar, DataType dataType) {
        Predef$.MODULE$.assert(scalar != null, (Function0 & Serializable & scala.Serializable)() -> "The cudf Scalar should NOT be null.");
        Predef$.MODULE$.assert(this.typeConversionAllowed(scalar, dataType), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Type conversion is not allowed from ").append(" ").append(scalar).append(" to ").append(dataType).toString());
        return new GpuScalar((Option<Scalar>)new Some((Object)scalar), (Option<Object>)None$.MODULE$, dataType);
    }

    private boolean typeConversionAllowed(Scalar s, DataType sType) {
        boolean bl;
        DType dType = s.getType();
        if (dType.isNestedType()) {
            boolean bl2;
            DataType dataType = sType;
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType elementType = arrayType.elementType();
                bl2 = DType.LIST.equals((Object)dType) ? BoxesRunTime.unboxToBoolean(this.withResource(s.getListAsColumnView(), (Function1 & Serializable & scala.Serializable)elementView -> BoxesRunTime.boxToBoolean((boolean)GpuScalar$.$anonfun$typeConversionAllowed$1(elementType, elementView)))) : false;
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else {
            bl = GpuColumnVector.getNonNestedRapidsType(sType).equals((Object)dType);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$typeConversionAllowed$1(DataType elementType$2, ColumnView elementView) {
        return GpuColumnVector.typeConversionAllowed(elementView, elementType$2);
    }

    private GpuScalar$() {
        MODULE$ = this;
        Arm.$init$(this);
        Logging.$init$((Logging)this);
    }
}

